/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.product.service.imp;

import com.newtouch.design.asyn.FileInfo;
import com.newtouch.design.file.service.FileManger;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class StringBuilderFile {
    String newFilePath = "";
    String fileNamePrefix = "";
    private int contextLength = 0;
    protected List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    OutputStream cacheLastOutputStream = null;

    public StringBuilderFile(String newFilePath, String fileNamePrefix) {
        this.newFilePath = newFilePath;
        this.fileNamePrefix = fileNamePrefix;
    }

    public StringBuilderFile() {
    }

    public StringBuilderFile append(String context) {
        this.cacheLastOutputStream = this.appendFileOrCreateNewFile(context, this.cacheLastOutputStream);
        return this;
    }

    private OutputStream appendFileOrCreateNewFile(String writeContext, OutputStream lastOutputStream) {
        this.contextLength += writeContext.getBytes().length;
        try {
            if (!StrUtil.isNull((Object)writeContext)) {
                if (lastOutputStream != null) {
                    lastOutputStream.write(writeContext.getBytes());
                    if (FileManger.splitFileFlag() && this.contextLength > FileManger.splitFileSize()) {
                        lastOutputStream.flush();
                        lastOutputStream.close();
                        this.contextLength = 0;
                        return null;
                    }
                    return lastOutputStream;
                }
                String fileName = this.fileNamePrefix + UniqueSeq.shortUUID() + ".txt";
                File file = new File(this.newFilePath + fileName);
                if (!file.exists()) {
                    file.createNewFile();
                    this.fileInfos.add(new FileInfo(writeContext.getBytes().length, fileName, this.newFilePath));
                }
                FileOutputStream outs = new FileOutputStream(file);
                ((OutputStream)outs).write(writeContext.getBytes());
                if (this.contextLength < FileManger.splitFileSize()) {
                    return outs;
                }
                this.contextLength = 0;
                outs.flush();
                ((OutputStream)outs).close();
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lastOutputStream;
    }
}

