/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.product.service.imp;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Rules;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Dynamic_Text_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Reg_Rules_Param;
import cn.com.chinalife.model.Reg_Rules_Param_Group;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Products_Channel;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risk_Rules;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.model.Sys_Enum;
import com.newtouch.design.asyn.FileInfo;
import com.newtouch.design.product.service.IExportProductSql;
import com.newtouch.design.product.service.imp.StringBuilderFile;
import com.newtouch.design.util.StructureConstant;
import com.newtouch.log.Ulog;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.repository.util.SqlUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductExportServiceImp
extends BaseService
implements IExportProductSql {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public List<FileInfo> exportProductSql(String product_uuid, String fileNamePrefix, String newFilePath) throws Exception {
        StringBuilderFile stringBuilderFile = new StringBuilderFile(newFilePath, fileNamePrefix);
        this.startExportProductsAndAttributeSQL(product_uuid, stringBuilderFile);
        return stringBuilderFile.fileInfos;
    }

    public void startExportProductsAndAttributeSQL(String fromPage_root_node_no, StringBuilderFile insertSQL) {
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)fromPage_root_node_no);
        product = (Sip_Products)this.dao.findOne((AbsModel)product);
        this.handleProductRoot(fromPage_root_node_no, insertSQL);
        this.changeChildNodeNoAndSeriNoAndAttributes(fromPage_root_node_no, insertSQL);
        this.getSql_Sip_Products_all(fromPage_root_node_no, insertSQL);
        if (!"Y".equals(product.getIsMaster())) {
            this.addSipProductsChannelOrOrgan(fromPage_root_node_no, insertSQL);
        }
        this.systemBase(insertSQL);
        Ulog.info((String)(product.getProductName() + "\u5bfc\u51faSQL\u811a\u672c\u6210\u529f!!"));
    }

    private void systemBase(StringBuilderFile insertSQL) {
        this.findWs_life_t_company_organ(insertSQL);
        this.findSys_enum(insertSQL);
    }

    private void findWs_life_t_company_organ(StringBuilderFile stringBuilderFile) {
    }

    private void findSys_enum(StringBuilderFile stringBuilderFile) {
        Sys_Enum sys_enum = new Sys_Enum();
        sys_enum.where().setCheckWhere(false);
        List sys_enums = this.dao.findAll((AbsModel)sys_enum, false);
        sys_enums.stream().forEach(x -> {
            x.where().setCheckWhere(false);
            x.where().addEq((ModelField)Sys_Enum.Field.serno, (Object)x.getSerno());
            stringBuilderFile.append(this.getNeedSql(x));
        });
    }

    private void addSipProductsChannelOrOrgan(String node_no, StringBuilderFile insertSQL) {
        Sip_Products_Channel spc = new Sip_Products_Channel();
        spc.where().addEq((ModelField)Sip_Products_Channel.Field.product_uuid, (Object)node_no);
        List spcList = this.dao.findAll((AbsModel)spc, false);
        if (spcList.size() > 0) {
            for (Sip_Products_Channel sip_Products_Channel : spcList) {
            }
        }
    }

    public <T extends AbsModel> String getNeedSql(T model) {
        StringBuilder insertSql = new StringBuilder();
        String insert_structure_SQl = SqlUtil.getInsertSql(model).getPrintSql();
        String deleteSQL = SqlUtil.getDeleteSql(model).getPrintSql();
        insertSql.append(deleteSQL).append("; \r\n ").append(insert_structure_SQl).append("; \r\n ");
        return insertSql.toString();
    }

    public void changeChildNodeNoAndSeriNoAndAttributes(String old_parent_node_no, StringBuilderFile insertSQL) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)old_parent_node_no);
        List old_structureLists = this.dao.findAll((AbsModel)structure, false);
        if (old_structureLists == null || old_structureLists.size() < 1) {
            return;
        }
        old_structureLists.stream().forEach(old_structure -> {
            String old_node_no = old_structure.getNodeNo();
            String nodeType = old_structure.getNodeType();
            String relate_tab = "";
            String relate_fk = "";
            if (StringUtils.equals((CharSequence)"rule", (CharSequence)old_structure.getNodeType())) {
                relate_tab = old_structure.getRelateTab();
                relate_fk = old_structure.getRelateFk();
            }
            old_structure.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)old_structure.getSerno());
            insertSQL.append(this.getNeedSql(old_structure));
            if (StructureConstant.RISK_DETAIL_LIST.contains(nodeType)) {
                this.handleRiskInfo(old_node_no, insertSQL);
            }
            if (StructureConstant.ATTR_ARR_LIST.contains(old_structure.getNodeType())) {
                relate_fk = old_structure.getRelateFk();
                this.handleAttributesTables(relate_fk, old_node_no, insertSQL);
            }
            if ("rate".equals(nodeType)) {
                this.handleDsn_Dynamic_Data(old_node_no, insertSQL);
            }
            if ("rule".equals(nodeType)) {
                this.getRule_sip_risk_ruleSQL(relate_tab, relate_fk, old_node_no, insertSQL);
            }
            this.changeChildNodeNoAndSeriNoAndAttributes(old_node_no, insertSQL);
        });
    }

    public void handleDsn_Dynamic_Data(String old_node_no, StringBuilderFile stringBuilderFile) {
        Dsn_Dynamic_Data dsn_dynamic_data_old = new Dsn_Dynamic_Data();
        dsn_dynamic_data_old.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)old_node_no);
        dsn_dynamic_data_old = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dsn_dynamic_data_old);
        if (StringUtils.isNotBlank((CharSequence)dsn_dynamic_data_old.getSerno())) {
            dsn_dynamic_data_old.where().addEq((ModelField)Dsn_Dynamic_Data.Field.serno, (Object)dsn_dynamic_data_old.getSerno());
            stringBuilderFile.append(this.getNeedSql(dsn_dynamic_data_old));
        }
    }

    public void handleRiskInfo(String old_node_no, StringBuilderFile stringBuilderFile) {
        Sip_Risks sip_risks = new Sip_Risks();
        sip_risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)old_node_no);
        sip_risks = (Sip_Risks)this.dao.findOne((AbsModel)sip_risks);
        if (sip_risks != null && !StrUtil.isNull((Object)sip_risks.getSerno())) {
            sip_risks.where().addEq((ModelField)Sip_Risks.Field.risk_no, (Object)sip_risks.getRiskNo());
            stringBuilderFile.append(this.getNeedSql(sip_risks));
            String risk_uuid = sip_risks.getRiskUuid();
            Sip_Risk_Relation sip_risk_relation = new Sip_Risk_Relation();
            sip_risk_relation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)old_node_no);
            List sip_risk_relations = this.dao.findAll((AbsModel)sip_risk_relation);
            if (sip_risk_relations != null && !sip_risk_relations.isEmpty()) {
                sip_risk_relations.stream().forEach(x -> {
                    x.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)x.getRiskUuid());
                    x.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)x.getMainRisk());
                    stringBuilderFile.append(this.getNeedSql(x));
                });
            }
        }
    }

    public void handleAttributesTables(String relate_fk, String old_node_no, StringBuilderFile stringBuilderFile) {
        Dsn_Biz_Attribute biz_attr = new Dsn_Biz_Attribute();
        biz_attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)old_node_no);
        biz_attr = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)biz_attr);
        if (biz_attr != null && StringUtils.isNotBlank((CharSequence)biz_attr.getBizUuid())) {
            String old_attr_uuid = biz_attr.getAttrUuid();
            biz_attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)biz_attr.getBizUuid());
            stringBuilderFile.append(this.getNeedSql(biz_attr));
            stringBuilderFile.append(this.copyDsn_Attribute(old_attr_uuid));
            this.copyDsn_Biz_Attribute_Option(relate_fk, stringBuilderFile);
            String tableName = biz_attr.getStoredTab();
            String biz_uuid = biz_attr.getBizUuid();
            this.handleDynamicTable(tableName, biz_uuid, stringBuilderFile);
        }
    }

    public void handleDynamicTable(String tableName, String biz_uuid, StringBuilderFile insertSQL) {
        if (tableName.equals("dsn_dynamic_text_data")) {
            Dsn_Dynamic_Text_Data dsn_dynamic_text_data = new Dsn_Dynamic_Text_Data();
            dsn_dynamic_text_data.where().addEq((ModelField)Dsn_Dynamic_Text_Data.Field.text_key, (Object)biz_uuid);
            dsn_dynamic_text_data = (Dsn_Dynamic_Text_Data)this.dao.findOne((AbsModel)dsn_dynamic_text_data);
            if (dsn_dynamic_text_data != null && StringUtils.isNotBlank((CharSequence)dsn_dynamic_text_data.getSerno())) {
                dsn_dynamic_text_data.where().addEq((ModelField)Dsn_Dynamic_Text_Data.Field.text_key, (Object)biz_uuid);
                insertSQL.append(this.getNeedSql(dsn_dynamic_text_data));
            }
        }
    }

    public void copyDsn_Biz_Attribute_Option(String old_node_no, StringBuilderFile insertSQL) {
        Dsn_Biz_Attribute_Option biz_attr_option = new Dsn_Biz_Attribute_Option();
        biz_attr_option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)old_node_no);
        List dsn_biz_attribute_optionList = this.dao.findAll((AbsModel)biz_attr_option, false);
        if (dsn_biz_attribute_optionList != null && !dsn_biz_attribute_optionList.isEmpty()) {
            for (Dsn_Biz_Attribute_Option option : dsn_biz_attribute_optionList) {
                if (!StringUtils.isNotBlank((CharSequence)option.getBizUuid())) continue;
                option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.serno, (Object)option.getSerno());
                insertSQL.append(this.getNeedSql(option));
                insertSQL.append(this.save_Dsn_Attribute_Option(option, UniqueSeq.shortUUID()));
            }
        }
    }

    private String save_Dsn_Attribute_Option(Dsn_Biz_Attribute_Option dsn_biz_attribute_option, String newAttr) {
        Dsn_Attribute_Option attr_option = new Dsn_Attribute_Option();
        attr_option.setOptionNo(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getOptionNo()));
        attr_option.setSerno(UniqueSeq.shortUUID());
        attr_option.setAttrUuid(StringUtils.trimToEmpty((String)newAttr));
        attr_option.setOptionOrder(dsn_biz_attribute_option.getOptionOrder());
        attr_option.setOptionName(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getOptionName()));
        attr_option.setOptionValue(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getOptionValue()));
        attr_option.setCrtDate(dsn_biz_attribute_option.getCrtDate());
        attr_option.setDataFlag(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getDataFlag()));
        attr_option.setPatchMemo(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getPatchMemo()));
        attr_option.setRn(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getRn()));
        attr_option.setCrtUser(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getCrtUser()));
        attr_option.setMdfUser(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getMdfUser()));
        attr_option.where().addEq((ModelField)Dsn_Attribute_Option.Field.serno, (Object)attr_option.getSerno());
        return this.getNeedSql(attr_option);
    }

    public String copyDsn_Attribute(String old_attr_uuid) {
        Dsn_Attribute attr = new Dsn_Attribute();
        attr.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)old_attr_uuid);
        attr = (Dsn_Attribute)this.dao.findOne((AbsModel)attr);
        if (attr != null && StringUtils.isNotBlank((CharSequence)attr.getAttrUuid())) {
            attr.where().addEq((ModelField)Dsn_Attribute.Field.serno, (Object)attr.getSerno());
            return this.getNeedSql(attr);
        }
        return "";
    }

    private void getSql_Sip_Products_all(String fromPage_root_node_no, StringBuilderFile insertSql) {
        Sip_Product_Risks sip_product_risks = new Sip_Product_Risks();
        sip_product_risks.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)fromPage_root_node_no);
        List sip_product_risks1 = this.dao.findAll((AbsModel)sip_product_risks, false);
        if (sip_product_risks1 != null && sip_product_risks1.size() > 0) {
            for (Sip_Product_Risks sipProductRisks2 : sip_product_risks1) {
                String insert_structure_SQl = SqlUtil.getInsertSql((AbsModel)sipProductRisks2).getPrintSql();
                sipProductRisks2.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)fromPage_root_node_no);
                String deleteSQL = SqlUtil.getDeleteSql((AbsModel)sipProductRisks2).getPrintSql();
                insertSql.append(deleteSQL).append("; \r\n ").append(insert_structure_SQl).append("; \r\n ");
            }
        }
    }

    private void handleProductRoot(String fromPage_node_no, StringBuilderFile insertSql) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)fromPage_node_no);
        structure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        if (structure != null && StringUtils.isNotBlank((CharSequence)structure.getNodeNo())) {
            Sip_Products product = new Sip_Products();
            product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)fromPage_node_no);
            product = (Sip_Products)this.dao.findOne((AbsModel)product);
            product.setRedisDealInfo("\u672a\u7f13\u5b58");
            product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)fromPage_node_no);
            insertSql.append(this.getNeedSql(product));
            structure.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)structure.getSerno());
            insertSql.append(this.getNeedSql(structure));
        }
    }

    public void getRule_sip_risk_ruleSQL(String relate_tab, String relate_fk, String old_node_no, StringBuilderFile insertFile) {
        block5: {
            block4: {
                if (!StringUtils.equals((CharSequence)"sip_risk_rules", (CharSequence)relate_tab)) break block4;
                Sip_Risk_Rules sip_rule = new Sip_Risk_Rules();
                sip_rule.where().addEq((ModelField)Sip_Risk_Rules.Field.risk_rule_uuid, (Object)old_node_no);
                List sip_ruleList = this.dao.findAll((AbsModel)sip_rule, false);
                if (sip_ruleList.size() <= 0) break block5;
                for (Sip_Risk_Rules sipRule : sip_ruleList) {
                    String oldSerno = sipRule.getSerno();
                    sipRule.where().addEq((ModelField)Sip_Risk_Rules.Field.serno, (Object)sipRule.getSerno());
                    insertFile.append(this.getNeedSql(sipRule));
                    this.getDsn_Dynamic_DataSQL(oldSerno, insertFile);
                    this.handleReg_param_group(sipRule.getRuleNo(), insertFile);
                }
                break block5;
            }
            if (StringUtils.equals((CharSequence)"dsn_biz_attribute_rules", (CharSequence)relate_tab)) {
                Dsn_Biz_Attribute_Rules dsn_biz_attribute_rule = new Dsn_Biz_Attribute_Rules();
                dsn_biz_attribute_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)old_node_no);
                List dsn_biz_attribute_rulesList = this.dao.findAll((AbsModel)dsn_biz_attribute_rule, false);
                if (dsn_biz_attribute_rulesList != null && dsn_biz_attribute_rulesList.size() > 0) {
                    for (Dsn_Biz_Attribute_Rules dsn_biz_attribute_rules : dsn_biz_attribute_rulesList) {
                        if (dsn_biz_attribute_rules == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dsn_biz_attribute_rules.getSerno()})) continue;
                        dsn_biz_attribute_rules.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.serno, (Object)dsn_biz_attribute_rules.getSerno());
                        insertFile.append(this.getNeedSql(dsn_biz_attribute_rules));
                        this.getDsn_Dynamic_DataSQL(dsn_biz_attribute_rules.getSerno(), insertFile);
                        this.handleReg_param_group(dsn_biz_attribute_rules.getRuleNo(), insertFile);
                    }
                }
            }
        }
    }

    private void handleReg_param_group(String ruleNo, StringBuilderFile stringBuilderFile) {
        Reg_Rules_Param_Group reg_rules_param_group = new Reg_Rules_Param_Group();
        reg_rules_param_group.where().addEq((ModelField)Reg_Rules_Param_Group.Field.rule_no, (Object)ruleNo);
        reg_rules_param_group.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.crt_date.asc()});
        reg_rules_param_group.setOrderBy(new Sort.Order[]{Reg_Rules_Param_Group.Field.group_name.asc()});
        List reg_rules_param_groups = this.dao.findAll((AbsModel)reg_rules_param_group, false);
        if (reg_rules_param_groups != null && !reg_rules_param_groups.isEmpty()) {
            for (Reg_Rules_Param_Group reg_rules_param_group_new : reg_rules_param_groups) {
                reg_rules_param_group_new.where().addEq((ModelField)Reg_Rules_Param_Group.Field.serno, (Object)reg_rules_param_group_new.getSerno());
                stringBuilderFile.append(this.getNeedSql(reg_rules_param_group_new));
                Reg_Rules_Param reg_rules_param = new Reg_Rules_Param();
                reg_rules_param.where().addEq((ModelField)Reg_Rules_Param.Field.group_no, (Object)reg_rules_param_group_new.getGroupNo());
                reg_rules_param.setOrderBy(new Sort.Order[]{Reg_Rules_Param.Field.param_order.asc()});
                List reg_rules_param_db = this.dao.findAll((AbsModel)reg_rules_param, false);
                if (reg_rules_param_db == null || reg_rules_param_db.isEmpty()) continue;
                for (Reg_Rules_Param x : reg_rules_param_db) {
                    x.where().addEq((ModelField)Reg_Rules_Param.Field.serno, (Object)x.getSerno());
                    stringBuilderFile.append(this.getNeedSql(x));
                    if (!"dsn_dynamic_data".equals(x.getStoredTab())) continue;
                    String relate_fk = x.getSerno();
                    this.getDsn_Dynamic_DataSQL(relate_fk, stringBuilderFile);
                }
            }
        }
    }

    private void getDsn_Dynamic_DataSQL(String oldSerno, StringBuilderFile insertFile) {
        Dsn_Dynamic_Data dsn_dynamic_data_old = new Dsn_Dynamic_Data();
        dsn_dynamic_data_old.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)oldSerno);
        List dsn_dynamic_data_new_list = this.dao.findAll((AbsModel)dsn_dynamic_data_old, false);
        if (dsn_dynamic_data_new_list != null && dsn_dynamic_data_new_list.size() > 0) {
            for (Dsn_Dynamic_Data dsn_dynamic_data_new : dsn_dynamic_data_new_list) {
                if (dsn_dynamic_data_new == null || !StringUtils.isNotBlank((CharSequence)dsn_dynamic_data_new.getSerno())) continue;
                dsn_dynamic_data_new.where().addEq((ModelField)Dsn_Dynamic_Data.Field.serno, (Object)dsn_dynamic_data_new.getSerno());
                insertFile.append(this.getNeedSql(dsn_dynamic_data_new));
            }
        }
    }
}

