/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.product.service.imp;

import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Dynamic_Text_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Products;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.data.service.StructureService;
import com.newtouch.design.file.service.FileManger;
import com.newtouch.design.file.service.IFileService;
import com.newtouch.design.product.service.DBFactory;
import com.newtouch.design.product.service.IProductDetailsService;
import com.newtouch.design.product.service.SqlFunService;
import com.newtouch.design.product.service.imp.DateConverter;
import com.newtouch.design.product.service.imp.FileCommonServiceImp;
import com.newtouch.design.risk.service.IRiskService;
import com.newtouch.file.upload.service.imp.FileUploaderImp;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.web.BaseService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProductDetailsServiceImp
extends BaseService
implements IProductDetailsService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private FileUploaderImp fileImp;
    @Autowired
    private IRiskService riskService;
    @Autowired
    FileCommonServiceImp fileCommonService;
    @Autowired
    private StructureService nodeService;

    @Override
    public ReturnMsg getProductDetails(Dsn_Structure dsn_Structure) {
        Return msg = new Return();
        String up_node = dsn_Structure.getNodeNo();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryAttr = "select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? ) order by display_order ";
        querySql.add((Object)up_node);
        querySql.setSql(queryAttr);
        List attrList = this.dao.findAll(querySql, false);
        querySql.clearParam();
        String queryProductUUID = " select up_node as product_uuid from dsn_structure WHERE node_no = ? ";
        querySql.add((Object)up_node);
        querySql.setSql(queryProductUUID);
        List productUUIDList = this.dao.findAll(querySql, false);
        querySql.clearParam();
        if (null != productUUIDList && !productUUIDList.isEmpty()) {
            Map attrValueMap = productUUIDList.isEmpty() ? null : (Map)productUUIDList.get(0);
            msg.setDataTable(attrValueMap);
        }
        if (null != attrList && !attrList.isEmpty()) {
            for (Map tmpMap : attrList) {
                this.nodeService.bizAttributeFieldChange2(tmpMap);
                String queryAttrOptValue = "select * from dsn_biz_attribute_option where biz_uuid = ? order by option_order ";
                querySql.add((Object)StrUtil.trimStr(tmpMap.get("biz_uuid")));
                querySql.setSql(queryAttrOptValue);
                List attrOptValueList = this.dao.findAll(querySql, false);
                if (null != attrOptValueList && !attrOptValueList.isEmpty()) {
                    tmpMap.put("attrOptValueList", attrOptValueList);
                }
                querySql.clearParam();
                String stored_tab = StrUtil.trimStr(tmpMap.get("stored_tab"));
                String stored_field = StrUtil.trimStr(tmpMap.get("stored_field"));
                StringBuffer queryAttrValueBuffer = new StringBuffer();
                if ("sip_products".equalsIgnoreCase(stored_tab)) {
                    queryAttrValueBuffer.append(" SELECT ").append("     * ").append(" FROM ").append("     sip_products  ").append(" WHERE ").append("     product_uuid in ( ").append("         SELECT ").append("             up_node ").append("         FROM ").append("             dsn_structure ").append("         WHERE ").append("             node_no = ? ").append("     ) ");
                    querySql.add((Object)up_node);
                } else if ("dsn_dynamic_data".equalsIgnoreCase(stored_tab)) {
                    querySql.clearParam();
                    queryAttrValueBuffer.append("SELECT * from dsn_dynamic_data where data_flag = ? and serno = ?");
                    querySql.add((Object)"1");
                    querySql.add((Object)up_node);
                } else if ("sys_file_repostry".equalsIgnoreCase(stored_tab)) {
                    querySql.clearParam();
                    queryAttrValueBuffer.append("SELECT * from sys_file_repostry where file_no = ?");
                    querySql.add((Object)up_node);
                } else {
                    if ("dsn_dynamic_text_data".equalsIgnoreCase(stored_tab)) {
                        Dsn_Dynamic_Text_Data textData = new Dsn_Dynamic_Text_Data();
                        textData.where().addEq((ModelField)Dsn_Dynamic_Text_Data.Field.text_key, tmpMap.get("biz_uuid"));
                        textData = (Dsn_Dynamic_Text_Data)this.dao.findOne((AbsModel)textData);
                        String str = "";
                        if (!StrUtil.isNull((Object)textData.getTextValue())) {
                            str = textData.getTextValue().replaceAll("<br>", "\r");
                        }
                        tmpMap.put("field_value", str);
                        continue;
                    }
                    throw new BusinessException("\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u5b58\u50a8\u8868\u662f[" + stored_tab + "]\u672a\u627e\u5230\u8be5\u5c5e\u6027\u6240\u914d\u7f6e\u7684\u5b58\u50a8\u8868\uff01\uff01\uff01");
                }
                querySql.setSql(queryAttrValueBuffer.toString());
                List reslutList = this.dao.findAll(querySql, false);
                Map attrValueMap = reslutList.isEmpty() ? null : (Map)reslutList.get(0);
                if (null == attrValueMap || attrValueMap.isEmpty()) continue;
                tmpMap.put("field_value", attrValueMap.get(stored_field));
            }
        }
        this.riskService.getFileInfo(attrList, up_node);
        msg.setDataList(attrList);
        return msg.msg();
    }

    @Override
    public String getProductUUID(Dsn_Structure dsn_Structure) {
        String node_no = dsn_Structure.getNodeNo();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryAttr = "select * from dsn_structure where node_no = (select up_node from dsn_structure where node_no = ?)";
        querySql.add((Object)node_no);
        querySql.setSql(queryAttr);
        List queryList = this.dao.findAll(querySql, false);
        if (null == queryList || queryList.isEmpty()) {
            Ulog.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4ea7\u54c1\uff01");
            return null;
        }
        return StrUtil.trimStr(((Map)queryList.get(0)).get("node_no"));
    }

    public void exchangFileInfo(String current_node_no, Map<String, Object> request) {
        Dsn_Structure dsn_structure = new Dsn_Structure();
        dsn_structure.setNodeNo(current_node_no);
        ReturnMsg returnMsg = this.getProductDetails(dsn_structure);
        if (returnMsg.isSuccessflag()) {
            List list_map = returnMsg.getDataList();
            list_map.parallelStream().forEach(param -> {
                if (param.get("ui_type").equals("file")) {
                    String tableParam = (String)param.get("attr_no");
                    String downLoadfileKey = (String)param.get("downLoadfileKey");
                    request.put(tableParam, downLoadfileKey);
                }
            });
        }
    }

    @Override
    public ReturnMsg saveProductDetails(Map<String, Object> paramMap) throws Exception {
        String current_node_no = StrUtil.trimStr((Object)paramMap.get("current_node_no"));
        String flag = StrUtil.trimStr((Object)paramMap.get("flag"));
        Return rn = new Return();
        if (StrUtil.isNull((Object)current_node_no)) {
            throw new BusinessException("[\u4ea7\u54c1\u8be6\u60c5]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String product_uuid = StrUtil.trimStr((Object)paramMap.get("product_uuid"));
        if (StrUtil.isNull((Object)product_uuid)) {
            throw new BusinessException("[\u4ea7\u54c1\u7f16\u7801]\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        paramMap.remove("current_node_no");
        paramMap.remove("rqstType");
        paramMap.remove("funcID");
        paramMap.remove("uploadService");
        paramMap.remove("new_file_name_name");
        paramMap.remove("funcID");
        Dsn_Structure dsn_Structure = new Dsn_Structure();
        dsn_Structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)current_node_no);
        dsn_Structure.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        List dsn_StructureList = this.dao.findAll((AbsModel)dsn_Structure);
        for (Dsn_Structure tmpDsn : dsn_StructureList) {
            Map<String, String> attrMap = this.getAttrInfo(tmpDsn);
            String stored_tab = attrMap.get("stored_tab");
            String stored_field = attrMap.get("stored_field");
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                String entryKey = entry.getKey();
                String entryValue = StrUtil.trimStr((Object)entry.getValue());
                if (!stored_field.equals(entryKey)) continue;
                if ("Dsn_Dynamic_Data".equalsIgnoreCase(stored_tab)) {
                    this.storeValue4DsnDynamicData(stored_tab, stored_field, entryValue, current_node_no);
                } else if ("Sip_Products".equalsIgnoreCase(stored_tab)) {
                    try {
                        this.storeValue4SipProducts(stored_tab, stored_field, entryValue, product_uuid, flag);
                    }
                    catch (BusinessException e) {
                        if (e.getMessage().startsWith("9999")) {
                            rn.msg().setFailMessage(new Message("\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
                        }
                        return rn.msg();
                    }
                }
                if (!"Sip_Products".equalsIgnoreCase(stored_tab) || !"product_name".equals(stored_field)) continue;
                this.modifyProductTreeRootName(entryValue, current_node_no);
            }
        }
        paramMap.put("current_node_no", current_node_no);
        this.riskService.saveMarkDown(paramMap);
        return rn.msg();
    }

    private Map<String, String> getAttrInfo(Dsn_Structure tmpDsn) {
        String relate_tab = tmpDsn.getRelateTab();
        if (StrUtil.isNull((Object)relate_tab)) {
            return null;
        }
        String relate_fk = tmpDsn.getRelateFk();
        String relate_field = tmpDsn.getRelateField();
        StringBuffer sqlBuffer = new StringBuffer();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        sqlBuffer.append(" select * from ").append(relate_tab).append(" where ").append(relate_field).append(" = ?");
        querySql.add((Object)relate_fk);
        querySql.setSql(sqlBuffer.toString());
        List attrList = this.dao.findAll(querySql, false);
        if (null == attrList || attrList.isEmpty()) {
            return null;
        }
        String stored_tab = StrUtil.trimStr(((Map)attrList.get(0)).get("stored_tab"));
        String stored_field = StrUtil.trimStr(((Map)attrList.get(0)).get("stored_field"));
        if (StrUtil.isNull((Object)stored_tab) || StrUtil.isNull((Object)stored_field)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("stored_tab", stored_tab);
        result.put("stored_field", stored_field);
        return result;
    }

    private void modifyProductTreeRootName(String productName, String nodeNo) {
        Dsn_Structure dsnStructure4Query = new Dsn_Structure();
        dsnStructure4Query.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        Dsn_Structure dsnStructure4Result = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure4Query);
        if (null != dsnStructure4Result && !StrUtil.isNull((Object)dsnStructure4Result.getSerno())) {
            String nodeSeq = dsnStructure4Result.getNodeSeq();
            String[] nodeSeqArray = nodeSeq.split("\\.");
            Dsn_Structure dsnStructure4Update = new Dsn_Structure();
            dsnStructure4Update.setNodeName(productName);
            dsnStructure4Update.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeSeqArray[0]);
            this.dao.update((AbsModel)dsnStructure4Update);
        }
    }

    private void storeValue4DsnDynamicData(String stored_tab, String stored_field, String value, String current_node_no) throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        SqlFunService SqlFun = DBFactory.getSqlFunService();
        if (stored_field.toLowerCase().endsWith("_date")) {
            value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
            value = SqlFun.getFunctionStr2Date(value);
        }
        queryBuffer.append("select * from ").append(stored_tab).append(" where serno = '").append(current_node_no).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(stored_tab).append(" (serno, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(stored_field).append(" ) values( '").append(current_node_no).append("', ").append(SqlFun.getFunctionStr2Date(date) + " , ").append(SqlFun.getFunctionStr2Date(date) + " , ").append(" 'login_user', 'login_user', '1', ").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(stored_tab).append(" set ").append(stored_field).append("=").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(SqlFun.getFunctionStr2Date(updateDate) + " ").append(" where serno ='").append(current_node_no).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    private void storeValue4SipProducts(String stored_tab, String stored_field, String value, String product_uuid, String flag) throws Exception, BusinessException {
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer insertBuffer = new StringBuffer();
        StringBuffer updateBuffer = new StringBuffer();
        SqlFunService SqlFun = DBFactory.getSqlFunService();
        if (stored_field.toLowerCase().endsWith("_date")) {
            try {
                value = DateUtil.date2String((Date)DateUtil.string2Date((Object)value), (String)"yyyy-MM-dd HH:mm:ss");
                value = SqlFun.getFunctionStr2Date(value);
            }
            catch (Exception e) {
                throw new BusinessException(new Message("9999", "\u4fdd\u5b58\u6570\u636e\u5e94\u4e3a\u65e5\u671f\u683c\u5f0f\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u65e0\u8bef\u540e\u4fdd\u5b58"));
            }
        }
        queryBuffer.append("select * from ").append(stored_tab).append(" where product_uuid = '").append(product_uuid).append("'");
        Ulog.info((String)("\t\u52a8\u6001\u67e5\u8be2\u6570\u636e\u7684sql===>" + queryBuffer.toString()));
        List queryResultList = this.dao.getJdbcTemplate().queryForList(queryBuffer.toString());
        if (null == queryResultList || queryResultList.isEmpty()) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            insertBuffer.append(" insert into ").append(stored_tab).append(" (product_uuid, ").append(" crt_date, mdf_date, crt_user, mdf_user, data_flag, ").append(stored_field).append(" ) values( '").append(product_uuid).append("', ").append(SqlFun.getFunctionStr2Date(date) + ", ").append(SqlFun.getFunctionStr2Date(date) + ", ").append(" 'login_user', 'login_user', '1', ").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(") ");
            Ulog.info((String)("\t\u52a8\u6001\u63d2\u5165\u6570\u636e\u7684sql===>" + insertBuffer.toString()));
            this.dao.getJdbcTemplate().execute(insertBuffer.toString());
        } else if (null == flag || "".equalsIgnoreCase(flag)) {
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            updateBuffer.append("update ").append(stored_tab).append(" set ").append(stored_field).append("=").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(SqlFun.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(product_uuid).append("'");
            Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        } else {
            Map map = (Map)queryResultList.get(0);
            String updateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            if ("product_name".equalsIgnoreCase(stored_field) || "product_no".equalsIgnoreCase(stored_field) || StrUtil.isNull(map.get(stored_field))) {
                updateBuffer.append("update ").append(stored_tab).append(" set ").append(stored_field).append("=").append(stored_field.toLowerCase().endsWith("_date") ? value : "'" + value + "'").append(", mdf_date=").append(SqlFun.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(product_uuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            } else {
                updateBuffer.append("update ").append(stored_tab).append(" set ").append(" mdf_date=").append(SqlFun.getFunctionStr2Date(updateDate) + " ").append(" where product_uuid ='").append(product_uuid).append("'");
                Ulog.info((String)("\t\u52a8\u6001\u66f4\u65b0\u6570\u636e\u7684sql===>" + updateBuffer.toString()));
            }
            this.dao.getJdbcTemplate().execute(updateBuffer.toString());
        }
    }

    private void storeValueInDsnDynamicData(String stored_tab, String stored_field, String value, String current_node_no) throws Exception {
        ConvertUtils.register((Converter)new DateConverter(), Date.class);
        Dsn_Dynamic_Data dsn_Dynamic_Data4Query = new Dsn_Dynamic_Data();
        dsn_Dynamic_Data4Query.where().addEq((ModelField)Dsn_Dynamic_Data.Field.serno, (Object)current_node_no);
        dsn_Dynamic_Data4Query.where().addEq((ModelField)Dsn_Dynamic_Data.Field.data_flag, (Object)"1");
        Dsn_Dynamic_Data dsn_Dynamic_Data = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dsn_Dynamic_Data4Query);
        Ulog.info((String)("\t \u5728Dsn_Dynamic_Data\u8868\u4e2d\u67e5\u8be2serno\u4e3a[" + current_node_no + "]\u7684\u8bb0\u5f55\u4e3a" + ((Object)((Object)dsn_Dynamic_Data)).toString()));
        if (StrUtil.isNull((Object)dsn_Dynamic_Data.getSerno())) {
            Dsn_Dynamic_Data dsn_Dynamic_Data4Insert = new Dsn_Dynamic_Data();
            dsn_Dynamic_Data4Insert.setSerno(current_node_no);
            BeanUtils.setProperty((Object)((Object)dsn_Dynamic_Data4Insert), (String)stored_field.replace("_", ""), (Object)value);
            Ulog.info((String)("\t \u5728Dsn_Dynamic_Data\u8868\u4e2d\u65b0\u589e\u8bb0\u5f55" + ((Object)((Object)dsn_Dynamic_Data4Insert)).toString()));
            this.dao.save((AbsModel)dsn_Dynamic_Data4Insert);
        } else {
            Dsn_Dynamic_Data dsn_Dynamic_Data4Update = new Dsn_Dynamic_Data();
            dsn_Dynamic_Data4Update.where().addEq((ModelField)Dsn_Dynamic_Data.Field.serno, (Object)current_node_no);
            BeanUtils.setProperty((Object)((Object)dsn_Dynamic_Data4Update), (String)stored_field.replace("_", ""), (Object)value);
            Ulog.info((String)("\t \u5728Dsn_Dynamic_Data\u8868\u4e2d\u66f4\u65b0\u8bb0\u5f55" + ((Object)((Object)dsn_Dynamic_Data4Update)).toString()));
            this.dao.update((AbsModel)dsn_Dynamic_Data4Update);
        }
    }

    private void storeValueInSipProducts(String stored_tab, String stored_field, String value, String product_uuid) throws Exception {
        ConvertUtils.register((Converter)new DateConverter(), Date.class);
        Sip_Products sip_Products4Query = new Sip_Products();
        sip_Products4Query.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)product_uuid);
        sip_Products4Query.where().addEq((ModelField)Sip_Products.Field.data_flag, (Object)"1");
        Sip_Products sip_Products = (Sip_Products)this.dao.findOne((AbsModel)sip_Products4Query);
        Ulog.info((String)("\t \u5728Sip_Products\u8868\u4e2d\u67e5\u8be2product_uuid\u4e3a[" + product_uuid + "]\u7684\u8bb0\u5f55\u4e3a" + ((Object)((Object)sip_Products)).toString()));
        if (StrUtil.isNull((Object)sip_Products.getProductUuid())) {
            Sip_Products sip_Products4Insert = new Sip_Products();
            sip_Products4Insert.setProductUuid(product_uuid);
            BeanUtils.setProperty((Object)((Object)sip_Products4Insert), (String)this.handleStr(stored_field), (Object)value);
            Ulog.info((String)("\t \u5728Sip_Products\u8868\u4e2d\u65b0\u589e\u8bb0\u5f55" + ((Object)((Object)sip_Products4Insert)).toString()));
            this.dao.save((AbsModel)sip_Products4Insert);
        } else {
            Sip_Products sip_Products4Update = new Sip_Products();
            sip_Products4Update.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)product_uuid);
            BeanUtils.setProperty((Object)((Object)sip_Products4Update), (String)this.handleStr(stored_field), (Object)value);
            Ulog.info((String)("\t \u5728Sip_Products\u8868\u4e2d\u66f4\u65b0\u8bb0\u5f55" + ((Object)((Object)sip_Products4Update)).toString()));
            this.dao.update((AbsModel)sip_Products4Update);
        }
    }

    @Override
    public ReturnMsg saveFile(Map<String, Object> paramMap) {
        Return res = new Return();
        String fileNo = StrUtil.trimStr((Object)paramMap.get("file_node_no"));
        MultipartFile file = (MultipartFile)paramMap.get("file");
        String localFileSize = StrUtil.trimStr((Object)paramMap.get("size"));
        if (StringUtils.isBlank((CharSequence)FileManger.getRemoteSendFileUrl())) {
            return this.fileCommonService.uploadFileAndSave(file, fileNo, null, localFileSize);
        }
        IFileService iFileService = FileManger.getUpLoadFileService();
        try {
            res = iFileService.remoteUpLoadFileToServer(fileNo, file.getOriginalFilename(), Long.parseLong(localFileSize), file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            res.setFailMsg(e.toString());
        }
        return res.msg();
    }

    private String handleStr(String stored_field) {
        int i;
        StringBuffer strBuffer = new StringBuffer();
        String[] strArray = stored_field.split("_");
        for (i = 1; i < strArray.length; ++i) {
            strArray[i] = StrUtil.uppFstChar((Object)strArray[i]);
        }
        for (i = 0; i < strArray.length; ++i) {
            strBuffer.append(strArray[i]);
        }
        return strBuffer.toString();
    }
}

