/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.product.service.imp;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Rules;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Prd_Organ_Risk_Relation;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Products_Channel;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risk_Rules;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.model.Sys_Enum;
import cn.com.chinalife.model.Sys_Tree_Menu;
import cn.com.chinalife.model.Ws_Life_T_Company_Organ;
import com.newtouch.chinalife.service.IProductService;
import com.newtouch.config.ProductConfig;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.DBHandleable;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.dao.pojo.DBTypes;
import com.newtouch.dao.util.callback.RepEnum;
import com.newtouch.design.asyn.MyThread;
import com.newtouch.design.data.service.StructureService;
import com.newtouch.design.product.service.IExportProductSql;
import com.newtouch.design.product.service.IProductConfigService;
import com.newtouch.design.product.service.ProductRuleCopyImp;
import com.newtouch.design.product.service.imp.AttrbuteHandleService;
import com.newtouch.design.product.service.imp.RiskCopyService;
import com.newtouch.design.tree.dao.INodeService;
import com.newtouch.design.tree.service.IPublicTreeService;
import com.newtouch.design.util.StructureConstant;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.test.http.HttpClient;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"springContext"})
public class ProductConfigServiceImp
extends BaseService
implements IProductConfigService {
    private static final String AGENCY_ORGAN_FLAG = "100";
    private static final String AGENTCATENAME = "\u56e2\u9669\u4e2d\u4ecb";
    @Autowired
    private AbsModelRepository dao;
    private String sqlPath = "/chianlife/rules/fileRepostry/";
    @Autowired
    private ProductConfig prdConf;
    @Autowired
    private INodeService nodeService;
    @Autowired
    private AttrbuteHandleService attrbuteHandleService;
    @Autowired
    private RiskCopyService riskCopyService;
    @Autowired
    private IPublicTreeService publicTreeService;
    @Autowired
    private ProductRuleCopyImp productRuleCopyImp;
    @Autowired
    private IExportProductSql iExportProductSql;
    @Autowired
    private StructureService structureService;
    @Autowired
    private IProductService productService;
    private final DBTypes DB_TYPE = DBHandleCreator.getInstance().getDbType();
    private String IS_TEMPLATE = "Y";
    private String NOT_TEMPLATE = "N";
    private List detailNodeTypeList = new ArrayList();
    private String product_uuid_tag;
    private String organ_tag;
    private String start_date_tag;
    private String file_no_tag;
    private String riskRelationSernoList_tag;
    private String class_1_tag;
    private String class_2_tag;
    private String class_3_tag;
    private String class_4_tag;
    private String class_100_tag;

    public ProductConfigServiceImp() {
        this.detailNodeTypeList.add("n_risk_detail");
        this.detailNodeTypeList.add("n_accy_detail");
        this.detailNodeTypeList.add("n_exempt_detail");
        this.detailNodeTypeList.add("n_a_exempt_detai");
        this.product_uuid_tag = "product_uuid";
        this.organ_tag = "organ";
        this.start_date_tag = "date";
        this.file_no_tag = "file_no";
        this.riskRelationSernoList_tag = "riskRelationSernoList";
        this.class_1_tag = "class_1";
        this.class_2_tag = "class_2";
        this.class_3_tag = "class_3";
        this.class_4_tag = "class_4";
        this.class_100_tag = "class_100";
    }

    @Override
    public ReturnMsg queryProductConfig(Sip_Products sip_Products) {
        String productName = sip_Products.getProductName();
        String productNo = sip_Products.getProductNo();
        String state = sip_Products.getState();
        Sip_Products sipProducts4Query = new Sip_Products();
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.data_flag, (Object)"1");
        sipProducts4Query.where().addIsNull((ModelField)Sip_Products.Field.product_catefory);
        if (!StrUtil.isNull((Object)productName)) {
            sipProducts4Query.where().addLike((ModelField)Sip_Products.Field.product_name, (Object)productName);
        }
        if (!StrUtil.isNull((Object)productNo)) {
            sipProducts4Query.where().addLike((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        }
        if (!StrUtil.isNull((Object)state)) {
            sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.state, (Object)state);
        }
        sipProducts4Query.setOrderBy(new Sort.Order[]{Sip_Products.Field.mdf_date.desc()});
        sipProducts4Query.where().addCallback((RowCallback)new RowCallback<AbsModel>(){

            public void callback(AbsModel absModel, List<? extends AbsModel> list, int i) {
                Sip_Products sipProducts = (Sip_Products)absModel;
                if (ProductConfigServiceImp.this.IS_TEMPLATE.equals(sipProducts.getIsMaster())) {
                    sipProducts.setIsMaster("\u662f");
                } else if (ProductConfigServiceImp.this.NOT_TEMPLATE.equals(sipProducts.getIsMaster())) {
                    sipProducts.setIsMaster("\u5426");
                }
                sipProducts.putOtherProperty("true_product_uuid", sipProducts.getProductUuid());
                sipProducts.putOtherProperty("node_no", sipProducts.getProductUuid());
                String channelStr = ProductConfigServiceImp.this.queryChannel4Callback(sipProducts.getProductUuid());
                sipProducts.putOtherProperty("channel_type", channelStr);
            }
        });
        sipProducts4Query.where().addCallback((RowCallback)new com.newtouch.repository.util.RepEnum("prdStatus", (ModelField)Sip_Products.Field.state));
        sipProducts4Query.where().addCallback((RowCallback)new com.newtouch.repository.util.RepEnum("open_state", (ModelField)Sip_Products.Field.open_state));
        List resultList = this.dao.findAll((AbsModel)sipProducts4Query, true);
        Return msg = new Return();
        msg.setDataList(resultList, Sip_Products.class);
        return msg.msg();
    }

    private String queryChannel4Callback(String productUUIDStr) {
        Sip_Products_Channel sipProductsChannel4Query = new Sip_Products_Channel();
        sipProductsChannel4Query.where().addEq((ModelField)Sip_Products_Channel.Field.product_uuid, (Object)productUUIDStr);
        sipProductsChannel4Query.where().addCallback((RowCallback)new com.newtouch.repository.util.RepEnum("channel_type", (ModelField)Sip_Products_Channel.Field.channel_type));
        List resultList = this.dao.findAll((AbsModel)sipProductsChannel4Query);
        if (resultList.isEmpty()) {
            return "";
        }
        StringBuffer resultBuffer = new StringBuffer();
        for (int i = 0; i < resultList.size(); ++i) {
            resultBuffer.append(((Sip_Products_Channel)((Object)resultList.get(i))).getOtherProperty().get("channel_type_name")).append(",");
        }
        String resultStr = resultBuffer.toString();
        resultStr = resultStr.substring(0, resultStr.length() - 1);
        return resultStr;
    }

    @Override
    public ReturnMsg queryProductConfigRelease(Sip_Products_Channel sip_Products_Channel) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     c.product_uuid AS product_uuid, ").append("     c.channel_type AS channel_type, ").append("     c.start_date AS start_date, c.end_date AS end_date, ").append("\t  c.prd_chanl_uuid AS prd_uuid,").append("     ds.node_name AS product_name ").append(" FROM ").append("     sip_products_channel c, ").append("     dsn_structure ds ").append(" WHERE ").append("     c.product_uuid = ds.node_no ").append(" AND c.product_uuid = ? ").append(" order by c.start_date desc ");
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)sip_Products_Channel.getProductUuid());
        querySql.setSql(sqlBuffer.toString());
        querySql.addRowCallback((RowCallback)new RepEnum("channel_type", "channel_type"));
        List resultDBList = this.dao.findAll(querySql);
        Return msg = new Return();
        if (resultDBList.isEmpty()) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("product_uuid", sip_Products_Channel.getProductUuid());
            resultDBList.add(resultMap);
        }
        msg.setDataList(resultDBList);
        return msg.msg();
    }

    private String getChannelValueByChannelType(String channel_type) {
        Sys_Enum sys_enum4Query = new Sys_Enum();
        String up_enum = "channel_type";
        sys_enum4Query.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)up_enum);
        sys_enum4Query.where().addEq((ModelField)Sys_Enum.Field.enum_code, (Object)channel_type);
        Sys_Enum sys_enumResult = (Sys_Enum)this.dao.findOne((AbsModel)sys_enum4Query);
        if (StrUtil.isNull((Object)sys_enumResult.getSerno())) {
            Ulog.error((String)("===>sys_enum\u8868\u4e2d\u672a\u67e5\u5230enum_code\u4e3a" + channel_type + "\uff0cup_enum\u4e3a" + up_enum + "\u7684\u8bb0\u5f55\n"));
            return null;
        }
        return sys_enumResult.getEnumName();
    }

    @Override
    public ReturnMsg addProductConfigRelease(Sip_Products_Channel sip_Products_Channel) {
        Return r = new Return();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channel_type", sip_Products_Channel.getChannelType());
        param.put("start_date", sip_Products_Channel.getStartDate());
        Return check = this.checkParam(param);
        if (!check.isSuccessflag()) {
            return check.msg();
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("  channel_type  ").append(" FROM ").append("     sip_products_channel ").append(" WHERE ").append("     product_uuid = ? ");
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)sip_Products_Channel.getProductUuid());
        querySql.setSql(sqlBuffer.toString());
        List resultList = this.dao.findAll(querySql);
        if (resultList.isEmpty()) {
            Sip_Products sip_Products = new Sip_Products();
            sip_Products.setState("putaway");
            sip_Products.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)sip_Products_Channel.getProductUuid());
            this.dao.update((AbsModel)sip_Products);
            r = this.saveChannelInfo(sip_Products_Channel);
        } else {
            for (Map map : resultList) {
                if (!sip_Products_Channel.getChannelType().contains(StrUtil.trimStr(map.get("channel_type")))) continue;
                r.setFailMsg("\u8be5\u4ea7\u54c1\u5df2\u7ecf\u5728\u9009\u62e9\u7684\u6e20\u9053\u4e2d\u53d1\u5e03,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                return r.msg();
            }
            r = this.saveChannelInfo(sip_Products_Channel);
        }
        r.setSuccessMsg("\u4fdd\u5b58\u4ea7\u54c1\u53d1\u5e03\u4fe1\u606f\u6210\u529f\uff01");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("channel_type", sip_Products_Channel.getChannelType());
        m.put("node_no", sip_Products_Channel.getProductUuid());
        r.setDataTable(m);
        return r.msg();
    }

    private Return checkParam(Map<String, Object> param) {
        Return msg = new Return();
        String channel_type = StrUtil.trimStr((Object)param.get("channel_type"));
        String start_date = StrUtil.trimStr((Object)param.get("start_date"));
        if (StrUtil.isNull((Object)channel_type)) {
            msg.setFailMsg("\u4ea7\u54c1\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!start_date.equals(DateUtil.date2String((Date)DateUtil.sysDate())) && DateUtil.dateBetween((Date)DateUtil.string2Date((Object)start_date), (Date)DateUtil.sysDate(), (DateUtil.DateType)DateUtil.DateType.DAY) == -1) {
            msg.setFailMsg("\u53d1\u5e03\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff01");
        }
        return msg;
    }

    private Return saveChannelInfo(Sip_Products_Channel sip_Products_Channel) {
        String[] channelContetnArray;
        Return msg = new Return();
        String channelStr = sip_Products_Channel.getChannelType();
        for (String channelType : channelContetnArray = channelStr.split(",")) {
            sip_Products_Channel.setPrdChanlUuid(UniqueSeq.shortUUID());
            sip_Products_Channel.setChannelType(channelType);
            this.dao.save((AbsModel)sip_Products_Channel);
        }
        return msg;
    }

    private void copyRelease(String product_uuid, String node_seq, String node_seq_new) {
        Dsn_Structure structure = new Dsn_Structure();
        String node_no = node_seq.substring(node_seq.length() - 9, node_seq.length() - 1);
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        List structureList = this.dao.findAll((AbsModel)structure);
        for (Dsn_Structure newStructure : structureList) {
            String newNode_no = UniqueSeq.shortUUID();
            String serno = UniqueSeq.shortUUID();
            newStructure.setSerno(serno);
            newStructure.setNodeNo(newNode_no);
            newStructure.setUpNode(product_uuid);
            String node_seq_old = newStructure.getNodeSeq().substring(0, newStructure.getNodeSeq().length());
            if (StrUtil.isNull((Object)node_seq_new)) {
                node_seq_new = product_uuid + ".";
            }
            newStructure.setNodeSeq(node_seq_new + newNode_no + ".");
            newStructure.setIsMaster("");
            this.dao.save((AbsModel)newStructure);
        }
    }

    @Override
    public ReturnMsg queryParentProduct() {
        Return r = new Return();
        Sip_Products sipProducts4Query = new Sip_Products();
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.is_master, (Object)this.IS_TEMPLATE);
        List sipProductsList = this.dao.findAll((AbsModel)sipProducts4Query);
        if (null == sipProductsList || sipProductsList.isEmpty()) {
            r.setFailMsg("\u6ca1\u6709\u67e5\u5230\u6bcd\u7248\u7c7b\u4ea7\u54c1\uff01");
            return r.msg();
        }
        r.setDataList(sipProductsList, Sip_Products.class);
        return r.msg();
    }

    @Override
    public ReturnMsg addProductParent(Map<String, Object> param) {
        Return r = new Return();
        String product_name = StrUtil.trimStr((Object)param.get("product_name"));
        Dsn_Structure structure = new Dsn_Structure();
        structure.setNodeName(product_name);
        String node_no = UniqueSeq.shortUUID();
        structure.setNodeNo(node_no);
        structure.setNodeType("prd");
        structure.setUpNode("prd_root");
        structure.setNodeSeq(node_no + ".");
        Dsn_Structure newStructure = new Dsn_Structure();
        newStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd");
        newStructure.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.desc()});
        List dsnList = this.dao.findAll((AbsModel)newStructure);
        String display_order = "0";
        if (null != dsnList && !dsnList.isEmpty()) {
            display_order = StrUtil.trimStr((Object)((Dsn_Structure)((Object)dsnList.get(0))).getDisplayOrder());
        }
        int display = Integer.parseInt(display_order);
        structure.setDisplayOrder(++display);
        structure.setIsMaster(this.IS_TEMPLATE);
        this.dao.save((AbsModel)structure);
        Sip_Products product = new Sip_Products();
        product.setProductUuid(node_no);
        product.setProductNo(node_no);
        product.setProductName(product_name);
        product.setState("S");
        product.setIsMaster(this.IS_TEMPLATE);
        this.dao.save((AbsModel)product);
        r = this.saveChildNode(structure);
        param.put("node_no", node_no);
        r.setDataTable(param);
        return r.msg();
    }

    private Return saveChildNode(Dsn_Structure ds) {
        Return r = new Return();
        List<Dsn_Structure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        this.dao.save(nextNodeList);
        if (!nextNodeList.isEmpty()) {
            for (Dsn_Structure dsNew : nextNodeList) {
                r = this.saveChildNode(dsNew);
            }
        }
        return r;
    }

    private List<Dsn_Structure> queryChildNode(String node_type, String node_no, String node_seq) {
        Sys_Tree_Menu queryNode = new Sys_Tree_Menu();
        queryNode.where().addEq((ModelField)Sys_Tree_Menu.Field.up_menu, (Object)node_type);
        queryNode.where().addEq((ModelField)Sys_Tree_Menu.Field.menu_type, (Object)"node");
        queryNode.setOrderBy(new Sort.Order[]{Sys_Tree_Menu.Field.display_order.asc()});
        List<Dsn_Structure> nextNodeList = this.dao.findAll((AbsModel)queryNode, false).stream().map(node -> {
            Dsn_Structure nextNode = new Dsn_Structure();
            nextNode.setNodeNo(UniqueSeq.shortUUID());
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(node_no);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(node_seq + nextNode.getNodeNo() + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }

    @Override
    public ReturnMsg executeProductNotRelease(Sip_Products_Channel sipProductsChannel) {
        Return r = new Return();
        if (DateUtil.compareDate((Date)DateUtil.string2Date((Object)sipProductsChannel.getStartDate()), (Date)DateUtil.string2Date((Object)sipProductsChannel.getEndDate())) == 1) {
            r.setFailMsg("\u53d6\u6d88\u53d1\u5e03\u65f6\u95f4\u4e0d\u80fd\u518d\u53d1\u5e03\u65f6\u95f4\u4e4b\u524d");
            return r.msg();
        }
        if (DateUtil.compareDate((Date)DateUtil.sysDate(), (Date)DateUtil.string2Date((Object)sipProductsChannel.getEndDate())) == 1) {
            r.setFailMsg("\u53d6\u6d88\u53d1\u5e03\u65f6\u95f4\u4e0d\u80fd\u4e3a\u5f53\u524d\u65e5\u5fd7\u4e4b\u524d");
            return r.msg();
        }
        String product_uuid = sipProductsChannel.getProductUuid();
        String prd_chanl_uuid = sipProductsChannel.getPrdChanlUuid();
        Sip_Products_Channel sipProductsChannel1 = new Sip_Products_Channel();
        sipProductsChannel1.where().addEq((ModelField)Sip_Products_Channel.Field.prd_chanl_uuid, (Object)prd_chanl_uuid);
        sipProductsChannel1.setEndDate(sipProductsChannel.getEndDate());
        this.dao.update((AbsModel)sipProductsChannel1);
        Sip_Products_Channel spc = new Sip_Products_Channel();
        spc.where().addEq((ModelField)Sip_Products_Channel.Field.product_uuid, (Object)product_uuid);
        List spcList = this.dao.findAll((AbsModel)spc);
        if (spcList.isEmpty()) {
            String sql = "update sip_products set state = ? where product_uuid = ?";
            UpdateSqlable querySql = DBHandleCreator.getInstance().getUpdateSql();
            querySql.add((Object)"effective");
            querySql.add((Object)product_uuid);
            querySql.setSql(sql);
            this.dao.update(querySql);
        }
        return r.msg();
    }

    @Override
    public ReturnMsg addProduct(Map<String, Object> param) {
        Return r = new Return();
        String fromProductNo = StrUtil.trimStr((Object)param.get("parent_node_no"));
        String product_name = StrUtil.trimStr((Object)param.get("product_name"));
        String channel = StrUtil.trimStr((Object)param.get("channel"));
        String product_uuid = UniqueSeq.shortUUID();
        this.copyProductsAndAttributes(fromProductNo, product_name, product_uuid, this.NOT_TEMPLATE);
        List<Dsn_Structure> dsList = this.nodeService.getMainRiskNodeListByProductUuid(product_uuid);
        int idx = 0;
        for (Dsn_Structure mainRiskNode : dsList) {
            mainRiskNode.setNodeName(StrUtil.trimStr((Object)param.get("main_risks_name" + idx++)));
            this.dao.update(mainRiskNode.getSerno(), (AbsModel)mainRiskNode);
            String no = mainRiskNode.getNodeNo();
            Dsn_Structure ds1 = new Dsn_Structure();
            ds1.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)no);
            ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
            ds1.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
            List dsList1 = this.dao.findAll((AbsModel)ds1);
            for (int j = 0; j < dsList1.size(); ++j) {
                ((Dsn_Structure)((Object)dsList1.get(j))).setNodeName(StrUtil.trimStr((Object)param.get("accy_risks_name" + j)));
                this.dao.update(((Dsn_Structure)((Object)dsList1.get(j))).getSerno(), (AbsModel)dsList1.get(j));
                ds1.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)((Dsn_Structure)((Object)dsList1.get(j))).getNodeSeq());
                ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_main_exempt");
                ds1.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
                List dsList2 = this.dao.findAll((AbsModel)ds1);
                for (int z = 0; z < dsList2.size(); ++z) {
                    ((Dsn_Structure)((Object)dsList2.get(z))).setNodeName(StrUtil.trimStr((Object)param.get("exempt_risks_name1_" + z)));
                    this.dao.update(((Dsn_Structure)((Object)dsList2.get(z))).getSerno(), (AbsModel)dsList2.get(z));
                }
            }
            ds1.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)no);
            ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_main_exempt");
            ds1.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
            List dsList3 = this.dao.findAll((AbsModel)ds1);
            for (int j = 0; j < dsList3.size(); ++j) {
                String[] nodeSeqs = ((Dsn_Structure)((Object)dsList3.get(j))).getNodeSeq().split("\\.");
                if (nodeSeqs.length != 5) continue;
                ((Dsn_Structure)((Object)dsList3.get(j))).setNodeName(StrUtil.trimStr((Object)param.get("exempt_risks_name2_" + j)));
                this.dao.update(((Dsn_Structure)((Object)dsList3.get(j))).getSerno(), (AbsModel)dsList3.get(j));
            }
        }
        String sql = "update sip_products set state = ?,serno = ? where product_uuid = ?";
        UpdateSqlable querySql = DBHandleCreator.getInstance().getUpdateSql();
        querySql.add((Object)"S");
        querySql.add((Object)UniqueSeq.shortUUID());
        querySql.add((Object)product_uuid);
        querySql.setSql(sql);
        this.dao.update(querySql);
        param.put("node_no", product_uuid);
        r.setDataTable(param);
        return r.msg();
    }

    private Return copyProduct(String fromPage_node_no, String newProduct_name, String newgenProduct_uuid, String flag) {
        Return r = new Return();
        Dsn_Structure structure_dis = new Dsn_Structure();
        structure_dis.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd");
        structure_dis.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.desc()});
        String display_order = StrUtil.trimStr((Object)((Dsn_Structure)((Object)this.dao.findAll((AbsModel)structure_dis).get(0))).getDisplayOrder());
        int display = Integer.parseInt(display_order);
        ++display;
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)fromPage_node_no);
        structure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        structure.setSerno(UniqueSeq.shortUUID());
        structure.setNodeNo(newgenProduct_uuid);
        structure.setNodeName(newProduct_name);
        structure.setNodeSeq(newgenProduct_uuid + ".");
        structure.setUpNode("/prd_root");
        structure.setDisplayOrder(display);
        switch (flag) {
            case "Y": {
                structure.setIsMaster(this.IS_TEMPLATE);
                break;
            }
            case "N": {
                structure.setIsMaster(this.NOT_TEMPLATE);
                break;
            }
            default: {
                structure.setIsMaster("");
            }
        }
        this.dao.save((AbsModel)structure);
        this.replaceNodeNo(newgenProduct_uuid, fromPage_node_no + ".", null, newgenProduct_uuid);
        this.addSipProduct(fromPage_node_no, newgenProduct_uuid, newProduct_name, flag);
        if (!this.IS_TEMPLATE.equals(structure.getIsMaster())) {
            this.addSipProductsChannelOrOrgan(fromPage_node_no, newgenProduct_uuid);
        }
        return r;
    }

    private void replaceNodeNo(String product_uuid, String node_seq, String node_seq_new, String sip_product_uuid) {
        Dsn_Structure structure = new Dsn_Structure();
        String node_no = node_seq.substring(node_seq.length() - 9, node_seq.length() - 1);
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        List structureList = this.dao.findAll((AbsModel)structure);
        for (Dsn_Structure newStructure : structureList) {
            newStructure.setSerno(UniqueSeq.shortUUID());
            String newNode_no = UniqueSeq.shortUUID();
            String old_node_no = newStructure.getNodeNo();
            newStructure.setNodeNo(newNode_no);
            newStructure.setUpNode(product_uuid);
            String node_seq_old = newStructure.getNodeSeq().substring(0, newStructure.getNodeSeq().length());
            if (StrUtil.isNull((Object)node_seq_new)) {
                node_seq_new = product_uuid + ".";
            }
            newStructure.setNodeSeq(node_seq_new + newNode_no + ".");
            newStructure.setIsMaster("");
            if (!"main_risks".equals(newStructure.getNodeType())) {
                this.replaceNodeNo(newNode_no, node_seq_old, node_seq_new + newNode_no + ".", sip_product_uuid);
            } else {
                Dsn_Structure dsn = new Dsn_Structure();
                dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)old_node_no);
                dsn.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_risk_detail");
                dsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
                Sip_Product_Risks product_risk = new Sip_Product_Risks();
                product_risk.setProductUuid(sip_product_uuid);
                product_risk.setRiskUuid(dsn.getNodeNo());
                this.dao.save((AbsModel)product_risk);
                newStructure.setNodeNo(old_node_no);
            }
            if ("attr_detail".equals(newStructure.getNodeType())) {
                this.copyAttributeTable(old_node_no, newNode_no);
            }
            this.dao.save((AbsModel)newStructure);
        }
    }

    private void copyAttributeTable(String oldNodeNo, String node_no) {
        Dsn_Biz_Attribute biz_attr = new Dsn_Biz_Attribute();
        biz_attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)oldNodeNo);
        biz_attr = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)biz_attr);
        String attr_uuid = "";
        String old_attr_uuid = "";
        if (biz_attr != null) {
            attr_uuid = UniqueSeq.shortUUID();
            old_attr_uuid = biz_attr.getAttrUuid();
            if (!StrUtil.isNull((Object)biz_attr.getBizUuid())) {
                biz_attr.setAttrUuid(attr_uuid);
                biz_attr.setBizUuid(node_no);
                biz_attr.setSerno(UniqueSeq.shortUUID());
                this.dao.save((AbsModel)biz_attr);
            }
        }
        Dsn_Biz_Attribute_Option biz_attr_option = new Dsn_Biz_Attribute_Option();
        biz_attr_option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)oldNodeNo);
        biz_attr_option.setOrderBy(new Sort.Order[]{Dsn_Biz_Attribute_Option.Field.option_order.asc()});
        List biz_attr_optionList = this.dao.findAll((AbsModel)biz_attr_option);
        if (biz_attr_optionList != null && !biz_attr_optionList.isEmpty()) {
            for (Dsn_Biz_Attribute_Option option : biz_attr_optionList) {
                option.setSerno(UniqueSeq.shortUUID());
                option.setBizUuid(node_no);
                option.setOptionNo(UniqueSeq.shortUUID());
                this.dao.save((AbsModel)option);
            }
        }
        Dsn_Attribute attr = new Dsn_Attribute();
        attr.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)old_attr_uuid);
        attr = (Dsn_Attribute)this.dao.findOne((AbsModel)attr);
        if (attr != null && !StrUtil.isNull((Object)attr.getAttrUuid())) {
            attr.setSerno(UniqueSeq.shortUUID());
            attr.setAttrUuid(attr_uuid);
            this.dao.save((AbsModel)attr);
        }
        Dsn_Attribute_Option attr_option = new Dsn_Attribute_Option();
        attr_option.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)old_attr_uuid);
        attr_option.setOrderBy(new Sort.Order[]{Dsn_Attribute_Option.Field.option_order.asc()});
        List attr_optionList = this.dao.findAll((AbsModel)attr_option);
        if (attr_optionList != null && !attr_optionList.isEmpty()) {
            String finalAttr_uuid = attr_uuid;
            attr_optionList.stream().forEach(x -> {
                x.setSerno(UniqueSeq.shortUUID());
                x.setAttrUuid(finalAttr_uuid);
                this.dao.save((AbsModel)x);
            });
        }
    }

    private void addSipProduct(String node_no, String product_uuid, String product_name, String flag) {
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)node_no);
        List productList = this.dao.findAll((AbsModel)product);
        if (productList.size() > 0) {
            product = (Sip_Products)((Object)productList.get(0));
            product.setProductUuid(product_uuid);
            product.setProductName(product_name);
            product.setProductNo(product_uuid);
            product.setIsMaster(flag);
            this.dao.save((AbsModel)product);
        }
    }

    private void addSipProductsChannelOrOrgan(String node_no, String product_uuid) {
        Sip_Products_Channel spc = new Sip_Products_Channel();
        spc.where().addEq((ModelField)Sip_Products_Channel.Field.product_uuid, (Object)node_no);
        List spcList = this.dao.findAll((AbsModel)spc);
        if (spcList.size() > 0) {
            for (Sip_Products_Channel sip_Products_Channel : spcList) {
            }
        }
    }

    @Override
    public ReturnMsg delProduct(Map<String, Object> param) {
        Return r = new Return();
        List newListParam = (List)param.get("checkbox");
        for (Map tempMap : newListParam) {
            if ("ALL".equals(StrUtil.trimStr(tempMap.get("open_state"))) || "PART".equals(StrUtil.trimStr(tempMap.get("open_state")))) {
                r.setFailMsg("\u5f00\u653e\u72b6\u6001\u4e3a\u90e8\u5206\u9500\u552e\u548c\u5168\u90e8\u9500\u552e\u7684\u4ea7\u54c1\u4e0d\u80fd\u5220\u9664");
                break;
            }
            String product_uuid = StrUtil.trimStr(tempMap.get("true_product_uuid"));
            Dsn_Structure productNode = this.structureService.getOneDsnByNodeNo(product_uuid);
            this.publicTreeService.delFromRiskRelation(productNode.getNodeSeq(), productNode.getNodeType());
            Sip_Products sp = new Sip_Products();
            sp.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)product_uuid);
            this.dao.delete((AbsModel)sp);
            Sip_Products_Channel channel1 = new Sip_Products_Channel();
            channel1.where().addEq((ModelField)Sip_Products_Channel.Field.product_uuid, (Object)product_uuid);
            this.dao.delete((AbsModel)channel1);
            List<Dsn_Structure> subNodes = this.structureService.getSubNode(product_uuid);
            for (Dsn_Structure subNode : subNodes) {
                String nodeType = subNode.getNodeType();
                if ("prd_detail".equals(nodeType)) {
                    this.deleteAttrDetail(subNode.getNodeSeq(), "attr_detail");
                }
                if ("n_risk".equals(nodeType)) {
                    this.deleteRisk(subNode);
                }
                if ("n_prd_rule".equals(nodeType)) {
                    this.deleteRule(subNode);
                }
                this.structureService.delNodeBySerno(subNode.getSerno());
            }
            Dsn_Structure dsn = new Dsn_Structure();
            dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)product_uuid);
            this.dao.delete((AbsModel)dsn);
        }
        return r.msg();
    }

    private void deleteRisk(Dsn_Structure subNode) {
        List<Dsn_Structure> riskNodeList = this.structureService.getSubNode(subNode.getNodeNo());
        if (StrUtil.isNull(riskNodeList) || riskNodeList.isEmpty()) {
            return;
        }
        for (Dsn_Structure riskNode : riskNodeList) {
            this.deleteSubRisk(riskNode);
        }
    }

    @Override
    public void deleteSubRisk(Dsn_Structure riskNode) {
        Dsn_Structure main = new Dsn_Structure();
        main.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskNode.getNodeNo());
        List riskList = this.dao.findAll((AbsModel)main);
        boolean delSubflag = false;
        if (riskList.size() == 1) {
            delSubflag = true;
        } else if (riskList.size() == 2) {
            for (Dsn_Structure structureTemp2 : riskList) {
                if (!StrUtil.isNull((Object)structureTemp2.getUpNode())) continue;
                delSubflag = true;
                break;
            }
        }
        if (delSubflag) {
            this.deleteRiskDetail(riskNode, riskNode.getNodeType());
            riskList.stream().forEach(structureTemp -> this.structureService.delNodeBySerno(structureTemp.getSerno()));
            return;
        }
        this.structureService.delNodeBySerno(riskNode.getSerno());
    }

    @Override
    public void getProductfrom3rdChinaLife(Map<String, Object> param) throws Exception {
        String prdCode = StrUtil.trimStr((Object)param.get("prd_code"));
        this.productService.saveFrom3rdChinaLifeByProductNo(prdCode);
    }

    @Override
    public ReturnMsg mdfOpenState(Map<String, Object> param) {
        Return _return = new Return();
        String openState = StrUtil.trimStr((Object)param.get("open_state"));
        String productUuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        if (StrUtil.isNull((Object)productUuid)) {
            _return.setFailMsg("\u4ea7\u54c1\u7f16\u7801\u5fc5\u987b\u4f20\u5165\u3002");
            return _return.msg();
        }
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUuid);
        product = (Sip_Products)this.dao.findOne((AbsModel)product);
        product.setOpenState(openState);
        product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUuid);
        int update = this.dao.update((AbsModel)product);
        if (update < 1) {
            _return.setFailMsg("\u72b6\u6001\u4fee\u6539\u5931\u8d25\u3002");
            return _return.msg();
        }
        Sip_Products siProducts = new Sip_Products();
        siProducts.setProductName("");
        siProducts.setProductNo("");
        siProducts.setState("");
        return this.queryProductConfig(siProducts);
    }

    @Override
    public Return deleteRiskDetail(Dsn_Structure deleteRisk, String deleteRiskNodeType) {
        Return _return = new Return();
        String nodeSeq = deleteRisk.getNodeSeq();
        String riskNodeNo = deleteRisk.getNodeNo();
        List<Dsn_Structure> subNodes = this.structureService.getSubNode(riskNodeNo);
        if (StrUtil.isNull(subNodes) || subNodes.isEmpty()) {
            return _return;
        }
        String riskUUid = this.structureService.getRiskuuidByNode(deleteRisk);
        for (Dsn_Structure subNode : subNodes) {
            String nodeType = subNode.getNodeType();
            String subNodeSeq = subNode.getNodeSeq();
            if (this.detailNodeTypeList.contains(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, "attr_detail");
            }
            if ("n_risk_attr".equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, "attr");
            }
            if ("n_accy_risks".equals(nodeType)) {
                this.deleteRisk(subNode);
            }
            if ("main_exempt".equals(nodeType)) {
                this.deleteRisk(subNode);
            }
            if ("n_rule".equals(nodeType)) {
                this.deleteRule(subNode);
            }
            if ("n_rate".equals(nodeType)) {
                this.deleteRatesGroup(deleteRisk, riskUUid);
            }
            if ("n_liability".equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, "attr4Liability");
            }
            if ("tbr".equals(nodeType)) {
                _return = this.deleteAttrDetail(subNodeSeq, "tbr_attr");
            }
            if ("bbr".equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, "bbr_attr");
            }
            if ("syr".equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, "syr_attr");
            }
            this.structureService.delNodeBySerno(subNode.getSerno());
        }
        this.delSipRisk(riskUUid);
        return _return;
    }

    private void delSipRisk(String riskUUid) {
        Sip_Risks risks = new Sip_Risks();
        risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUUid);
        this.dao.delete((AbsModel)risks);
    }

    private Return deleteRelation(String productUuid, String riskUUid) {
        Return _return = new Return();
        Sip_Risk_Relation sip_relation = new Sip_Risk_Relation();
        sip_relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)productUuid);
        sip_relation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)riskUUid);
        this.dao.delete((AbsModel)sip_relation);
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUUid);
        this.dao.delete((AbsModel)risk);
        Sip_Product_Risks product_risk = new Sip_Product_Risks();
        product_risk.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)riskUUid);
        product_risk.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)productUuid);
        this.dao.delete((AbsModel)product_risk);
        return _return;
    }

    private Return deleteRatesGroup(Dsn_Structure risk, String riskUUid) {
        Return _return = new Return();
        String sql = "select * from dsn_structure where up_node = (select node_no from dsn_structure where up_node = ? and node_type = ?)";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)risk.getNodeNo());
        querySql.add((Object)"n_rate");
        querySql.setSql(sql);
        List rateList = this.dao.findAll(querySql);
        for (Map rate : rateList) {
            Dsn_Structure attrRate = new Dsn_Structure();
            attrRate.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, rate.get("node_seq"));
            attrRate.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"attr4Rate");
            List attrRateList = this.dao.findAll((AbsModel)attrRate);
            _return = this.deleteAttribute(attrRateList, "attr4Rate");
            attrRate.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, rate.get("node_seq"));
            this.dao.delete((AbsModel)attrRate);
            Dsn_Dynamic_Data dynamicData = new Dsn_Dynamic_Data();
            dynamicData.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, rate.get("node_no"));
            dynamicData = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)dynamicData);
            if (!StrUtil.isNull((Object)riskUUid) && !StrUtil.isNull((Object)dynamicData.getField2())) {
                String rateTableName = "dsn_rate_" + riskUUid.toLowerCase() + "_" + dynamicData.getField2();
                String drop = "";
                if (DBTypes.ORACLE.equals((Object)this.DB_TYPE)) {
                    try {
                        drop = "drop table " + rateTableName;
                    }
                    catch (Exception e) {
                        Ulog.info((String)"oracle \u6ca1\u6709if exsit \u8bed\u6cd5\u6545\u6355\u83b7\u8be5\u5f02\u5e38");
                    }
                } else if (DBTypes.MYSQL.equals((Object)this.DB_TYPE)) {
                    drop = "drop table if exists " + rateTableName;
                } else {
                    throw new BusinessException("\u5f53\u524d\u6570\u636e\u7c7b\u7c7b\u578b\u6682\u65f6\u6ca1\u6709\u5339\u914d\uff01");
                }
                QuerySqlable execute = DBHandleCreator.getInstance().getQuerySql();
                execute.setSql(drop);
                this.dao.getJdbcTemplate().execute(drop);
            }
            dynamicData.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, rate.get("node_no"));
            this.dao.delete((AbsModel)dynamicData);
        }
        Dsn_Structure rateGroup = new Dsn_Structure();
        rateGroup.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)risk.getNodeNo());
        rateGroup.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_rate");
        this.dao.delete((AbsModel)rateGroup);
        return _return;
    }

    private Return deleteRule(Dsn_Structure rule) {
        Return r = new Return();
        rule.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)rule.getNodeSeq());
        rule.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"rule");
        List ruleList = this.dao.findAll((AbsModel)rule);
        r = this.deleeteRuleDetail(ruleList);
        rule.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)rule.getNodeSeq());
        if (!StrUtil.isNull((Object)rule.getNodeSeq())) {
            this.dao.delete((AbsModel)rule);
        }
        return r;
    }

    private Return deleeteRuleDetail(List<Dsn_Structure> ruleList) {
        Return r = new Return();
        for (Dsn_Structure rule : ruleList) {
            Dsn_Dynamic_Data data;
            String relate_tab = StrUtil.trimStr((Object)rule.getRelateTab());
            if ("sip_risk_rules".equals(relate_tab)) {
                Sip_Risk_Rules sip_rule = new Sip_Risk_Rules();
                sip_rule.where().addEq((ModelField)Sip_Risk_Rules.Field.risk_rule_uuid, (Object)rule.getNodeNo());
                List sip_ruleList = this.dao.findAll((AbsModel)sip_rule);
                sip_rule.where().addEq((ModelField)Sip_Risk_Rules.Field.risk_rule_uuid, (Object)rule.getNodeNo());
                this.dao.delete((AbsModel)sip_rule);
                if (sip_ruleList.size() <= 0) continue;
                for (Sip_Risk_Rules sipRule : sip_ruleList) {
                    if (StrUtil.isNull((Object)sipRule.getSerno())) continue;
                    data = new Dsn_Dynamic_Data();
                    data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)sipRule.getSerno());
                    this.dao.delete((AbsModel)data);
                }
                continue;
            }
            if (!"dsn_biz_attribute_rules".equals(relate_tab)) continue;
            Dsn_Biz_Attribute_Rules biz_rule = new Dsn_Biz_Attribute_Rules();
            biz_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)rule.getNodeNo());
            List biz_ruleList = this.dao.findAll((AbsModel)biz_rule);
            biz_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)rule.getNodeNo());
            this.dao.delete((AbsModel)biz_rule);
            if (biz_ruleList.size() <= 0) continue;
            for (Dsn_Biz_Attribute_Rules bizRule : biz_ruleList) {
                if (StrUtil.isNull((Object)bizRule.getSerno())) continue;
                data = new Dsn_Dynamic_Data();
                data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)bizRule.getSerno());
                this.dao.delete((AbsModel)data);
            }
        }
        return r;
    }

    private Return deleteAttrDetail(String node_seq, String node_type) {
        Return r = new Return();
        Dsn_Structure attr_detail = new Dsn_Structure();
        attr_detail.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_seq);
        attr_detail.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)node_type);
        List attr_detailList = this.dao.findAll((AbsModel)attr_detail);
        r = this.deleteAttribute(attr_detailList, node_type);
        attr_detail.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_seq);
        attr_detail.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)node_type);
        this.dao.delete((AbsModel)attr_detail);
        return r;
    }

    private Return deleteAttribute(List<Dsn_Structure> attrList, String node_type) {
        Return r = new Return();
        for (Dsn_Structure detail : attrList) {
            Dsn_Biz_Attribute attr_biz = new Dsn_Biz_Attribute();
            attr_biz.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)detail.getNodeNo());
            attr_biz = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)attr_biz);
            attr_biz.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)detail.getNodeNo());
            this.dao.delete((AbsModel)attr_biz);
            Dsn_Biz_Attribute_Option biz_option = new Dsn_Biz_Attribute_Option();
            biz_option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)detail.getNodeNo());
            this.dao.delete((AbsModel)biz_option);
            Dsn_Attribute attr = new Dsn_Attribute();
            attr.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)attr_biz.getAttrUuid());
            attr = (Dsn_Attribute)this.dao.findOne((AbsModel)attr);
            attr.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)attr_biz.getAttrUuid());
            this.dao.delete((AbsModel)attr);
            Dsn_Attribute_Option dsn_option = new Dsn_Attribute_Option();
            dsn_option.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)attr.getAttrUuid());
            this.dao.delete((AbsModel)dsn_option);
            Dsn_Structure rule = new Dsn_Structure();
            rule.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)detail.getNodeNo());
            if (!"attr4Liability".equals(node_type)) {
                if (!StrUtil.isNull((Object)(rule = (Dsn_Structure)this.dao.findOne((AbsModel)rule)).getNodeNo())) {
                    r = this.deleteRule(rule);
                }
            } else {
                List ruleList = this.dao.findAll((AbsModel)rule);
                r = this.deleeteRuleDetail(ruleList);
            }
            Dsn_Structure dsn = new Dsn_Structure();
            dsn.where().addEq((ModelField)Dsn_Structure.Field.node_seq, (Object)detail.getNodeSeq());
            this.dao.delete((AbsModel)dsn);
        }
        return r;
    }

    @Override
    public ReturnMsg copyProduct(Map<String, Object> param) {
        Return r = new Return();
        String fromPage_node_no = StrUtil.trimStr((Object)param.get("product_uuid"));
        String newProduct_name = StrUtil.trimStr((Object)param.get("product_name"));
        String is_master = StrUtil.trimStr((Object)param.get("is_master"));
        if ("\u662f".equals(is_master)) {
            is_master = this.IS_TEMPLATE;
        } else if ("\u5426".equals(is_master)) {
            is_master = this.NOT_TEMPLATE;
        }
        String newgenProduct_uuid = UniqueSeq.shortUUID();
        r = this.copyProduct(fromPage_node_no, newProduct_name, newgenProduct_uuid, is_master);
        param.put("node_no", newgenProduct_uuid);
        r.setDataTable(param);
        return r.msg();
    }

    @Override
    public ReturnMsg newCopyProductDetailHandle(Map<String, Object> param, String new_product_no) {
        String fromPage_node_no = StrUtil.trimStr((Object)param.get("product_uuid"));
        String newProduct_name = StrUtil.trimStr((Object)param.get("product_name"));
        String is_master = StrUtil.trimStr((Object)param.get("is_master"));
        if ("\u662f".equals(is_master)) {
            is_master = this.IS_TEMPLATE;
        } else if ("\u5426".equals(is_master)) {
            is_master = this.NOT_TEMPLATE;
        }
        String new_node_no = UniqueSeq.shortUUID();
        this.copyProductsAndAttributes(fromPage_node_no, newProduct_name, new_node_no, is_master);
        Return res = new Return();
        param.put("node_no", new_node_no);
        res.setDataTable(param);
        return res.msg();
    }

    private void copyProductsAndAttributes(String oldProductRootNodeNo, String newProductName, String newProductRootNodeNo, String isModel) {
        this.creatProductRoot(oldProductRootNodeNo, newProductRootNodeNo, newProductName, isModel);
        List<String> mainRiskUUidList = this.changeChildNodeNoAndSeriNoAndAttributes("", oldProductRootNodeNo, newProductRootNodeNo + ".", newProductRootNodeNo);
        this.copy_Sip_Products_all(mainRiskUUidList, oldProductRootNodeNo, newProductRootNodeNo, newProductName, isModel);
        if (!this.IS_TEMPLATE.equals(isModel)) {
            this.addSipProductsChannelOrOrgan(oldProductRootNodeNo, newProductRootNodeNo);
        }
    }

    private void copy_Sip_Products_all(List<String> riskUuidList, String oldProductRootNodeNo, String newProductRootNodeNo, String newProductName, String isMaster) {
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)oldProductRootNodeNo);
        List productList = this.dao.findAll((AbsModel)product);
        if (productList != null && !productList.isEmpty()) {
            product = (Sip_Products)((Object)productList.get(0));
            product.setProductUuid(newProductRootNodeNo);
            product.setProductName(newProductName);
            product.setProductNo(newProductRootNodeNo);
            product.setIsMaster(isMaster);
            this.dao.save((AbsModel)product);
        }
        if (riskUuidList != null && !riskUuidList.isEmpty()) {
            for (String mainRiskUUid : riskUuidList) {
                Sip_Product_Risks sip_product_risks = new Sip_Product_Risks();
                sip_product_risks.setProductUuid(newProductRootNodeNo);
                sip_product_risks.setRiskUuid(mainRiskUUid);
            }
        }
    }

    private void creatProductRoot(String oldNodeNo, String newNodeNo, String newProductName, String isModel) {
        Dsn_Structure structure_dis = new Dsn_Structure();
        structure_dis.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd");
        structure_dis.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.desc()});
        String display_order = StrUtil.trimStr((Object)((Dsn_Structure)((Object)this.dao.findAll((AbsModel)structure_dis).get(0))).getDisplayOrder());
        int display = Integer.parseInt(display_order);
        ++display;
        Dsn_Structure oldProductNo = new Dsn_Structure();
        oldProductNo.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldNodeNo);
        oldProductNo = (Dsn_Structure)this.dao.findOne((AbsModel)oldProductNo);
        if (oldProductNo != null && StringUtils.isNotBlank((CharSequence)oldProductNo.getNodeNo())) {
            oldProductNo.setSerno(UniqueSeq.shortUUID());
            oldProductNo.setNodeNo(newNodeNo);
            oldProductNo.setNodeName(newProductName);
            oldProductNo.setNodeSeq(newNodeNo + ".");
            oldProductNo.setUpNode("/product_root");
            oldProductNo.setDisplayOrder(display);
            oldProductNo.setIsMaster(!StrUtil.isNull((Object)isModel) ? isModel : "N");
            this.dao.save((AbsModel)oldProductNo);
        }
    }

    @Override
    public List<String> changeChildNodeNoAndSeriNoAndAttributes(String new_risk_name, String old_parent_node_no, String parent_new_node_seq, String parent_new_node_no) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)old_parent_node_no);
        structure.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        List oldSubStructureList = this.dao.findAll((AbsModel)structure);
        if (oldSubStructureList == null || oldSubStructureList.isEmpty()) {
            return null;
        }
        ArrayList<String> mainRiskUUidList = new ArrayList<String>();
        oldSubStructureList.stream().forEach(oldSubStructure -> {
            String oldSubNodeNo = oldSubStructure.getNodeNo();
            String nodeType = oldSubStructure.getNodeType();
            String newSubNodeNo = UniqueSeq.shortUUID();
            String newSubNodeSeq = parent_new_node_seq + newSubNodeNo + ".";
            oldSubStructure.setNodeNo(newSubNodeNo);
            oldSubStructure.setNodeSeq(newSubNodeSeq);
            oldSubStructure.setUpNode(parent_new_node_no);
            oldSubStructure.setSerno(UniqueSeq.shortUUID());
            this.dao.save((AbsModel)oldSubStructure);
            if (StructureConstant.RISK_DETAIL_LIST.contains(nodeType)) {
                if ("n_risk_detail".equals(nodeType)) {
                    mainRiskUUidList.add(newSubNodeNo);
                }
                this.riskCopyService.handleRiskInfo(oldSubNodeNo, newSubNodeNo, new_risk_name);
            }
            if (StructureConstant.ATTR_ARR_LIST.contains(nodeType)) {
                this.attrbuteHandleService.handleAttributesTables(oldSubNodeNo, newSubNodeNo);
            }
            if ("rate".equals(nodeType)) {
                this.attrbuteHandleService.handleDsn_Dynamic_Data(oldSubNodeNo, newSubNodeNo);
            }
            if ("rule".equals(nodeType)) {
                String relate_tab = oldSubStructure.getRelateTab();
                this.productRuleCopyImp.handleRule_sip_risk_rule(relate_tab, oldSubNodeNo, newSubNodeNo);
            }
            if (!(StringUtils.equals((CharSequence)nodeType, (CharSequence)"n_accy_risks") || StringUtils.equals((CharSequence)nodeType, (CharSequence)"main_exempt") || StringUtils.equals((CharSequence)nodeType, (CharSequence)"output") || StringUtils.equals((CharSequence)nodeType, (CharSequence)"input"))) {
                this.changeChildNodeNoAndSeriNoAndAttributes(new_risk_name, oldSubNodeNo, newSubNodeSeq, newSubNodeNo);
            }
        });
        return mainRiskUUidList;
    }

    @Override
    public ReturnMsg queryProductChannel(Map<String, Object> param) {
        String product_uuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        Sip_Products_Channel spc = new Sip_Products_Channel();
        spc.where().addEq((ModelField)Sip_Products_Channel.Field.product_uuid, (Object)product_uuid);
        spc.where().addCallback((RowCallback)new com.newtouch.repository.util.RepEnum("channel_type", (ModelField)Sip_Products_Channel.Field.channel_type));
        List spcList = this.dao.findAll((AbsModel)spc);
        Return r = new Return();
        if (spcList.size() > 0) {
            r.setDataList(spcList, Sip_Products_Channel.class);
        }
        return r.msg();
    }

    @Override
    public ReturnMsg queryFindOrgan() {
        Ws_Life_T_Company_Organ org = new Ws_Life_T_Company_Organ();
        org.where().addEq((ModelField)Ws_Life_T_Company_Organ.Field.organ_id, (Object)"1000000");
        org.where().addCallback((RowCallback)new RowCallback<Ws_Life_T_Company_Organ>(){

            public void callback(Ws_Life_T_Company_Organ row, List<? extends Ws_Life_T_Company_Organ> data, int index) {
                row.putOtherProperty("isParent", "true");
            }
        });
        List orgList = this.dao.findAll((AbsModel)org);
        Return r = new Return();
        r.setDataList(orgList, Ws_Life_T_Company_Organ.class);
        return r.msg();
    }

    @Override
    public ReturnMsg queryFindAllOrgan(Map<String, Object> param) {
        Return r = new Return();
        String organ_id = StrUtil.trimStr((Object)param.get("organ_id"));
        ArrayList dataListNew = new ArrayList();
        if (organ_id.contains("agency")) {
            String agencyOrganID = organ_id.split("\\.")[1];
            List dataList = null;
            DBHandleable db = DBHandleCreator.getInstance().getDBHandle("fmisDataSource", DBTypes.ORACLE);
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            String sql = "select AGENCY_ID,AGENCY_NAME from t01agencyinfo where stat = ? and branch_id = ? ";
            query.add((Object)"1");
            query.add((Object)agencyOrganID);
            query.setSql(sql);
            query.addRowCallback((RowCallback)new RowCallback<Map<String, Object>>(){

                public void callback(Map<String, Object> row, List<? extends Map<String, Object>> dataList, int index) {
                    String agencyName = StrUtil.trimStr((Object)row.get("agency_id")) + "-" + StrUtil.trimStr((Object)row.get("agency_name"));
                    row.put("agency_name", agencyName);
                }
            });
            dataList = db.queryList(query);
            HashMap<String, String> dataMap = null;
            for (Map tmpMap : dataList) {
                dataMap = new HashMap<String, String>();
                dataMap.put("organ_id", StrUtil.trimStr(tmpMap.get("agency_id")));
                dataMap.put("company_name", StrUtil.trimStr(tmpMap.get("agency_name")));
                dataMap.put("leaf", "Y");
                dataMap.put("parent_id", "agency" + organ_id);
                dataMap.put("class_id", AGENCY_ORGAN_FLAG);
                dataListNew.add(dataMap);
            }
        }
        Ws_Life_T_Company_Organ org = new Ws_Life_T_Company_Organ();
        org.where().addEq((ModelField)Ws_Life_T_Company_Organ.Field.parent_id, (Object)organ_id);
        org.where().addCallback((RowCallback)new RowCallback<Ws_Life_T_Company_Organ>(){

            public void callback(Ws_Life_T_Company_Organ row, List<? extends Ws_Life_T_Company_Organ> data, int index) {
                if (row.getFullId().length() < 24) {
                    row.putOtherProperty("isParent", "true");
                } else if (row.getFullId().length() > 31) {
                    data.remove(index);
                }
            }
        });
        List orgList = this.dao.findAll((AbsModel)org);
        ArrayList<Map<String, Object>> newOrgList = new ArrayList<Map<String, Object>>();
        Map<String, Object> tmpMap = null;
        for (Ws_Life_T_Company_Organ wsLifeTCompanyOrgan : orgList) {
            tmpMap = JsonUtilOld.objToMap((Object)wsLifeTCompanyOrgan);
            newOrgList.add(tmpMap);
        }
        if (!"1000000".equals(organ_id) && !organ_id.contains("agency")) {
            HashMap<String, String> agencyNode = new HashMap<String, String>(16);
            agencyNode.put("leaf", "N");
            agencyNode.put("parent_id", organ_id);
            agencyNode.put("organ_id", "agency." + organ_id);
            agencyNode.put("company_name", "\u4e2d\u4ecb\u673a\u6784");
            agencyNode.put("isParent", "true");
            newOrgList.add(agencyNode);
        }
        if (null != dataListNew && !dataListNew.isEmpty()) {
            newOrgList.addAll(dataListNew);
        }
        r.setDataList(newOrgList);
        return r.msg();
    }

    @Override
    public ReturnMsg putawayProduct(Map<String, Object> requestParam) {
        Return r = new Return();
        Map<String, Object> parmMap = null;
        try {
            parmMap = this.getInnerParm(requestParam);
        }
        catch (BusinessException e) {
            r.setFailMsg(e.getMessage());
            return r.msg();
        }
        ReturnMsg class1RM = this.class1Deal((Map)parmMap.get(this.class_1_tag), parmMap);
        if (class1RM == null) {
            this.saveParentAndDelsub((List)parmMap.get(this.class_2_tag), parmMap, (List)parmMap.get(this.class_3_tag));
            this.saveParentAndDelsub((List)parmMap.get(this.class_3_tag), parmMap, (List)parmMap.get(this.class_4_tag));
            this.saveOrganData((List)parmMap.get(this.class_4_tag), parmMap);
            this.saveOrganData((List)parmMap.get(this.class_100_tag), parmMap);
        }
        String sql = "update sip_products set state = ? where product_uuid = ?";
        UpdateSqlable querySql = DBHandleCreator.getInstance().getUpdateSql();
        querySql.add((Object)"putaway");
        querySql.add((Object)((String)parmMap.get(this.product_uuid_tag)));
        querySql.setSql(sql);
        this.dao.update(querySql);
        this.executeMyThread((String)parmMap.get(this.product_uuid_tag), (Date)parmMap.get(this.start_date_tag), (String)parmMap.get(this.file_no_tag), false);
        r.setSuccessMsg("\u4e0a\u67b6\u6210\u529f");
        return r.msg();
    }

    private Map<String, Object> getInnerParm(Map<String, Object> requestParam) {
        HashMap<String, Object> innerParmMap = new HashMap<String, Object>();
        String product_uuid = StrUtil.trimStr((Object)requestParam.get("product_uuid"));
        innerParmMap.put(this.product_uuid_tag, product_uuid);
        if (this.checkPutawayCondition(product_uuid)) {
            throw new BusinessException("\u8be5\u4ea7\u54c1\u8fd8\u672a\u914d\u7f6e\u9669\u79cd\u4fe1\u606f\uff0c\u8bf7\u5b8c\u6210\u9669\u79cd\u7684\u914d\u7f6e\u518d\u64cd\u4f5c\u4e0a\u67b6\uff01");
        }
        if (this.checkPutawayProductInfo(requestParam)) {
            throw new BusinessException("\u4e0d\u53ef\u4e0a\u67b6\u91cd\u590d\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u673a\u6784\uff0c\u6e20\u9053\uff0c\u5efa\u8bae\u4e66\u3001\u51fa\u5355\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        String prd_chanl_uuid = StrUtil.trimStr((Object)requestParam.get("prd_chanl_uuid"));
        Date policyStartDate = DateUtil.string2Date((Object)StrUtil.trimStr((Object)requestParam.get("start_date")));
        innerParmMap.put(this.start_date_tag, policyStartDate);
        Date policyEndDate = DateUtil.string2Date((Object)StrUtil.trimStr((Object)requestParam.get("end_date")));
        List checkboxMapList = (List)requestParam.get("checkbox");
        this.organizationSelectDeal(checkboxMapList, innerParmMap);
        List riskRelationSernoList = (List)requestParam.get("riskRelationSernoJson");
        innerParmMap.put(this.riskRelationSernoList_tag, riskRelationSernoList);
        String file_no = UniqueSeq.shortUUID();
        innerParmMap.put(this.file_no_tag, file_no);
        return innerParmMap;
    }

    private void organizationSelectDeal(List<Map<String, Object>> checkboxMapList, Map<String, Object> innerParmMap) {
        if (checkboxMapList == null || checkboxMapList.isEmpty()) {
            throw new BusinessException("\u9009\u62e9\u7684\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<Object, Object> class_1 = new HashMap();
        ArrayList<Map<String, Object>> class_2 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_3 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_4 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_100 = new ArrayList<Map<String, Object>>();
        block14: for (Map<String, Object> map : checkboxMapList) {
            String class_id;
            switch (class_id = StrUtil.trimStr((Object)map.get("class_id"))) {
                case "1": {
                    class_1 = map;
                    continue block14;
                }
                case "2": {
                    class_2.add(map);
                    continue block14;
                }
                case "3": {
                    class_3.add(map);
                    continue block14;
                }
                case "4": {
                    class_4.add(map);
                    continue block14;
                }
                case "100": {
                    class_100.add(map);
                    continue block14;
                }
            }
            Ulog.warn((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u673a\u6784\u7ea7\u522b\uff01");
        }
        innerParmMap.put(this.class_1_tag, class_1);
        innerParmMap.put(this.class_2_tag, class_2);
        innerParmMap.put(this.class_3_tag, class_3);
        innerParmMap.put(this.class_4_tag, class_4);
        innerParmMap.put(this.class_100_tag, class_100);
    }

    private void saveOrganData(List<Map<String, Object>> dataList, Map<String, Object> parmMap) {
        if (dataList.isEmpty()) {
            return;
        }
    }

    private void saveParentAndDelsub(List<Map<String, Object>> parentClassList, Map<String, Object> parmMap, List<Map<String, Object>> subClassList) {
        if (parentClassList.isEmpty()) {
            return;
        }
        List riskRelationSernoList = (List)parmMap.get(this.riskRelationSernoList_tag);
        HashSet<String> parentOrganIDList = new HashSet<String>();
        for (Map<String, Object> map : parentClassList) {
            parentOrganIDList.add(StrUtil.trimStr((Object)map.get("organ_id")));
        }
        Iterator<Map<String, Object>> i4 = subClassList.iterator();
        while (i4.hasNext()) {
            String parent_id = StrUtil.trimStr((Object)i4.next().get("parent_id"));
            if (!parentOrganIDList.contains(parent_id)) continue;
            i4.remove();
        }
    }

    private ReturnMsg class1Deal(Map<String, Object> class_1, Map<String, Object> parmMap) {
        if (class_1.isEmpty()) {
            return null;
        }
        Return r = new Return();
        r.setSuccessMsg("\u4e0a\u67b6\u6210\u529f!");
        return r.msg();
    }

    private void executeMyThread(String productUUID, Date date, String fileNo, boolean flag) {
        MyThread myThread = new MyThread();
        myThread.setDao(this.dao);
        myThread.setSqlPath(this.sqlPath);
        myThread.setProductUUID(productUUID);
        myThread.setDate(date);
        myThread.setFileNo(fileNo);
        myThread.setFlag(flag);
        myThread.setiExportProductSql(this.iExportProductSql);
        new Thread(myThread).start();
    }

    private boolean checkPutawayProductInfo(Map<String, Object> param) {
        Return msg = new Return();
        boolean timeFlag = this.checkPutawayProductTime(param);
        boolean channelFlag = this.checkPutawayProductChannel(param);
        boolean organFlag = this.checkPutawayProductOrgan(param);
        return organFlag && channelFlag && timeFlag;
    }

    private boolean checkPutawayProductOrgan(Map<String, Object> param) {
        String shelfFlag = "1";
        boolean flag = false;
        String startDate = StrUtil.trimStr((Object)param.get("start_date"));
        String endDate = StrUtil.trimStr((Object)param.get("end_date"));
        String product_uuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        List mapList = (List)param.get("checkbox");
        Map class_1 = new HashMap();
        ArrayList<Map> class_2 = new ArrayList<Map>();
        ArrayList<Map> class_3 = new ArrayList<Map>();
        ArrayList<Map<String, Object>> class_4 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_100 = new ArrayList<Map<String, Object>>();
        block14: for (Map map : mapList) {
            String class_id;
            switch (class_id = StrUtil.trimStr(map.get("class_id"))) {
                case "1": {
                    class_1 = map;
                    continue block14;
                }
                case "2": {
                    class_2.add(map);
                    continue block14;
                }
                case "3": {
                    class_3.add(map);
                    continue block14;
                }
                case "4": {
                    class_4.add(map);
                    continue block14;
                }
                case "100": {
                    class_100.add(map);
                    continue block14;
                }
            }
            Ulog.warn((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u673a\u6784\u7ea7\u522b\uff01");
        }
        if (!class_1.isEmpty()) {
            String string = StrUtil.trimStr(class_1.get("organ_id"));
        }
        if (!class_2.isEmpty()) {
            // empty if block
        }
        if (!class_3.isEmpty()) {
            // empty if block
        }
        if (!class_4.isEmpty() && (flag = this.checkOrganData(class_4, product_uuid, startDate, endDate))) {
            return flag;
        }
        if (!class_100.isEmpty() && (flag = this.checkOrganData(class_100, product_uuid, startDate, endDate))) {
            return flag;
        }
        return flag;
    }

    private boolean checkOrganData(List<Map<String, Object>> dataList, String product_uuid, String startDate, String endDate) {
        String shelfFlag = "1";
        return false;
    }

    private boolean checkPutawayProductChannel(Map<String, Object> param) {
        String shelfFlag = "1";
        String product_uuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        String product_channel_uuid = StrUtil.trimStr((Object)param.get("prd_chanl_uuid"));
        return false;
    }

    private boolean checkPutawayProductTime(Map<String, Object> param) {
        String shelfFlag = "1";
        String product_uuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        String startDate = StrUtil.trimStr((Object)param.get("start_date"));
        String endDate = StrUtil.trimStr((Object)param.get("end_date"));
        String proposeStartDate = StrUtil.trimStr((Object)param.get("propose_start_date"));
        String proposeEndDate = StrUtil.trimStr((Object)param.get("propose_end_date"));
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     serno ").append(" FROM ").append("     sip_products_organ ").append(" WHERE ").append("     product_uuid = ? ").append(" AND shelf_flag = ? ").append(" AND ( ").append("     start_date BETWEEN ? ").append("     AND ? ").append("     OR end_date BETWEEN ? ").append("     AND ?  ").append("     OR propose_start_date BETWEEN ? ").append("     AND ? ").append("     OR propose_end_date BETWEEN ? ").append("     AND ? ").append(" ) ");
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)product_uuid);
        querySql.add((Object)shelfFlag);
        querySql.add((Object)startDate);
        querySql.add((Object)endDate);
        querySql.add((Object)startDate);
        querySql.add((Object)endDate);
        querySql.add((Object)proposeStartDate);
        querySql.add((Object)proposeEndDate);
        querySql.add((Object)proposeStartDate);
        querySql.add((Object)proposeEndDate);
        querySql.setSql(sqlBuffer.toString());
        List resultList = this.dao.findAll(querySql);
        return null != resultList && !resultList.isEmpty();
    }

    private void savePrdOrganRiskRelation(String prdOrganUUID, List<Map<String, Object>> riskRelationSernoList) {
        if (null == riskRelationSernoList || riskRelationSernoList.isEmpty()) {
            return;
        }
        Sip_Prd_Organ_Risk_Relation sipPrdOrganRiskRelation = null;
        for (Map<String, Object> tmpMap : riskRelationSernoList) {
            sipPrdOrganRiskRelation = new Sip_Prd_Organ_Risk_Relation();
            sipPrdOrganRiskRelation.setPrdOrganUuid(prdOrganUUID);
            String riskRelationSerno = StrUtil.trimStr((Object)tmpMap.get("riskRelationSerno"));
            sipPrdOrganRiskRelation.setRiskRelationUuid(riskRelationSerno);
            String proposeStartDate = StrUtil.trimStr((Object)tmpMap.get("proposeStartDate"));
            sipPrdOrganRiskRelation.setProposeStartDate(DateUtil.string2Date((String)proposeStartDate, (String)"yyyy-MM-dd HH:mm:ss"));
            String proposeEndDate = StrUtil.trimStr((Object)tmpMap.get("proposeEndDate"));
            sipPrdOrganRiskRelation.setProposeEndDate(DateUtil.string2Date((String)proposeEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
            String policyStartDate = StrUtil.trimStr((Object)tmpMap.get("policyStartDate"));
            sipPrdOrganRiskRelation.setPolicyStartDate(DateUtil.string2Date((String)policyStartDate, (String)"yyyy-MM-dd HH:mm:ss"));
            String policyEndDate = StrUtil.trimStr((Object)tmpMap.get("policyEndDate"));
            sipPrdOrganRiskRelation.setPolicyEndDate(DateUtil.string2Date((String)policyEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
            String isRequired = StrUtil.trimStr((Object)tmpMap.get("isRequired"));
            sipPrdOrganRiskRelation.setIsRequired(isRequired);
            String isRecommend = StrUtil.trimStr((Object)tmpMap.get("isRecommend"));
            sipPrdOrganRiskRelation.setIsRecommend(isRecommend);
            this.dao.save((AbsModel)sipPrdOrganRiskRelation);
        }
    }

    private void updateShelfFlag(String ShelfFlag, String prdOrganUUID) {
    }

    private boolean checkPutawayCondition(String productUUID) {
        Sip_Product_Risks sipProductRisks4Query = new Sip_Product_Risks();
        sipProductRisks4Query.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)productUUID);
        List sipProductRisksList = this.dao.findAll((AbsModel)sipProductRisks4Query);
        return null == sipProductRisksList || sipProductRisksList.isEmpty();
    }

    @Override
    public ReturnMsg queryPutawayMessage(Map<String, Object> param) {
        String product_uuid = StrUtil.trimStr((Object)param.get("true_product_uuid"));
        if (StrUtil.isNull((Object)product_uuid)) {
            product_uuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        }
        String organName = StrUtil.trimStr((Object)param.get("organ_name"));
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     c.channel_type AS channel_type, ").append("     w.company_name AS organ_name, ").append("     o.start_date AS start_date, ").append(" o.end_date AS end_date, ").append(" o.propose_start_date as propose_start_date, o.propose_end_date as propose_end_date, ").append("o.prd_organ_uuid AS prd_organ_uuid, o.shelf_flag, o.crt_user,").append(" c.prd_chanl_uuid AS prd_chanl_uuid ").append(" FROM ").append("     sip_products_channel c, ").append("     sip_products_organ o, ").append("     ws_life_t_company_organ w").append(" WHERE ").append("     c.prd_chanl_uuid=o.prd_chanl_uuid ").append(" AND o.organ_id=w.organ_id ").append(" AND c.product_uuid= ?   ").append(" AND o.class_id <> ? ");
        if (!StrUtil.isNull((Object)organName)) {
            sqlBuffer.append(" and w.company_name like ? ");
        }
        sqlBuffer.append(" order by o.mdf_date desc  ");
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)product_uuid);
        querySql.add((Object)AGENCY_ORGAN_FLAG);
        if (!StrUtil.isNull((Object)organName)) {
            querySql.add((Object)("%" + organName + "%"));
        }
        querySql.setSql(sqlBuffer.toString());
        querySql.addRowCallback((RowCallback)new RowCallback<Map<String, Object>>(){

            public void callback(Map<String, Object> row, List<? extends Map<String, Object>> data, int index) {
                Sip_Products_Channel sipProductsChannel4Query = new Sip_Products_Channel();
                sipProductsChannel4Query.where().addEq((ModelField)Sip_Products_Channel.Field.prd_chanl_uuid, row.get("prd_chanl_uuid"));
                sipProductsChannel4Query.where().addCallback((RowCallback)new com.newtouch.repository.util.RepEnum("channel_type", (ModelField)Sip_Products_Channel.Field.channel_type));
                sipProductsChannel4Query = (Sip_Products_Channel)ProductConfigServiceImp.this.dao.findOne((AbsModel)sipProductsChannel4Query);
                row.put("channel_type_name", sipProductsChannel4Query.getOtherProperty("channel_type_name"));
                String userID = StrUtil.trimStr((Object)row.get("crt_user"));
                String sql = " select user_name from rms_user where pk_uuid = ? ";
                QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
                query.add((Object)userID);
                query.setSql(sql);
                List userList = ProductConfigServiceImp.this.dao.findAll(query);
                if (null != userList && !userList.isEmpty()) {
                    Map userMap = (Map)userList.get(0);
                    row.put("crt_user", StrUtil.trimStr(userMap.get("user_name")));
                } else {
                    row.put("crt_user", StrUtil.trimStr((Object)"\u672a\u67e5\u8be2\u5230\u7528\u6237\uff01"));
                }
            }
        });
        List resultDBList = this.dao.findAll(querySql);
        Return r = new Return();
        r.setDataTable(param);
        Map<String, Object> organMap = this.handleOrganData(product_uuid);
        if (!StrUtil.isNull((Object)organName)) {
            organMap.put("organName", organName);
        }
        r.setDataList(resultDBList);
        r.getDataTable().put("product_uuid", product_uuid);
        List<Map<String, Object>> addedRisksList = this.getADDEDRisks(product_uuid);
        if (null != addedRisksList && !addedRisksList.isEmpty()) {
            r.getDataTable().put("addedRisks", addedRisksList);
        }
        return r.msg();
    }

    private List<Map<String, Object>> getADDEDRisks(String productUUID) {
        HashMap<String, Object> resultMap = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        Sip_Product_Risks sipProductRisk4Query = new Sip_Product_Risks();
        sipProductRisk4Query.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)productUUID);
        List sipProductRisksList = this.dao.findAll((AbsModel)sipProductRisk4Query);
        Sip_Risks sipRisk4Result = null;
        List<Map<String, Object>> addedRiskInfoList = null;
        List<Map<String, Object>> exemptRiskInfoList = null;
        List<Map<String, Object>> exemptRiskInfoInAddedRiskList = null;
        for (Sip_Product_Risks tmpProductRisk : sipProductRisksList) {
            resultMap = new HashMap<String, Object>(16);
            String mainRiskUUID = tmpProductRisk.getRiskUuid();
            sipRisk4Result = this.getRiskInfo(mainRiskUUID);
            if (null == sipRisk4Result) continue;
            resultMap.put("mainRisk", (Object)sipRisk4Result);
            addedRiskInfoList = this.queryAddedOrExemptRisk(mainRiskUUID, "ADDED");
            for (Map<String, Object> tmpMap : addedRiskInfoList) {
                String addedRiskUUID = StrUtil.trimStr((Object)tmpMap.get("risk_uuid"));
                exemptRiskInfoInAddedRiskList = this.queryAddedOrExemptRisk(addedRiskUUID, "EXEMPT");
                tmpMap.put("exemptRisk", exemptRiskInfoInAddedRiskList);
            }
            exemptRiskInfoList = this.queryAddedOrExemptRisk(mainRiskUUID, "EXEMPT");
            resultMap.put("addedRisk", addedRiskInfoList);
            resultMap.put("exemptRisk", exemptRiskInfoList);
            resultList.add(resultMap);
        }
        return resultList;
    }

    private List<Map<String, Object>> queryAddedOrExemptRisk(String riskUUID, String riskType) {
        ArrayList<Map<String, Object>> riskInfoList = new ArrayList<Map<String, Object>>(10);
        Sip_Risk_Relation sipRiskRelation4Query = new Sip_Risk_Relation();
        sipRiskRelation4Query.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)riskUUID);
        sipRiskRelation4Query.where().addEq((ModelField)Sip_Risk_Relation.Field.relation_type, (Object)riskType);
        List sipRiskRelationList = this.dao.findAll((AbsModel)sipRiskRelation4Query);
        Map<String, Object> riskMap = null;
        for (Sip_Risk_Relation tmpRiskRelation : sipRiskRelationList) {
            String riskUUID4Result = tmpRiskRelation.getRiskUuid();
            String isRequired = tmpRiskRelation.getIsRequired();
            String isRecommend = tmpRiskRelation.getIsRecommend();
            String riskRelationSerno = tmpRiskRelation.getSerno();
            Sip_Risks risk = this.getRiskInfo(riskUUID4Result);
            if (null == risk || StrUtil.isNull((Object)risk.getSerno())) continue;
            riskMap = JsonUtilOld.objToMap((Object)risk);
            riskMap.put("isRequired", isRequired);
            riskMap.put("isRecommend", isRecommend);
            riskMap.put("riskRelationSerno", riskRelationSerno);
            riskInfoList.add(riskMap);
        }
        return riskInfoList;
    }

    private Sip_Risks getRiskInfo(String riskUUID) {
        String isSaleFlag = "Y";
        Sip_Risks sipRisk4Query = new Sip_Risks();
        sipRisk4Query.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUUID);
        Sip_Risks sipRisks = (Sip_Risks)this.dao.findOne((AbsModel)sipRisk4Query);
        if (null == sipRisks || !StrUtil.isNull((Object)sipRisks.getSerno())) {
            // empty if block
        }
        return null;
    }

    private Map<String, Object> handleOrganData(String product_uuid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        return resultMap;
    }

    @Override
    public ReturnMsg soldProduct(Map<String, Object> param) {
        Return r = new Return();
        String prd_organ_uuid = StrUtil.trimStr((Object)param.get("prd_organ_uuid"));
        String product_uuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        Timestamp end_date = DateUtil.sysTimestamp();
        String shelfFlag = "0";
        List prdMap = (List)param.get("checkbox");
        if (StrUtil.isNull((Object)prd_organ_uuid)) {
            for (Map map : prdMap) {
                String string = StrUtil.trimStr(map.get("prd_organ_uuid"));
            }
        } else {
            Date date = DateUtil.string2Date((Object)StrUtil.trimStr((Object)param.get("start_date")));
            int n = DateUtil.compareDate((Date)date, (Date)end_date);
        }
        r.setSuccessMsg("\u4e0b\u67b6\u6210\u529f");
        return r.msg();
    }

    @Override
    public ReturnMsg queryRisksName(Map<String, Object> param) {
        Return r = new Return();
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_no);
        ds.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        List dsList = this.dao.findAll((AbsModel)ds);
        String main_risks_name = "";
        String accy_risks_name = "";
        String exempt_risks_name1 = "";
        String exempt_risks_name2 = "";
        for (Dsn_Structure dsNew : dsList) {
            if (!"main_risks".equals(dsNew.getNodeType())) continue;
            main_risks_name = main_risks_name + dsNew.getNodeName() + ",";
            String no = dsNew.getNodeNo();
            Dsn_Structure ds1 = new Dsn_Structure();
            ds1.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)no);
            ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
            ds1.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
            List dsList1 = this.dao.findAll((AbsModel)ds1);
            for (Dsn_Structure dsNew1 : dsList1) {
                accy_risks_name = accy_risks_name + dsNew1.getNodeName() + ",";
                ds1.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)dsNew1.getNodeSeq());
                ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_main_exempt");
                ds1.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
                List dsList2 = this.dao.findAll((AbsModel)ds1);
                for (Dsn_Structure dsNew2 : dsList2) {
                    exempt_risks_name1 = exempt_risks_name1 + dsNew2.getNodeName() + ",";
                }
            }
            ds1.where().addLike((ModelField)Dsn_Structure.Field.node_seq, (Object)no);
            ds1.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_main_exempt");
            ds1.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
            List dsList3 = this.dao.findAll((AbsModel)ds1);
            for (Dsn_Structure dsNew3 : dsList3) {
                String[] nodeSeqs = dsNew3.getNodeSeq().split("\\.");
                if (nodeSeqs.length != 5) continue;
                exempt_risks_name2 = exempt_risks_name2 + dsNew3.getNodeName() + ",";
            }
        }
        if (!StrUtil.isNull((Object)main_risks_name)) {
            param.put("main_risks_name", main_risks_name.subSequence(0, main_risks_name.length() - 1));
        }
        if (!StrUtil.isNull((Object)accy_risks_name)) {
            param.put("accy_risks_name", accy_risks_name.subSequence(0, accy_risks_name.length() - 1));
        }
        if (!StrUtil.isNull((Object)exempt_risks_name1)) {
            param.put("exempt_risks_name1", exempt_risks_name1.subSequence(0, exempt_risks_name1.length() - 1));
        }
        if (!StrUtil.isNull((Object)exempt_risks_name2)) {
            param.put("exempt_risks_name2", exempt_risks_name2.subSequence(0, exempt_risks_name2.length() - 1));
        }
        r.setDataTable(param);
        return r.msg();
    }

    @Override
    public ReturnMsg queryChannel(Map<String, Object> param) {
        Return r = new Return();
        Sys_Enum sysEnum = new Sys_Enum();
        sysEnum.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"channel_type");
        List enumList = this.dao.findAll((AbsModel)sysEnum);
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String up_node = StrUtil.trimStr((Object)param.get("up_node"));
        Dsn_Structure dsn = new Dsn_Structure();
        if (!StrUtil.isNull((Object)node_no) && !StrUtil.isNull((Object)up_node)) {
            QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
            String sql = "select node_no from dsn_structure where up_node = (select up_node from dsn_structure where node_no = ? ) and node_type in (?,?)";
            querySql.setSql(sql);
            querySql.add((Object)up_node);
            querySql.add((Object)"n_risk_detail");
            querySql.add((Object)"n_accy_detail");
            Map mainMap = (Map)this.dao.findAll(querySql).get(0);
            dsn = new Dsn_Structure();
            dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
            dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_accy_detail", "n_exempt_detail"});
            dsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Sys_Enum e : enumList) {
            Map<String, Object> map = JsonUtilOld.objToMap((Object)e);
            list.add(map);
        }
        r.setDataList(list);
        return r.msg();
    }

    @Override
    public ReturnMsg doClient(Map<String, Object> param) {
        String product_uuids = "";
        List newListParam = (List)param.get("checkbox");
        Return r = new Return();
        ArrayList<String> productUuids = new ArrayList<String>();
        for (Map tempMap : newListParam) {
            String product_uuid = StrUtil.trimStr(tempMap.get("true_product_uuid"));
            product_uuids = product_uuids + product_uuid + ",";
            productUuids.add(product_uuid);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organ_id", "000000");
        map.put("product_uuid", product_uuids.substring(0, product_uuids.length() - 1));
        HttpClient http = HttpClient.getInstance();
        String conent = http.sendHttpPost(this.prdConf.getProductList_toResid(), map);
        System.out.println(conent);
        r.setSuccessMsg("\u4ea7\u54c1\u7f13\u5b58\u5df2\u542f\u52a8");
        return r.msg();
    }

    private void UpdateProductRedisInfo(List<String> productUuids, String info) {
        if (productUuids == null || productUuids.isEmpty()) {
            return;
        }
        String sysDate = DateUtil.date2String((Date)DateUtil.sysDate(), (String)"yyyy-MM-dd HH:mm:ss");
        for (String productUuid : productUuids) {
            String sql = "update sip_products set redis_deal_info = ? where product_uuid = ?";
            UpdateSqlable querySql = DBHandleCreator.getInstance().getUpdateSql();
            querySql.add((Object)(info + " " + sysDate));
            querySql.add((Object)productUuid);
            querySql.setSql(sql);
            this.dao.update(querySql);
        }
    }

    @Override
    public ReturnMsg queryProductName(Map<String, Object> param) {
        String product_name = StrUtil.trimStr((Object)param.get("product_name"));
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_name, (Object)product_name);
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd");
        dsn.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        List dsnList = this.dao.findAll((AbsModel)dsn);
        Return r = new Return();
        if (dsnList != null && !dsnList.isEmpty()) {
            r.setFailMsg("\u8be5\u4ea7\u54c1\u540d\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        if (product_name.length() > 32) {
            r.setFailMsg("\u4ea7\u54c1\u540d\u79f0\u5df2\u8d85\u8fc732\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        return r.msg();
    }

    @Override
    public ReturnMsg queryRelation(Map<String, Object> param) {
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String up_node = StrUtil.trimStr((Object)param.get("up_node"));
        Dsn_Structure risk = new Dsn_Structure();
        risk.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        risk.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_accy_detail", "n_exempt_detail"});
        risk = (Dsn_Structure)this.dao.findOne((AbsModel)risk);
        String sql = "select node_no from dsn_structure where up_node = (select up_node from dsn_structure where node_no = ?) and node_type in (?,?)";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.add((Object)up_node);
        querySql.add((Object)"n_risk_detail");
        querySql.add((Object)"n_accy_detail");
        querySql.setSql(sql);
        Map main = (Map)this.dao.findAll(querySql).get(0);
        Sip_Risk_Relation relation = new Sip_Risk_Relation();
        relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, main.get("node_no"));
        relation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)risk.getNodeNo());
        relation = (Sip_Risk_Relation)this.dao.findOne((AbsModel)relation);
        Return r = new Return();
        r.setDataTable(new Object[]{relation});
        return r.msg();
    }

    @Override
    public Return searchSql(String emailAddress, String productUUID, String url) {
        MyThread createSql = new MyThread();
        createSql.setDao(this.dao);
        createSql.setSqlPath("");
        createSql.setProductUUID(productUUID);
        createSql.setDate(null);
        createSql.setFileNo(productUUID);
        createSql.setFlag(false);
        createSql.setiExportProductSql(this.iExportProductSql);
        Return res = new Return();
        try {
            res = createSql.saveInsertSql(emailAddress, productUUID, null, productUUID, true, url);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            res.setFailMsg("\u751f\u6210\u811a\u672c\u5931\u8d25");
            return res;
        }
    }

    @Override
    public List<Map<String, Object>> queryProduct(String request, String flag) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        List resultDao = null;
        if ("M".equals(flag)) {
            String sql = "select product_no from sip_products where product_uuid in(\nselect product_uuid from sip_product_risks  where risk_uuid=?\n)";
            query.add((Object)this.queryRiskUuid(request, flag));
            query.setSql(sql);
            resultDao = this.dao.findAll(query);
            query.clearParam();
        } else if ("A".equals(flag)) {
            String sql = "select product_no from sip_products e right join (\nselect * from sip_product_risks where risk_uuid in(\nselect main_risk from sip_risk_relation  where risk_uuid=?\n)) s\non  e.product_uuid = s.product_uuid";
            query.add((Object)this.queryRiskUuid(request, flag));
            query.setSql(sql);
            resultDao = this.dao.findAll(query);
            query.clearParam();
        }
        return resultDao;
    }

    private String queryRiskUuid(String request, String flag) {
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.policy_code, (Object)request);
        risk.where().addEq((ModelField)Sip_Risks.Field.is_main_risk, (Object)flag);
        Sip_Risks risk1 = (Sip_Risks)this.dao.findOne((AbsModel)risk);
        return risk1.getRiskUuid();
    }

    @Override
    public ReturnMsg addLiability(Map<String, Object> param) {
        String serno = UniqueSeq.shortUUID();
        String nodeNo = UniqueSeq.shortUUID();
        String upNode = StrUtil.trimStr((Object)param.get("node_no"));
        String nodeSeq = StrUtil.trimStr((Object)param.get("node_seq"));
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.setSerno(serno);
        dsn.setNodeNo(nodeNo);
        dsn.setNodeName("\u5229\u76ca\u6f14\u793a");
        dsn.setNodeType("n_liability");
        dsn.setUpNode(upNode);
        dsn.setNodeSeq(nodeSeq + nodeNo + ".");
        dsn.setDisplayOrder(7);
        this.dao.save((AbsModel)dsn);
        this.addNode(dsn);
        Dsn_Structure dsn1 = new Dsn_Structure();
        String nodeNo1 = UniqueSeq.shortUUID();
        dsn1.setSerno(UniqueSeq.shortUUID());
        dsn1.setNodeNo(nodeNo1);
        dsn1.setNodeName("\u8d39\u7387\u7ec4");
        dsn1.setNodeType("n_rate");
        dsn1.setUpNode(upNode);
        dsn1.setNodeSeq(nodeSeq + nodeNo1 + ".");
        dsn1.setDisplayOrder(7);
        Return msg = new Return();
        Dsn_Structure dsn_structure1 = (Dsn_Structure)this.dao.save((AbsModel)dsn1);
        if (dsn_structure1 == null) {
            msg.setFailMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        msg.setSuccessMsg("\u4fdd\u5b58\u6210\u529f");
        msg.getDataTable().put("1", dsn1);
        return msg.msg();
    }

    private void addNode(Dsn_Structure dsn) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("node_name", "\u5229\u76ca\u6f14\u793a\u6307\u6807");
        request.put("node_no", dsn.getNodeNo());
        request.put("up_node", dsn.getNodeNo());
        request.put("node_type", "n_liability_target");
        request.put("node_seq", dsn.getNodeSeq());
        this.publicTreeService.addTreeNode(request);
        request.put("node_name", "\u4fdd\u969c\u6c47\u603b\u6307\u6807");
        request.put("node_no", dsn.getNodeNo());
        request.put("up_node", dsn.getNodeNo());
        request.put("node_type", "n_security_target");
        request.put("node_seq", dsn.getNodeSeq());
        this.publicTreeService.addTreeNode(request);
        request.put("node_name", "\u5229\u76ca\u6f14\u793a\u8868\u5934");
        request.put("node_no", dsn.getNodeNo());
        request.put("up_node", dsn.getNodeNo());
        request.put("node_type", "n_liability_table");
        request.put("node_seq", dsn.getNodeSeq());
        this.publicTreeService.addTreeNode(request);
    }
}

