/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.product.service.imp;

import com.newtouch.design.file.service.IFileService;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.util.md5.Md5;
import com.newtouch.util.string.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileCommonServiceImp {
    @Autowired
    @Qualifier(value="localService")
    private IFileService fileService;
    private String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private long allowSize = 0x500000L;

    public ReturnMsg uploadFileAndSave(MultipartFile file, String fileNo, String md5, String localFileSize) {
        long fileSize;
        String fileName = file.getOriginalFilename();
        Return msg = this.check(fileName, fileSize = file.getSize(), localFileSize);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        try {
            if (!StrUtil.isNull((Object)md5) && !md5.equals(Md5.getFileMD5((InputStream)file.getInputStream()))) {
                msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return msg.msg();
            }
            msg = this.fileService.saveFile(fileNo, fileName, fileSize, file.getInputStream());
            return msg.msg();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Return check(String fileName, long fileSize, String localFileSize) {
        String suffix;
        Return msg = new Return();
        if (StrUtil.isNull((Object)fileName)) {
            msg.setFailMsg("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNull((Object)localFileSize) && fileSize != Long.parseLong(localFileSize)) {
            msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e3a[" + Long.parseLong(localFileSize) / 1024L + "]KB\uff0c\u5b9e\u9645\u63a5\u6536[" + fileSize / 1024L + "]KB\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[" + this.allowSuffix + "]\u7684\u6587\u4ef6");
        }
        if (this.allowSuffix.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg("\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[" + this.allowSuffix + "]\u7684\u6587\u4ef6");
        }
        if (fileSize <= 0L) {
            msg.setFailMsg("\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB");
        }
        if (fileSize > this.allowSize) {
            msg.setFailMsg("\u6587\u4ef6\u6700\u5927\u4e0d\u80fd\u8d85\u8fc7[2M]");
        }
        return msg;
    }
}

