/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.product.service.imp;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import com.newtouch.log.Ulog;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.uuid.UniqueSeq;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class AttrbuteHandleService {
    @Autowired
    private AbsModelRepository repository;

    public void handleAttributesTables(String old_node_no, String new_node_no) {
        Dsn_Biz_Attribute biz_attr = new Dsn_Biz_Attribute();
        biz_attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)old_node_no);
        biz_attr = (Dsn_Biz_Attribute)this.repository.findOne((AbsModel)biz_attr);
        String new_attr_uuid = UniqueSeq.shortUUID();
        if (biz_attr != null && StringUtils.isNotBlank((CharSequence)biz_attr.getBizUuid())) {
            String old_attr_uuid = biz_attr.getAttrUuid();
            biz_attr.setAttrUuid(new_attr_uuid);
            biz_attr.setBizUuid(new_node_no);
            biz_attr.setSerno(UniqueSeq.shortUUID());
            this.repository.save((AbsModel)biz_attr);
            this.copyDsn_Attribute(old_attr_uuid, new_attr_uuid);
            this.copyDsn_Biz_Attribute_Option(old_node_no, new_node_no, old_attr_uuid, new_attr_uuid);
        }
    }

    public void copyDsn_Attribute(String old_attr_uuid, String new_attr_uuid) {
        Dsn_Attribute attr = new Dsn_Attribute();
        attr.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)old_attr_uuid);
        attr = (Dsn_Attribute)this.repository.findOne((AbsModel)attr);
        if (attr != null && StringUtils.isNotBlank((CharSequence)attr.getAttrUuid())) {
            attr.setSerno(UniqueSeq.shortUUID());
            attr.setAttrUuid(new_attr_uuid);
            Ulog.info((String)(old_attr_uuid + ":attr_name is\uff1a" + attr.getAttrName()));
            attr.setAttrName(StringUtils.trimToEmpty((String)attr.getAttrName()));
            this.repository.save((AbsModel)attr);
        }
    }

    public void copyDsn_Biz_Attribute_Option(String old_node_no, String new_node_no, String oldAttr, String newAttr) {
        Dsn_Biz_Attribute_Option biz_attr_option = new Dsn_Biz_Attribute_Option();
        biz_attr_option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)old_node_no);
        biz_attr_option.setOrderBy(new Sort.Order[]{Dsn_Biz_Attribute_Option.Field.option_order.asc()});
        List dsn_biz_attribute_optionList = this.repository.findAll((AbsModel)biz_attr_option);
        if (dsn_biz_attribute_optionList != null && !dsn_biz_attribute_optionList.isEmpty()) {
            for (Dsn_Biz_Attribute_Option option : dsn_biz_attribute_optionList) {
                if (!StringUtils.isNotBlank((CharSequence)option.getBizUuid())) continue;
                option.setSerno(UniqueSeq.shortUUID());
                option.setBizUuid(new_node_no);
                option.setOptionNo(UniqueSeq.shortUUID());
                this.save_Dsn_Attribute_Option(option, newAttr);
                this.repository.save((AbsModel)option);
            }
        }
    }

    private void save_Dsn_Attribute_Option(Dsn_Biz_Attribute_Option dsn_biz_attribute_option, String newAttr) {
        Dsn_Attribute_Option attr_option = new Dsn_Attribute_Option();
        attr_option.setSerno(UniqueSeq.shortUUID());
        attr_option.setOptionNo(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getOptionNo()));
        attr_option.setAttrUuid(StringUtils.trimToEmpty((String)newAttr));
        attr_option.setOptionName(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getOptionName()));
        attr_option.setOptionOrder(dsn_biz_attribute_option.getOptionOrder());
        attr_option.setOptionValue(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getOptionValue()));
        attr_option.setCrtDate(dsn_biz_attribute_option.getCrtDate());
        attr_option.setPatchMemo(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getPatchMemo()));
        attr_option.setDataFlag(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getDataFlag()));
        attr_option.setRn(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getRn()));
        attr_option.setCrtUser(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getCrtUser()));
        attr_option.setMdfUser(StringUtils.trimToEmpty((String)dsn_biz_attribute_option.getMdfUser()));
        this.repository.save((AbsModel)attr_option);
    }

    public void handleDsn_Dynamic_Data(String old_node_no, String new_node_no) {
        Dsn_Dynamic_Data dsn_dynamic_data_old = new Dsn_Dynamic_Data();
        dsn_dynamic_data_old.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)old_node_no);
        dsn_dynamic_data_old = (Dsn_Dynamic_Data)this.repository.findOne((AbsModel)dsn_dynamic_data_old);
        if (StringUtils.isNotBlank((CharSequence)dsn_dynamic_data_old.getSerno())) {
            dsn_dynamic_data_old.setSerno(UniqueSeq.shortUUID());
            dsn_dynamic_data_old.setRelateFk(new_node_no);
            this.repository.save((AbsModel)dsn_dynamic_data_old);
        }
    }
}

