/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.file.service.imp;

import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.design.file.service.IsqlService;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.product.transfer.services.IProductTransferService;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.util.string.StrUtil;
import com.newtouch.web.BaseService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportFileServiceImp
extends BaseService
implements IsqlService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    @Qualifier(value="defaultJdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IProductTransferService productTransferService;

    @Override
    public ReturnMsg importSqlFile(Map requestParam) throws Exception {
        Return res = new Return();
        ReturnMsg msg = res.msg();
        MultipartFile file = (MultipartFile)requestParam.get("file");
        String userNo = StrUtil.trimStr(requestParam.get("user_no"));
        try {
            msg = "propose".equals(userNo) ? this.productTransferService.importPropose(file, "") : this.productTransferService.importProduct(file, "");
        }
        catch (BusinessException e) {
            msg.setFailMessage(new Message("2016027", "\u6b64\u4ea7\u54c1\u4e0d\u5b58\u5728,\u8be5\u8d26\u6237\u65e0\u6743\u9650\u5bfc\u5165"));
        }
        return msg;
    }

    public void handleTask(Map requestParam) {
        MultipartFile file = (MultipartFile)requestParam.get("file");
        try {
            InputStream inputStream = file.getInputStream();
            String fileName = file.getOriginalFilename();
            long fileSize = file.getSize();
            Ulog.info((String)("\u5bfc\u5165SQL\u811a\u672c\uff1a" + fileName + "\u6587\u4ef6\u5927\u5c0f: " + fileSize));
            this.readFileByLinesAndWriteIntoDB(inputStream);
            Ulog.info((String)"SQL\u6267\u884c\u5b8c\u6bd5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readFileByLinesAndWriteIntoDB(InputStream inputStream) throws Exception {
        BufferedReader reader = null;
        String message = "";
        String product_uuid = "";
        String tempSQL = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int line = 1;
            while ((tempSQL = reader.readLine()) != null) {
                if (!tempSQL.contains("DELETE") && !tempSQL.contains("INSERT")) continue;
                if (line == 1) {
                    product_uuid = this.getProductUuid(tempSQL);
                }
                Ulog.info((String)("\u6267\u884cSQL\uff1a" + tempSQL));
                this.jdbcTemplate.execute(tempSQL);
                if (++line != 5 || !StringUtils.isNotBlank((CharSequence)product_uuid)) continue;
                this.updateProductState("\u6b63\u5728\u5bfc\u5165\u4e2d", product_uuid);
            }
            Ulog.info((String)("\u603b\u5171\u5bfc\u5165\u884c\u6570\uff1a" + line));
            message = "\u5bfc\u5165\u6210\u529f";
            reader.close();
            this.updateProductCacheState();
        }
        catch (Exception e) {
            message = "\u5bfc\u5165\u5931\u8d25";
            e.printStackTrace();
            throw new BusinessException("sql\u6267\u884c\u5f02\u5e38: " + tempSQL);
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)product_uuid)) {
                this.updateProductState(message, product_uuid);
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void updateProductState(String message, String product_uuid) {
        UpdateSqlable querySql = DBHandleCreator.getInstance().getUpdateSql();
        String sql = "update sip_products set import_info = ? where product_uuid = ?";
        querySql.add((Object)message);
        querySql.add((Object)product_uuid);
        querySql.setSql(sql);
        this.dao.update(querySql);
    }

    private void updateProductCacheState() {
        String sql = "update sip_products set redis_deal_info = ? ";
        UpdateSqlable querySql = DBHandleCreator.getInstance().getUpdateSql();
        querySql.add((Object)"");
        querySql.setSql(sql);
        this.dao.update(querySql);
    }

    private String getProductUuid(String firstSql) {
        String productuuid = "";
        try {
            productuuid = firstSql.split("'")[1];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return productuuid;
    }
}

