/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.file.service.imp;

import com.newtouch.dao.IDao;
import com.newtouch.design.file.service.IFileService;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="localService")
public class FileLocalServiceImp
implements IFileService {
    private String rootDir = "fileRepostry/";
    @Autowired
    @Qualifier(value="Sys_File_RepostryDao")
    private IDao fileDao;

    @Override
    public Return saveFile(String file_no, String fileName, long fileSize, InputStream in) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)file_no)) {
            file_no = UniqueSeq.shortUUID();
        }
        String relativePath = this.rootDir + DateUtil.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/";
        String absolutePath = PathFactory.getProperty() + relativePath;
        File destFile = new File(absolutePath);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        String newFileName = "file_" + file_no + "_" + DateUtil.date2String((Date)DateUtil.sysTimestamp(), (String)"yyyyMMddHHmmssSSS") + "." + suffix;
        File f = new File(absolutePath + newFileName);
        int byteread = 0;
        OutputStream out = null;
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            out = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (f.length() != fileSize) {
            msg.setFailMsg("\u4e0a\u4f20\u6587\u4ef6\u4e3a[" + fileSize / 1024L + "]KB\uff0c\u5b9e\u9645\u63a5\u6536[" + f.length() / 1024L + "]KB\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return msg;
        }
        this.fileDao.addEq("file_no", (Object)file_no);
        this.fileDao.delete();
        HashMap<String, Object> afile = new HashMap<String, Object>();
        afile.put("file_no", file_no);
        afile.put("file_name", fileName);
        afile.put("new_file_name", newFileName);
        afile.put("file_suffix", suffix);
        afile.put("file_type", suffix);
        afile.put("file_path", relativePath + newFileName);
        afile.put("file_size", fileSize);
        afile.put("upload_date", DateUtil.sysDate());
        this.fileDao.insert(afile);
        msg.getDataTable().put("file_no", file_no);
        return msg;
    }

    @Override
    public Return remoteUpLoadFileToServer(String file_no, String fileName, long fileSize, InputStream in) {
        return this.saveFile(file_no, fileName, fileSize, in);
    }
}

