/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.file.service;

import com.newtouch.design.file.service.IFileService;
import com.newtouch.design.util.SpringUtil;
import com.newtouch.util.properties.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FileManger {
    public static final String LOCATION = "localhost";
    public static final String HENG_AN = "HengAn";
    public static final String SPLIT_EXPORT_FILE = "splitExportFile";
    public static final String SPLIT_FILE_SIZE = "splitFileSize";
    public static final String CONFIG_FILE = "build_page";
    public static final String FILE_SERVICE_FIELD = "fileHost";
    public static final String FILE_REMOTE_URL = "fileRemotelUrl";
    public static final String FILE_DOWNLOAD_REMOTE_URL = "fileDownloadRemotelUrl";

    public static String getFileHost() {
        return PropertiesUtil.getPropertiesBySrc((String)CONFIG_FILE, (String)FILE_SERVICE_FIELD);
    }

    public static IFileService getUpLoadFileService() {
        IFileService fileService = null;
        if (LOCATION.equals(PropertiesUtil.getPropertiesBySrc((String)CONFIG_FILE, (String)FILE_SERVICE_FIELD))) {
            fileService = SpringUtil.getBean("localService", IFileService.class);
        }
        fileService = SpringUtil.getBean("localService", IFileService.class);
        return fileService;
    }

    public static String getRemoteSendFileUrl() {
        String url = PropertiesUtil.getPropertiesBySrc((String)CONFIG_FILE, (String)FILE_REMOTE_URL);
        return StringUtils.isNotBlank((CharSequence)StringUtils.trimToEmpty((String)url)) ? url : "";
    }

    public static String getRemoteDownLoadFileUrl() {
        String url = PropertiesUtil.getPropertiesBySrc((String)CONFIG_FILE, (String)FILE_DOWNLOAD_REMOTE_URL);
        return StringUtils.isNotBlank((CharSequence)StringUtils.trimToEmpty((String)url)) ? url : "";
    }

    public static boolean splitFileFlag() {
        String flag = PropertiesUtil.getPropertiesBySrc((String)CONFIG_FILE, (String)SPLIT_EXPORT_FILE);
        return flag.equals("true");
    }

    public static int splitFileSize() {
        String size = PropertiesUtil.getPropertiesBySrc((String)CONFIG_FILE, (String)SPLIT_FILE_SIZE);
        return Integer.parseInt(size) * 1024 * 1024;
    }
}

