/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.data.service.imp;

import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.design.data.service.StructureService;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.string.StrUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class StructureServiceImpl
implements StructureService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public List<Dsn_Structure> getSubAttr(Dsn_Structure dsn) {
        Dsn_Structure detail_attr = new Dsn_Structure();
        detail_attr.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn.getNodeNo());
        detail_attr.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)detail_attr, false);
    }

    @Override
    public List<Dsn_Structure> getSubAttr(String node_no) {
        Dsn_Structure detail_attr = new Dsn_Structure();
        detail_attr.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        detail_attr.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)detail_attr, false);
    }

    @Override
    public Dsn_Structure getOneDsnBySerno(String serno) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
    }

    @Override
    public Dsn_Structure getOneDsnByNodeNo(String nodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        List queryList = this.dao.findAll((AbsModel)dsn);
        return (Dsn_Structure)((Object)queryList.get(0));
    }

    @Override
    public String getRiskuuidByNode(Dsn_Structure riskNode) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskNode.getNodeNo());
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail", "n_exempt_detail", "n_sub_risks_detail", "n_a_exempt_detai"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            throw new BusinessException("\u9669\u79cd[" + riskNode.getNodeName() + "]\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        return ((Dsn_Structure)((Object)queryList.get(0))).getNodeNo();
    }

    @Override
    public String getRiskuuidByNodeNo(String upRiskNodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upRiskNodeNo);
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail", "n_sub_risks_detail", "n_exempt_detail", "n_a_exempt_detai"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return ((Dsn_Structure)((Object)queryList.get(0))).getNodeNo();
    }

    @Override
    public List<Dsn_Structure> getSubNode(String upNodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNodeNo);
        dsn.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)dsn);
    }

    @Override
    public void delNodeBySerno(String serno) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
        this.dao.delete((AbsModel)dsn);
    }

    @Override
    public int getMaxDisplayorder(String upNodeNo) {
        Dsn_Structure maxOrder = new Dsn_Structure();
        maxOrder.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNodeNo);
        maxOrder.groupBy().max((ModelField)Dsn_Structure.Field.display_order);
        maxOrder = (Dsn_Structure)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrder = maxOrder.getOtherProperty("max_display_order", String.class);
        int displayOrder = Integer.parseInt(StrUtil.isNull((Object)maxDisplayOrder) ? "0" : maxDisplayOrder.toString());
        return displayOrder;
    }

    @Override
    public void bizAttributeFieldchange(Map<String, Object> tmpMap) {
        tmpMap.put("length", tmpMap.get("attr_length"));
        tmpMap.put("interger", tmpMap.get("attr_integer"));
        tmpMap.put("attr_precision", tmpMap.get("attr_precision"));
    }

    @Override
    public void bizAttributeFieldChange2(Map<String, Object> tmpMap) {
        String attrLength = "";
        if (tmpMap.get("attr_length").toString() != null) {
            attrLength = tmpMap.get("attr_length").toString();
        }
        tmpMap.put("length", attrLength);
        String interger = "";
        if (tmpMap.get("attr_integer") != null) {
            interger = tmpMap.get("attr_integer").toString();
        }
        tmpMap.put("interger", interger);
        String attrPrecision = "";
        if (tmpMap.get("attr_precision") != null) {
            attrPrecision = tmpMap.get("attr_precision").toString();
        }
        tmpMap.put("attr_precision", attrPrecision);
    }
}

