/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.data.service.imp;

import cn.com.chinalife.model.Sip_Prd_Organ_Risk_Relation;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.model.Ws_Life_T_Company_Organ;
import com.newtouch.cache.CacheManager;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.data.service.IDataService;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataServiceImp
implements IDataService {
    @Autowired
    private AbsModelRepository dao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnMsg getProductInfoData(Map<String, Object> paramMap) {
        Return msg = this.checkParam(paramMap);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        String organID = StrUtil.trimStr((Object)paramMap.get("organ_id"));
        String channelType = StrUtil.trimStr((Object)paramMap.get("channel_type"));
        String mdfDate = StrUtil.trimStr((Object)paramMap.get("mdf_date"));
        Map<String, Object> productOrganMap = this.getProductInfo(organID, channelType);
        String newMdfDate = "";
        if (null == productOrganMap || productOrganMap.isEmpty()) {
            msg = new Return();
            msg.setSuccessMsg("\u5728sip_products_organ\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\uff01");
            return msg.msg();
        }
        Date tmpMdfDate = (Date)productOrganMap.get("mdfDate");
        newMdfDate = DateUtil.date2String((Date)tmpMdfDate, (String)"yyyy-MM-dd HH:mm:ss");
        if (!StrUtil.isNull((Object)newMdfDate)) {
            if (newMdfDate.equals(mdfDate)) {
                msg = new Return();
                msg.setSuccessMsg("\u8bf7\u6c42\u7684mdfDate\u76f8\u540c\uff0c\u4e0d\u8fd4\u56de\u6570\u636e");
                return msg.msg();
            }
            Map redisData = this.getRedisData(organID, channelType, mdfDate);
            if (null == redisData || redisData.isEmpty()) {
                DataServiceImp dataServiceImp = this;
                synchronized (dataServiceImp) {
                    redisData = this.getRedisData(organID, channelType, mdfDate);
                    if (null == redisData || redisData.isEmpty()) {
                        msg = new Return();
                        Map<String, Object> resultMap = this.queryDBData(organID, channelType, productOrganMap);
                        Ulog.info((String)"\u67e5\u8be2\u4e86\u6570\u636e\u5e93\u3002\u3002\u3002\n");
                        msg.setDataTable(resultMap);
                        String key = channelType + "_" + organID + "_" + mdfDate;
                        CacheManager.put((String)key, (Object)JsonUtilOld.formatObject(resultMap), (int)300);
                        return msg.msg();
                    }
                    Ulog.info((String)"\u67e5\u8be2\u4e86\u7f13\u5b58\u3002\u3002\u3002\n");
                }
            } else {
                Ulog.info((String)"\u67e5\u8be2\u4e86\u7f13\u5b58\u3002\u3002\u3002\n");
            }
            msg = new Return();
            msg.setDataTable(redisData);
            return msg.msg();
        }
        return msg.msg();
    }

    private Map<String, Object> queryDBData(String organID, String channelType, Map<String, Object> productOrganMap) {
        List productList = (List)productOrganMap.get("productList");
        Date tmpMdfDate = (Date)productOrganMap.get("mdfDate");
        String mdfDate = DateUtil.date2String((Date)tmpMdfDate, (String)"yyyy-MM-dd HH:mm:ss");
        Map<String, Object> resultMap = this.getRiskInfo(productList, organID);
        resultMap.put("organ_id", organID);
        resultMap.put("channel_type", channelType);
        resultMap.put("mdf_date", mdfDate);
        return resultMap;
    }

    private Map<String, Object> getRiskInfo(List<String> productList, String organID) {
        HashSet<Map<String, Object>> sipProductRisksSet = new HashSet<Map<String, Object>>(16);
        Sip_Product_Risks sipProductRisks4Query = null;
        List sipProductRisks4List = null;
        ArrayList prdOrganUUIDList = new ArrayList(10);
        HashSet<Sip_Risks> sipRisksSet = new HashSet<Sip_Risks>(16);
        HashSet<Sip_Risk_Relation> riskRelationSet = new HashSet<Sip_Risk_Relation>(16);
        HashSet<String> riskUUIDSet = new HashSet<String>(16);
        HashSet<String> riskRelationSernoSet = new HashSet<String>(16);
        for (String productUUID : productList) {
            Sip_Products sip_products = this.getProductOfProposeFlag(productUUID);
            sipProductRisks4Query = new Sip_Product_Risks();
            sipProductRisks4Query.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)productUUID);
            sipProductRisks4List = this.dao.findAll((AbsModel)sipProductRisks4Query);
            if (null == sipProductRisks4List || sipProductRisks4List.isEmpty()) continue;
            for (Sip_Product_Risks sipProductRisks4Result : sipProductRisks4List) {
                Map<String, Object> sipProductRiskMap = JsonUtilOld.objToMap((Object)sipProductRisks4Result);
                sipProductRiskMap.put("product_name", sip_products.getProductName());
                sipProductRisksSet.add(sipProductRiskMap);
                String riskUUID = sipProductRisks4Result.getRiskUuid();
                riskUUIDSet.add(riskUUID);
            }
        }
        for (String prdOrganUUIDStr : prdOrganUUIDList) {
            Sip_Prd_Organ_Risk_Relation sipPrdOrganRiskRelation4Query = new Sip_Prd_Organ_Risk_Relation();
            sipPrdOrganRiskRelation4Query.where().addEq((ModelField)Sip_Prd_Organ_Risk_Relation.Field.prd_organ_uuid, (Object)prdOrganUUIDStr);
            List sipPrdOrganRiskRelationList = this.dao.findAll((AbsModel)sipPrdOrganRiskRelation4Query);
            if (null == sipPrdOrganRiskRelationList || sipPrdOrganRiskRelationList.isEmpty()) continue;
            for (Sip_Prd_Organ_Risk_Relation tmpSipPrdOrganRiskRelation : sipPrdOrganRiskRelationList) {
                String riskRelationSerno = tmpSipPrdOrganRiskRelation.getRiskRelationUuid();
                Sip_Risk_Relation sipRiskRelation4Query = new Sip_Risk_Relation();
                sipRiskRelation4Query.where().addEq((ModelField)Sip_Risk_Relation.Field.serno, (Object)riskRelationSerno);
                Sip_Risk_Relation sipRiskRelation4Result = (Sip_Risk_Relation)this.dao.findOne((AbsModel)sipRiskRelation4Query);
                if (null == sipRiskRelation4Result || StrUtil.isNull((Object)sipRiskRelation4Result.getSerno())) continue;
                riskRelationSernoSet.add(riskRelationSerno);
                String mainRiskUUID = sipRiskRelation4Result.getMainRisk();
                riskUUIDSet.add(mainRiskUUID);
                String riskUUID = sipRiskRelation4Result.getRiskUuid();
                riskUUIDSet.add(riskUUID);
            }
        }
        for (String riskRelationStr : riskRelationSernoSet) {
            Sip_Risk_Relation sipRiskRelation = this.queryRiskRelation(riskRelationStr);
            if (null == sipRiskRelation) continue;
            riskRelationSet.add(sipRiskRelation);
        }
        for (String riskUUIDStr : riskUUIDSet) {
            Sip_Risks risk = this.queryRisks(riskUUIDStr);
            if (null == risk) continue;
            sipRisksSet.add(risk);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("sip_product_risks", sipProductRisksSet);
        resultMap.put("sip_risks", sipRisksSet);
        resultMap.put("sip_risk_relation", riskRelationSet);
        return resultMap;
    }

    private Sip_Risks queryRisks(String riskUUID) {
        Sip_Risks sipRisks4Query = new Sip_Risks();
        sipRisks4Query.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUUID);
        Sip_Risks sipRisks4Result = (Sip_Risks)this.dao.findOne((AbsModel)sipRisks4Query);
        return null != sipRisks4Result && !StrUtil.isNull((Object)((Object)sipRisks4Result)) ? sipRisks4Result : null;
    }

    private Sip_Risk_Relation queryRiskRelation(String riskRelationSerno) {
        Sip_Risk_Relation sipRiskRelation4Query = new Sip_Risk_Relation();
        sipRiskRelation4Query.where().addEq((ModelField)Sip_Risk_Relation.Field.serno, (Object)riskRelationSerno);
        Sip_Risk_Relation sipRiskRelation4Result = (Sip_Risk_Relation)this.dao.findOne((AbsModel)sipRiskRelation4Query);
        return null != sipRiskRelation4Result && !StrUtil.isNull((Object)sipRiskRelation4Result.getSerno()) ? sipRiskRelation4Result : null;
    }

    private Sip_Products getProductOfProposeFlag(String productUUID) {
        Sip_Products sipProducts4Query = new Sip_Products();
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUUID);
        Sip_Products sipProducts4Result = (Sip_Products)this.dao.findOne((AbsModel)sipProducts4Query);
        return sipProducts4Result;
    }

    public Map<String, Object> getProductInfo(String organID, String channelType) {
        HashMap resultMap = new HashMap(16);
        ArrayList productList = new ArrayList(10);
        StringBuffer sqlBuffer = new StringBuffer();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        sqlBuffer.append(" SELECT ").append("     * ").append(" FROM ").append("     sip_products_organ organ ").append(" WHERE ").append("     organ_id = ? ").append(" AND ? = ( ").append("     SELECT ").append("         channel_type ").append("     FROM ").append("         sip_products_channel chann ").append("     WHERE ").append("         chann.prd_chanl_uuid = organ.prd_chanl_uuid ").append(" ) ").append(" ORDER BY ").append("     mdf_date DESC ");
        querySql.add((Object)organID);
        querySql.add((Object)channelType);
        querySql.setSql(sqlBuffer.toString());
        return null;
    }

    private String getSuperiorOrganID(String organID) {
        Ws_Life_T_Company_Organ wsLifeTCompanyOrgan4Query = new Ws_Life_T_Company_Organ();
        wsLifeTCompanyOrgan4Query.where().addEq((ModelField)Ws_Life_T_Company_Organ.Field.organ_id, (Object)organID);
        Ws_Life_T_Company_Organ wsLifeTCompanyOrgan4Result = (Ws_Life_T_Company_Organ)this.dao.findOne((AbsModel)wsLifeTCompanyOrgan4Query);
        if (null == wsLifeTCompanyOrgan4Result || StrUtil.isNull((Object)wsLifeTCompanyOrgan4Result.getSerno())) {
            Ulog.info((String)("\u672a\u67e5\u8be2\u5230organ_id\u4e3a\u3010" + organID + "\u3011\u7684\u4e0a\u7ea7\u673a\u6784"));
            return null;
        }
        return wsLifeTCompanyOrgan4Result.getParentId();
    }

    private Map getRedisData(String organID, String channelType, String mdfDate) {
        Set redisKeySet = CacheManager.keys((String)(channelType + "_" + organID + "*"));
        if (null == redisKeySet || redisKeySet.isEmpty()) {
            Ulog.info((String)("\u5728redis\u4e2d\u672a\u67e5\u8be2\u5230key\u503c\u4e3aorgan_id\u4e3a\u3010" + organID + "\u3011\uff0cchannelType\u4e3a\u3010" + channelType + "\u3011\u7ec4\u6210\u7684\u8bb0\u5f55"));
            return null;
        }
        String redisKey = channelType + "_" + organID + "_" + mdfDate;
        Map<String, Object> redisValue = JsonUtilOld.json2Map(StrUtil.trimStr((Object)CacheManager.get((String)redisKey)));
        return redisValue;
    }

    private Return checkParam(Map<String, Object> paramMap) {
        Return msg = new Return();
        String organID = StrUtil.trimStr((Object)paramMap.get("organ_id"));
        if (StrUtil.isNull((Object)organID)) {
            msg.setFailMsg("\u6ca1\u6709\u83b7\u53d6\u5230\u673a\u6784ID\uff01");
            return msg;
        }
        String channelID = StrUtil.trimStr((Object)paramMap.get("channel_type"));
        if (StrUtil.isNull((Object)channelID)) {
            msg.setFailMsg("\u6ca1\u6709\u83b7\u53d6\u5230\u6e20\u9053\u7c7b\u578b\uff01");
            return msg;
        }
        String mdfDate = StrUtil.trimStr((Object)paramMap.get("mdf_date"));
        if (!StrUtil.isNull((Object)mdfDate)) {
            try {
                DateUtil.string2Date((String)mdfDate, (String)"yyyy-MM-dd");
            }
            catch (Exception e) {
                msg.setFailMsg("\u65f6\u95f4\u6233\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u3010yyyy-MM-dd\u3011\u6dfb\u52a0\u6b63\u786e\u7684\u65f6\u95f4");
                return msg;
            }
        }
        return msg;
    }

    @Override
    public ReturnMsg getMarkDownData(Map<String, Object> paramMap) {
        Return msg = new Return();
        if (paramMap.get("risk_no") == null || StrUtil.isNull((Object)paramMap.get("risk_no"))) {
            msg.setFailMsg("\u9669\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u9669\u79cd\u7f16\u7801");
        }
        String risk_no = (String)paramMap.get("risk_no");
        Sip_Risks risks = new Sip_Risks();
        risks.where().addEq((ModelField)Sip_Risks.Field.risk_no, (Object)risk_no);
        Sip_Risks riskDao = (Sip_Risks)this.dao.findOne((AbsModel)risks);
        if (null == riskDao || StrUtil.isNull((Object)riskDao.getSerno())) {
            msg.setFailMsg("\u9669\u79cd\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9669\u79cd\u7f16\u7801");
        }
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuffer sql = new StringBuffer("select attr.attr_no , attr.attr_name ,  markdown.text_key , markdown.text_value\nfrom dsn_biz_attribute attr , dsn_structure str , sip_risks risks ,dsn_dynamic_text_data markdown\nwhere attr.biz_uuid = str.node_no and risks.risk_uuid = str.up_node and attr.biz_uuid = markdown.text_key and attr.ui_type=? and risk_no = ? ");
        if (paramMap.get("attr_no") != null && !StrUtil.isNull((Object)paramMap.get("attr_no"))) {
            sql.append(" and attr.attr_no = ? ");
        }
        sql.append("order by attr.display_order");
        querySql.add((Object)"markdown");
        querySql.add((Object)risk_no);
        if (paramMap.get("attr_no") != null && !StrUtil.isNull((Object)paramMap.get("attr_no"))) {
            querySql.add(paramMap.get("attr_no"));
        }
        querySql.setSql(sql.toString());
        List markdownList = this.dao.findAll(querySql, false);
        for (Map markdownMap : markdownList) {
            markdownMap.put("text_value", ((String)markdownMap.get("text_value")).replaceAll("<br>", "\n"));
        }
        msg.setDataList(markdownList);
        return msg.msg();
    }
}

