/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.benefit.service.imp;

import cn.com.chinalife.model.Dsn_Biz_Attribute_Rules;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Reg_Rules;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.model.Sys_File_Repostry;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.pojo.DBTypes;
import com.newtouch.design.benefit.freemarker.Benefit;
import com.newtouch.design.benefit.service.IBenefitService;
import com.newtouch.design.benefit.service.imp.BenefitTask;
import com.newtouch.design.util.ExcelUtil;
import com.newtouch.design.util.ListUtil;
import com.newtouch.design.util.PinYin4J;
import com.newtouch.excel.pojo.Excel;
import com.newtouch.excel.pojo.Sheet;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Service
public class BenefitServiceImp
extends BaseService
implements IBenefitService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private Benefit benefit;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfig;
    private static final String TABLE_PREFIX = "dsn_benefit_";
    private Map<String, Object> newTableInfoMap = new HashMap<String, Object>();
    private String tabNameKey = "tabNameKey";
    private String columnInfoKey = "columnInfoKey";

    @Override
    public ReturnMsg queryBenefitInfo(Map<String, Object> param) {
        Map<String, Map<String, Map<String, Object>>> attrMap = this.queryBenefitAttr(param);
        Map<String, Map<String, Map<String, Map<String, Object>>>> groupAttrMap = this.queryBenegitGroupAttr(param);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attr", attrMap);
        map.put("group", groupAttrMap);
        Return r = new Return();
        r = this.buildHtml(map, StrUtil.trimStr((Object)param.get("node_no")));
        return r.msg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Return buildHtml(Map<String, Object> param, String benefit_uuid) {
        Return r = new Return();
        Template temp = null;
        Writer out = null;
        String ftlPath = "newtouch/benefit/TestBenefitPage.ftl";
        try {
            String path = PathFactory.getProperty() + "riskHtml/benefit/";
            File file = new File(path);
            if (!file.exists() && !file.isDirectory()) {
                file.mkdirs();
            }
            Configuration cfg = this.freemarkerConfig.getConfiguration();
            cfg.setSharedVariable("benefit", (TemplateModel)this.benefit);
            this.benefit.setParam(param);
            temp = cfg.getTemplate(ftlPath);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path + benefit_uuid + ".html"), "utf-8"));
            temp.process(null, out);
            String file_no = UniqueSeq.shortUUID();
            this.saveFile(file_no, benefit_uuid + ".html", path + benefit_uuid + ".html");
            this.saveFileNo(file_no, benefit_uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            r.setFailMsg("\u7a0b\u5e8f\u5f02\u5e38\uff0c\u751f\u6210\u9875\u9762\u5931\u8d25\uff01");
            Return return_ = r;
            return return_;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return r;
    }

    private void saveFile(String file_no, String file_name, String file_path) {
        Sys_File_Repostry repostry = new Sys_File_Repostry();
        repostry.where().addEq((ModelField)Sys_File_Repostry.Field.file_name, (Object)file_name);
        this.dao.delete((AbsModel)repostry);
        Sys_File_Repostry repostryNew = new Sys_File_Repostry();
        repostryNew.setFileName(file_name);
        repostryNew.setFileNo(file_no);
        repostryNew.setNewFileName(file_name);
        repostryNew.setFileType("html");
        repostryNew.setFileSuffix("html");
        repostryNew.setFilePath(file_path);
        if (!StrUtil.isNull((Object)file_path)) {
            File file = new File(file_path);
            repostryNew.setFileSize(file.length() + "");
        } else {
            repostryNew.setFileSize("0");
        }
        repostryNew.setUploadDate(DateUtil.sysDate());
        this.dao.save((AbsModel)repostryNew);
    }

    private void saveFileNo(String file_no, String risk_uuid) throws Exception {
        Dsn_Dynamic_Data dsn_Dynamic_Data4del = new Dsn_Dynamic_Data();
        dsn_Dynamic_Data4del.where().addEq((ModelField)Dsn_Dynamic_Data.Field.biz_type, (Object)3);
        dsn_Dynamic_Data4del.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_tab, (Object)"sys_file_repostry");
        dsn_Dynamic_Data4del.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)risk_uuid);
        this.dao.delete((AbsModel)dsn_Dynamic_Data4del);
        Dsn_Dynamic_Data dsn_Dynamic_Data4Insert = new Dsn_Dynamic_Data();
        dsn_Dynamic_Data4Insert.setBizType("3");
        dsn_Dynamic_Data4Insert.setRelateTab("sys_file_repostry");
        dsn_Dynamic_Data4Insert.setRelateFk(risk_uuid);
        dsn_Dynamic_Data4Insert.setField1(file_no);
        this.dao.save((AbsModel)dsn_Dynamic_Data4Insert);
    }

    public Map<String, Map<String, Map<String, Object>>> queryBenefitAttr(Map<String, Object> param) {
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        ds.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"attr");
        List dsList = this.dao.findAll((AbsModel)ds);
        Map<String, Map<String, Map<String, Object>>> result = this.commonQuery(dsList);
        return result;
    }

    private Map<String, Map<String, Map<String, Object>>> commonQuery(List<Dsn_Structure> dsList) {
        HashMap<String, Map<String, Map<String, Object>>> result = new HashMap<String, Map<String, Map<String, Object>>>();
        for (int i = 0; i < dsList.size(); ++i) {
            Dsn_Structure dsNew = new Dsn_Structure();
            dsNew.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)dsList.get(i).getNodeSeq());
            List dsListNew = this.dao.findAll((AbsModel)dsNew);
            HashMap resultMap = new HashMap();
            for (int j = 0; j < dsListNew.size(); ++j) {
                Dsn_Dynamic_Data data;
                HashMap<String, String> resultMapMap;
                Reg_Rules rule;
                List param_no;
                QuerySqlable query;
                StringBuffer sql;
                String serno;
                Dsn_Biz_Attribute_Rules attr_rule;
                String node_no_rule;
                int z;
                HashMap resultMap1;
                if ("init_rule".equals(((Dsn_Structure)((Object)dsListNew.get(j))).getNodeType())) {
                    resultMap1 = new HashMap();
                    for (z = 0; z < dsListNew.size(); ++z) {
                        if (!((Dsn_Structure)((Object)dsListNew.get(j))).getNodeNo().equals(((Dsn_Structure)((Object)dsListNew.get(z))).getUpNode())) continue;
                        node_no_rule = ((Dsn_Structure)((Object)dsListNew.get(z))).getNodeNo();
                        attr_rule = new Dsn_Biz_Attribute_Rules();
                        attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)node_no_rule);
                        attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
                        serno = attr_rule.getSerno();
                        sql = new StringBuffer();
                        sql.append("select p.param_no,p.param_name from reg_rules_param_group g,reg_rules_param p where g.group_no = p.group_no and rule_no = ?");
                        query = DBHandleCreator.getInstance().getQuerySql();
                        query.add((Object)attr_rule.getRuleNo());
                        query.setSql(sql.toString());
                        param_no = this.dao.findAll(query);
                        rule = new Reg_Rules();
                        rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)attr_rule.getRuleNo());
                        rule = (Reg_Rules)this.dao.findOne((AbsModel)rule);
                        resultMapMap = new HashMap<String, String>();
                        for (Map m : param_no) {
                            data = new Dsn_Dynamic_Data();
                            data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)serno);
                            data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_2, m.get("param_no"));
                            data = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)data);
                            resultMapMap.put(StrUtil.trimStr(m.get("param_name")), data.getField3());
                        }
                        resultMap1.put(rule.getRuleName(), resultMapMap);
                    }
                    resultMap.put("attr_init_rule", resultMap1);
                    continue;
                }
                if ("verify_rule".equals(((Dsn_Structure)((Object)dsListNew.get(j))).getNodeType())) {
                    resultMap1 = new HashMap();
                    for (z = 0; z < dsListNew.size(); ++z) {
                        if (!((Dsn_Structure)((Object)dsListNew.get(j))).getNodeNo().equals(((Dsn_Structure)((Object)dsListNew.get(z))).getUpNode())) continue;
                        node_no_rule = ((Dsn_Structure)((Object)dsListNew.get(z))).getNodeNo();
                        attr_rule = new Dsn_Biz_Attribute_Rules();
                        attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)node_no_rule);
                        attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
                        serno = attr_rule.getSerno();
                        sql = new StringBuffer();
                        sql.append("select p.param_no,p.param_name from reg_rules_param_group g,reg_rules_param p where g.group_no = p.group_no and rule_no = ?");
                        query = DBHandleCreator.getInstance().getQuerySql();
                        query.add((Object)attr_rule.getRuleNo());
                        query.setSql(sql.toString());
                        param_no = this.dao.findAll(query);
                        rule = new Reg_Rules();
                        rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)attr_rule.getRuleNo());
                        rule = (Reg_Rules)this.dao.findOne((AbsModel)rule);
                        resultMapMap = new HashMap();
                        for (Map m : param_no) {
                            data = new Dsn_Dynamic_Data();
                            data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)serno);
                            data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_2, m.get("param_no"));
                            data = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)data);
                            resultMapMap.put(StrUtil.trimStr(m.get("param_name")), data.getField3());
                        }
                        resultMap1.put(rule.getRuleName(), resultMapMap);
                    }
                    resultMap.put("attr_verify_rule", resultMap1);
                    continue;
                }
                if (!"linkage_rule".equals(((Dsn_Structure)((Object)dsListNew.get(j))).getNodeType())) continue;
                resultMap1 = new HashMap();
                for (z = 0; z < dsListNew.size(); ++z) {
                    if (!((Dsn_Structure)((Object)dsListNew.get(j))).getNodeNo().equals(((Dsn_Structure)((Object)dsListNew.get(z))).getUpNode())) continue;
                    node_no_rule = ((Dsn_Structure)((Object)dsListNew.get(z))).getNodeNo();
                    attr_rule = new Dsn_Biz_Attribute_Rules();
                    attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)node_no_rule);
                    attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
                    serno = attr_rule.getSerno();
                    sql = new StringBuffer();
                    sql.append("select p.param_no,p.param_name from reg_rules_param_group g,reg_rules_param p where g.group_no = p.group_no and rule_no = ?");
                    query = DBHandleCreator.getInstance().getQuerySql();
                    query.add((Object)attr_rule.getRuleNo());
                    query.setSql(sql.toString());
                    param_no = this.dao.findAll(query);
                    rule = new Reg_Rules();
                    rule.where().addEq((ModelField)Reg_Rules.Field.rule_no, (Object)attr_rule.getRuleNo());
                    rule = (Reg_Rules)this.dao.findOne((AbsModel)rule);
                    resultMapMap = new HashMap();
                    for (Map m : param_no) {
                        data = new Dsn_Dynamic_Data();
                        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)serno);
                        data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.field_2, m.get("param_no"));
                        data = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)data);
                        resultMapMap.put(StrUtil.trimStr(m.get("param_name")), data.getField3());
                    }
                    resultMap1.put(rule.getRuleName(), resultMapMap);
                }
                resultMap.put("attr_linkage_rule", resultMap1);
            }
            result.put(dsList.get(i).getNodeName(), resultMap);
        }
        return result;
    }

    public Map<String, Map<String, Map<String, Map<String, Object>>>> queryBenegitGroupAttr(Map<String, Object> param) {
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        ds.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"attr_group");
        List dsList = this.dao.findAll((AbsModel)ds);
        HashMap<String, Map<String, Map<String, Map<String, Object>>>> result = new HashMap<String, Map<String, Map<String, Map<String, Object>>>>();
        for (Dsn_Structure d : dsList) {
            Map<Object, Object> resultMap = new HashMap();
            Dsn_Structure dsNew = new Dsn_Structure();
            dsNew.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)d.getNodeNo());
            List dsListNew = this.dao.findAll((AbsModel)dsNew);
            resultMap = this.commonQuery(dsListNew);
            result.put(d.getNodeName(), resultMap);
        }
        return result;
    }

    @Override
    public Map<String, Object> benefitDetailQuery(String nodeSeq, String nodeNo) throws SQLException {
        this.getNewBenefitTableInfo(nodeSeq, nodeNo);
        if (!this.queryBenefitTableInDB(nodeSeq)) {
            Ulog.info((String)"\u8868\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa=======>\n");
            this.createBenefitTable();
        }
        Map<String, Object> conditionMap = this.getBenefitConditionQueryInfo();
        return conditionMap;
    }

    private ReturnMsg getNewBenefitTableInfo(String nodeSeq, String nodeNo) {
        boolean flag;
        ReturnMsg msg4RiskUUID = this.getRiskNo(nodeSeq);
        String riskUUID = StrUtil.trimStr(msg4RiskUUID.getDataTable().get("riskUUID"));
        if (StrUtil.isNull((Object)riskUUID)) {
            return msg4RiskUUID;
        }
        String tableName = TABLE_PREFIX + riskUUID.toLowerCase();
        this.newTableInfoMap.put(this.tabNameKey, tableName);
        Dsn_Structure model = new Dsn_Structure();
        model.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)nodeSeq);
        model.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"attr4Liability");
        List dsnList = this.dao.findAll((AbsModel)model);
        List oldDsnList = (List)this.newTableInfoMap.get(this.columnInfoKey);
        if (null != oldDsnList && !(flag = JsonUtilOld.formatJSONArray(dsnList).equals(JsonUtilOld.formatJSONArray(oldDsnList)))) {
            String sql = " drop table " + tableName;
            QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
            querySql.setSql(sql);
            this.dao.getJdbcTemplate().execute(sql);
        }
        this.newTableInfoMap.put(this.columnInfoKey, dsnList);
        return new Return().msg();
    }

    private ReturnMsg getRiskNo(String node_seq) {
        Return msg = new Return();
        String[] nodeSeqArray = node_seq.split("\\.");
        String riskNodeNo = nodeSeqArray[nodeSeqArray.length - 1 - 1];
        Dsn_Structure dsnQuery = new Dsn_Structure();
        dsnQuery.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskNodeNo);
        dsnQuery.where().addEq((ModelField)Dsn_Structure.Field.node_name, (Object)"\u9669\u79cd\u4fe1\u606f");
        String riskUUID = "";
        List dsnStructureList = this.dao.findAll((AbsModel)dsnQuery);
        if (null != dsnStructureList && !dsnStructureList.isEmpty() && dsnStructureList.size() == 1) {
            riskUUID = ((Dsn_Structure)((Object)dsnStructureList.get(0))).getNodeNo();
        }
        Sip_Risks sipRisks4Query = new Sip_Risks();
        sipRisks4Query.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUUID);
        Sip_Risks sipRisks4Result = (Sip_Risks)this.dao.findOne((AbsModel)sipRisks4Query);
        if (StrUtil.isNull((Object)sipRisks4Result.getSerno())) {
            msg.setFailMsg("\u8bf7\u5148\u914d\u7f6e\u5e76\u4fdd\u5b58\u9669\u79cd\u4fe1\u606f\uff01");
            return msg.msg();
        }
        HashMap<String, String> dataTable = new HashMap<String, String>();
        dataTable.put("riskUUID", riskUUID);
        msg.setDataTable(dataTable);
        return msg.msg();
    }

    private boolean queryBenefitTableInDB(String node_seq) throws SQLException {
        Connection conn = DBHandleCreator.getInstance().getDBHandle().getJdbcTemplate().getDataSource().getConnection();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = conn.getMetaData().getTables(null, null, null, types);
        while (rs.next()) {
            String tabName = StrUtil.trimStr((Object)rs.getObject("TABLE_NAME"));
            if (!tabName.equals(StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey)))) continue;
            return true;
        }
        return false;
    }

    private void createBenefitTable() {
        StringBuffer sqlBuffer = new StringBuffer();
        DBTypes dbTypes = this.dao.getDbType();
        if (dbTypes.equals((Object)DBTypes.MYSQL)) {
            sqlBuffer.append(" CREATE TABLE `" + StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey)) + "` ( ");
            sqlBuffer.append("   `serno` VARCHAR (32) COLLATE utf8_bin NOT NULL COMMENT '01.serno', ");
            for (Dsn_Structure dsn : (List)this.newTableInfoMap.get(this.columnInfoKey)) {
                sqlBuffer.append("   `" + PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)dsn.getNodeName())).toLowerCase() + "` VARCHAR (256) COLLATE utf8_bin COMMENT '" + StrUtil.trimStr((Object)dsn.getNodeName()) + "', ");
            }
            sqlBuffer.append("   `crt_date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '05.\u521b\u5efa\u65e5\u671f', ").append("   `mdf_date` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '06.\u4fee\u6539\u65e5\u671f', ").append("   `crt_user` VARCHAR (64) COLLATE utf8_bin NOT NULL COMMENT '07.\u521b\u5efa\u64cd\u4f5c\u5458', ").append("   `mdf_user` VARCHAR (64) COLLATE utf8_bin NOT NULL COMMENT '08.\u4fee\u6539\u64cd\u4f5c\u5458', ").append("   `data_flag` VARCHAR (4) COLLATE utf8_bin NOT NULL COMMENT '09.\u6709\u6548\u6027\u6807\u5fd7', ").append("   `patch_memo` VARCHAR (1024) CHARACTER ").append(" SET utf8 DEFAULT NULL COMMENT '10.\u6570\u8865\u5907\u6ce8', ").append("  PRIMARY KEY (`serno`) ").append(" ) ENGINE = INNODB DEFAULT CHARSET = utf8 COLLATE = utf8_bin ");
            Ulog.info((String)("\u8d39\u7387\u8be6\u60c5\u5efa\u8868sql==> " + sqlBuffer.toString()));
            try {
                JdbcTemplate jdbcTemplate = this.dao.getJdbcTemplate();
                jdbcTemplate.execute(sqlBuffer.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, Object> getBenefitConditionQueryInfo() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList conditionList = new ArrayList();
        List columnInfoList = (List)this.newTableInfoMap.get(this.columnInfoKey);
        columnInfoList.stream().forEach(column -> {
            HashMap<String, String> conditonMap = new HashMap<String, String>();
            conditonMap.put("nodeKey", PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)column.getNodeName())).toLowerCase());
            conditonMap.put("nodeName", column.getNodeName());
            conditionList.add(conditonMap);
        });
        resultMap.put("tableName", this.newTableInfoMap.get(this.tabNameKey));
        resultMap.put("nodeList", conditionList);
        return resultMap;
    }

    @Override
    public ReturnMsg exportExcel(Map<String, Object> paramMap) {
        Return msg = new Return();
        List<Map<String, Object>> list = this.getExcelTitleMap(paramMap);
        Sheet sheet = Sheet.getInstance();
        sheet.setSheetName("sheet1");
        for (Map<String, Object> head : list) {
            sheet.addHead(StrUtil.trimStr((Object)head.get("nodeKey")), StrUtil.trimStr((Object)head.get("nodeName")));
        }
        Excel excel = Excel.getInstance();
        excel.addSheets(sheet);
        excel.setExcelName("importBenefitAttr.xls");
        msg.getDataTable().put("excel", excel);
        return msg.msg();
    }

    private List<Map<String, Object>> getExcelTitleMap(Map<String, Object> paramMap) {
        ArrayList<Map<String, Object>> titleList = new ArrayList<Map<String, Object>>();
        List columnInfoList = (List)this.newTableInfoMap.get(this.columnInfoKey);
        columnInfoList.stream().forEach(column -> {
            HashMap<String, String> conditonMap = new HashMap<String, String>();
            conditonMap.put("nodeKey", PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)column.getNodeName())).toLowerCase());
            conditonMap.put("nodeName", column.getNodeName());
            titleList.add(conditonMap);
        });
        return titleList;
    }

    @Override
    public ReturnMsg importAttribute(Map<String, Object> paramMap) throws Exception {
        ExcelUtil excel = new ExcelUtil();
        String[] titles = this.getExcelTitle(paramMap);
        String[] titlesName = this.getExcelTitleName(paramMap);
        MultipartFile mFile = (MultipartFile)paramMap.get("file");
        Map<String, List<Object>> excelMap = excel.initSheet4Stream(mFile.getInputStream(), titles, titlesName, mFile.getOriginalFilename());
        ReturnMsg rm = this.valid(excelMap, titles, paramMap);
        if (!rm.isSuccessflag()) {
            return rm;
        }
        rm = this.impAttr(excelMap, titles, paramMap);
        return rm;
    }

    public String[] getExcelTitle(Map<String, Object> paramMap) {
        List<Map<String, Object>> list = this.getExcelTitleMap(paramMap);
        String[] arrayTitle = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arrayTitle[i] = StrUtil.trimStr((Object)list.get(i).get("nodeKey"));
        }
        return arrayTitle;
    }

    public String[] getExcelTitleName(Map<String, Object> paramMap) {
        List<Map<String, Object>> list = this.getExcelTitleMap(paramMap);
        String[] arrayTitle = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arrayTitle[i] = StrUtil.trimStr((Object)list.get(i).get("nodeName"));
        }
        return arrayTitle;
    }

    private ReturnMsg valid(Map<String, List<Object>> excelMap, String[] titles, Map<String, Object> paramMap) {
        Return rm = new Return();
        rm.setAutoRollback(false);
        Message m = new Message();
        if (excelMap.get("sheet1").size() == 0) {
            m.setMsgRemark("\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5bfc\u5165\u6570\u636e\uff01");
            rm.setFailMsg(m);
            return rm.msg();
        }
        for (int i = 0; i < excelMap.get("sheet1").size(); ++i) {
            Map jkkvo = (Map)excelMap.get("sheet1").get(i);
            for (int o = i; o < titles.length; ++o) {
                String code = titles[o];
                String cmount = StrUtil.trimStr(jkkvo.get(code));
                if (!StrUtil.isNull((Object)cmount)) continue;
                m.setMsgRemark("\u7b2c" + (i + 1) + "\u884c\u5bfc\u5165\u6570\u636e\u5b58\u5728\u7a7a\u503c");
                rm.setFailMsg(m);
                return rm.msg();
            }
        }
        return rm.msg();
    }

    private ReturnMsg impAttr(Map<String, List<Object>> excelMap, String[] titles, Map<String, Object> paramMap) {
        Return returnMsg = new Return();
        Timestamp start1 = null;
        try {
            List<String> insertList = this.getInsertParam(excelMap);
            List<List<?>> taskList = ListUtil.splitList(insertList, 1000);
            Ulog.info((String)("\u6570\u636e\u603b\u91cf\u4e3a===>" + insertList.size() + "\n\u5206\u7ec4\u6570\u91cf\u4e3a===>" + taskList.size()));
            ExecutorService executor = Executors.newCachedThreadPool();
            start1 = DateUtil.sysTimestamp();
            for (int i = 0; i < taskList.size(); ++i) {
                BenefitTask rateTask = new BenefitTask(taskList.get(i), this.dao.getJdbcTemplate());
                executor.execute(rateTask);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            Ulog.info((String)("excel\u6570\u636e\u5bfc\u5165\u5b8c\u6210,\u7528\u65f6[" + DateUtil.dateBetween((Date)new Date(), (Date)start1, (DateUtil.DateType)DateUtil.DateType.SS) + "]\u79d2"));
        }
        catch (Exception e) {
            Ulog.info((String)("excel\u6570\u636e\u5bfc\u5165\u5931\u8d25,\u7528\u65f6[" + DateUtil.dateBetween((Date)new Date(), start1, (DateUtil.DateType)DateUtil.DateType.SS) + "]\u79d2"));
            e.printStackTrace();
            returnMsg.setFailMsg("\u5c06excel\u4e2d\u7684\u6570\u636e\u6279\u91cf\u63d2\u5165\u5bfc\u6570\u636e\u5e93\u5931\u8d25!");
            return returnMsg.msg();
        }
        return returnMsg.msg();
    }

    private Map<String, Object> getBatchParam(Map<String, List<Object>> excelMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList resultList = new ArrayList();
        ArrayList<String> tmpList = null;
        StringBuffer paramBuffer = new StringBuffer();
        StringBuffer paramValueBuffer = new StringBuffer();
        int count = 0;
        List<Object> sheetList = excelMap.get("sheet1");
        Map map = (Map)sheetList.get(0);
        paramBuffer.append(" insert into " + this.newTableInfoMap.get(this.tabNameKey) + " ( serno, crt_user, mdf_user, data_flag, ");
        paramValueBuffer.append(" values( ?, '" + ThreadLocalContext.get().getUser().getOptName() + "', '" + ThreadLocalContext.get().getUser().getOptName() + "','1', ");
        for (Map.Entry en : map.entrySet()) {
            paramBuffer.append((String)en.getKey() + " ,");
            paramValueBuffer.append("? ,");
            ++count;
        }
        String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1) + " ) ";
        String paramValueStr = paramValueBuffer.toString().substring(0, paramValueBuffer.toString().length() - 1) + " ) ";
        resultMap.put("insertSql", paramStr + paramValueStr);
        resultMap.put("paramCount", count + 1);
        for (Map.Entry<String, List<Object>> entry : excelMap.entrySet()) {
            List<Object> dataList = entry.getValue();
            for (Object obj : dataList) {
                if (obj instanceof Map) {
                    Map tmpMap = (Map)obj;
                    tmpList = new ArrayList<String>();
                    tmpList.add(UniqueSeq.shortUUID());
                    for (Map.Entry en : tmpMap.entrySet()) {
                        tmpList.add(StrUtil.trimStr(en.getValue()));
                    }
                    resultList.add(tmpList);
                    continue;
                }
                Ulog.info((String)"\u89e3\u6790excel\u4e2d\u7684\u6570\u636e\u5f02\u5e38===>");
            }
        }
        resultMap.put("dataList", resultList);
        return resultMap;
    }

    private List<String> getInsertParam(Map<String, List<Object>> excelMap) {
        ArrayList<String> insertList = new ArrayList<String>();
        StringBuffer paramBuffer = null;
        StringBuffer paramValueBuffer = null;
        for (Map.Entry<String, List<Object>> entry : excelMap.entrySet()) {
            List<Object> dataList = entry.getValue();
            for (Object obj : dataList) {
                paramBuffer = new StringBuffer();
                paramValueBuffer = new StringBuffer();
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    paramBuffer.append(" insert into " + this.newTableInfoMap.get(this.tabNameKey) + " ( serno, crt_user, mdf_user, data_flag, ");
                    paramValueBuffer.append(" values( '" + UniqueSeq.shortUUID() + "', '" + ThreadLocalContext.get().getUser().getOptName() + "', '" + ThreadLocalContext.get().getUser().getOptName() + "','1', ");
                    for (Map.Entry en : map.entrySet()) {
                        paramBuffer.append((String)en.getKey() + " ,");
                        paramValueBuffer.append("'" + en.getValue() + "' ,");
                    }
                    String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1) + " ) ";
                    String paramValueStr = paramValueBuffer.toString().substring(0, paramValueBuffer.toString().length() - 1) + " ) ";
                    insertList.add(paramStr + paramValueStr);
                    continue;
                }
                Ulog.info((String)"\u89e3\u6790excel\u4e2d\u7684\u6570\u636e\u5f02\u5e38===>");
            }
        }
        return insertList;
    }

    @Override
    public List<Map<String, Object>> queryBenefitDetail(Map<String, Object> paramMap) throws SQLException {
        HashMap<String, Object> cloneMap = new HashMap<String, Object>();
        StringBuffer paramBuffer = new StringBuffer();
        String tableName = StrUtil.trimStr((Object)this.newTableInfoMap.get(this.tabNameKey));
        paramMap.remove("tableName");
        cloneMap.putAll(paramMap);
        Map sqlMap = (Map)cloneMap.get("queryTerms");
        sqlMap.remove("row4Page");
        sqlMap.remove("tableName");
        sqlMap.remove("order");
        sqlMap.remove("nowPage");
        sqlMap.remove("uploadService");
        sqlMap.remove("downloadService");
        sqlMap.remove("fileType");
        for (Map.Entry entry : sqlMap.entrySet()) {
            paramBuffer.append((String)entry.getKey() + ",");
        }
        if (StrUtil.isNull((Object)paramBuffer.toString())) {
            return null;
        }
        String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1);
        StringBuffer sqlbuffer = new StringBuffer();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        sqlbuffer.append(" select serno, ").append(paramStr);
        sqlbuffer.append(" from " + tableName);
        sqlbuffer.append(" where 1=1 ");
        for (Map.Entry entry : sqlMap.entrySet()) {
            if (StrUtil.isNull(entry.getValue())) continue;
            sqlbuffer.append(" and  " + (String)entry.getKey() + " like ? ");
            query.add((Object)("%" + entry.getValue() + "%"));
        }
        query.setSql(sqlbuffer.toString());
        query.setPaginate(true);
        List resultList = this.dao.findAll(query);
        return resultList;
    }

    @Override
    public ReturnMsg delAttr(Map<String, Object> paramMap) {
        Return msg = new Return();
        List delList = (List)paramMap.get("checkbox");
        final ArrayList<String> sernoList = new ArrayList<String>();
        for (Map tmpMap : delList) {
            sernoList.add(StrUtil.trimStr(tmpMap.get("serno")));
        }
        String sql = "delete from " + this.newTableInfoMap.get(this.tabNameKey) + " where serno = ? ";
        try {
            this.dao.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    Object[] args = sernoList.toArray();
                    ps.setString(1, (String)args[i]);
                }

                public int getBatchSize() {
                    return sernoList.size();
                }
            });
            msg.setSuccessMsg("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg("\u5220\u9664\u5931\u8d25\uff01");
        }
        return msg.msg();
    }

    @Override
    public Map<String, Object> mdfAttr(Map<String, Object> paramMap) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List relationList = (List)this.getBenefitConditionQueryInfo().get("nodeList");
        String sernoStr = StrUtil.trimStr((Object)paramMap.get("serno"));
        StringBuffer paramBuffer = new StringBuffer();
        for (Map map : relationList) {
            paramBuffer.append(map.get("nodeKey")).append(" ,");
        }
        String paramStr = paramBuffer.toString().substring(0, paramBuffer.toString().length() - 1);
        String sql = "select serno, " + paramStr + " from " + this.newTableInfoMap.get(this.tabNameKey) + " where serno ='" + sernoStr + "'";
        Map resultMap = this.dao.getJdbcTemplate().queryForMap(sql);
        HashMap showMap = new HashMap();
        for (Map map : relationList) {
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!((String)entry.getKey()).equals(StrUtil.trimStr(map.get("nodeKey")))) continue;
                showMap.put(entry.getKey(), map.get("nodeName"));
            }
        }
        returnMap.put("resultMap", resultMap);
        returnMap.put("showMap", showMap);
        return returnMap;
    }

    @Override
    public ReturnMsg addAttr(Map<String, Object> paramMap) {
        Return msg = new Return();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(paramMap);
        map.remove("rqstType");
        String serno = StrUtil.trimStr(map.get("serno"));
        map.remove("serno");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" update " + this.newTableInfoMap.get(this.tabNameKey) + " set ");
        for (Map.Entry entry : map.entrySet()) {
            sqlBuffer.append((String)entry.getKey() + "='" + entry.getValue() + "',");
        }
        String sqlStr = sqlBuffer.toString().substring(0, sqlBuffer.toString().length() - 1);
        sqlStr = sqlStr + " where serno =  '" + serno + "'";
        Ulog.info((String)("\u4fdd\u5b58\u4fee\u6539\u7684\u5c5e\u6027\u7684sql===>" + sqlStr));
        try {
            this.dao.getJdbcTemplate().execute(sqlStr);
            msg.setSuccessMsg("\u4fdd\u5b58\u4fee\u6539\u540e\u7684\u5c5e\u6027\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            msg.setFailMsg("\u4fdd\u5b58\u4fee\u6539\u540e\u7684\u5c5e\u6027\u5931\u8d25!");
        }
        return msg.msg();
    }
}

