/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.attribute.service.imp;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Rules;
import cn.com.chinalife.model.Dsn_Dynamic_Data;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.model.Sys_Enum;
import cn.com.chinalife.model.Sys_Tree_Menu;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.design.attribute.service.IAttributeService;
import com.newtouch.design.util.StructureConstant;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.repository.util.RepEnum;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.properties.PropertiesUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class AttributeServiceImp
extends BaseService
implements IAttributeService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    @Qualifier(value="Dsn_StructureDao")
    private IDao structDao;
    @Autowired
    @Qualifier(value="Dsn_AttributeDao")
    private IDao attributeDao;
    @Autowired
    @Qualifier(value="Sys_Tree_MenuDao")
    private IDao menuConfig;
    @Autowired
    @Qualifier(value="Dsn_Attribute_OptionDao")
    private IDao allAttributeOption;
    @Autowired
    @Qualifier(value="Dsn_Biz_Attribute_OptionDao")
    private IDao BizAttributeOption;
    @Autowired
    @Qualifier(value="Dsn_Biz_AttributeDao")
    private IDao BizAttribute;
    @Value(value="${spring.datasource.dialect}")
    private String dialect;
    private final String splitTag = "\\|";

    @Override
    public ReturnMsg mdfAttributeInit(String node_no) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)node_no)) {
            msg.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        Dsn_Structure str = new Dsn_Structure();
        str.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)node_no);
        str = (Dsn_Structure)this.dao.findOne((AbsModel)str);
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)str.getUpNode());
        structure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        HashMap<String, String> up_node_type = new HashMap<String, String>();
        up_node_type.put("up_node_type", structure.getNodeType());
        Dsn_Biz_Attribute biz_attr = new Dsn_Biz_Attribute();
        biz_attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)node_no);
        biz_attr = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)biz_attr);
        QuerySqlable dbquerySql = DBHandleCreator.getInstance().getQuerySql();
        String dbSql = "";
        List battrOptionList = null;
        if ("radio".equals(biz_attr.getUiType()) || "select".equals(biz_attr.getUiType())) {
            Dsn_Biz_Attribute_Option dsn_Biz_Attribute_Option = new Dsn_Biz_Attribute_Option();
            dbSql = "select option_name,option_value,option_order from dsn_biz_attribute_option where biz_uuid =?";
            dbquerySql.add((Object)node_no);
            dbquerySql.setSql(dbSql.toString());
            dbquerySql.setPaginate(true);
            battrOptionList = this.dao.findAll(dbquerySql);
        } else if ("checkbox".equals(biz_attr.getUiType())) {
            Dsn_Attribute_Option dsn_Attribute_Option = new Dsn_Attribute_Option();
            dbSql = "select option_name,option_value,option_order from dsn_attribute_option where attr_uuid =?";
            dbquerySql.add((Object)node_no);
            dbquerySql.setSql(dbSql.toString());
            dbquerySql.setPaginate(true);
            battrOptionList = this.dao.findAll(dbquerySql);
        } else if ("select".equals(biz_attr.getUiType())) {
            // empty if block
        }
        biz_attr.setBizUuid(str.getNodeNo());
        biz_attr.setAttrName(str.getNodeName());
        msg.setDataTable(up_node_type);
        msg.setDataTable(new Object[]{str});
        msg.setDataTable(new Object[]{biz_attr});
        msg.setDataList(battrOptionList);
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfAttribute(Dsn_Structure structure, Dsn_Biz_Attribute attribute, Dsn_Attribute allAttribute, Map<String, Object> requestMap) {
        String biz_ui_type;
        Return msg = new Return();
        String upNode = StrUtil.trimStr((Object)requestMap.get("up_node"));
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        String node_no = structure.getNodeNo();
        structure.setNodeName(attribute.getAttrName());
        structure.setRelateFk(node_no);
        this.updateStructure(structure);
        attribute.setBizUuid(node_no);
        this.validateAttr(msg, attribute);
        if (StrUtil.isNull((Object)attribute.getAttrUuid()) && !this.checkDupAttr(attribute, upNode)) {
            msg.setFailMsg("\u5c5e\u6027\u4ee3\u7801" + attribute.getAttrNo() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u5f55\u5165\uff0c\u8bf7\u4fee\u6539");
        }
        String attr_uuid = UniqueSeq.shortUUID();
        if (StrUtil.isNull((Object)attribute.getAttrUuid())) {
            attribute.setAttrUuid(attr_uuid);
        }
        if (StrUtil.isNull((Object)allAttribute.getAttrUuid())) {
            allAttribute.setAttrUuid(attr_uuid);
        }
        if (("radio".equals(biz_ui_type = StrUtil.trimStr((Object)attribute.getUiType())) || "checkbox".equals(biz_ui_type) || "select".equals(biz_ui_type)) && StrUtil.isNull((Object)requestMap.get("dsn_biz_attribute_option"))) {
            QuerySqlable dbquerySql = DBHandleCreator.getInstance().getQuerySql();
            String dbSql = "select * from dsn_biz_attribute_option where biz_uuid =?";
            dbquerySql.add((Object)node_no);
            dbquerySql.setSql(dbSql);
            List options = this.dao.findAll(dbquerySql, Dsn_Biz_Attribute_Option.class);
            if (options.size() == 0) {
                msg.setFailMsg("\u8bf7\u6dfb\u52a0\u5355\u9009/\u591a\u9009\u4fe1\u606f/\u4e0b\u62c9\u9009\u4fe1\u606f");
                return msg.msg();
            }
        }
        this.updateAttribute(attribute, allAttribute, requestMap);
        return msg.msg();
    }

    private void validateAttr(Return msg, Dsn_Biz_Attribute attribute) {
        String msg4CheckColumnInTable;
        String msg4CheckTableExist;
        String storedField;
        String sotredTable;
        if (StrUtil.isNull((Object)attribute.getAttrName())) {
            msg.setFailMsg("\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)attribute.getAttrNo())) {
            msg.setFailMsg("\u5c5e\u6027\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)attribute.getDisplayOrder())) {
            msg.setFailMsg("\u663e\u793a\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)attribute.getUiType())) {
            msg.setFailMsg("\u663e\u793a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)(sotredTable = attribute.getStoredTab()))) {
            msg.setFailMsg("\u5b58\u50a8\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)(storedField = attribute.getStoredField()))) {
            msg.setFailMsg("\u5b58\u50a8\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNull((Object)(msg4CheckTableExist = this.checkStoredTableIsExist(sotredTable)))) {
            msg.setFailMsg(msg4CheckTableExist);
        }
        if (!StrUtil.isNull((Object)(msg4CheckColumnInTable = this.checkColumnInTable(sotredTable, storedField)))) {
            msg.setFailMsg(msg4CheckColumnInTable);
        }
        if (StrUtil.isNull((Object)attribute.getRowClm())) {
            msg.setFailMsg("\u5b58\u50a8\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isNull((Object)attribute.getNotNull())) {
            msg.setFailMsg("\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean checkDupAttr(Dsn_Biz_Attribute attribute, String upNode) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        boolean flag = true;
        String sql = "select a.* from dsn_biz_attribute a left join \n dsn_structure b \n on b.relate_fk=a.biz_uuid\n where b.up_node=?  and a.attr_no=?";
        query.add((Object)upNode);
        query.add((Object)attribute.getAttrNo());
        query.setSql(sql);
        List result = this.dao.findAll(query);
        if (null != result && !result.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    private String checkColumnInTable(String tableName, String column) {
        String msg = "";
        if (this.dialect == null || this.dialect.equalsIgnoreCase("MYSQL")) {
            String[] dbURL = PropertiesUtil.getPropertiesBySrc((String)"jdbc", (String)"database.url").split("/");
            String dbName = dbURL[1];
            String sql = "select COLUMN_NAME from information_schema.COLUMNS where table_name = ? and table_schema = ?";
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            query.add((Object)tableName);
            query.add((Object)dbName);
            query.setSql(sql);
            List resultList = this.dao.findAll(query);
            if (null != resultList && !resultList.isEmpty()) {
                boolean bl;
                boolean bl2 = false;
                for (Map tmpMap : resultList) {
                    String columnValue = StrUtil.trimStr(tmpMap.get("column_name"));
                    if (!column.equalsIgnoreCase(columnValue)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    msg = "\u5f55\u5165\u7684\u5b58\u50a8\u5b57\u6bb5[" + column + "]\u5728\u5b58\u50a8\u8868[" + tableName + "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8868\u7ed3\u6784\uff01";
                    return msg;
                }
            }
        } else {
            boolean riskFlag = false;
            if ("sip_risks".equals(tableName)) {
                Sip_Risks.Field[] risk = Sip_Risks.Field.values();
                for (Enum enum_ : risk) {
                    if (!column.equals(((Sip_Risks.Field)enum_).column())) continue;
                    riskFlag = true;
                    break;
                }
            }
            if ("sip_products".equals(tableName)) {
                Sip_Products.Field[] product = Sip_Products.Field.values();
                for (Enum enum_ : product) {
                    if (!column.equals(((Sip_Products.Field)enum_).column())) continue;
                    riskFlag = true;
                    break;
                }
            }
            if (!riskFlag && !"dsn_dynamic_data".equals(tableName)) {
                msg = "\u5f55\u5165\u7684\u5b58\u50a8\u5b57\u6bb5[" + column + "]\u5728\u5b58\u50a8\u8868[" + tableName + "]\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8868\u7ed3\u6784\uff01";
                return msg;
            }
        }
        return msg;
    }

    private String checkStoredTableIsExist(String tableName) {
        String msg = "";
        if (this.dialect == null || this.dialect.equalsIgnoreCase("MYSQL")) {
            Map resultMap;
            String isExist;
            String existFlag;
            String[] dbURL = PropertiesUtil.getPropertiesBySrc((String)"jdbc", (String)"database.url").split("/");
            String dbName = dbURL[1];
            String sql = "select count(1) as is_exist from information_schema.tables where table_schema= ? and table_name = ? ";
            QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
            query.add((Object)dbName);
            query.add((Object)tableName);
            query.setSql(sql);
            List resultList = this.dao.findAll(query);
            if (null != resultList && !resultList.isEmpty() && !(existFlag = "1").equals(isExist = StrUtil.trimStr((resultMap = (Map)resultList.get(0)).get("is_exist")))) {
                msg = tableName + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff0c\u6e29\u99a8\u63d0\u793a\uff1a\u5728\u914d\u7f6e\u4ea7\u54c1\u5c5e\u6027\u7684\u65f6\u5019\uff0c\u8bf7\u67e5\u770b\u8868sip_products\u8868\u7ed3\u6784\uff1b\u914d\u7f6e\u9669\u79cd\u5c5e\u6027\u7684\u65f6\u5019\uff0c\u8bf7\u67e5\u770b\u8868sip_risks\u8868\u7ed3\u6784";
                return msg;
            }
        }
        return msg;
    }

    private Dsn_Structure updateStructure(Dsn_Structure structure) {
        structure.setRelateTab("dsn_biz_attribute");
        structure.setRelateField("biz_uuid");
        structure.setConfigType("use");
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)structure.getNodeNo());
        this.dao.update((AbsModel)structure);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)structure.getNodeNo());
        return (Dsn_Structure)this.dao.findOne((AbsModel)structure);
    }

    private String subName(String value) {
        String[] valueChar = value.split("\\|");
        String returnValue = "";
        for (String char_ : valueChar) {
            returnValue = returnValue + StrUtil.uppFstChar((Object)char_);
        }
        return StrUtil.lowFstChar((Object)returnValue);
    }

    private Return updateAttribute(Dsn_Biz_Attribute bizAttribute, Dsn_Attribute allAttribute, Map<String, Object> requestMap) {
        Return r = new Return();
        String biz_ui_type = StrUtil.trimStr((Object)bizAttribute.getUiType());
        String defValue = StrUtil.trimStr((Object)requestMap.get("def_value"));
        switch (biz_ui_type) {
            case "hidden": {
                String column = StrUtil.trimStr((Object)bizAttribute.getStoredField());
                column = this.subName(column);
                Dsn_Dynamic_Data data = new Dsn_Dynamic_Data();
                data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, requestMap.get("node_no"));
                data = (Dsn_Dynamic_Data)this.dao.findOne((AbsModel)data);
                try {
                    BeanUtils.setProperty((Object)((Object)data), (String)column, (Object)defValue);
                }
                catch (Exception e) {
                    r.setDtildMsg("\u9690\u85cf\u7c7b\u578b\u6682\u53ea\u652f\u6301\u5b58\u50a8dsn_dynamic_data\u8868,\u5982\u679c\u5176\u4ed6\u9700\u6c42\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458!");
                    return r;
                }
                String nodeNo = StrUtil.trimStr((Object)requestMap.get("node_no"));
                if (StrUtil.isNull((Object)data.getSerno())) {
                    data.setRelateFk(nodeNo);
                    this.dao.save((AbsModel)data);
                } else {
                    data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)nodeNo);
                    this.dao.update((AbsModel)data);
                }
            }
            case "text": {
                bizAttribute.setDefValue(defValue);
                allAttribute.setDefaultValue(defValue);
                break;
            }
            case "date": {
                String dateFmt = StrUtil.trimStr((Object)requestMap.get("date_fmt"));
                bizAttribute.setDateFmt(dateFmt);
                allAttribute.setDateFmt(dateFmt);
                break;
            }
            case "number": {
                bizAttribute.setInterger(Integer.parseInt(StrUtil.trimStr((Object)requestMap.get("interger"))));
                bizAttribute.setAttrPrecision(Integer.parseInt(StrUtil.trimStr((Object)requestMap.get("int_precision"))));
                bizAttribute.setThsRs(StrUtil.trimStr((Object)requestMap.get("int_ths_rs")));
                allAttribute.setInterger(Integer.parseInt(StrUtil.trimStr((Object)requestMap.get("interger"))));
                allAttribute.setAttrPrecision(Integer.parseInt(StrUtil.trimStr((Object)requestMap.get("int_precision"))));
                allAttribute.setThsRs(StrUtil.trimStr((Object)requestMap.get("int_ths_rs")));
                break;
            }
            case "select": 
            case "checkbox": 
            case "radio": {
                ArrayList<Dsn_Biz_Attribute_Option> attrOptions = new ArrayList();
                List<Dsn_Attribute_Option> allAttrOptions = new ArrayList<Dsn_Attribute_Option>();
                Object attributeOption = requestMap.get("dsn_biz_attribute_option");
                if (!StrUtil.isNull((Object)attributeOption)) {
                    attrOptions = JsonUtilOld.json2List(attributeOption, Dsn_Biz_Attribute_Option.class);
                    allAttrOptions = JsonUtilOld.json2List(attributeOption, Dsn_Attribute_Option.class);
                }
                this.saveDsnAttrOption(allAttrOptions, allAttribute);
                this.saveDsnAttrOption(attrOptions, bizAttribute);
                break;
            }
        }
        bizAttribute.setBizType(this.queryBizType(bizAttribute.getBizUuid()));
        bizAttribute.setIsMapping("N");
        bizAttribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)bizAttribute.getBizUuid());
        this.dao.delete((AbsModel)bizAttribute);
        this.dao.save((AbsModel)bizAttribute);
        if (StrUtil.isNull((Object)allAttribute.getInterger())) {
            allAttribute.setInterger(0);
        }
        allAttribute.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)allAttribute.getAttrUuid());
        Dsn_Attribute checkallattribute = (Dsn_Attribute)this.dao.findOne((AbsModel)allAttribute);
        if (StrUtil.isNull((Object)checkallattribute.getAttrName())) {
            this.dao.save((AbsModel)allAttribute);
        }
        return r;
    }

    private void saveDsnAttrOption(List<Dsn_Attribute_Option> allAttrOptions, Dsn_Attribute allAttribute) {
        String attr_uuid = allAttribute.getAttrUuid();
        if (StrUtil.isNull(allAttrOptions) || allAttrOptions.isEmpty()) {
            return;
        }
        for (Dsn_Attribute_Option allAttrOption : allAttrOptions) {
            allAttrOption.setAttrUuid(attr_uuid);
            if (this.isExistAttrOption(attr_uuid, allAttrOption.getOptionNo(), allAttrOption.getOptionName()).booleanValue()) continue;
            allAttrOption.setOptionNo(UniqueSeq.shortUUID());
            allAttrOption.setSerno(UniqueSeq.shortUUID());
            this.dao.save((AbsModel)allAttrOption);
        }
    }

    private void saveDsnAttrOption(List<Dsn_Biz_Attribute_Option> attrOptions, Dsn_Biz_Attribute bizAttribute) {
        String biz_uuid = bizAttribute.getBizUuid();
        bizAttribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)biz_uuid);
        bizAttribute = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)bizAttribute);
        Dsn_Biz_Attribute_Option bizAttrOption = new Dsn_Biz_Attribute_Option();
        bizAttrOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)biz_uuid);
        this.dao.delete((AbsModel)bizAttrOption);
        if (StrUtil.isNull(attrOptions) || attrOptions.isEmpty()) {
            return;
        }
        for (Dsn_Biz_Attribute_Option attrOption : attrOptions) {
            if (StrUtil.isNull((Object)attrOption.getOptionNo())) {
                attrOption.setOptionNo(UniqueSeq.shortUUID());
                if (StrUtil.trimStr((Object)bizAttribute.getBizType()).endsWith("_detail")) {
                    this.saveOptionToOtherDetailAttr(bizAttribute.getAttrName(), biz_uuid, attrOption);
                }
            }
            attrOption.setBizUuid(biz_uuid);
            this.dao.save((AbsModel)attrOption);
        }
    }

    private void saveOptionToOtherDetailAttr(String attrName, String notBizUuid, Dsn_Biz_Attribute_Option option) {
        Dsn_Biz_Attribute attr = new Dsn_Biz_Attribute();
        attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.attr_name, (Object)attrName);
        attr.where().addNotEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)notBizUuid);
        List otherAttrList = this.dao.findAll((AbsModel)attr);
        for (Dsn_Biz_Attribute temp : otherAttrList) {
            Dsn_Biz_Attribute_Option option1 = new Dsn_Biz_Attribute_Option();
            option1.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)temp.getBizUuid());
            option1.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_value, (Object)option.getOptionValue());
            List option1List = this.dao.findAll((AbsModel)option1);
            if (!option1List.isEmpty() && option1List.size() != 0) continue;
            option.setBizUuid(temp.getBizUuid());
            this.dao.save((AbsModel)option);
        }
    }

    private Boolean isExistAttrOption(String attr_uuid, String option_no, String option_name) {
        if (StrUtil.isNull((Object)attr_uuid)) {
            Ulog.error((String)"\u9669\u79cd\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        Dsn_Attribute_Option dsnAttrOption = new Dsn_Attribute_Option();
        dsnAttrOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)attr_uuid);
        dsnAttrOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.option_no, (Object)StrUtil.trimStr((Object)option_no));
        dsnAttrOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.option_name, (Object)StrUtil.trimStr((Object)option_name));
        List attrOptionList = this.dao.findAll((AbsModel)dsnAttrOption);
        return attrOptionList != null && !attrOptionList.isEmpty();
    }

    private String queryBizType(String node_no) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from dsn_structure where node_no=(  select up_node from dsn_structure where node_no=?)";
        query.add((Object)node_no);
        query.setSql(sql);
        Map strt = (Map)this.dao.findAll(query).get(0);
        String nodeType = StrUtil.trimStr(strt.get("node_type"));
        if ("attr_group".equals(nodeType) || "input".equals(nodeType) || "output".equals(nodeType) || "n_liability".equals(nodeType)) {
            this.queryBizType((String)strt.get("node_no"));
        }
        return nodeType;
    }

    @Override
    public ReturnMsg queryAttributeOption(String attr_uuid) {
        Return msg = new Return();
        if (StrUtil.isNull((Object)attr_uuid)) {
            msg.setFailMsg("\u5c5e\u6027\u4e3b\u952e[attr_uuid]\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        Dsn_Biz_Attribute attr = new Dsn_Biz_Attribute();
        attr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.attr_uuid, (Object)attr_uuid);
        attr = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)attr);
        Dsn_Biz_Attribute_Option attrOption = new Dsn_Biz_Attribute_Option();
        attrOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)attr.getBizUuid());
        attrOption.setOrderBy(new Sort.Order[]{Dsn_Biz_Attribute_Option.Field.option_order.asc()});
        List attrOptionList = this.dao.findAll((AbsModel)attrOption);
        msg.getDataTable().put("dsn_biz_attribute_option", attrOptionList);
        return msg.msg();
    }

    @Override
    public ReturnMsg addAttribute(Map<String, Object> param) {
        String node_no = UniqueSeq.shortUUID();
        String attr_uuid = UniqueSeq.shortUUID();
        param.put("up_node", StrUtil.trimStr((Object)param.get("node_no")));
        param.put("node_no", node_no);
        param.put("relate_fk", attr_uuid);
        param.put("relate_tab", "dsn_biz_attribute");
        param.put("relate_field", "biz_uuid");
        this.addNode(param);
        HashMap<String, Object> allattr = new HashMap<String, Object>();
        String biz_uuid = UniqueSeq.shortUUID();
        allattr.put("attr_uuid", attr_uuid);
        String attrno = StrUtil.trimStr((Object)param.get("attr_no"));
        allattr.put("attr_no", attrno);
        allattr.put("attr_name", StrUtil.trimStr((Object)param.get("attr_name")));
        this.attributeDao.addGroupBy("max(display_order)");
        allattr.put("biz_stored_tab", StrUtil.trimStr((Object)param.get("biz_stored_tab")));
        allattr.put("biz_stored_field", StrUtil.trimStr((Object)param.get("biz_stored_field")));
        String biz_ui_type = StrUtil.trimStr((Object)param.get("biz_ui_type"));
        allattr.put("biz_ui_type", biz_ui_type);
        ArrayList<Map<String, Object>> te = new ArrayList();
        HashMap mp = new HashMap();
        switch (biz_ui_type) {
            case "2": {
                allattr.put("biz_length", StrUtil.trimStr((Object)param.get("biz_length")));
                break;
            }
            case "6": {
                allattr.put("biz_date_fmt", StrUtil.trimStr((Object)param.get("biz_date_type")));
                break;
            }
            case "7": {
                allattr.put("biz_interger_number", StrUtil.trimStr((Object)param.get("biz_interger_number")));
                allattr.put("biz_precision", StrUtil.trimStr((Object)param.get("biz_precision_num")));
                allattr.put("biz_ths_rs", StrUtil.trimStr((Object)param.get("biz_is_display")));
                break;
            }
            case "4": 
            case "5": {
                te = (List)param.get("dsn_attribute_option");
                this.SaveDsnOptionChoice(te, attrno, attr_uuid, biz_uuid);
            }
        }
        allattr.put("biz_row_clm", StrUtil.trimStr((Object)param.get("biz_row_clm")));
        allattr.put("biz_not_null", StrUtil.trimStr((Object)param.get("biz_not_null")));
        this.attributeDao.insert(allattr);
        this.BizAttribute.addGroupBy("max(display_order)");
        String attr_display_order = StrUtil.trimStr(this.BizAttribute.query().get("max_display_order"));
        allattr.put("display_order", StrUtil.isNull((Object)attr_display_order) ? 1 : Integer.parseInt(attr_display_order) + 1);
        allattr.put("biz_uuid", biz_uuid);
        allattr.put("biz_type", "1");
        this.BizAttribute.insert(allattr);
        return new Return().msg();
    }

    private void SaveDsnOptionChoice(List<Map<String, Object>> param, String option_no, String attr_uuid, String biz_uuid) {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        optionMap.put("option_no", option_no);
        if (param == null || param.size() == 0) {
            return;
        }
        for (Map<String, Object> map : param) {
            for (String k : map.keySet()) {
                optionMap.put(k, map.get(k));
            }
            optionMap.put("attr_no", UniqueSeq.shortUUID());
            optionMap.put("biz_uuid", UniqueSeq.shortUUID());
            optionMap.put("relate_fk", attr_uuid);
            this.allAttributeOption.insert(optionMap);
            optionMap.put("relate_fk", biz_uuid);
            this.BizAttributeOption.insert(optionMap);
        }
    }

    @Override
    public ReturnMsg queryExistAttr(Map<String, Object> param) {
        String upNodeNo = StrUtil.trimStr((Object)param.get("up_node_select"));
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)upNodeNo);
        Dsn_Structure dsnStrResult = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        if (StrUtil.isNull((Object)dsnStrResult.getNodeName())) {
            Ulog.error((String)"\u6ca1\u53d6\u5230\u5f53\u524d\u8282\u70b9\u7684\u540d\u79f0\uff01\uff01\uff01");
            return null;
        }
        String searchAll = StrUtil.trimStr((Object)param.get("checked"));
        String queryKey = StrUtil.trimStr((Object)param.get("attr_name_query"));
        boolean isNotSearchAll = "N".equals(searchAll);
        boolean isQueryByName = !queryKey.equals("0");
        String parentNodeName = "liab_group".equals(dsnStrResult.getNodeType()) ? "\u5229\u76ca\u6f14\u793a" : dsnStrResult.getNodeName();
        List<Map<String, Object>> dsnList = this.queryAttrList(parentNodeName, queryKey, isNotSearchAll, isQueryByName);
        List<Map<String, Object>> dsn4ExistList = this.getCurrentNodeSubAttribute(upNodeNo);
        LinkedList attrnameAndUiTypeList = new LinkedList();
        dsn4ExistList.forEach(map -> attrnameAndUiTypeList.add(StrUtil.trimStr(map.get("ui_type")) + StrUtil.trimStr(map.get("attr_name"))));
        Sys_Enum sysEnum = new Sys_Enum();
        sysEnum.where().addEq((ModelField)Sys_Enum.Field.up_enum, (Object)"ui_type");
        List sysEnumList = this.dao.findAll((AbsModel)sysEnum);
        Map<String, String> enumMap = sysEnumList.stream().collect(Collectors.toMap(Sys_Enum::getEnumNo, Sys_Enum::getEnumName));
        LinkedList result = new LinkedList();
        dsnList.stream().forEach(map -> {
            String uiType = StrUtil.trimStr(map.get("ui_type"));
            String attr_name = StrUtil.trimStr(map.get("attr_name"));
            if (!attrnameAndUiTypeList.contains(uiType + attr_name)) {
                map.put("ui_type_name", attr_name + "(" + (String)enumMap.get(uiType) + ")");
                result.add(map);
            }
        });
        Return msg = new Return();
        if (result.isEmpty()) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("ui_type_name", "\u672a\u67e5\u8be2\u5230\u4fe1\u606f,\u8bf7\u4e0d\u8981\u6dfb\u52a0\u6b64\u6761\u8bb0\u5f55!");
            result.add(map2);
        }
        msg.setDataList(result);
        return msg.msg();
    }

    private List<Map<String, Object>> getCurrentNodeSubAttribute(String parentNodeNo) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append(" SELECT MAX(BIZ.BIZ_UUID) ATTR_UUID, BIZ.ATTR_NAME, BIZ.UI_TYPE FROM  DSN_STRUCTURE  SUB,DSN_BIZ_ATTRIBUTE BIZ   ");
        sqlSB.append(" WHERE SUB.RELATE_TAB = ? ");
        sqlSB.append(" AND SUB.UP_NODE =  ?");
        sqlSB.append(" AND  BIZ.BIZ_UUID=SUB.NODE_NO ");
        sqlSB.append(" GROUP BY  BIZ.ATTR_NAME, BIZ.UI_TYPE ORDER BY BIZ.ATTR_NAME ");
        querySql.add((Object)"dsn_biz_attribute");
        querySql.add((Object)parentNodeNo);
        querySql.setSql(sqlSB.toString());
        List dsnList = this.dbHandle().queryList(querySql);
        return dsnList;
    }

    private List<Map<String, Object>> queryAttrList(String parentNodeName, String queryKey, boolean isNotSearchAll, boolean isQueryByName) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append(" SELECT MAX(BIZ.BIZ_UUID) ATTR_UUID , BIZ.ATTR_NAME, BIZ.UI_TYPE FROM  DSN_STRUCTURE  SUB,DSN_BIZ_ATTRIBUTE BIZ   ");
        if (isNotSearchAll) {
            sqlSB.append(" ,DSN_STRUCTURE  P  ");
        }
        sqlSB.append(" WHERE SUB.RELATE_TAB = ? ");
        querySql.add((Object)"dsn_biz_attribute");
        if (isNotSearchAll) {
            sqlSB.append(" AND P.NODE_NO=SUB.UP_NODE   AND P.NODE_NAME=?  ");
            querySql.add((Object)parentNodeName);
        }
        if (isQueryByName) {
            sqlSB.append(" AND SUB.NODE_NAME LIKE ?  ");
            querySql.add((Object)("%" + queryKey + "%"));
        }
        sqlSB.append(" AND  BIZ.BIZ_UUID=SUB.NODE_NO ");
        sqlSB.append(" GROUP BY  BIZ.ATTR_NAME, BIZ.UI_TYPE ORDER BY BIZ.ATTR_NAME ");
        querySql.setSql(sqlSB.toString());
        List dsnList = this.dbHandle().queryList(querySql);
        return dsnList;
    }

    public ReturnMsg queryExistAttr22222222222222222222222(Map<String, Object> param) {
        String attrNameQuery;
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, param.get("up_node_select"));
        Dsn_Structure dsnStrResult = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        if (StrUtil.isNull((Object)dsnStrResult.getNodeName())) {
            Ulog.error((String)"\u6ca1\u53d6\u5230\u5f53\u524d\u8282\u70b9\u7684\u540d\u79f0\uff01\uff01\uff01");
            return null;
        }
        Dsn_Structure dsnUp = new Dsn_Structure();
        String node_name = "liab_group".equals(dsnStrResult.getNodeType()) ? "\u5229\u76ca\u6f14\u793a" : dsnStrResult.getNodeName();
        dsnUp.where().addEq((ModelField)Dsn_Structure.Field.node_name, (Object)node_name);
        List dsnUpList = this.dao.findAll((AbsModel)dsnUp);
        Dsn_Structure attrNode = new Dsn_Structure();
        attrNode.where().addEq((ModelField)Dsn_Structure.Field.relate_tab, (Object)"dsn_biz_attribute");
        if ("N".equals(StrUtil.trimStr((Object)param.get("checked")))) {
            for (Dsn_Structure dsn : dsnUpList) {
                attrNode.where().addIn((ModelField)Dsn_Structure.Field.up_node, dsn.getNodeNo());
            }
        }
        if (!(attrNameQuery = StrUtil.trimStr((Object)param.get("attr_name_query"))).equals("0")) {
            attrNode.where().addLike((ModelField)Dsn_Structure.Field.node_name, (Object)attrNameQuery);
        }
        attrNode.where().addCallback((RowCallback)new RowCallback<AbsModel>(){

            public void callback(AbsModel row, List<? extends AbsModel> data, int index) {
                Dsn_Structure dsn = (Dsn_Structure)row;
                dsn.putOtherProperty("attr_uuid", dsn.getNodeNo());
                dsn.putOtherProperty("attr_name", dsn.getNodeName());
                Dsn_Biz_Attribute attribute = new Dsn_Biz_Attribute();
                attribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)dsn.getNodeNo());
                attribute.where().addCallback((RowCallback)new RepEnum("ui_type", (ModelField)Dsn_Biz_Attribute.Field.ui_type));
                attribute = (Dsn_Biz_Attribute)AttributeServiceImp.this.dao.findOne((AbsModel)attribute);
                dsn.putOtherProperty("ui_type_name", dsn.getNodeName() + "(" + attribute.getOtherProperty("ui_type_name") + ")");
            }
        });
        attrNode.groupBy().by().add(Dsn_Structure.Field.node_no);
        attrNode.groupBy().by().add(Dsn_Structure.Field.node_name);
        List dsnList = this.dao.findAll((AbsModel)attrNode);
        List<Dsn_Structure> dsn4ExistList = this.getCurrentNodeAttribute(StrUtil.trimStr((Object)param.get("up_node_select")));
        ArrayList<Object> returnDsnList = new ArrayList<Object>(10);
        for (Object dsnName : dsnList) {
            if (!returnDsnList.isEmpty()) {
                boolean bl = false;
                for (Dsn_Structure dsn_Structure : returnDsnList) {
                    if (!dsnName.getOtherProperty("ui_type_name").equals(dsn_Structure.getOtherProperty("ui_type_name"))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                returnDsnList.add(dsnName);
                continue;
            }
            returnDsnList.add(dsnName);
        }
        ArrayList<Dsn_Structure> returnDsnList4Result = new ArrayList<Dsn_Structure>(10);
        for (Dsn_Structure dsn_Structure : returnDsnList) {
            if (!dsn4ExistList.isEmpty()) {
                boolean flag = false;
                for (Dsn_Structure returnDsn : dsn4ExistList) {
                    if (!dsn_Structure.getOtherProperty("ui_type_name").equals(returnDsn.getOtherProperty("ui_type_name"))) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                returnDsnList4Result.add(dsn_Structure);
                continue;
            }
            returnDsnList4Result.add(dsn_Structure);
        }
        Return msg = new Return();
        if (returnDsnList.isEmpty()) {
            Dsn_Structure dsn_Structure = new Dsn_Structure();
            dsn_Structure.putOtherProperty("ui_type_name", "\u672a\u67e5\u8be2\u5230\u4fe1\u606f,\u8bf7\u4e0d\u8981\u6dfb\u52a0\u6b64\u6761\u8bb0\u5f55!");
            returnDsnList4Result.add(dsn_Structure);
        }
        msg.setDataList(returnDsnList4Result, Dsn_Structure.class);
        return msg.msg();
    }

    private List<Dsn_Structure> getCurrentNodeAttribute(String nodeNO) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNO);
        dsnStructure.where().addCallback((RowCallback)new RowCallback<AbsModel>(){

            public void callback(AbsModel row, List<? extends AbsModel> data, int index) {
                Dsn_Structure dsn = (Dsn_Structure)row;
                dsn.putOtherProperty("attr_uuid", dsn.getNodeNo());
                dsn.putOtherProperty("attr_name", dsn.getNodeName());
                Dsn_Biz_Attribute attribute = new Dsn_Biz_Attribute();
                attribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)dsn.getNodeNo());
                attribute.where().addCallback((RowCallback)new RepEnum("ui_type", (ModelField)Dsn_Biz_Attribute.Field.ui_type));
                attribute = (Dsn_Biz_Attribute)AttributeServiceImp.this.dao.findOne((AbsModel)attribute);
                dsn.putOtherProperty("ui_type_name", dsn.getNodeName() + "(" + attribute.getOtherProperty("ui_type_name") + ")");
            }
        });
        List dsnStructureList = this.dao.findAll((AbsModel)dsnStructure);
        return null == dsnStructureList ? null : dsnStructureList;
    }

    @Override
    public ReturnMsg selectAttrToSave(Map<String, Object> param) {
        List<String> biz_uuidAndAttr_name;
        Return msg = new Return();
        String right_select = StrUtil.trimStr((Object)param.get("rightSelect"));
        if (StrUtil.isNull((Object)right_select)) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u5c5e\u6027\uff01");
            return msg.msg();
        }
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq"));
        String attrNodeUpNode = StrUtil.trimStr((Object)param.get("up_node_select"));
        if (this.haveSameNode(attrNodeUpNode, biz_uuidAndAttr_name = Arrays.asList(right_select.split(",")))) {
            msg.setFailMsg("\u4e0d\u80fd\u6dfb\u52a0\u4e24\u79cd\u76f8\u540c\u5c5e\u6027");
            return msg.msg();
        }
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)attrNodeUpNode);
        dsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
        String nodeType = this.getNodeType(dsn);
        for (String temp : biz_uuidAndAttr_name) {
            String[] st = temp.split("\\|");
            String biz_uuid = st[0];
            String attr_name = st[1];
            HashMap<String, Object> struct = new HashMap<String, Object>();
            String node_no = UniqueSeq.shortUUID();
            struct.put("node_seq", node_seq);
            struct.put("up_node", attrNodeUpNode);
            struct.put("node_no", node_no);
            struct.put("relate_fk", node_no);
            struct.put("attr_name", attr_name);
            struct.put("node_type", nodeType);
            struct.put("relate_tab", "dsn_biz_attribute");
            struct.put("relate_field", "biz_uuid");
            String displayOrder = this.addNode(struct);
            this.attrCopy(biz_uuid, attr_name, node_no, displayOrder);
            this.attrOptionCopy(biz_uuid, node_no);
        }
        return msg.msg();
    }

    private void attrOptionCopy(String biz_uuid, String newBiz_uuid) {
        QuerySqlable query1 = DBHandleCreator.getInstance().getQuerySql();
        String sql1 = "select * from dsn_biz_attribute_option where biz_uuid = ? ";
        query1.add((Object)biz_uuid);
        query1.setSql(sql1);
        List dsnOption = this.dbHandle().queryList(query1);
        if (dsnOption.size() > 0) {
            for (Map m1 : dsnOption) {
                m1.put("biz_uuid", newBiz_uuid);
                m1.put("option_no", UniqueSeq.shortUUID());
                this.removeKey(m1);
                this.BizAttributeOption.insert(m1);
            }
        }
    }

    private void attrCopy(String biz_uuid, String attr_name, String node_no, String display_order) {
        Dsn_Biz_Attribute bizAttr = new Dsn_Biz_Attribute();
        bizAttr.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)biz_uuid);
        Dsn_Biz_Attribute attr = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)bizAttr);
        attr.setSerno(UniqueSeq.shortUUID());
        attr.setAttrUuid(UniqueSeq.shortUUID());
        attr.setAttrName(attr_name);
        attr.setBizUuid(node_no);
        attr.setBizType("1");
        attr.setIsMapping("N");
        attr.setDisplayOrder(Integer.valueOf(display_order));
        this.dao.save((AbsModel)attr);
    }

    private boolean haveSameNode(String up_node_select, List<String> biz_uuidAndAttr_name) {
        ArrayList<String> attrNameList = new ArrayList<String>();
        Dsn_Structure dsn_structure = new Dsn_Structure();
        dsn_structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)up_node_select);
        List subNodeList = this.dao.findAll((AbsModel)dsn_structure);
        subNodeList.stream().forEach(subNode -> attrNameList.add(subNode.getNodeName()));
        for (String right : biz_uuidAndAttr_name) {
            String[] rightStr = right.split("\\|");
            String attr_name = rightStr[1];
            if (attrNameList.contains(attr_name)) {
                return true;
            }
            attrNameList.add(attr_name);
        }
        return false;
    }

    private String getNodeType(Dsn_Structure dsn) {
        String type = "attr";
        String nodeType = dsn.getNodeType();
        if ("output".equals(nodeType) || "input".equals(nodeType)) {
            type = "attr4Rate";
        } else if ("n_liability".equals(nodeType) || "liab_group".equals(nodeType)) {
            type = "attr4Liability";
        } else if ("tbr".equals(nodeType)) {
            type = "tbr_attr";
        } else if ("bbr".equals(nodeType)) {
            type = "bbr_attr";
        } else if ("syr".equals(nodeType)) {
            type = "syr_attr";
        } else if (StructureConstant.RISK_DETAIL_LIST.contains(nodeType)) {
            type = "attr_detail";
        }
        return type;
    }

    private String addNode(Map<String, Object> param) {
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("node_no", node_no);
        map.put("node_name", StrUtil.trimStr((Object)param.get("attr_name")));
        map.put("node_type", StrUtil.trimStr((Object)param.get("node_type")));
        map.put("up_node", StrUtil.trimStr((Object)param.get("up_node")));
        map.put("relate_tab", StrUtil.trimStr((Object)param.get("relate_tab")));
        map.put("relate_field", StrUtil.trimStr((Object)param.get("relate_field")));
        map.put("relate_fk", StrUtil.trimStr((Object)param.get("relate_fk")));
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq")) + node_no + ".";
        map.put("node_seq", node_seq);
        this.structDao.addEq("up_node", map.get("up_node"));
        this.structDao.addGroupBy("max(display_order)");
        String display_order = StrUtil.trimStr(this.structDao.query().get("max_display_order"));
        display_order = StrUtil.isNull((Object)display_order) ? "1" : String.valueOf(Integer.parseInt(display_order) + 1);
        map.put("display_order", display_order);
        this.structDao.insert(map);
        List<Dsn_Structure> nextNodeList = this.queryChildNode(StrUtil.trimStr((Object)param.get("node_type")), node_no, node_seq + node_no + ".");
        this.dao.save(nextNodeList);
        if (!nextNodeList.isEmpty()) {
            for (Dsn_Structure ds : nextNodeList) {
                List<Dsn_Structure> nextNextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
                this.dao.save(nextNextNodeList);
            }
        }
        return display_order;
    }

    private List<Dsn_Structure> queryChildNode(String node_type, String node_no, String node_seq) {
        Sys_Tree_Menu queryMenu = new Sys_Tree_Menu();
        queryMenu.where().addEq((ModelField)Sys_Tree_Menu.Field.up_menu, (Object)node_type);
        queryMenu.where().addEq((ModelField)Sys_Tree_Menu.Field.menu_type, (Object)"node");
        queryMenu.setOrderBy(new Sort.Order[]{Sys_Tree_Menu.Field.display_order.asc()});
        List<Dsn_Structure> nextNodeList = this.dao.findAll((AbsModel)queryMenu, false).stream().map(menuNode -> {
            Dsn_Structure nextNode = new Dsn_Structure();
            nextNode.setNodeNo(UniqueSeq.shortUUID());
            nextNode.setNodeName(menuNode.getMenuName());
            nextNode.setNodeType(menuNode.getNodeType());
            nextNode.setUpNode(node_no);
            nextNode.setDisplayOrder(menuNode.getDisplayOrder());
            nextNode.setNodeSeq(node_seq + nextNode.getNodeNo() + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }

    private void removeKey(Map<String, Object> param) {
        param.remove("serno");
        param.remove("crt_date");
        param.remove("mdf_date");
        param.remove("crt_user");
        param.remove("mdf_user");
        param.remove("data_flag");
    }

    public String NotInSql(Map<String, Object> param) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        StringBuffer str = new StringBuffer();
        str.append("select * from dsn_attribute where attr_uuid not in(");
        String query_name = StrUtil.trimStr((Object)param.get("attr_name_query"));
        String sql = "select relate_fk from dsn_structure where up_node=?";
        query.add(param.get("up_node_pro"));
        query.setSql(sql);
        List list = this.dbHandle().queryList(query);
        if (list.size() <= 0) {
            str.append("'')");
        } else {
            for (Map map : list) {
                str.append("'" + StrUtil.trimStr(map.get("relate_fk")) + "',");
            }
            str.replace(str.length() - 1, str.length(), ")");
        }
        if (!query_name.equals("0")) {
            str.append("and attr_name like ?");
        }
        return str.toString();
    }

    @Override
    public ReturnMsg queryBizAttrInfo(Map<String, Object> param) {
        Return msg = new Return();
        this.BizAttribute.addEq("attr_uuid", (Object)((String)param.get("relate_fk")));
        Map map = this.BizAttribute.query();
        msg.setDataTable(map);
        msg.getDataTable().put("node_no", param.get("node_no"));
        msg.getDataTable().put("node_type", param.get("node_type"));
        msg.getDataTable().put("node_seq", param.get("node_seq"));
        String biz_ui_type = StrUtil.trimStr(map.get("biz_ui_type"));
        this.BizAttributeOption.addEq("relate_fk", map.get("biz_uuid"));
        if (biz_ui_type.equals("4") || biz_ui_type.equals("5")) {
            List list = this.BizAttributeOption.queryList(false);
            msg.getDataTable().put("dsn_attribute_option", list);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg bizAttrInfoMdf(Map<String, Object> param) {
        this.structDao.addEq("node_no", param.get("node_no"));
        Map strcut = this.structDao.query();
        this.bizAttrInfoDel(param);
        String node_no = (String)strcut.get("up_node");
        String node_seq = (String)strcut.get("node_seq");
        String[] seq = node_seq.split("\\.", 3);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < seq.length - 1; ++i) {
            sb.append(seq[i] + ".");
        }
        param.put("node_seq", sb.toString());
        param.put("node_no", node_no);
        ReturnMsg msg = this.addAttribute(param);
        return msg;
    }

    @Override
    public ReturnMsg bizAttrInfoDel(Map<String, Object> param) {
        String node_no = StrUtil.trimStr((Object)param.get("node_no"));
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_seq);
        List dsList = this.dao.findAll((AbsModel)ds);
        for (Dsn_Structure d : dsList) {
            if (!"rule".equals(d.getNodeType())) continue;
            Dsn_Biz_Attribute_Rules attr_rule = new Dsn_Biz_Attribute_Rules();
            attr_rule.where().addEq((ModelField)Dsn_Biz_Attribute_Rules.Field.attr_rule_uuid, (Object)d.getNodeNo());
            attr_rule = (Dsn_Biz_Attribute_Rules)this.dao.findOne((AbsModel)attr_rule);
            Dsn_Dynamic_Data data = new Dsn_Dynamic_Data();
            data.where().addEq((ModelField)Dsn_Dynamic_Data.Field.relate_fk, (Object)attr_rule.getSerno());
            this.dao.delete((AbsModel)data);
        }
        Dsn_Structure structure4 = new Dsn_Structure();
        structure4.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_seq);
        this.dao.delete((AbsModel)structure4);
        Dsn_Structure structure1 = new Dsn_Structure();
        structure1.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)node_no);
        Dsn_Structure structure2 = new Dsn_Structure();
        structure2.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        Dsn_Structure structure3 = new Dsn_Structure();
        structure3.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)structure4.getNodeNo());
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().or((AbsModel)structure1);
        structure.where().or((AbsModel)structure2);
        structure.where().or((AbsModel)structure3);
        this.dao.delete((AbsModel)structure);
        Dsn_Biz_Attribute biz_attribute = new Dsn_Biz_Attribute();
        biz_attribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)node_no);
        biz_attribute = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)biz_attribute);
        biz_attribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)node_no);
        this.dao.delete((AbsModel)biz_attribute);
        Dsn_Biz_Attribute_Option biz_attribute_option = new Dsn_Biz_Attribute_Option();
        biz_attribute_option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)node_no);
        this.dao.delete((AbsModel)biz_attribute_option);
        Dsn_Attribute attr = new Dsn_Attribute();
        attr.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)biz_attribute.getAttrUuid());
        this.dao.delete((AbsModel)attr);
        Dsn_Attribute_Option attrOption = new Dsn_Attribute_Option();
        attrOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)biz_attribute.getAttrUuid());
        this.dao.delete((AbsModel)attrOption);
        Return msg = new Return();
        return msg.msg();
    }

    @Override
    public ReturnMsg doValidateAttrNo(Map<String, Object> param) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from dsn_attribute where attr_no=?";
        query.add(param.get("attr_no"));
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg doValidateAttrName(Map<String, Object> param) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from dsn_attribute where attr_name=?";
        query.add(param.get("node_name"));
        query.setSql(sql);
        Return msg = new Return();
        msg.setDataList(this.dbHandle().queryList(query));
        return msg.msg();
    }

    @Override
    public ReturnMsg doValidateProductName(Map<String, Object> param) {
        Return msg = new Return();
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_type, param.get("node_type"));
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_name, param.get("node_name"));
        msg.setDataList(this.dao.findAll((AbsModel)dsn), Dsn_Structure.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateOptionName(Map<String, Object> param) {
        Return msg = new Return();
        Dsn_Attribute_Option attrOption = new Dsn_Attribute_Option();
        attrOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, param.get("attr_uuid"));
        attrOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.option_name, param.get("option_name"));
        msg.setDataList(this.dao.findAll((AbsModel)attrOption), Dsn_Attribute_Option.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateOptionValue(Map<String, Object> param) {
        Return msg = new Return();
        Dsn_Biz_Attribute_Option attrOption = new Dsn_Biz_Attribute_Option();
        attrOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, param.get("attr_uuid"));
        attrOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_value, param.get("option_value"));
        msg.setDataList(this.dao.findAll((AbsModel)attrOption), Dsn_Biz_Attribute_Option.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateOptionOrder(Map<String, Object> param) {
        Return msg = new Return();
        Dsn_Biz_Attribute_Option attrOption = new Dsn_Biz_Attribute_Option();
        attrOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, param.get("attr_uuid"));
        attrOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_order, param.get("option_order"));
        msg.setDataList(this.dao.findAll((AbsModel)attrOption), Dsn_Biz_Attribute_Option.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg attrOptionInfoDel(Map<String, Object> param) {
        Return msg = new Return();
        Dsn_Attribute_Option alloption = new Dsn_Attribute_Option();
        Dsn_Biz_Attribute_Option attroption = new Dsn_Biz_Attribute_Option();
        if (StrUtil.isNull((Object)param.get("option_no")) || StrUtil.isNull((Object)param.get("attr_uuid"))) {
            return msg.msg();
        }
        attroption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, param.get("biz_uuid"));
        attroption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.option_no, param.get("option_no"));
        if (this.dao.findAll((AbsModel)attroption).size() > 0) {
            msg.setFailMsg("\u6b64\u5c5e\u6027\u9009\u9879\u5728\u5176\u4ed6\u4ea7\u54c1\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u5220\u9664");
        } else {
            alloption.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, param.get("attr_uuid"));
            alloption.where().addEq((ModelField)Dsn_Attribute_Option.Field.option_no, param.get("option_no"));
            this.dao.delete((AbsModel)alloption);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg queryExistRule(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg selectRuleToSave(Map<String, Object> param) {
        return null;
    }

    @Override
    public ReturnMsg delAttrGroup(Map<String, Object> param) {
        String node_seq = StrUtil.trimStr((Object)param.get("node_seq"));
        Dsn_Structure ds = new Dsn_Structure();
        ds.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)node_seq);
        this.dao.delete((AbsModel)ds);
        Return r = new Return();
        return r.msg();
    }
}

