/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.design.asyn;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sys_File_Repostry;
import com.newtouch.design.asyn.FileInfo;
import com.newtouch.design.product.service.IExportProductSql;
import com.newtouch.design.util.ZipUtil;
import com.newtouch.log.Ulog;
import com.newtouch.mail.Mail;
import com.newtouch.msg.Return;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.repository.util.SqlMapper;
import com.newtouch.repository.util.SqlUtil;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.path.PathFactory;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;

public class MyThread
implements Runnable {
    private String productUUID;
    private Date date;
    private String fileNo;
    private boolean flag;
    private String url = "";
    private String emailAddress;
    private AbsModelRepository dao;
    private String sqlPath;
    private IExportProductSql iExportProductSql;
    private int MaxSize = 0x2800000;
    private int minSize = 0x1E00000;
    private List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    private int contextLength = 0;

    public IExportProductSql getiExportProductSql() {
        return this.iExportProductSql;
    }

    public void setiExportProductSql(IExportProductSql iExportProductSql) {
        this.iExportProductSql = iExportProductSql;
    }

    public void setProductUUID(String productUUID) {
        this.productUUID = productUUID;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFileNo(String fileNo) {
        this.fileNo = fileNo;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setDao(AbsModelRepository dao) {
        this.dao = dao;
    }

    public void setSqlPath(String sqlPath) {
        this.sqlPath = sqlPath;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public void run() {
        try {
            this.saveInsertSql(this.emailAddress, this.productUUID, this.date, this.fileNo, this.flag, this.url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private OutputStream genarateSqlFile(OutputStream lastOutputStream, boolean end, String fileNamePrefix, String newFilePath, String writeContext) {
        this.contextLength += writeContext.getBytes().length;
        if (!StrUtil.isNull((Object)writeContext)) {
            if (lastOutputStream != null) {
                try {
                    lastOutputStream.write(writeContext.getBytes());
                    if (this.contextLength > this.MaxSize) {
                        this.contextLength = 0;
                        lastOutputStream.flush();
                        lastOutputStream.close();
                        return null;
                    }
                    return lastOutputStream;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String fileName = "";
                try {
                    fileName = fileNamePrefix + UniqueSeq.shortUUID() + ".txt";
                    File file = new File(newFilePath + fileName);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream outs = new FileOutputStream(file);
                    ((OutputStream)outs).write(writeContext.getBytes());
                    this.fileInfos.add(new FileInfo(writeContext.getBytes().length, fileName, newFilePath));
                    if (this.contextLength < this.MaxSize) {
                        return outs;
                    }
                    this.contextLength = 0;
                    outs.flush();
                    ((OutputStream)outs).close();
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return lastOutputStream;
    }

    public String getInsertSqlAndWriteIntoFile(String fileNamePrefix, String newFilePath, String product_uuid, Sip_Products product, boolean genFlag) {
        StringBuilder insertSql = new StringBuilder();
        try {
            if (!genFlag) {
                this.fileInfos = this.iExportProductSql.exportProductSql(product_uuid, fileNamePrefix, newFilePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u751f\u6210sql\u811a\u672c\u65f6\u51fa\u9519\u5566!");
        }
        String zipName = fileNamePrefix + ".zip";
        String zipPath = newFilePath;
        this.zipFile(zipPath + zipName);
        return zipName;
    }

    public void zipFile(String zipNamePath) {
        List<FileInfo> fileInfo = this.fileInfos;
        File[] temp = new File[fileInfo.size()];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = new File(fileInfo.get(i).getFilePath() + fileInfo.get(i).getFileName());
        }
        File zip = new File(zipNamePath);
        ZipUtil.zip(temp, zip);
    }

    public Return saveInsertSql(String email_address, String product_uuid, Date date, String file_no, boolean exportflag, String url) throws Exception {
        Return r = new Return();
        StringBuilder insertSql = new StringBuilder();
        String product_name = "";
        Sip_Products sip_products = new Sip_Products();
        insertSql.append("/*\u4ea7\u54c1\u8868--sip_products*/ \r\n ");
        sip_products.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)product_uuid);
        sip_products = (Sip_Products)this.dao.findOne((AbsModel)sip_products);
        product_name = sip_products.getProductName();
        String path = this.getSaveFilePath(date, exportflag);
        Ulog.info((String)("\u4fdd\u5b58\u6587\u4ef6\u8def\u5f84\uff1a" + path));
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (exportflag) {
            SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
            date = DateUtil.string2Date((Object)aDate.format(new Date()));
        }
        String time = date.toString().substring(date.toString().indexOf(" ") + 1);
        time = time.replace(":", "-");
        time = time.substring(0, time.indexOf("."));
        String fileNamePrefix = "";
        fileNamePrefix = exportflag ? sip_products.getProductName() + "_" + time : sip_products.getProductUuid() + "_" + time;
        Ulog.info((String)("\u6587\u4ef6\u751f\u6210\u5904\u7406\u5f00\u59cb.\u751f\u6210\u6587\u4ef6\uff1a" + file.getAbsolutePath()));
        if (exportflag) {
            file_no = sip_products.getProductUuid() + "_" + time;
            this.exportConfigFile(fileNamePrefix, product_uuid, sip_products, url, fileNamePrefix, insertSql.toString(), path, product_name, email_address, file_no, file);
        } else {
            this.saveSqlConfigFile(fileNamePrefix, product_uuid, sip_products, fileNamePrefix, file, insertSql.toString(), path, product_name);
        }
        Ulog.info((String)("\u6587\u4ef6\u751f\u6210\u5904\u7406\u7ed3\u675f.\u751f\u6210\u6587\u4ef6\uff1a" + file.getAbsolutePath() + File.separator + fileNamePrefix + ".zip"));
        r.getDataTable().put("filePath", path);
        r.getDataTable().put("insertSql", insertSql);
        return r;
    }

    private void saveSys_File_Repostry(String file_no, String fileName, String path, File file) {
        Sys_File_Repostry sysFile = new Sys_File_Repostry();
        sysFile.setFileNo(file_no);
        sysFile.setFileName(fileName);
        sysFile.setNewFileName(fileName);
        sysFile.setFileType("zip");
        sysFile.setFileSuffix("zip");
        sysFile.setFilePath(path);
        sysFile.setFileSize(StrUtil.trimStr((Object)file.length()));
        sysFile.setUploadDate(DateUtil.sysDate());
        try {
            this.dao.save((AbsModel)sysFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u751f\u6210\u811a\u672c\u4fdd\u5b58\u5230Sys_File_Repostry \u5931\u8d25");
        }
    }

    private String getSaveFilePath(Date date, boolean exportflag) {
        if (exportflag) {
            date = new Date();
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        String dealDate = sdfDate.format(date);
        String[] d = dealDate.substring(0, 10).split("-");
        String path = "";
        path = this.sqlPath + File.separator;
        for (int i = 0; i < d.length; ++i) {
            path = path + d[i] + File.separator;
        }
        if (exportflag && (path = PathFactory.getProperty() + path).contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }

    private void exportConfigFile(String fileNamePrefix, String productUUID, Sip_Products sip_products, String url, String file_name, String insertSql, String newFilePath, String product_name, String email_address, String file_no, File file) {
        try {
            file_name = this.genNewFileAndWriteContext(fileNamePrefix, newFilePath, insertSql, productUUID, sip_products);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (newFilePath.contains(PathFactory.getProperty())) {
            newFilePath = newFilePath.replace(PathFactory.getProperty(), "/");
        }
        this.saveSys_File_Repostry(file_no, file_name, newFilePath + file_name, file);
        Ulog.info((String)"\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6");
        this.sendEmail(product_name, email_address, file_no, url);
    }

    private void saveSqlConfigFile(String fileNamePrefix, String productUUID, Sip_Products sip_products, String file_name, File file, String insertSql, String newFilePath, String file_no) {
        try {
            file_name = this.genNewFileAndWriteContext(fileNamePrefix, newFilePath, insertSql, productUUID, sip_products);
            this.saveSys_File_Repostry(file_no, file_name, newFilePath + file_name, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String genNewFileAndWriteContext(String fileNamePrefix, String newFilePath, String insertSql, String product_uuid, Sip_Products product) throws IOException {
        return this.getInsertSqlAndWriteIntoFile(fileNamePrefix, newFilePath, product_uuid, product, false);
    }

    public void sendEmail(String product_name, String emailAddress, String fileNo, String url) {
        url = url + "/doFileDownload.do?file_no=" + fileNo;
        Mail mail = new Mail();
        mail.setSubject(new String("\u4ea7\u54c1\u5de5\u5382\u4ea7\u54c1\u5bfc\u51fa\u914d\u7f6e\u4e0b\u8f7d\u4fe1\u606f"));
        mail.setText(this.getHtmlString(product_name, url), true);
        mail.addTo(emailAddress);
        mail.send();
    }

    private String getHtmlString(String product_name, String url) {
        String str = "<html><body><h2>\u60a8\u597d\uff1a</h2> <p>" + product_name + "\u914d\u7f6e\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740(\u8bf7\u4f7f\u7528\u548c\u9879\u76ee\u6240\u5728\u7684\u6e38\u89c8\u5668\u6253\u5f00\u94fe\u63a5)\uff1a<a href=\"" + url + "\">" + url + "</a></p></body></html>";
        return str;
    }

    private String getRiskInformation(String node_no, List<Dsn_Structure> structure_ruleList) {
        String insertSql = "";
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)node_no);
        List dsnList = this.dao.findAll((AbsModel)dsn);
        for (Dsn_Structure dsn1 : dsnList) {
            if ("rule".equals(dsn1.getNodeType())) {
                structure_ruleList.add(dsn1);
            }
            SqlMapper structure_mapper = SqlUtil.getInsertSql((AbsModel)dsn1);
            dsn1.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)dsn1.getSerno());
            String del_structure = SqlUtil.getDeleteSql((AbsModel)dsn1).getPrintSql();
            insertSql = insertSql + del_structure;
            insertSql = insertSql + "; \r\n ";
            String insert_structure = structure_mapper.getPrintSql();
            insertSql = insertSql + insert_structure;
            insertSql = insertSql + "; \r\n ";
            insertSql = insertSql + this.getRiskInformation(dsn1.getNodeNo(), structure_ruleList);
        }
        return insertSql;
    }

    private String getRiskInformation2(Dsn_Structure dsn, List<Dsn_Structure> structure_ruleList) {
        StringBuffer insertSqlBuffer = new StringBuffer();
        Stack<Dsn_Structure> nodeStack = new Stack<Dsn_Structure>();
        nodeStack.add(dsn);
        Dsn_Structure tempDsn = null;
        while (!nodeStack.isEmpty()) {
            List<Dsn_Structure> children;
            tempDsn = (Dsn_Structure)((Object)nodeStack.pop());
            String insertSql = this.getDsnSql(tempDsn);
            insertSqlBuffer.append(insertSql);
            if ("rule".equals(tempDsn.getNodeType())) {
                structure_ruleList.add(tempDsn);
            }
            if ((children = this.getChildren(tempDsn.getNodeNo())) == null || children.isEmpty()) continue;
            for (Dsn_Structure child : children) {
                nodeStack.push(child);
            }
        }
        return insertSqlBuffer.toString();
    }

    private List<Dsn_Structure> getChildren(String nodeNO) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNO);
        List dsnList = this.dao.findAll((AbsModel)dsn);
        return dsnList;
    }

    private String getDsnSql(Dsn_Structure dsn1) {
        String insertSql = "";
        SqlMapper structure_mapper = SqlUtil.getInsertSql((AbsModel)dsn1);
        dsn1.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)dsn1.getSerno());
        String del_structure = SqlUtil.getDeleteSql((AbsModel)dsn1).getPrintSql();
        insertSql = insertSql + del_structure;
        insertSql = insertSql + "; \r\n ";
        String insert_structure = structure_mapper.getPrintSql();
        insertSql = insertSql + insert_structure;
        insertSql = insertSql + "; \r\n ";
        return insertSql;
    }
}

