/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.dao;

import com.newtouch.dao.DBHandleable;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.jdbc.util.MapRowMapperImp;
import com.newtouch.dao.pojo.DBTypes;
import com.newtouch.log.Ulog;
import com.newtouch.repository.util.SqlUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public abstract class AbsHandle
implements DBHandleable {
    protected JdbcTemplate jTemplate;
    private DBTypes dbType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> query(QuerySqlable querySQL) {
        long start = System.currentTimeMillis();
        Map resultSetTable = null;
        MapRowMapperImp mapRowMapper = new MapRowMapperImp(querySQL);
        List list = null;
        try {
            list = this.getJdbcTemplate().query(querySQL.getSql(), querySQL.getParam().toArray(), (RowMapper)mapRowMapper);
            SqlUtil.annalLog((String)(list == null ? "-1" : list.size() + ""), (long)start, (Object)list, (String)"\u67e5\u8be2", () -> querySQL.getPrintSql());
        }
        catch (Throwable throwable) {
            SqlUtil.annalLog((String)(list == null ? "-1" : list.size() + ""), (long)start, (Object)list, (String)"\u67e5\u8be2", () -> querySQL.getPrintSql());
            throw throwable;
        }
        resultSetTable = !list.isEmpty() ? (Map)list.get(0) : new HashMap();
        querySQL.clearParam();
        return resultSetTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(UpdateSqlable updateSQL) {
        long startTime = System.currentTimeMillis();
        int result = -1;
        try {
            result = this.getJdbcTemplate().update(updateSQL.getSql(), updateSQL.getParamList());
        }
        finally {
            SqlUtil.annalLog((String)(result + ""), (long)startTime, null, (String)"\u66f4\u65b0", () -> updateSQL.getPrintSql());
        }
        updateSQL.clearParam();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBatch(UpdateSqlable updateSQL, List<Object[]> paramList) {
        long startTime = System.currentTimeMillis();
        updateSQL.setDBType(this.dbType);
        int[] result = new int[]{};
        try {
            result = this.getJdbcTemplate().batchUpdate(updateSQL.getSql(), paramList);
        }
        finally {
            SqlUtil.annalLog((String)(result.length + ""), (long)startTime, null, (String)"\u66f4\u65b0", () -> updateSQL.getPrintSql());
        }
        updateSQL.clearParam();
        return result.length;
    }

    public Connection getConnection() {
        try {
            Connection conn = this.getJdbcTemplate().getDataSource().getConnection();
            Ulog.warn((String)("\u521b\u5efa\u8fde\u63a5[" + conn.hashCode() + "]"));
            return conn;
        }
        catch (SQLException e) {
            Ulog.error((Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startTransaction() {
        Ulog.debug((String)"\u561b\u4e5f\u6ca1\u6267\u884c\uff0c\u54b1\u7528Spring\u63a7\u4e8b\u52a1\u3002");
    }

    public void commitTransaction() {
        Ulog.debug((String)"\u561b\u4e5f\u6ca1\u6267\u884c\uff0c\u54b1\u7528Spring\u63a7\u4e8b\u52a1\u3002");
    }

    public void rollbackTransaction() {
        Ulog.debug((String)"\u561b\u4e5f\u6ca1\u6267\u884c\uff0c\u54b1\u7528Spring\u63a7\u4e8b\u52a1\u3002");
    }

    public DBTypes getDBType() {
        return this.dbType;
    }

    public void setDBType(DBTypes dbType) {
        this.dbType = dbType;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jTemplate = jdbcTemplate;
    }
}

