/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.dao;

import com.newtouch.context.ThreadLocalContext;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.DBHandleable;
import com.newtouch.dao.IDao;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.dao.Sqlable;
import com.newtouch.dao.UpdateSqlable;
import com.newtouch.dao.callback.FieldCallback;
import com.newtouch.dao.callback.RowCallback;
import com.newtouch.dao.pojo.DaoWhere;
import com.newtouch.dao.util.callback.Field2RowCallback;
import com.newtouch.log.Ulog;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbsDao
implements IDao {
    private String dataSource = "";
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, DaoWhere> whereMap = new HashMap<String, DaoWhere>();
    private Map<String, String> as = new HashMap<String, String>();
    private List<DaoWhere> betweenList = new ArrayList<DaoWhere>();
    private Set<String> distinct = new HashSet<String>();
    private boolean checkBaseClm = true;
    private boolean clsParam = true;
    private String order = "";
    private List<RowCallback<Map<String, Object>>> rowCallback = new ArrayList<RowCallback<Map<String, Object>>>();
    private Map<String, List<FieldCallback<Map<String, Object>>>> fieldCbMap = new HashMap<String, List<FieldCallback<Map<String, Object>>>>();
    private String group = "";
    private String by = "";
    private String having = "";
    private boolean isSetPageCount = true;
    private static final String FIELD = "*";

    public String insert(Map<String, Object> param) {
        return this.insert(param, false);
    }

    public String insert(Map<String, Object> param, boolean autoQuery) {
        UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder clm = new StringBuilder();
        StringBuilder value = new StringBuilder();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (this.serno().equals(entry.getKey())) {
                map.put(this.serno(), StrUtil.trimStr((Object)entry.getValue()));
            }
            if (!this.isInstContinue(entry.getKey()) || StrUtil.isNull((Object)entry.getValue())) continue;
            clm.append(entry.getKey()).append(", ");
            value.append("?, ");
            update.add(entry.getValue());
        }
        Map<String, String> instMap = this.joinInstBaseClm(clm, value, update, map);
        String sql = StrUtil.append((String[])new String[]{"INSERT /*", this.callMethod(), "*/ INTO ", this.getTableName(), " (", instMap.get("clm"), ") VALUES(", instMap.get("value"), ")"}).toString();
        update.setSql(sql);
        this.dbHandle().update(update);
        if (autoQuery) {
            this.addEq(this.serno(), StrUtil.trimStr(map.get(this.serno())));
            this.query();
        }
        this.clearParam();
        return (String)map.get(this.serno());
    }

    public void insert(List<Map<String, Object>> paramList) {
        if (paramList == null || paramList.isEmpty()) {
            return;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        Map<String, Object> param = paramList.get(0);
        StringBuilder clm = new StringBuilder();
        StringBuilder value = new StringBuilder();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            if (!this.getClmList().contains(entry.getKey())) continue;
            clm.append(entry.getKey()).append(", ");
            value.append("?, ");
            keyList.add(entry.getKey());
        }
        clm.append(this.getBaseClm4Str());
        value.append("?, ?, ?, ?, ?, ?");
        String sql = StrUtil.append((String[])new String[]{"INSERT /*", this.callMethod(), "*/ INTO ", this.getTableName(), " (", clm.toString(), ") VALUES(", value.toString(), ")"}).toString();
        ArrayList<Object[]> paramArray = new ArrayList<Object[]>();
        for (Map<String, Object> map : paramList) {
            Object[] paraObject = new Object[keyList.size() + 6];
            paramArray.add(paraObject);
            int i = 0;
            for (String arrayKey : keyList) {
                paraObject[i] = map.get(arrayKey);
                ++i;
            }
            if (this.checkBaseClm) {
                paraObject[i + 0] = UniqueSeq.shortUUID();
                paraObject[i + 1] = DateUtil.sysTimestamp();
                paraObject[i + 2] = DateUtil.sysTimestamp();
                paraObject[i + 3] = ThreadLocalContext.get().getUser().getId();
                paraObject[i + 4] = ThreadLocalContext.get().getUser().getId();
                paraObject[i + 5] = "1";
                continue;
            }
            paraObject[i + 0] = map.get(this.serno());
            paraObject[i + 1] = map.get(this.crt_date());
            paraObject[i + 2] = map.get(this.mdf_date());
            paraObject[i + 3] = map.get(this.crt_user());
            paraObject[i + 4] = map.get(this.mdf_user());
            paraObject[i + 5] = map.get(this.data_flag());
        }
        UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
        update.setSql(sql);
        this.dbHandle().updateBatch(update, paramArray);
        this.clearParam();
    }

    public int update(String serno, Map<String, Object> set) {
        this.addEq(this.serno(), serno);
        return this.update(set);
    }

    public int update(Map<String, Object> set) {
        if (this.whereMap.isEmpty() && this.betweenList.isEmpty()) {
            throw new RuntimeException("update\u8bed\u53e5\u672a\u8bbe\u7f6ewhere\u6761\u4ef6!");
        }
        UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
        StringBuilder setClm = new StringBuilder(this.mdf_date()).append(" = ?, ").append(this.mdf_user()).append(" = ? ");
        update.add((Object)DateUtil.sysTimestamp());
        update.add((Object)ThreadLocalContext.get().getUser().getId());
        boolean cache = this.checkBaseClm;
        this.setCheckBaseClm(true);
        for (Map.Entry<String, Object> entry : set.entrySet()) {
            if (!this.isInstContinue(entry.getKey()) || entry.getKey().equals(this.serno())) continue;
            setClm.append(", ").append(entry.getKey()).append(" = ?");
            if (StrUtil.isNull((Object)entry.getValue())) {
                update.add(null);
                continue;
            }
            update.add(entry.getValue());
        }
        this.setCheckBaseClm(cache);
        String whereClm = this.joinWhere((Sqlable)update);
        String sql = StrUtil.append((String[])new String[]{"UPDATE /*", this.callMethod(), "*/ ", this.getTableName(), " SET ", setClm.toString(), " ", whereClm}).toString();
        update.setSql(sql);
        this.clearParam();
        return this.dbHandle().update(update);
    }

    public int delete(String serno) {
        this.addEq(this.serno(), serno);
        return this.delete();
    }

    public int delete() {
        if (this.whereMap.isEmpty() && this.betweenList.isEmpty()) {
            throw new RuntimeException("delete\u8bed\u53e5\u672a\u8bbe\u7f6ewhere\u6761\u4ef6!");
        }
        UpdateSqlable update = DBHandleCreator.getInstance().getUpdateSql();
        String whereClm = this.joinWhere((Sqlable)update);
        String sql = StrUtil.append((String[])new String[]{"DELETE /*", this.callMethod(), "*/ FROM ", this.getTableName(), " ", whereClm}).toString();
        update.setSql(sql);
        this.clearParam();
        return this.dbHandle().update(update);
    }

    public int deleteFlag(String serno) {
        this.addEq(this.serno(), serno);
        return this.deleteFlag();
    }

    public int deleteFlag() {
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put(this.data_flag(), "0");
        return this.update(set);
    }

    public Map<String, Object> query() {
        Map map = this.dbHandle().query(this.joinQuerySql(true));
        this.data.clear();
        this.data.putAll(map);
        return map;
    }

    public List<Map<String, Object>> queryList() {
        return this.queryList(true);
    }

    public List<Map<String, Object>> queryList(boolean isPaginate) {
        return this.dbHandle().queryList(this.joinQuerySql(isPaginate));
    }

    public boolean equalsData(String serno, Map<String, Object> data) {
        this.addEq(this.serno(), serno);
        return this.equalsData(data);
    }

    public boolean equalsData(Map<String, Object> data) {
        Map<String, Object> map = this.query();
        if (map.isEmpty()) {
            return false;
        }
        boolean isSame = true;
        for (String key : this.getClmList()) {
            if (!isSame) break;
            if (map.get(key).equals(data.get(key))) {
                isSame = isSame;
                continue;
            }
            if (isSame) {
                // empty if block
            }
            isSame = false;
        }
        return isSame;
    }

    public Map<String, Object> getData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.data);
        return map;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    private boolean isInstContinue(String clmName) {
        if (this.getClmList().contains(clmName)) {
            return true;
        }
        if (this.getBaseClm().contains(clmName)) {
            if (clmName.equals(this.serno()) || clmName.equals(this.data_flag())) {
                return true;
            }
            return !this.checkBaseClm;
        }
        return false;
    }

    private boolean isContinue(String clmName) {
        if (this.getClmList().contains(clmName)) {
            return true;
        }
        return this.getBaseClm().contains(clmName);
    }

    private QuerySqlable joinQuerySql(boolean isPaginate) {
        String field = this.joinField();
        String sql = StrUtil.append((String[])new String[]{"SELECT /*", this.callMethod(), "*/ ", field, " FROM ", this.getTableName()}).toString();
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        query.setIsPageCount(this.isSetPageCount);
        for (Map.Entry<String, List<FieldCallback<Map<String, Object>>>> entry : this.fieldCbMap.entrySet()) {
            for (FieldCallback<Map<String, Object>> callback : entry.getValue()) {
                query.addFieldCallback(entry.getKey(), callback);
            }
        }
        for (RowCallback rowCallback : this.rowCallback) {
            query.addRowCallback(rowCallback);
        }
        query.setPaginate(isPaginate);
        query.setLocalOrder(true);
        StringBuilder where = new StringBuilder(this.joinWhere((Sqlable)query));
        if (!StrUtil.isNull((Object)this.by)) {
            StrUtil.append((StringBuilder)where, (String[])new String[]{" GROUP BY ", this.by});
        }
        if (!StrUtil.isNull((Object)this.having)) {
            StrUtil.append((StringBuilder)where, (String[])new String[]{" HAVING ", this.having});
        }
        try {
            query.setSql(sql + where);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!StrUtil.isNull((Object)this.order)) {
            query.setLocalOrder(true);
            query.setOrderBy(this.order);
        }
        this.clearParam();
        return query;
    }

    private String joinField() {
        if (this.as.isEmpty() && this.distinct.isEmpty() && StrUtil.isNull((Object)this.group)) {
            return FIELD;
        }
        StringBuilder field = new StringBuilder();
        if (!this.as.isEmpty() && this.distinct.isEmpty()) {
            ArrayList<String> allField = new ArrayList<String>();
            allField.addAll(this.getBaseClm());
            allField.addAll(this.getClmList());
            for (String key : this.as.keySet()) {
                allField.remove(key);
                StrUtil.append((StringBuilder)field, (String[])new String[]{key, " as '", this.as.get(key), "', "});
            }
            for (String key : allField) {
                StrUtil.append((StringBuilder)field, (String[])new String[]{key, ", "});
            }
            return field.substring(0, field.length() - 2);
        }
        if (!StrUtil.isNull((Object)this.group)) {
            if (!StrUtil.isNull((Object)this.by)) {
                StrUtil.append((StringBuilder)field, (String[])new String[]{this.by, ", ", this.group});
            } else {
                field.append(this.group);
            }
            return field.toString();
        }
        if (!this.distinct.isEmpty()) {
            field = new StringBuilder("DISTINCT ");
            for (String aField : this.distinct) {
                String as = "";
                if (!StrUtil.isNull((Object)this.as.get(aField))) {
                    as = " as '" + this.as.get(aField) + "'";
                }
                StrUtil.append((StringBuilder)field, (String[])new String[]{aField, as, ", "});
            }
            return field.substring(0, field.length() - 2);
        }
        return field.toString();
    }

    private String joinWhere(Sqlable query) {
        String subSql = "";
        StringBuilder whereClm = new StringBuilder();
        for (String key : this.whereMap.keySet()) {
            if (!this.isContinue(key)) continue;
            subSql = this.whereMap.get(key).joinSql(query);
            this.appendSql(whereClm, subSql);
        }
        for (DaoWhere dWhere : this.betweenList) {
            subSql = dWhere.joinSql(query);
            this.appendSql(whereClm, subSql);
        }
        return whereClm.toString();
    }

    private void appendSql(StringBuilder where, String subSql) {
        if (StrUtil.isNull((Object)subSql)) {
            return;
        }
        if (StrUtil.isNull((Object)where)) {
            StrUtil.append((StringBuilder)where, (String[])new String[]{" WHERE ", subSql});
            return;
        }
        StrUtil.append((StringBuilder)where, (String[])new String[]{" AND ", subSql});
    }

    public void addEq(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("=");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addEq(Map<String, Object> map) {
        for (String key : map.keySet()) {
            this.addEq(key, map.get(key));
        }
    }

    public void addNotEq(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("!=");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addIn(String field, List<Object> value) {
        if (!this.isContinue(field)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("IN");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addIn(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        DaoWhere where = this.whereMap.get(field);
        if (where == null) {
            where = DaoWhere.getInstance();
            where.setConFlag("IN");
            where.setField1(field);
            where.setValue(new ArrayList());
            this.whereMap.put(field, where);
        }
        List list = (List)where.getValue();
        if (value instanceof List) {
            list.addAll((List)value);
        } else {
            list.add(value);
        }
    }

    public void addNotIn(String field, List<Object> value) {
        if (!this.isContinue(field)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("NOTIN");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addNotIn(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        DaoWhere where = this.whereMap.get(field);
        if (where == null) {
            where = DaoWhere.getInstance();
            where.setConFlag("NOTIN");
            where.setField1(field);
            where.setValue(new ArrayList());
        }
        List list = (List)where.getValue();
        list.add(value);
    }

    public void addLike(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("%Like%");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addLikeR(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("%Like");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addLikeL(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("Like%");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addNotLike(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("%NOTLIKE%");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addNotLikeR(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("NOTLIKE%");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addNotLikeL(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("%NOTLIKE");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addBetween(Object value, String field1, String field2) {
        if (!this.isContinue(field1) || !this.isContinue(field2)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("BETWEEN");
        where.setField1(field1);
        where.setField2(field2);
        where.setValue(value);
        this.betweenList.add(where);
    }

    public void addBetween(String field, Object value1, Object value2) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value1) || StrUtil.isNull((Object)value2)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("BETWEEN");
        where.setField1(field);
        where.setValue(value1);
        where.setValue2(value2);
        this.betweenList.add(where);
    }

    public void addLT(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("<");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addGT(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag(">");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addLTEq(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag("<=");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addGTEq(String field, Object value) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)value)) {
            return;
        }
        DaoWhere where = DaoWhere.getInstance();
        where.setConFlag(">=");
        where.setField1(field);
        where.setValue(value);
        this.whereMap.put(field, where);
    }

    public void addAs(String field, String as) {
        if (!this.isContinue(field)) {
            return;
        }
        if (StrUtil.isNull((Object)as)) {
            return;
        }
        this.as.put(field, as);
    }

    public void addGroupBy(String group) {
        this.addGroupBy(group, "", "");
    }

    public void addGroupBy(String group, String by) {
        this.addGroupBy(group, by, "");
    }

    public void addGroupBy(String group, String by, String having) {
        String field = group.substring(group.indexOf("(") + 1, group.indexOf(")"));
        if (FIELD.equals(field)) {
            this.group = group;
        }
        if (this.isContinue(StrUtil.trimStr((Object)field))) {
            this.group = group + " AS " + group.substring(0, group.indexOf("(")) + "_" + field;
        }
        for (String aField : by.split(",")) {
            if (!this.isContinue(StrUtil.trimStr((Object)aField))) continue;
            this.by = this.by + aField + ",";
        }
        if (!StrUtil.isNull((Object)this.by)) {
            this.by = this.by.substring(0, this.by.length() - 1);
        }
        if (!StrUtil.isNull((Object)this.group) && !StrUtil.isNull((Object)having)) {
            this.having = group + having;
        }
    }

    public void addRowCallback(RowCallback<Map<String, Object>> row) {
        this.rowCallback.add(row);
    }

    public void addFieldCallback(String field, FieldCallback<Map<String, Object>> callback) {
        if (!this.isContinue(field = field.toLowerCase())) {
            return;
        }
        this.rowCallback.add((RowCallback<Map<String, Object>>)new Field2RowCallback(field, callback));
    }

    public void addDistinct(String field) {
        if (this.isContinue(StrUtil.trimStr((Object)field))) {
            this.distinct.add(field);
        }
    }

    public void clearParam() {
        if (!this.clsParam) {
            return;
        }
        this.whereMap.clear();
        this.betweenList.clear();
        this.as.clear();
        this.order = "";
        this.group = "";
        this.by = "";
        this.having = "";
        this.setCheckBaseClm(true);
        this.fieldCbMap.clear();
        this.rowCallback.clear();
    }

    public boolean hasWhere() {
        return !this.whereMap.isEmpty();
    }

    public boolean isClsParam() {
        return this.clsParam;
    }

    public void setClsParam(boolean clsParam) {
        this.clsParam = clsParam;
    }

    public boolean isCheckBaseClm() {
        return this.checkBaseClm;
    }

    public void setCheckBaseClm(boolean checkBaseClm) {
        this.checkBaseClm = checkBaseClm;
    }

    private Map<String, String> joinInstBaseClm(StringBuilder clm, StringBuilder value, UpdateSqlable update, Map<String, String> serno) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.checkBaseClm) {
            clm.append(this.getBaseClm4Str());
            value.append("?, ?, ?, ?, ?, ?");
            serno.put(this.serno(), UniqueSeq.shortUUID());
            update.add((Object)serno.get(this.serno()));
            update.add((Object)DateUtil.sysTimestamp());
            update.add((Object)DateUtil.sysTimestamp());
            update.add((Object)ThreadLocalContext.get().getUser().getId());
            update.add((Object)ThreadLocalContext.get().getUser().getId());
            update.add((Object)"1");
            map.put("clm", clm.toString());
            map.put("value", value.toString());
            return map;
        }
        for (String aClm : this.getBaseClm()) {
            if (clm.indexOf(aClm) >= 0) continue;
            clm.append(aClm).append(", ");
            value.append("?, ");
            update.add(this.checkBaseClm(aClm));
        }
        String clmString = clm.toString();
        String valueString = value.toString();
        if (clmString.endsWith(", ")) {
            clmString = clmString.substring(0, clmString.length() - 2);
        }
        if (valueString.endsWith(", ")) {
            valueString = valueString.substring(0, valueString.length() - 2);
        }
        map.put("clm", clmString);
        map.put("value", valueString);
        return map;
    }

    private DBHandleable dbHandle() {
        if (ThreadLocalContext.get().getDbHandleable() != null) {
            return ThreadLocalContext.get().getDbHandleable();
        }
        if (!StrUtil.isNull((Object)this.dataSource)) {
            return DBHandleCreator.getInstance().getDBHandle(this.dataSource);
        }
        return DBHandleCreator.getInstance().getDBHandle();
    }

    private Object checkBaseClm(String aClm) {
        if (aClm.equals(this.serno())) {
            return UniqueSeq.shortUUID();
        }
        if (aClm.equals(this.crt_date()) || aClm.equals(this.mdf_date())) {
            return DateUtil.sysDate();
        }
        if (aClm.equals(this.crt_user()) || aClm.equals(this.mdf_user())) {
            return ThreadLocalContext.get().getUser().getId();
        }
        return "1";
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isSetPageCount() {
        return this.isSetPageCount;
    }

    public void setIsPageCount(boolean isSetPageCount) {
        this.isSetPageCount = isSetPageCount;
    }

    public abstract List<String> getClmList();

    public abstract List<String> getBaseClm();

    public abstract String getTableName();

    public abstract String serno();

    public abstract String crt_date();

    public abstract String crt_user();

    public abstract String mdf_date();

    public abstract String mdf_user();

    public abstract String data_flag();

    public abstract String getBaseClm4Str();

    private String callMethod() {
        StackTraceElement[] exception = Thread.currentThread().getStackTrace();
        String className = "";
        String[] classAttr = null;
        for (StackTraceElement ste : exception) {
            className = ste.toString();
            classAttr = (className = className.substring(className.indexOf("(") + 1, className.indexOf(")"))).split("\\.");
            if (Ulog.excludeClass.contains(classAttr[0])) continue;
            return className;
        }
        return className;
    }
}

