/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.util;

import com.newtouch.context.ThreadLocalContext;
import com.newtouch.context.pojo.PageCount;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.web.pojo.RequestParam;
import com.newtouch.web.util.RequestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class ReturnUtil {
    public static final ModelAndView returnPage(HttpServletResponse response, String viewName) {
        Return msg = new Return();
        return ReturnUtil.returnPage(response, msg.msg(), viewName);
    }

    public static final ModelAndView returnPage(HttpServletResponse response, ReturnMsg msg, String viewName) {
        return ReturnUtil.returnPage(response, msg, viewName, false);
    }

    public static final ModelAndView returnPage(HttpServletResponse response, ReturnMsg msg, String viewName, boolean partLog) {
        String jsonStr = "";
        if (msg != null) {
            jsonStr = ReturnUtil.return2Json(msg, partLog);
        } else {
            msg = new Return().msg();
            jsonStr = ReturnUtil.return2Json(msg);
        }
        Ulog.info((String)("\u8df3\u8f6c\u9875\u9762[" + viewName + "]"));
        String rqstType = ThreadLocalContext.get().getRqstType();
        if (StrUtil.isNull((Object)viewName) || "AJAX".equals(rqstType) || "MOBILE".equals(rqstType)) {
            try {
                response.setContentType("application/json;charset=utf-8");
                PrintWriter out = response.getWriter();
                out.print(jsonStr);
                out.flush();
                out.close();
                return null;
            }
            catch (IOException var7) {
                Ulog.error((Throwable)var7);
            }
        }
        return new ModelAndView(viewName, "json", (Object)jsonStr);
    }

    public final Map<String, Object> getRequestMap(HttpServletRequest request) {
        String contentType = StrUtil.trimStr((Object)request.getHeader("content-type"));
        Map<String, Object> paramMap = null;
        paramMap = !StrUtil.isNull((Object)contentType) && contentType.startsWith("application/json") ? this.initDataInputStream(request) : RequestUtil.getRequestValue((Map)request.getParameterMap());
        String json = JsonUtil.toJson((Object)paramMap);
        Ulog.info((String)("\u9875\u9762\u4f20\u5165\u53c2\u6570:" + json));
        this.checkXSS(json);
        return paramMap;
    }

    private void checkXSS(String json) {
        String str = "script";
        boolean status = json.contains(str);
        if (status) {
            throw new BusinessException("\u53c2\u6570\u4e2d\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff01");
        }
    }

    private Map<String, Object> initDataInputStream(HttpServletRequest request) {
        String requestStr = this.getRequestString(request);
        Map requestMap = JsonUtil.json2Map((String)requestStr);
        if (!StrUtil.isNull(requestMap.get("rqstType"))) {
            ThreadLocalContext.get().setRqstType(StrUtil.trimStr(requestMap.get("rqstType")));
        } else {
            ThreadLocalContext.get().setRqstType("AJAX");
        }
        ThreadLocalContext.get().setRqstSource(String.valueOf(requestMap.get("rqstSource")));
        PageCount pageCount = ThreadLocalContext.get().getPageCount();
        pageCount.setOrderBy(StrUtil.trimStr(requestMap.get("order")));
        String row4Page = StrUtil.trimStr(requestMap.get("row4Page"));
        String nowPage = StrUtil.trimStr(requestMap.get("nowPage"));
        if (!StrUtil.isNull((Object)row4Page)) {
            pageCount.setRows4Page(Integer.valueOf(Integer.parseInt(row4Page)));
        }
        if (!StrUtil.isNull((Object)nowPage)) {
            pageCount.setNowPage(Integer.valueOf(Integer.parseInt(nowPage)));
        } else {
            pageCount.setNowPage(Integer.valueOf(1));
        }
        this.initMapDateType(requestMap);
        return requestMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestString(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try {
            Throwable var4 = null;
            try (BufferedReader reader = request.getReader();){
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        builder.append(line);
                    }
                }
                catch (Throwable var14) {
                    var4 = var14;
                    throw var14;
                }
            }
        }
        catch (Exception var16) {
            throw new RuntimeException(var16);
        }
        return builder.toString();
    }

    private void initMapDateType(Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> var2 = map.entrySet().iterator();
        while (var2.hasNext()) {
            Map.Entry<String, Object> entry = var2.next();
            if (entry.getValue() == null) continue;
            if (entry.getKey().toLowerCase().endsWith("date") && !StrUtil.isNull((Object)entry.getValue()) && DateUtil.isValidDate((String)StrUtil.trimStr((Object)entry.getValue()))) {
                map.put(entry.getKey().toString(), DateUtil.string2Date((Object)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof Map) {
                this.initMapDateType((Map)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            this.initListDataType((List)entry.getValue());
        }
        return;
    }

    private void initListDataType(List list) {
        for (Object obj : list) {
            if (obj instanceof List) {
                this.initListDataType((List)obj);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            this.initMapDateType((Map)obj);
        }
    }

    public final String getRequestMap(HttpServletRequest request, String key) {
        Map<String, Object> map = this.getRequestMap(request);
        return StrUtil.trimStr((Object)map.get(key));
    }

    public final <T> T getRequestMap(HttpServletRequest request, Class<T> requiredType) {
        return this.getRequestMap(this.getRequestMap(request), requiredType);
    }

    public final <T> T getRequestMap(Map<String, Object> requestMap, Class<T> requiredType) {
        return (T)JsonUtil.map2Class(requestMap, requiredType);
    }

    public final RequestParam getRequestMap(HttpServletRequest request, Class ... requiredType) {
        return this.getRequestMap(this.getRequestMap(request), requiredType);
    }

    public final RequestParam getRequestMap(Map<String, Object> requestMap, Class ... requiredType) {
        String json = JsonUtil.toJson(requestMap);
        RequestParam param = new RequestParam();
        Class[] var5 = requiredType;
        int var6 = requiredType.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            Class clazz = var5[var7];
            param.addParam(JsonUtil.json2Class((String)json, (Class)clazz));
        }
        return param;
    }

    public final <T> T getJsonParam(String jsonStr, Class<T> requiredType) {
        Ulog.info((String)("\u9875\u9762\u4f20\u5165\u53c2\u6570:" + jsonStr));
        return (T)JsonUtil.json2Class((String)jsonStr, requiredType);
    }

    public final Map<String, Object> getJsonParam(String jsonStr) {
        Ulog.info((String)("\u9875\u9762\u4f20\u5165\u53c2\u6570:" + jsonStr));
        return JsonUtil.json2Map((String)jsonStr);
    }

    public static final String return2Json(ReturnMsg returnMsg) {
        return ReturnUtil.return2Json(returnMsg, false);
    }

    public static final String return2Json(ReturnMsg returnMsg, boolean partLog) {
        if (returnMsg == null) {
            returnMsg = new Return().msg();
        }
        PageCount pageCount = ThreadLocalContext.get().getPageCount();
        HashMap<String, Object> _retMap = new HashMap<String, Object>();
        _retMap.put("data", returnMsg.getDataList());
        if (!returnMsg.getDataTable().isEmpty()) {
            _retMap.put("defmap", returnMsg.getDataTable());
        }
        _retMap.putAll(ReturnUtil.initMsg(returnMsg));
        _retMap.put("recordsTotal", pageCount.getAllRows());
        _retMap.put("recordsFiltered", pageCount.getAllRows());
        if (!StrUtil.isNull((Object)ThreadLocalContext.get().getQueryTerms())) {
            _retMap.put("queryTerms", ThreadLocalContext.get().getQueryTerms());
        }
        String retJson = "";
        try {
            retJson = JsonUtil.toJson(_retMap);
        }
        catch (Exception var6) {
            throw new RuntimeException(var6);
        }
        if (partLog) {
            Ulog.info((String)("\u5171\u67e5\u8be2\u5230[" + pageCount.getAllRows() + "]\u6761\u8bb0\u5f55\uff0c\u8fd4\u56de\u53c2\u6570\uff08\u53c2\u6570\u8fc7\u957f\u5c55\u793a100\u4e2a\u5b57\u7b26\uff09\uff1a" + retJson.substring(0, 100)));
        } else {
            Ulog.info((String)("\u5171\u67e5\u8be2\u5230[" + pageCount.getAllRows() + "]\u6761\u8bb0\u5f55\uff0c\u8fd4\u56de\u53c2\u6570\uff1a" + retJson));
        }
        return retJson;
    }

    private static Map<String, Object> initMsg(ReturnMsg returnMsg) {
        HashMap<String, Object> _retMap = new HashMap<String, Object>();
        if (returnMsg.isSuccessflag()) {
            if (returnMsg.getMsgList().isEmpty()) {
                returnMsg.setSuccessMessage(new Message("", "\u6210\u529f"));
            }
            _retMap.put("flag", "success");
            _retMap.put("msg", ReturnUtil.initMsgArray(returnMsg.getMsgList()));
        }
        if (returnMsg.isWarning()) {
            _retMap.put("flag", "warn");
            _retMap.put("msg", ReturnUtil.initMsgArray(returnMsg.getWarnList()));
        }
        if (!returnMsg.isSuccessflag()) {
            if (returnMsg.getMsgList().isEmpty()) {
                returnMsg.setSuccessMessage(new Message("", "\u6267\u884c\u5931\u8d25"));
            }
            _retMap.put("flag", "fail");
            _retMap.put("msg", ReturnUtil.initMsgArray(returnMsg.getMsgList()));
        }
        if (!returnMsg.getDtildMessage().isEmpty()) {
            Message msg = (Message)returnMsg.getDtildMessage().get(0);
            returnMsg.getDtildMessage().set(0, new Message("", "[" + ThreadLocalContext.get().getThreadUUID() + "]-" + msg.getMsgRemark()));
            _retMap.put("dtildMsg", ReturnUtil.initMsgArray(returnMsg.getDtildMessage()));
        }
        return _retMap;
    }

    private static List<Map<String, Object>> initMsgArray(List<Message> list) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        for (Message msg : list) {
            HashMap<String, String> aMsg = new HashMap<String, String>();
            aMsg.put(msg.getMsgCode(), msg.getMsgRemark());
            msgList.add(aMsg);
        }
        return msgList;
    }
}

