/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.service.impl;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Rules_Const;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Organ_Risk_Relation;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import com.newtouch.chinalife.dao.IProductDao;
import com.newtouch.chinalife.dao.IRiskNewDao;
import com.newtouch.chinalife.dao.IStructureNewService;
import com.newtouch.chinalife.entity.vo.AttributeDetailVo;
import com.newtouch.chinalife.entity.vo.MdfAttrDetailVo;
import com.newtouch.chinalife.service.IRiskService;
import com.newtouch.chinalife.service.IRulesService;
import com.newtouch.chinalife.util.ReturnUtil;
import com.newtouch.config.ProductConfig;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.attribute.service.IAttributeService;
import com.newtouch.design.risk.service.IRiskCopyService;
import com.newtouch.design.tree.service.IPublicTreeService;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import com.newtouch.web.pojo.RequestParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RiskServiceImpl
extends BaseService
implements IRiskService {
    @Autowired
    @Lazy
    private IRiskNewDao riskDao;
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IRulesService rules;
    @Autowired
    private IProductDao product;
    @Autowired
    private IStructureNewService nodeDao;
    @Autowired
    private ProductConfig prdConf;
    private static final List<String> ruleAttr = new ArrayList<String>();
    private String info01 = "\u8bf7\u6c42\u6570\u636e\uff1a||";
    private String info02 = "\u8bf7\u6c42\u8def\u5f84\uff1a";
    private String info03 = "\u54cd\u5e94\u6570\u636e\uff1a[";
    private String errMsg01 = "\u4ea7\u54c1\u914d\u7f6e\u670d\u52a1\u3010module-product-engine\u3011\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002";
    @Autowired
    private IAttributeService attrservice;
    @Autowired
    private IPublicTreeService pubTree;
    @Autowired
    private com.newtouch.design.risk.service.IRiskService riskServiceImp;
    @Autowired
    private IRiskCopyService riskCopyServiceImp;

    public ReturnMsg queryRiskRelation(Map<String, Object> param) {
        List<Map<String, Object>> list = this.riskDao.getOrganPrdUuid((String)param.get("product_uuid"));
        String organRiskUuid = "";
        if (list.isEmpty()) {
            param.put("organ_prd_uuid", "");
        } else {
            organRiskUuid = (String)list.get(0).get("organ_prd_uuid");
        }
        param.put("organ_prd_uuid", organRiskUuid);
        String nodeNo = (String)param.get("risk_uuid");
        Return msg = new Return();
        List<Map<String, Object>> queryRiskDetail = this.riskDao.queryRiskDetail(param, nodeNo, "n_risk_detail");
        Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(queryRiskDetail);
        String mainRisk = this.queryRiskInfoRoot(nodeNo, "n_risk_detail");
        fieldValueApp.put("risk_uuid", mainRisk);
        msg.getDataTable().put("riskDetail", fieldValueApp);
        List<Map<String, Object>> queryAdditionalRisk = this.queryAdditionalRisk(param, "0", null);
        msg.getDataTable().put("additional_risk", queryAdditionalRisk);
        return msg.msg();
    }

    private void dealProductRule(Map<String, Object> product, Map<String, Object> riskDetail, Map<String, Object> riskRule) {
        String init = JsonUtil.toJson((Object)riskRule.get("initRule"));
        Map initMap = JsonUtil.json2Map((String)init);
        String headRule = JsonUtil.toJson(initMap.get("headRuleInfo"));
        String organRule = JsonUtil.toJson(initMap.get("organRuleInfo"));
        List<Map<String, Object>> ruleList = this.switchConst(headRule, product, riskDetail);
        List<Map<String, Object>> rulesList = this.switchConst(organRule, product, riskDetail);
        String insure = JsonUtil.toJson((Object)riskRule.get("insureRule"));
        Map insureMap = JsonUtil.json2Map((String)insure);
        String headRule1 = JsonUtil.toJson(insureMap.get("headRuleInfo"));
        String organRule1 = JsonUtil.toJson(insureMap.get("organRuleInfo"));
        List<Map<String, Object>> ruleList1 = this.switchConst(headRule1, product, riskDetail);
        List<Map<String, Object>> rulesList1 = this.switchConst(organRule1, product, riskDetail);
        String linkage = JsonUtil.toJson((Object)riskRule.get("linkageRule"));
        Map linkageMap = JsonUtil.json2Map((String)linkage);
        String headRule2 = JsonUtil.toJson(linkageMap.get("headRuleInfo"));
        String organRule2 = JsonUtil.toJson(linkageMap.get("organRuleInfo"));
        List<Map<String, Object>> ruleList2 = this.switchConst(headRule2, product, riskDetail);
        List<Map<String, Object>> rulesList2 = this.switchConst(organRule2, product, riskDetail);
        String underwrite = JsonUtil.toJson((Object)riskRule.get("underwriteRule"));
        Map underwriteMap = JsonUtil.json2Map((String)underwrite);
        String headRule3 = JsonUtil.toJson(underwriteMap.get("headRuleInfo"));
        String organRule3 = JsonUtil.toJson(underwriteMap.get("organRuleInfo"));
        List<Map<String, Object>> ruleList3 = this.switchConst(headRule3, product, riskDetail);
        List<Map<String, Object>> rulesList3 = this.switchConst(organRule3, product, riskDetail);
        initMap.put("headRuleInfo", ruleList);
        insureMap.put("headRuleInfo", ruleList1);
        underwriteMap.put("headRuleInfo", ruleList3);
        linkageMap.put("headRuleInfo", ruleList2);
        initMap.put("organRuleInfo", rulesList);
        insureMap.put("organRuleInfo", rulesList1);
        linkageMap.put("organRuleInfo", rulesList2);
        underwriteMap.put("organRuleInfo", rulesList3);
        riskRule.put("linkageRule", linkageMap);
        riskRule.put("initRule", initMap);
        riskRule.put("insureRule", insureMap);
        riskRule.put("underwriteRule", underwriteMap);
    }

    private List<Map<String, Object>> switchConst(String rule, Map<String, Object> product, Map<String, Object> riskDetail) {
        List ruleList2 = JsonUtil.json2List((String)rule);
        for (Map ruleMap : ruleList2) {
            String ruleNo = (String)ruleMap.get("rule_no");
            if (!this.getIsConst(ruleNo)) continue;
            this.switchRule(product, riskDetail, ruleMap);
        }
        return ruleList2;
    }

    private boolean getIsConst(String ruleNo) {
        boolean flag = false;
        Dsn_Rules_Const dsnRuleConst = new Dsn_Rules_Const();
        dsnRuleConst.where().addEq((ModelField)Dsn_Rules_Const.Field.rule_no, (Object)ruleNo);
        List findRuleInfo = this.dao.findAll((AbsModel)dsnRuleConst);
        if (!findRuleInfo.isEmpty()) {
            flag = true;
        }
        return flag;
    }

    private void switchRule(Map<String, Object> product, Map<String, Object> riskDetail, Map<String, Object> rule) {
        String ruleInfo = (String)rule.get("rule_info");
        String ruleNo = (String)rule.get("rule_no");
        Dsn_Rules_Const dsnRuleConst = new Dsn_Rules_Const();
        dsnRuleConst.where().addEq((ModelField)Dsn_Rules_Const.Field.rule_no, (Object)ruleNo);
        List findRuleInfo = this.dao.findAll((AbsModel)dsnRuleConst);
        for (Dsn_Rules_Const factInfo : findRuleInfo) {
            String fact = factInfo.getConstNo();
            String[] factSplit = fact.split("\\.");
            String key = factSplit[1];
            String value = factSplit[2];
            boolean isNumber = false;
            ruleInfo = this.getRuleInfo(product, riskDetail, ruleInfo, fact, key, value, isNumber);
            rule.put("rule_info", ruleInfo);
        }
    }

    private String getRuleInfo(Map<String, Object> product, Map<String, Object> riskDetail, String ruleInfo, String fact, String key, String value, boolean isNumber) {
        String data = null;
        if ("prd_details".equals(key)) {
            String valueIndex = StrUtil.trimStr((Object)product.get(value));
            try {
                Double.parseDouble(valueIndex);
                isNumber = true;
            }
            catch (Exception e) {
                Ulog.info((String)"\u5e38\u91cf\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b");
            }
            data = valueIndex;
        } else {
            String valueIndex = StrUtil.trimStr((Object)riskDetail.get(value));
            try {
                Double.parseDouble(valueIndex);
                isNumber = true;
            }
            catch (Exception e) {
                Ulog.info((String)"\u5e38\u91cf\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b");
            }
            data = valueIndex;
        }
        ruleInfo = isNumber ? (ruleAttr.contains(value) ? ruleInfo.replace(fact, data.toString()) : ruleInfo.replaceAll(JsonUtil.toJson((Object)fact), data.toString())) : ruleInfo.replace(fact, "'" + data.toString() + "'");
        return ruleInfo;
    }

    public List<String> mainRiskDetail(String productUUid, List<Map<String, Object>> riskList, Dsn_Structure templateRiskRootNode, Dsn_Structure riskParentNode, String riskType, String parentRiskUuid) {
        ArrayList<String> riskNewUuidList = new ArrayList<String>();
        riskList.stream().forEach(mainRiskMap -> {
            Dsn_Structure mainRiskNode = this.copyRiskTemp((Map<String, Object>)mainRiskMap, productUUid, templateRiskRootNode, riskType, riskParentNode, parentRiskUuid);
            if ("M".equals(riskType) || "A".equals(riskType)) {
                String riskUuid = this.riskDao.getRiskUuidByNode(mainRiskNode);
                riskNewUuidList.add(riskUuid);
                String mainRiskNodeNo = mainRiskNode.getNodeNo();
                Dsn_Structure addRiskListNode = this.nodeDao.getSubNodeByNodeType(mainRiskNodeNo, "n_accy_risks");
                this.riskDeal(productUUid, this.prdConf.getAdd_risk_no(), "A", (Map<String, Object>)mainRiskMap, addRiskListNode, riskUuid);
                Dsn_Structure waireRiskListNode = this.nodeDao.getSubNodeByNodeType(mainRiskNodeNo, "main_exempt");
                this.riskDeal(productUUid, this.prdConf.getWaire_risk_no(), "W", (Map<String, Object>)mainRiskMap, waireRiskListNode, riskUuid);
                Dsn_Structure subRiskListNode = this.nodeDao.getSubNodeByNodeType(mainRiskNodeNo, "n_sub_risks");
                this.riskDeal(productUUid, this.prdConf.getSub_risk_no(), "S", (Map<String, Object>)mainRiskMap, subRiskListNode, riskUuid);
            }
        });
        return riskNewUuidList;
    }

    @Override
    public List<String> riskDeal(String productUUID, String templateRiskNo, String riskType, Map<String, Object> upRiskReqMap, Dsn_Structure riskParentNode, String parentRiskUuid) {
        String templateRiskUUID = this.riskDao.getRiskUUIDByRiskNo(templateRiskNo);
        if (StrUtil.isNull((Object)templateRiskUUID)) {
            throw new BusinessException(new Message("2016010", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u6a21\u677f\u7684risk_no\u3002"));
        }
        Dsn_Structure templateRiskNode = this.riskDao.getRiskNodeNoByRiskUUID(templateRiskUUID);
        String reqKey = this.getReqKeyByriskType(riskType);
        if (StrUtil.isNull((Object)reqKey)) {
            throw new BusinessException("riskDeal\u65b9\u6cd5\u4e2d[" + riskType + "]\u7c7b\u578b\u8282\u70b9\u8c03\u7528\u5f02\u5e38\u3002");
        }
        Object riskReq = upRiskReqMap.get(reqKey);
        if (StrUtil.isNull((Object)riskReq)) {
            return new ArrayList<String>();
        }
        if (!(riskReq instanceof List)) {
            throw new BusinessException("[" + reqKey + "]\u8282\u70b9\u53ea\u80fd\u662fList\u683c\u5f0f\u3002");
        }
        List riskList = (List)riskReq;
        return this.mainRiskDetail(productUUID, riskList, templateRiskNode, riskParentNode, riskType, parentRiskUuid);
    }

    @Override
    public void commonAddRiskDeal() {
        List<String> addNodeSernoList = this.getCommonRiskNodeSernoList();
        Ulog.info((String)("\u5168\u90e8\u901a\u7528\u9644\u52a0\u9669" + JsonUtil.toJson(addNodeSernoList)));
        List<String> riskParentNodeNos = this.getAllMainRiskAddRiskNodeList();
        Ulog.info((String)("\u5168\u90e8\u4e3b\u9669\u67e5\u8be2" + JsonUtil.toJson(riskParentNodeNos)));
        riskParentNodeNos.forEach(mainRiskNodeNo -> addNodeSernoList.forEach(addNodeSerno -> {
            if (this.validRisk((String)addNodeSerno, (String)mainRiskNodeNo)) {
                this.addRiskToRiskUpNode((String)addNodeSerno, (String)mainRiskNodeNo, "A");
            }
        }));
    }

    private List<String> getAllMainRiskAddRiskNodeList() {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append(" SELECT SUB.NODE_NO FROM DSN_STRUCTURE  SUB ,DSN_STRUCTURE  M    ");
        sqlSB.append(" WHERE M.NODE_TYPE =? AND M.NODE_NO= SUB.UP_NODE AND  SUB.NODE_TYPE= ? ");
        querySql.add((Object)"main_risks");
        querySql.add((Object)"n_accy_risks");
        querySql.setSql(sqlSB.toString());
        List riskParentNodeNos = this.dbHandle().queryList(querySql);
        ArrayList<String> riskParentNodeNoList = new ArrayList<String>(riskParentNodeNos.isEmpty() ? 1 : riskParentNodeNos.size());
        riskParentNodeNos.forEach(node -> riskParentNodeNoList.add(StrUtil.trimStr(node.get("node_no"))));
        return riskParentNodeNoList;
    }

    private List<String> getCommonRiskNodeSernoList() {
        String templateRiskUUID = this.riskDao.getRiskUUIDByRiskNo(this.prdConf.getCommon_add_parent_risk_no());
        if (StrUtil.isNull((Object)templateRiskUUID)) {
            throw new BusinessException(new Message("2016005", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u901a\u7528\u9644\u52a0\u9669\u6a21\u677f\u7684risk_no\u3002"));
        }
        Dsn_Structure templateRiskNode = this.riskDao.getRiskNodeNoByRiskUUID(templateRiskUUID);
        Dsn_Structure riskListNode = this.nodeDao.getSubNodeByNodeType(templateRiskNode.getNodeNo(), "n_accy_risks");
        List<Dsn_Structure> commonRiskNodes = this.nodeDao.getSubNode(riskListNode.getNodeNo());
        ArrayList<String> sernoList = new ArrayList<String>(commonRiskNodes.isEmpty() ? 1 : commonRiskNodes.size());
        commonRiskNodes.forEach(commonAddRisk -> sernoList.add(commonAddRisk.getSerno()));
        return sernoList;
    }

    private String getReqKeyByriskType(String riskType) {
        String reqKey = "";
        switch (riskType) {
            case "M": {
                reqKey = "risk_detail";
                break;
            }
            case "A": {
                reqKey = "additional_risk";
                break;
            }
            case "W": {
                reqKey = "pol_waiver_risk";
                break;
            }
            case "S": {
                reqKey = "pol_sub_risk";
                break;
            }
        }
        return reqKey;
    }

    private Dsn_Structure copyRiskTemp(Map<String, Object> mainRiskMap, String productUUid, Dsn_Structure templateRiskRootNode, String riskType, Dsn_Structure riskParentNode, String parentRiskUuid) {
        String newRiskSerno = "";
        if (StrUtil.isNull((Object)newRiskSerno)) {
            newRiskSerno = this.newRisk(templateRiskRootNode, riskType);
        }
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskParentNode.getNodeNo());
        this.addRiskToRiskUpNode(newRiskSerno, riskParentNode.getNodeNo(), riskType);
        this.saveRiskDetail(productUUid, newRiskSerno, mainRiskMap, riskType, parentRiskUuid, riskParentNode.getNodeNo());
        Object attrDetail = mainRiskMap.get("attr_detail");
        this.attrDeal(newRiskSerno, attrDetail);
        return this.nodeDao.getOneDsnBySerno(newRiskSerno);
    }

    private void attrDeal(String newRiskSerno, Object attrDetail) {
        if (StrUtil.isNull((Object)attrDetail)) {
            return;
        }
        if (!(attrDetail instanceof List)) {
            throw new BusinessException(new Message("2016014", "[\u9669\u79cd\u5c5e\u6027]\u8282\u70b9\u53ea\u80fd\u662fList\u683c\u5f0f\u3002"));
        }
        Dsn_Structure riskNode = this.nodeDao.getOneDsnBySerno(newRiskSerno);
        Dsn_Structure riskAttrNode = this.riskDao.queryRiskAttrByRiskRootNode(riskNode.getNodeNo());
        String attrNodeNodeSeq = riskAttrNode.getNodeSeq();
        String attrNodeNodeNo = riskAttrNode.getNodeNo();
        List attrList = (List)attrDetail;
        List<Dsn_Structure> subAttrNodes = this.nodeDao.getSubNode(attrNodeNodeNo);
        attrList.stream().forEach(attrMap -> {
            Dsn_Structure attrNode = this.newAttrNode(attrNodeNodeNo, attrNodeNodeSeq, subAttrNodes, (Map<String, Object>)attrMap);
            this.mdfAttrDetail(attrNode, (Map<String, Object>)attrMap);
        });
    }

    private void mdfAttrDetail(Dsn_Structure attrNode, Map<String, Object> attrMap) {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        this.getAttrBaseData(reqMap, attrNode);
        AttributeDetailVo attributeOptionVo = (AttributeDetailVo)JsonUtil.map2Class(attrMap, AttributeDetailVo.class);
        attributeOptionVo.addBase(attrNode);
        LinkedList<MdfAttrDetailVo> attrOptionVoList = new LinkedList<MdfAttrDetailVo>();
        if (attrMap.get("dsn_biz_attribute_option") instanceof List) {
            List attrOptions = (List)attrMap.get("dsn_biz_attribute_option");
            attrOptions.stream().forEach(attrOptionMap -> {
                MdfAttrDetailVo optionVo = (MdfAttrDetailVo)JsonUtil.map2Class((Map)attrOptionMap, MdfAttrDetailVo.class);
                optionVo.addBase();
                attrOptionVoList.add(optionVo);
            });
        }
        attributeOptionVo.setOptions(attrOptionVoList);
        String reqJson = JsonUtil.toJson((Object)attributeOptionVo);
        Ulog.info((String)(this.info01 + reqJson));
        Map requestMap = JsonUtil.json2Map((String)reqJson);
        RequestParam requestParam = this.getRequestMap(requestMap, Dsn_Structure.class, Dsn_Biz_Attribute.class, Dsn_Attribute.class);
        Dsn_Structure structure = (Dsn_Structure)((Object)requestParam.getParam(0, Dsn_Structure.class));
        Dsn_Biz_Attribute attribute = (Dsn_Biz_Attribute)((Object)requestParam.getParam(1, Dsn_Biz_Attribute.class));
        Dsn_Attribute allattribute = (Dsn_Attribute)((Object)requestParam.getParam(2, Dsn_Attribute.class));
        ReturnMsg msg = this.attrservice.mdfAttribute(structure, attribute, allattribute, requestMap);
        String reqStr = ReturnUtil.return2Json(msg);
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(this.errMsg01);
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException(new Message("2016015", "\u4fee\u6539\u5c5e\u6027\u8be6\u60c5\u5931\u8d25\u3002"));
        }
    }

    public final RequestParam getRequestMap(Map<String, Object> requestMap, Class ... requiredType) {
        String json = JsonUtil.toJson(requestMap);
        RequestParam param = new RequestParam();
        Class[] var5 = requiredType;
        int var6 = requiredType.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            Class clazz = var5[var7];
            param.addParam(JsonUtil.json2Class((String)json, (Class)clazz));
        }
        return param;
    }

    private Dsn_Structure newAttrNode(String riskAttrNodeNodeNo, String riskAttrNodeNodeSeq, List<Dsn_Structure> subAttrNodes, Map<String, Object> attrMap) {
        String attrName = StrUtil.trimStr((Object)attrMap.get("attr_name"));
        if (StrUtil.isNull((Object)attrName)) {
            throw new BusinessException(new Message("2016016", "attr_name\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
        }
        this.delOldAttr(attrName, subAttrNodes);
        return this.addAttrNode(riskAttrNodeNodeNo, riskAttrNodeNodeSeq, attrName);
    }

    private Dsn_Structure addAttrNode(String riskAttrNodeNodeNo, String riskAttrNodeNodeSeq, String attrName) {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("node_no", riskAttrNodeNodeNo);
        reqMap.put("node_seq", riskAttrNodeNodeSeq);
        reqMap.put("node_name", attrName);
        reqMap.put("node_type", "attr");
        ReturnMsg msg = this.pubTree.addTreeNode(reqMap);
        String reqStr = ReturnUtil.return2Json(msg);
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(this.errMsg01);
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException(new Message("2016017", "\u6dfb\u52a0\u5c5e\u6027\u8282\u70b9\u5931\u8d25\u3002"));
        }
        Map result = (Map)json2Map.get("defmap");
        return (Dsn_Structure)((Object)JsonUtil.map2Class((Map)result, Dsn_Structure.class));
    }

    private void delOldAttr(String attrName, List<Dsn_Structure> subAttrNodes) {
        if (subAttrNodes == null || subAttrNodes.isEmpty()) {
            return;
        }
        Dsn_Structure oldAttr = null;
        for (Dsn_Structure subAttrNode : subAttrNodes) {
            if (!attrName.equals(subAttrNode.getNodeName())) continue;
            oldAttr = subAttrNode;
            break;
        }
        if (oldAttr == null) {
            return;
        }
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("node_no", oldAttr.getNodeNo());
        reqMap.put("node_seq", oldAttr.getNodeSeq());
        ReturnMsg msg = this.attrservice.bizAttrInfoDel(reqMap);
        String reqStr = JsonUtil.toJson((Object)msg);
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(this.errMsg01);
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException("\u5220\u9664\u5df2\u6709\u5c5e\u6027\u8282\u70b9[" + oldAttr.getNodeName() + "]\u5931\u8d25\u3002");
        }
    }

    private void getAttrBaseData(Map<String, Object> reqMap, Dsn_Structure attrNode) {
        reqMap.put("up_node", attrNode.getUpNode());
        reqMap.put("node_no", attrNode.getNodeNo());
        reqMap.put("biz_uuid", attrNode.getNodeNo());
        reqMap.put("not_null", "Y");
        reqMap.put("display_order", attrNode.getDisplayOrder());
        reqMap.put("stored_tab", "db_database");
        reqMap.put("stored_field", "serno");
        reqMap.put("row_clm", "ROW");
        reqMap.put("attr_uuid", "");
        reqMap.put("node_type", "attr");
    }

    private void saveRiskDetail(String productUUid, String newRiskSerno, Map<String, Object> riskMap, String riskType, String parentRiskUuid, String mainParentNodeNoSeq) {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        String detailNodeNo = this.riskDao.getRiskDetailNodeBySerno(newRiskSerno);
        riskMap.forEach((k, v) -> {
            if (v instanceof String) {
                reqMap.put((String)k, (String)v);
            }
        });
        reqMap.put("temp", riskType);
        reqMap.put("current_node_no", detailNodeNo);
        reqMap.put("product_uuid", productUUid);
        reqMap.put("no_channel", "no-excuse");
        reqMap.put("parent_risk_uuid", parentRiskUuid);
        reqMap.put("root_node_no", parentRiskUuid);
        reqMap.put("risk_order_relation", String.valueOf(this.nodeDao.getSubNodeCount(mainParentNodeNoSeq)));
        this.modifyRiskDetail(reqMap);
    }

    private void modifyRiskDetail(Map<String, String> riskDetailMap) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        riskDetailMap.put("flag", "1");
        riskDetailMap.forEach((k, v) -> requestParams.put((String)k, v));
        String current_node_no = StrUtil.trimStr((Object)riskDetailMap.get("current_node_no"));
        Sip_Risks sip_risks = (Sip_Risks)((Object)JsonUtil.map2Class(requestParams, Sip_Risks.class));
        sip_risks.setRiskUuid(current_node_no);
        String reqStr = null;
        try {
            ReturnMsg msg = this.riskServiceImp.saveRiskInfo(requestParams, sip_risks);
            reqStr = ReturnUtil.return2Json(msg);
        }
        catch (Exception e) {
            Ulog.info((String)e.getMessage());
        }
        riskDetailMap.put("flag", "1");
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(this.errMsg01);
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException("\u4fdd\u5b58\u9669\u79cd\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\u3002" + json2Map.get("dtildMsg").toString());
        }
    }

    private void addRiskToRiskUpNode(String newRiskserno, String riskParentNodeNo, String riskType) {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("node_no", riskParentNodeNo);
        reqMap.put("node_type", this.getRiskNodeType(riskType));
        ArrayList addRiaklist = new ArrayList();
        reqMap.put("rigthSelect", addRiaklist);
        HashMap<String, String> riskMap = new HashMap<String, String>();
        riskMap.put("rigthSelect", newRiskserno);
        addRiaklist.add(riskMap);
        String reqStr = ReturnUtil.return2Json(this.riskServiceImp.addRisk(reqMap));
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(this.errMsg01);
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException(new Message("2016019", "\u6dfb\u52a0\u5df2\u590d\u5236\u9669\u79cd\u5931\u8d25\u3002"));
        }
    }

    private boolean validRisk(String addSerno, String riskNodeNo) {
        String addCommonCode = this.riskDao.queryPolicyCodeBySerno(addSerno);
        String riskPolicyCode = this.riskDao.queryPolicyCodeByAdd(riskNodeNo);
        return this.riskDao.validRiskCommon(addCommonCode, riskPolicyCode);
    }

    private String newRisk(Dsn_Structure templateRiskRootNode, String riskType) {
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("node_name", "\u65b0\u590d\u5236\u9669\u79cd");
        reqMap.put("node_seq", templateRiskRootNode.getNodeSeq());
        reqMap.put("node_no", templateRiskRootNode.getNodeNo());
        String nodeType = this.getRiskNodeType(riskType);
        reqMap.put("node_type", nodeType);
        ReturnMsg msg = this.riskCopyServiceImp.doRiskCopy(reqMap);
        String reqStr = ReturnUtil.return2Json(msg);
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(this.errMsg01);
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException(new Message("2016018", "\u590d\u5236\u9669\u79cd\u6a21\u677f\u5931\u8d25\u3002"));
        }
        Map result = (Map)json2Map.get("defmap");
        return StrUtil.trimStr(result.get("serno"));
    }

    private String getRiskNodeType(String riskType) {
        String nodeType = "";
        switch (riskType) {
            case "M": {
                nodeType = "main_risks";
                break;
            }
            case "A": {
                nodeType = "accy_risks";
                break;
            }
            case "W": {
                nodeType = "n_main_exempt";
                break;
            }
            case "S": {
                nodeType = "sub_risks";
                break;
            }
        }
        return nodeType;
    }

    private List<Map<String, Object>> queryExemptRisk(Map<String, Object> param) {
        ArrayList<Map<String, Object>> exemptList = new ArrayList<Map<String, Object>>();
        Dsn_Structure dsnStruct = new Dsn_Structure();
        String riskUuid = (String)param.get("risk_uuid");
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskUuid);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"main_exempt");
        Dsn_Structure exemptRisk = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)exemptRisk.getNodeNo());
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_main_exempt");
        List exemptInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (Dsn_Structure exempt : exemptInfo) {
            HashMap<String, Object> exemptResult = new HashMap<String, Object>();
            List<Map<String, Object>> exemptRiskDetail = this.riskDao.queryRiskDetail(param, exempt.getNodeNo(), "main_exempt");
            if (!"organ".equals(source)) {
                Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(exemptRiskDetail);
                exemptResult.put("riskDetail", fieldValueApp);
            } else {
                exemptResult.put("riskDetail", exemptRiskDetail);
            }
            List<Map<String, Object>> queryRiskAttr = this.riskDao.queryRiskAttr(param, exempt.getNodeNo());
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)exempt.getNodeNo());
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_rule");
            Dsn_Structure rule = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
            String ruleNo = rule.getNodeNo();
            Map<String, Object> riskRule = this.rules.queryRiskRule(ruleNo, organRiskUuid, param, "");
            exemptResult.put("riskAttr", queryRiskAttr);
            exemptResult.put("riskRule", riskRule);
            exemptList.add(exemptResult);
        }
        return exemptList;
    }

    private List<Map<String, Object>> queryAdditionalRisk(Map<String, Object> param, String flag, Map<String, Object> product) {
        ArrayList<Map<String, Object>> additionList = new ArrayList<Map<String, Object>>();
        Dsn_Structure dsnStruct = new Dsn_Structure();
        String riskUuid = (String)param.get("risk_uuid");
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskUuid);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        Dsn_Structure additionalRisk = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)additionalRisk.getNodeNo());
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
        List additionalInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (Dsn_Structure addition : additionalInfo) {
            HashMap<String, Object> additional = new HashMap<String, Object>();
            List<Map<String, Object>> additionalRiskDetail = this.riskDao.queryRiskDetail(param, addition.getNodeNo(), "n_accy_risks");
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)addition.getNodeNo());
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
            Dsn_Structure addRiskUuid = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
            String addUuid = addRiskUuid.getNodeNo();
            param.put("addRiskUuid", addUuid);
            Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(additionalRiskDetail);
            if (!"organ".equals(source)) {
                String mainRisk = this.queryRiskInfoRoot(addition.getNodeNo(), "n_accy_risks");
                fieldValueApp.put("risk_uuid", mainRisk);
                additional.put("riskDetail", fieldValueApp);
            } else {
                additional.put("riskDetail", additionalRiskDetail);
            }
            if ("relation".equals(source) || "app".equals(source)) {
                HashMap<String, Object> request = new HashMap<String, Object>();
                request.put("organ_prd_uuid", organRiskUuid);
                String mainRisk = this.queryRiskInfoRoot(riskUuid, "n_risk_detail");
                String riskId = this.queryRiskInfoRoot(addition.getNodeNo(), "n_accy_risks");
                request.put("main_risk", mainRisk);
                request.put("risk_uuid", riskId);
                Sip_Organ_Risk_Relation queryRiskReational = this.queryRiskReational(request);
                additional.put("riskRelation", (Object)queryRiskReational);
            }
            List<Map<String, Object>> queryRiskAttr = this.riskDao.queryRiskAttr(param, addition.getNodeNo());
            if ("app".equals(source) || "rule".equals(source)) {
                dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)addition.getNodeNo());
                dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_rule");
                Dsn_Structure rule = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
                String ruleNo = rule.getNodeNo();
                Map<String, Object> riskRule = this.rules.queryRiskRule(ruleNo, organRiskUuid, param, "addRiskAge");
                additional.put("riskRule", riskRule);
                if ("1".equals(flag)) {
                    this.dealProductRule(product, fieldValueApp, riskRule);
                }
            }
            if (!"relation".equals(source)) {
                List<Map<String, Object>> queryAccyExemptRisk = this.queryAccyExemptRisk(param);
                List<Map<String, Object>> querySubRisk = this.querySubRisk(param, addition.getNodeNo(), product);
                additional.put("riskAttr", queryRiskAttr);
                additional.put("pol_waiver_risk", queryAccyExemptRisk);
                additional.put("sub_risk", querySubRisk);
            }
            additionList.add(additional);
        }
        return additionList;
    }

    private List<Map<String, Object>> queryAccyExemptRisk(Map<String, Object> param) {
        ArrayList<Map<String, Object>> additionList = new ArrayList<Map<String, Object>>();
        Dsn_Structure dsnStruct = new Dsn_Structure();
        String riskUuid = (String)param.get("risk_uuid");
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskUuid);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        Dsn_Structure additionalRisk = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)additionalRisk.getNodeNo());
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
        List additionalInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (Dsn_Structure addition : additionalInfo) {
            HashMap<String, Object> additional = new HashMap<String, Object>();
            if (!"rule".equals(source)) {
                List<Map<String, Object>> additionalRiskDetail = this.riskDao.queryRiskDetail(param, addition.getNodeNo(), "n_accy_exempt");
                if ("app".equals(source)) {
                    Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(additionalRiskDetail);
                    String mainRisk = this.queryRiskInfoRoot(addition.getNodeNo(), "n_accy_exempt");
                    fieldValueApp.put("risk_uuid", mainRisk);
                    additional.put("riskDetail", fieldValueApp);
                } else {
                    additional.put("riskDetail", additionalRiskDetail);
                }
            }
            List<Map<String, Object>> queryRiskAttr = this.riskDao.queryRiskAttr(param, addition.getNodeNo());
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)addition.getNodeNo());
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_rule");
            Dsn_Structure rule = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
            String ruleNo = rule.getNodeNo();
            Map<String, Object> riskRule = this.rules.queryRiskRule(ruleNo, organRiskUuid, param, "");
            additional.put("riskAttr", queryRiskAttr);
            additional.put("riskRule", riskRule);
            additionList.add(additional);
        }
        return additionList;
    }

    @Override
    public Sip_Organ_Risk_Relation queryRiskReational(Map<String, Object> param) {
        String organPrdUuid = (String)param.get("organ_prd_uuid");
        String mainRisk = (String)param.get("main_risk");
        String riskUuid = (String)param.get("risk_uuid");
        Sip_Risk_Relation sipRelation = new Sip_Risk_Relation();
        sipRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainRisk);
        sipRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)riskUuid);
        Sip_Risk_Relation sipRiskRelation = (Sip_Risk_Relation)this.dao.findOne((AbsModel)sipRelation);
        Sip_Organ_Risk_Relation relation = new Sip_Organ_Risk_Relation();
        relation.where().addEq((ModelField)Sip_Organ_Risk_Relation.Field.organ_prd_uuid, (Object)organPrdUuid);
        relation.where().addEq((ModelField)Sip_Organ_Risk_Relation.Field.risk_uuid, (Object)riskUuid);
        relation.where().addEq((ModelField)Sip_Organ_Risk_Relation.Field.main_risk, (Object)mainRisk);
        Sip_Organ_Risk_Relation organRiskRelation = (Sip_Organ_Risk_Relation)this.dao.findOne((AbsModel)relation);
        organRiskRelation.setRiskUuid(riskUuid);
        organRiskRelation.setMainRisk(mainRisk);
        if (StrUtil.isNull((Object)organRiskRelation.getIsRecommend())) {
            organRiskRelation.setIsRecommend(sipRiskRelation.getIsRecommend());
        }
        if (StrUtil.isNull((Object)organRiskRelation.getIsRequired())) {
            organRiskRelation.setIsRequired(sipRiskRelation.getIsRequired());
        }
        return organRiskRelation;
    }

    private List<Map<String, Object>> querySubRisk(Map<String, Object> param, String riskUuid, Map<String, Object> product) {
        ArrayList<Map<String, Object>> subList = new ArrayList<Map<String, Object>>();
        Dsn_Structure dsnStruct = new Dsn_Structure();
        String source = (String)param.get("source");
        String organRiskUuid = (String)param.get("organ_prd_uuid");
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskUuid);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_sub_risks");
        Dsn_Structure subRisk = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)subRisk.getNodeNo());
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"sub_risks");
        List subInfo = this.dao.findAll((AbsModel)dsnStruct);
        for (Dsn_Structure sub : subInfo) {
            HashMap<String, Object> subResult = new HashMap<String, Object>();
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)sub.getNodeNo());
            dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_sub_risks_detail");
            Dsn_Structure subRiskUuid = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
            param.put("subRiskUuid", subRiskUuid.getNodeNo());
            List<Map<String, Object>> subRiskDetail = this.riskDao.queryRiskDetail(param, sub.getNodeNo(), "n_sub_risks_detail");
            Map<String, Object> fieldValueApp = this.riskDao.getFieldValueApp(subRiskDetail);
            if (!"organ".equals(source)) {
                String mainRisk = this.queryRiskInfoRoot(sub.getNodeNo(), "n_sub_risks_detail");
                fieldValueApp.put("risk_uuid", mainRisk);
                subResult.put("riskDetail", fieldValueApp);
            } else {
                subResult.put("riskDetail", subRiskDetail);
            }
            List<Map<String, Object>> querySubAttr = this.riskDao.queryRiskAttr(param, sub.getNodeNo());
            for (Map<String, Object> attrRule : querySubAttr) {
                String json = JsonUtil.toJson((Object)attrRule.get("ruleOption"));
                Map rule = JsonUtil.json2Map((String)json);
                this.dealProductRule(product, fieldValueApp, rule);
            }
            if ("app".equals(source) || "rule".equals(source)) {
                dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)sub.getNodeNo());
                dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_rule");
                Dsn_Structure rule = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
                String ruleNo = rule.getNodeNo();
                Map<String, Object> riskRule = this.rules.queryRiskRule(ruleNo, organRiskUuid, param, "");
                this.dealProductRule(product, fieldValueApp, riskRule);
                subResult.put("riskRule", riskRule);
            }
            if ("relation".equals(source) || "app".equals(source)) {
                HashMap<String, Object> request = new HashMap<String, Object>();
                String mainRisk = this.queryRiskInfoRoot(riskUuid, "n_risk_detail");
                String riskId = this.queryRiskInfoRoot(sub.getNodeNo(), "n_sub_risks_detail");
                request.put("organ_prd_uuid", organRiskUuid);
                request.put("main_risk", mainRisk);
                request.put("risk_uuid", riskId);
                Sip_Organ_Risk_Relation queryRiskReational = this.queryRiskReational(request);
                subResult.put("riskRelation", (Object)queryRiskReational);
            }
            subResult.put("riskAttr", querySubAttr);
            subList.add(subResult);
        }
        return subList;
    }

    private String queryRiskInfoRoot(String riskUuid, String type) {
        Dsn_Structure riskVo = this.riskDao.getDsnStructureInfo(riskUuid, type);
        return riskVo.getNodeNo();
    }

    @Override
    public Map<String, Object> saveOrganRule(Map<String, Object> request, String key, Map<String, Object> parmer) {
        String riskUuid = request.get("risk_uuid").toString();
        String ruleNo = "";
        ruleNo = "min_amount".equals(key) || "min_premium".equals(key) ? this.riskDao.ruleNodeNo(riskUuid, "underwrite_rule") : this.riskDao.ruleNodeNo(riskUuid, "insure_rule");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList ruleList = new ArrayList();
        Dsn_Rules dsnRule = new Dsn_Rules();
        dsnRule.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)key);
        List findAll = this.dao.findAll((AbsModel)dsnRule);
        Dsn_Rules_Const ruleConst = new Dsn_Rules_Const();
        ruleConst.where().addEq((ModelField)Dsn_Rules_Const.Field.rule_no, (Object)key);
        Dsn_Rules_Const constRules = (Dsn_Rules_Const)this.dao.findOne((AbsModel)ruleConst);
        HashMap constMap = new HashMap();
        for (Dsn_Rules rule : findAll) {
            HashMap<String, Object> ruleInfo = new HashMap<String, Object>();
            String ruleInfo1 = rule.getRuleInfo();
            String switchRule = this.rules.switchRule(parmer, ruleInfo1);
            Map json2Map = JsonUtil.json2Map((String)switchRule);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String format = df.format(new Date());
            ruleInfo.put("rule_info", json2Map);
            ruleInfo.put("organ_prd_uuid", parmer.get("organ_prd_uuid"));
            ruleInfo.put("crt_date", format);
            ruleInfo.put("mdf_date", format);
            ruleInfo.put("crt_user", rule.getCrtUser());
            ruleInfo.put("data_flag", rule.getDataFlag());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = sdf.parse("2019-01-01");
                long ts = date.getTime();
                ruleInfo.put("start_date", ts);
                Date date1 = sdf.parse("2099-12-31");
                long ts1 = date1.getTime();
                ruleInfo.put("end_date", ts1);
            }
            catch (ParseException e) {
                Ulog.info((String)("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage()));
            }
            ruleInfo.put("memo", rule.getMemo());
            ruleInfo.put("node_no", ruleNo);
            ruleInfo.put("rule_name", rule.getRuleName());
            ruleInfo.put("rule_no", UniqueSeq.shortUUID());
            ruleInfo.put("schedule_order", 1);
            ruleInfo.put("serno", UniqueSeq.shortUUID());
            ruleInfo.put("status", rule.getStatus());
            ruleList.add(ruleInfo);
            constMap.put("rule_no", ruleInfo.get("rule_no"));
            constMap.put("const_no", constRules.getConstNo());
            constMap.put("const_mapping", constRules.getConstMapping());
        }
        result.put("rules", ruleList);
        result.put("node_no", ruleNo);
        result.put("organ_prd_uuid", parmer.get("organ_prd_uuid"));
        result.put("constMap", constMap);
        return result;
    }

    static {
        ruleAttr.add("payment_duration");
        ruleAttr.add("period_duration");
    }
}

