/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.service.impl;

import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.wings.rmi.httptools.base.WingsHttpUtil;
import cn.com.chinalife.wings.util.DateUtil;
import com.github.stuxuhai.jpinyin.PinyinException;
import com.newtouch.chinalife.dao.IBranchDao;
import com.newtouch.chinalife.dao.IProductDao;
import com.newtouch.chinalife.dao.IRiskNewDao;
import com.newtouch.chinalife.entity.DsnStructureNew;
import com.newtouch.chinalife.entity.RiskRelationVo;
import com.newtouch.chinalife.entity.TreeNode;
import com.newtouch.chinalife.entity.bo.DetailBo;
import com.newtouch.chinalife.service.IBranchService;
import com.newtouch.chinalife.service.IConvertService;
import com.newtouch.chinalife.service.IProductDealProductService;
import com.newtouch.chinalife.service.IProductService;
import com.newtouch.chinalife.service.IRiskService;
import com.newtouch.chinalife.service.IRulesService;
import com.newtouch.chinalife.util.ReturnUtil;
import com.newtouch.chinalife.util.TreeUtil;
import com.newtouch.config.ProductConfig;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.design.product.service.IProductConfigService;
import com.newtouch.design.product.service.IProductDetailsService;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.md5.Md5;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductServiceImpl
extends BaseService
implements IProductService {
    @Autowired
    private IProductDao productDao;
    @Autowired
    @Lazy
    private IRiskNewDao riskDao;
    @Autowired
    private IRulesService rule;
    @Autowired
    private IRiskService riskService;
    @Autowired
    private IBranchService branch;
    @Autowired
    private IBranchDao branchDao;
    @Autowired
    private WingsHttpUtil wings;
    @Autowired
    private IConvertService convertService;
    @Autowired
    private IProductDealProductService productDealProductService;
    private String productNameNode = "product_name";
    private String code = "000000";
    private static final List<String> exceptAttrNo = new ArrayList<String>();
    private static final List<String> ruleAttr = new ArrayList<String>();
    @Autowired
    private ProductConfig prdConf;
    private String info02 = "\u8bf7\u6c42\u8def\u5f84\uff1a";
    private String info03 = "\u54cd\u5e94\u6570\u636e\uff1a[";
    private static Map<String, String> riskCodeMap = new HashMap<String, String>();
    private static Map<String, String> nodeNameMap = new HashMap<String, String>();
    private static final String MIN_AGE = "min_age";
    private static final String MAX_AGE = "max_age";
    @Autowired
    IProductDetailsService productDetailsService;
    @Autowired
    private IProductConfigService productConfigService;
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg queryProductDetail(Map<String, Object> param) {
        Return msg = new Return();
        String source = StrUtil.trimStr((Object)param.get("source"));
        List<Map<String, Object>> queryProductDetail = this.productDao.queryProductDetail(param);
        ArrayList<Map<String, Object>> queryProductResult = new ArrayList<Map<String, Object>>();
        if ("app".equals(source)) {
            Map<String, Object> fieldValueApp = this.productDao.getFieldValueApp(queryProductDetail);
            queryProductResult.add(fieldValueApp);
            msg.setDataList(queryProductResult);
        } else {
            msg.setDataList(queryProductDetail);
        }
        List<Dsn_Structure> queryRiskInfo = this.productDao.queryRiskInfo(param);
        msg.getDataTable().put("riskInfo", queryRiskInfo);
        return msg.msg();
    }

    private String saveOrganPro(Map<String, Object> request, String flag) {
        Map<String, Object> oldOrgan = null;
        List<Sip_Organ_Products> switchOldData = null;
        List<Sip_Organ_Products> switchRequestData = null;
        Map organProduct = JsonUtil.json2Map((String)JsonUtil.toJson((Object)request.get("organProduct")));
        String organPrdUuid = StrUtil.trimStr(organProduct.get("organ_prd_uuid"));
        if (!StrUtil.isNull((Object)organPrdUuid)) {
            oldOrgan = this.branch.queryProductOrganByOrgan(organProduct);
            switchOldData = this.switchData(oldOrgan);
            switchRequestData = this.switchData(organProduct);
            this.branchDao.saveProductOrgan(switchOldData, switchRequestData);
        } else {
            if (this.branchDao.queryProductRedisBranch(organProduct)) {
                throw new BusinessException(new Message("2016024", "\u8be5\u4ea7\u54c1\u5df2\u5728\u76f8\u540c\u673a\u6784\u4e0b\u53d1\u5e03\uff0c\u8bf7\u76f4\u63a5\u8fdb\u884c\u4fee\u6539"));
            }
            organPrdUuid = UniqueSeq.shortUUID();
            organProduct.put("organ_prd_uuid", organPrdUuid);
            switchRequestData = this.switchData(organProduct);
            this.branchDao.saveProductOrgan(switchOldData, switchRequestData);
        }
        if ("1".equals(flag)) {
            this.branchDao.updateProduct(organProduct);
        }
        return organPrdUuid;
    }

    private void saveOrganProduct(Map<String, Object> request, String organUuid, Map<String, Object> parmer) {
        HashMap<String, Object> product = new HashMap<String, Object>();
        Map productInfo = JsonUtil.json2Map((String)JsonUtil.toJson((Object)request.get("productInfo")));
        product.put("product_uuid", productInfo.get("product_uuid"));
        parmer.put("product_code", productInfo.get("product_no"));
        product.put("organ_prd_uuid", organUuid);
        ReturnMsg queryProductDetail = this.queryProductDetail(product);
        List productList = queryProductDetail.getDataList();
        this.productDao.saveProductInfo(productList, productInfo, organUuid);
    }

    private void saveOrganRisk(Map<String, Object> request, String organUuid, Map<String, Object> parmer) {
        List riskInfo = JsonUtil.json2List((String)JsonUtil.toJson((Object)request.get("risk")));
        List subRiskInfo = JsonUtil.json2List((String)JsonUtil.toJson((Object)request.get("sub_risk")));
        this.saveOrganRiskInfo(riskInfo, organUuid, "n_risk_detail", parmer);
        this.saveOrganRiskInfo(subRiskInfo, organUuid, "n_sub_risks_detail", parmer);
    }

    public void saveOrganRiskInfo(List<Map<String, Object>> newRisk, String organUuid, String type, Map<String, Object> parmer) {
        HashMap<String, Object> risk = new HashMap<String, Object>();
        for (Map<String, Object> subRisk : newRisk) {
            String upNode = this.productDao.getUpNode(StrUtil.trimStr((Object)subRisk.get("risk_uuid")));
            risk.put("organ_prd_uuid", subRisk.get("organ_prd_uuid"));
            risk.put("risk_uuid", upNode);
            if (type.equals("n_risk_detail")) {
                parmer.put("mainRiskUuid", StrUtil.trimStr((Object)subRisk.get("risk_uuid")));
            } else if (type.equals("n_sub_risks_detail")) {
                parmer.put("mainRiskUuid", subRisk.get("main_risk"));
                parmer.put("subRiskUuid", subRisk.get("risk_uuid"));
            }
            List<Map<String, Object>> queryRiskDetail = this.riskDao.queryRiskDetail(risk, upNode, type);
            this.compareValue(subRisk, queryRiskDetail, organUuid, parmer);
        }
    }

    private void compareValue(Map<String, Object> request, List<Map<String, Object>> risk, String organPrd, Map<String, Object> parmer) {
        for (Map<String, Object> riskInfo : risk) {
            String key = StrUtil.trimStr((Object)riskInfo.get("attr_no"));
            String oldValue = StrUtil.trimStr((Object)riskInfo.get("field_value"));
            String value = request.get(key).toString();
            if (value.equals(oldValue)) continue;
            this.productDao.saveRiskInfo(riskInfo, request, organPrd, value);
            if (!ruleAttr.contains(key)) continue;
            Map<String, Object> ruleResule = this.riskService.saveOrganRule(request, key, parmer);
            this.rule.saveOrganRulesInfoByNodeNo(ruleResule);
        }
    }

    @Override
    public ReturnMsg saveProductFrom3rd(Map<String, Object> requestMap) {
        Return result = new Return();
        Object proDetail = requestMap.get("product_detail");
        List riskList = (List)requestMap.get("riskList");
        if (StrUtil.isNull((Object)proDetail)) {
            result.setFailMsg(new Message("2016007", "\u4ea7\u54c1\u8be6\u60c5\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            return result.msg();
        }
        if (!(proDetail instanceof List)) {
            result.setFailMsg(new Message("2016008", "\u4ea7\u54c1\u8be6\u60c5\u8282\u70b9\u53ea\u80fd\u662fList\u683c\u5f0f\u3002"));
            return result.msg();
        }
        List productList = (List)proDetail;
        Ulog.info((String)("\u4ea7\u54c1\u8be6\u60c5\uff1a" + JsonUtil.toJson((Object)productList)));
        String productUuid = this.productDeal(productList);
        this.riskNewDeal(productUuid, (Map)productList.get(0), riskList);
        return result.msg();
    }

    private String productDeal(List<Map<String, Object>> productList) {
        StringBuilder productNewuUuid = new StringBuilder();
        String templateProductUUID = this.productDao.getProductUUIDByProductNo(this.prdConf.getProduct_no());
        if (StrUtil.isNull((Object)templateProductUUID)) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u6a21\u677f\u7684product_no\u3002");
        }
        String templateRiskUUID = this.riskDao.getRiskUUIDByRiskNo(this.prdConf.getMain_risk_no());
        if (StrUtil.isNull((Object)templateRiskUUID)) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u6a21\u677f\u7684risk_no\u3002");
        }
        productList.stream().forEach(productMap -> {
            String productUUid = this.copyProductTemp((Map<String, Object>)productMap, templateProductUUID);
            productNewuUuid.append(productUUid);
        });
        return productNewuUuid.toString();
    }

    private void riskNewDeal(String productUUid, Map<String, Object> productMap, List<Map<String, Object>> riskList) {
        List<Sip_Risks> riskStructure = this.riskDao.queryRiskStructure(riskList);
        riskStructure.forEach(risk -> {
            if ("common-add".equalsIgnoreCase(risk.getRiskNo())) {
                risk.setPolicyCode(risk.getRiskNo());
            }
        });
        Map<String, List<Sip_Risks>> mainRiksMap = riskStructure.stream().filter(e -> "M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        ArrayList<Sip_Risks> needDeleteRisk = new ArrayList<Sip_Risks>();
        Dsn_Structure mainParentNode = this.productDao.getMainParentNodeByProductUUid(productUUid);
        mainParentNode.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)mainParentNode.getNodeNo());
        List<String> riskUuidList = this.riskService.riskDeal(productUUid, this.prdConf.getMain_risk_no(), "M", productMap, mainParentNode, productUUid);
        ArrayList<Dsn_Structure> newInsertDsn = new ArrayList<Dsn_Structure>();
        ArrayList<DsnStructureNew> noNeed = new ArrayList<DsnStructureNew>();
        if (riskStructure.isEmpty()) {
            return;
        }
        riskUuidList.forEach(riskUuid -> {
            Dsn_Structure mainDsn = new Dsn_Structure();
            mainDsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, riskUuid);
            Dsn_Structure dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)mainDsn);
            mainDsn.where().addIn((ModelField)Dsn_Structure.Field.node_no, dsnStructure.getUpNode());
            mainDsn.where().addNotEq((ModelField)Dsn_Structure.Field.node_type, (Object)"root");
            Dsn_Structure mainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)mainDsn);
            this.queryDsnAll(dsnStructure.getUpNode(), newInsertDsn, riskStructure, mainRisk.getNodeNo(), needDeleteRisk, noNeed, "");
        });
        this.changeRiskCode(riskStructure, needDeleteRisk);
        riskUuidList.forEach(riskUuid -> {
            Sip_Risks risks = new Sip_Risks();
            risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, riskUuid);
            Sip_Risks newRisks = (Sip_Risks)this.dao.findOne((AbsModel)risks);
            this.dealAccyRiks(newRisks, mainRiksMap);
            this.dealRiskRelation(newRisks, mainRiksMap);
        });
        List<Dsn_Structure> bizAttribute = newInsertDsn.stream().filter(e -> !StrUtil.isNull((Object)e.getRelateTab())).collect(Collectors.toList());
        ArrayList<Sip_Risks> oldRisk = new ArrayList<Sip_Risks>();
        riskStructure.forEach(e -> oldRisk.addAll(this.riskDao.getChildRisk(e.getRiskUuid())));
        ArrayList<Sip_Risks> newRisk = new ArrayList<Sip_Risks>();
        needDeleteRisk.forEach(e -> newRisk.addAll(this.riskDao.getChildRisk(e.getRiskUuid())));
        this.updateRisk(oldRisk, newRisk);
        if (!needDeleteRisk.isEmpty()) {
            Sip_Risks sipRisks = new Sip_Risks();
            needDeleteRisk.forEach(risk -> sipRisks.where().addIn((ModelField)Sip_Risks.Field.risk_uuid, risk.getRiskUuid()));
            this.dao.delete((AbsModel)sipRisks);
        }
        this.deleteRiskRelationInfo(newInsertDsn, bizAttribute, noNeed);
        Sip_Products products = new Sip_Products();
        products.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUUid);
        Sip_Products sipProducts = (Sip_Products)this.dao.findOne((AbsModel)products);
        if (!StrUtil.isNull((Object)sipProducts.getProductNo())) {
            this.productDealProductService.dealProductRiskRealtion(sipProducts.getProductNo());
        }
    }

    private void updateRisk(List<Sip_Risks> oldRiskList, List<Sip_Risks> newRiskList) {
        Map<String, List<Sip_Risks>> newRiskMap = newRiskList.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        oldRiskList.forEach(risk -> {
            List risks = (List)newRiskMap.get(risk.getPolicyCode());
            if (!risks.isEmpty()) {
                Map riskMap = risks.stream().collect(Collectors.toMap(Sip_Risks::getIsMainRisk, Function.identity()));
                Sip_Risks sipRisks = (Sip_Risks)((Object)((Object)riskMap.get(risk.getIsMainRisk())));
                risk.setWaiverRisk(sipRisks.getWaiverRisk());
                risk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)risk.getRiskUuid());
                this.dao.update((AbsModel)risk);
            }
        });
    }

    private void dealAccyRiks(Sip_Risks newRisks, Map<String, List<Sip_Risks>> mainRiksMap) {
        Sip_Risks oldRisk = new Sip_Risks();
        if ("common-add".equalsIgnoreCase(newRisks.getRiskNo()) && !StrUtil.isNull(mainRiksMap.get("common-add"))) {
            oldRisk = mainRiksMap.get(newRisks.getRiskNo()).get(0);
        }
        if (!mainRiksMap.isEmpty() && !StrUtil.isNull(mainRiksMap.get(newRisks.getPolicyCode()))) {
            oldRisk = mainRiksMap.get(newRisks.getPolicyCode()).get(0);
        }
        this.dealAccyRisk(newRisks, oldRisk);
    }

    private void dealAccyRisk(Sip_Risks newRisks, Sip_Risks oldRisk) {
        Dsn_Structure structure = this.getAccyRiskByMainRisk(newRisks);
        Dsn_Structure oldStructure = this.getAccyRiskByMainRisk(oldRisk);
        if (!StrUtil.isNull((Object)oldStructure.getSerno())) {
            if ("common-add".equalsIgnoreCase(newRisks.getRiskNo())) {
                List<Sip_Risks> newRisksList = this.queryRisk(structure);
                List<Sip_Risks> oldRisks = this.queryRisk(oldStructure);
                Map oldRiskMap = oldRisks.stream().collect(Collectors.toMap(Sip_Risks::getPolicyCode, Function.identity()));
                Dsn_Structure dsnStructure = new Dsn_Structure();
                ArrayList dsnStructures = new ArrayList();
                newRisksList.forEach(e -> {
                    if (StrUtil.isNull(oldRiskMap.get(e.getPolicyCode()))) {
                        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getRiskUuid());
                        dsnStructures.add(this.dao.findOne((AbsModel)dsnStructure));
                    }
                });
                if (!dsnStructures.isEmpty()) {
                    dsnStructures.forEach(dsn -> dsnStructure.where().addIn((ModelField)Dsn_Structure.Field.node_no, dsn.getUpNode()));
                    List structuresList = this.dao.findAll((AbsModel)dsnStructure);
                    structuresList.forEach(dsn -> {
                        dsn.setUpNode(oldStructure.getNodeNo());
                        dsn.setSerno(UniqueSeq.shortUUID());
                        dsnStructure.where().addIn((ModelField)Dsn_Structure.Field.node_no, dsn.getNodeNo());
                        this.dao.delete((AbsModel)dsnStructure);
                        this.dao.save((AbsModel)dsn);
                    });
                }
            } else {
                oldStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldStructure.getNodeNo());
                this.dao.delete((AbsModel)oldStructure);
                structure.setUpNode(oldStructure.getUpNode());
                structure.setSerno(UniqueSeq.shortUUID());
                if (StrUtil.isNull((Object)oldStructure.getUpNode())) {
                    Ulog.info((String)"ASDASDASDADS");
                }
                this.dao.save((AbsModel)structure);
            }
        }
    }

    private List<Sip_Risks> queryRisk(Dsn_Structure structure) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)structure.getNodeNo());
        List dsnStructures = this.dao.findAll((AbsModel)dsnStructure);
        dsnStructures.forEach(dsn -> dsnStructure.where().addIn((ModelField)Dsn_Structure.Field.up_node, dsn.getNodeNo()));
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
        List accyDeatil = this.dao.findAll((AbsModel)dsnStructure);
        Sip_Risks risks = new Sip_Risks();
        accyDeatil.forEach(e -> risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)e.getNodeNo()));
        return this.dao.findAll((AbsModel)risks);
    }

    private Dsn_Structure getAccyRiskByMainRisk(Sip_Risks risk) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)risk.getRiskUuid());
        Dsn_Structure one = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)one.getUpNode());
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
    }

    private void dealRiskRelation(Sip_Risks newRisks, Map<String, List<Sip_Risks>> mainRiksMap) {
        if (!mainRiksMap.isEmpty() && !StrUtil.isNull(mainRiksMap.get(newRisks.getPolicyCode()))) {
            Sip_Risks oldRisk = mainRiksMap.get(newRisks.getPolicyCode()).get(0);
            Dsn_Structure oldStructure = this.getAccyRiskByMainRisk(oldRisk);
            List<RiskRelationVo> newAccyRiskList = this.getAccyRiskList(newRisks);
            List<Sip_Risks> riskUuidList = this.getRiskUuidList(oldStructure);
            Map<String, List<Sip_Risks>> oldMap = riskUuidList.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
            ArrayList relationRes = new ArrayList();
            newAccyRiskList.forEach(risk -> {
                Sip_Risk_Relation relation = new Sip_Risk_Relation();
                if (oldMap.isEmpty()) {
                    BeanUtils.copyProperties((Object)risk, (Object)((Object)relation));
                    relation.setMainRisk(oldRisk.getRiskUuid());
                    relation.setSerno(UniqueSeq.shortUUID());
                    relationRes.add(relation);
                } else {
                    List oldRelationList = (List)oldMap.get(risk.getRiskCode());
                    if (!StrUtil.isNull((Object)oldRelationList) && !oldRelationList.isEmpty()) {
                        oldRelationList.forEach(oldRelation -> {
                            BeanUtils.copyProperties((Object)risk, (Object)((Object)relation));
                            relation.setMainRisk(oldRisk.getRiskUuid());
                            relation.setRiskUuid(oldRelation.getRiskUuid());
                            relation.setSerno(UniqueSeq.shortUUID());
                            relationRes.add(relation);
                        });
                    }
                }
            });
            Sip_Risk_Relation relation = new Sip_Risk_Relation();
            relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)oldRisk.getRiskUuid());
            this.dao.delete((AbsModel)relation);
            relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)newRisks.getRiskUuid());
            this.dao.delete((AbsModel)relation);
            this.dao.save(relationRes);
        }
    }

    private List<RiskRelationVo> getAccyRiskList(Sip_Risks risk) {
        ArrayList<RiskRelationVo> relationVo = new ArrayList<RiskRelationVo>();
        Sip_Risk_Relation relation = new Sip_Risk_Relation();
        relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)risk.getRiskUuid());
        List all = this.dao.findAll((AbsModel)relation);
        all.forEach(arr -> {
            RiskRelationVo riskRelation = new RiskRelationVo();
            Sip_Risks sipRisks = new Sip_Risks();
            sipRisks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)arr.getRiskUuid());
            Sip_Risks risks = (Sip_Risks)this.dao.findOne((AbsModel)sipRisks);
            if (!StrUtil.isNull((Object)risks.getSerno())) {
                BeanUtils.copyProperties((Object)arr, (Object)((Object)riskRelation));
                riskRelation.setRiskCode(risks.getPolicyCode());
                relationVo.add(riskRelation);
            }
        });
        return relationVo;
    }

    private void changeRiskCode(List<Sip_Risks> oldRisk, List<Sip_Risks> newRiskList) {
        List<Sip_Risks> oldMain = oldRisk.stream().filter(e -> "M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        List<Sip_Risks> newMain = newRiskList.stream().filter(e -> "M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        List<Sip_Risks> oldOthMain = oldRisk.stream().filter(e -> !"M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        List<Sip_Risks> newOthMain = newRiskList.stream().filter(e -> !"M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        this.dealRisk(oldMain, newMain);
        this.dealRisk(oldOthMain, newOthMain);
    }

    private List<Sip_Risks> getRiskUuidList(Dsn_Structure oldStructure) {
        ArrayList<Sip_Risks> riskUuidList = new ArrayList<Sip_Risks>();
        oldStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)oldStructure.getNodeNo());
        List dsnStructureList = this.dao.findAll((AbsModel)oldStructure);
        dsnStructureList.forEach(acc -> {
            oldStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)acc.getNodeNo());
            oldStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
            Dsn_Structure daoOne = (Dsn_Structure)this.dao.findOne((AbsModel)oldStructure);
            if (!StrUtil.isNull((Object)daoOne.getSerno())) {
                Sip_Risks risks = new Sip_Risks();
                risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)daoOne.getNodeNo());
                Sip_Risks sipRisks = (Sip_Risks)this.dao.findOne((AbsModel)risks);
                riskUuidList.add(sipRisks);
            }
        });
        return riskUuidList;
    }

    private void dealRisk(List<Sip_Risks> oldRisk, List<Sip_Risks> newRiskList) {
        Dsn_Structure structure = new Dsn_Structure();
        Map newRiskMap = newRiskList.stream().collect(Collectors.toMap(Sip_Risks::getPolicyCode, Function.identity()));
        Map<String, List<Sip_Risks>> oldRiskList = oldRisk.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        oldRiskList.forEach((k, v) -> {
            Sip_Risks risk = (Sip_Risks)((Object)((Object)v.get(0)));
            Sip_Risks newRisk = (Sip_Risks)((Object)((Object)newRiskMap.get(risk.getPolicyCode())));
            if (!StrUtil.isNull((Object)((Object)newRisk))) {
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)risk.getRiskUuid());
                structure.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                Dsn_Structure oldRiskDsn = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldRiskDsn.getUpNode());
                structure.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                Dsn_Structure oldMainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                if (StrUtil.isNull((Object)oldMainRisk.getSerno())) {
                    structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldRiskDsn.getUpNode());
                    structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                    oldMainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                }
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)newRisk.getRiskUuid());
                Dsn_Structure newRiskDsn = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)newRiskDsn.getUpNode());
                structure.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                Dsn_Structure newMainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                oldMainRisk.setUpNode(newMainRisk.getUpNode());
                oldMainRisk.setNodeSeq(newMainRisk.getNodeSeq());
                oldMainRisk.setSerno(newMainRisk.getSerno());
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)newMainRisk.getNodeNo());
                this.dao.delete((AbsModel)structure);
                oldMainRisk.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldMainRisk.getNodeNo());
                oldMainRisk.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)oldMainRisk.getUpNode());
                this.dao.delete((AbsModel)oldMainRisk);
                this.dao.save((AbsModel)oldMainRisk);
            }
        });
    }

    private String copyProductTemp(Map<String, Object> productMap, String productUUID) {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("parent_node_no", productUUID);
        reqMap.put(this.productNameNode, "productName");
        String productUUid = this.productIsExist(productMap);
        if (StrUtil.isNull((Object)productUUid)) {
            productUUid = this.sendService(reqMap);
        }
        reqMap.clear();
        String detailNode = this.productDao.getProductDetailNodeByProductUUid(productUUid);
        Ulog.info((String)("\u4ea7\u54c1\u8be6\u60c5\uff1a" + JsonUtil.toJson(productMap)));
        productMap.forEach((k, v) -> reqMap.put((String)k, StrUtil.trimStr((Object)v)));
        reqMap.put("current_node_no", detailNode);
        reqMap.put("product_uuid", productUUid);
        this.modifyProductDetail(reqMap);
        return productUUid;
    }

    private String productIsExist(Map<String, Object> productMap) {
        String productNo = StrUtil.trimStr((Object)productMap.get("product_no"));
        if (StrUtil.isNull((Object)productNo)) {
            throw new BusinessException(new Message("2016011", "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Sip_Products product = this.productDao.queryProductByProductNo(productNo);
        return product == null ? "" : product.getProductUuid();
    }

    private void modifyProductDetail(Map<String, String> productDetailMap) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        productDetailMap.forEach((k, v) -> param.put((String)k, v));
        String reqStr = null;
        try {
            ReturnMsg returnMsg = this.productDetailsService.saveProductDetails(param);
            reqStr = ReturnUtil.return2Json(returnMsg);
        }
        catch (Exception e) {
            Ulog.info((String)e.getMessage());
        }
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(new Message("2016012", "\u4ea7\u54c1\u914d\u7f6e\u670d\u52a1\u3010n3s-insure-sip\u3011\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002"));
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException("\u4fdd\u5b58\u4ea7\u54c1\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\u3002" + json2Map.get("dtildMsg").toString());
        }
    }

    private String sendService(Map<String, String> reqMap) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        reqMap.forEach((k, v) -> param.put((String)k, v));
        String reqStr = ReturnUtil.return2Json(this.productConfigService.addProduct(param));
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException(new Message("2016013", "\u590d\u5236\u4ea7\u54c1\u5931\u8d25\u3002"));
        }
        Map result = (Map)json2Map.get("defmap");
        return StrUtil.trimStr(result.get("node_no"));
    }

    private List<Sip_Organ_Products> switchData(Map<String, Object> organData) {
        ArrayList<Sip_Organ_Products> resultList = new ArrayList<Sip_Organ_Products>();
        String channel = StrUtil.trimStr((Object)organData.get("channel_no"));
        String organ = StrUtil.trimStr((Object)organData.get("organ_id"));
        String[] organList = organ.split(",");
        String[] channelList = channel.split(",");
        for (String org : organList) {
            for (String channelNo : channelList) {
                Sip_Organ_Products switchResult = new Sip_Organ_Products();
                switchResult.setOrganId(org);
                switchResult.setOrganPrdUuid(StrUtil.trimStr((Object)organData.get("organ_prd_uuid")));
                switchResult.setPolStartDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("pol_start_date"))));
                switchResult.setPolEndDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("pol_end_date"))));
                switchResult.setPrpStartDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("prp_start_date"))));
                switchResult.setPrpEndDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("prp_end_date"))));
                switchResult.setProductUuid(StrUtil.trimStr((Object)organData.get("product_uuid")));
                switchResult.setChannelNo(channelNo);
                resultList.add(switchResult);
            }
        }
        return resultList;
    }

    @Override
    public ReturnMsg saveFrom3rdChinaLife(DetailBo detailBo) throws PinyinException {
        Map<String, Object> selfMap = this.convertService.transReqMap(detailBo);
        Ulog.info((String)("\u8f6c\u6362\u540e\u62a5\u6587\uff1a" + JsonUtil.toJson(selfMap)));
        ReturnMsg returnMsg = this.saveProductFrom3rd(selfMap);
        this.riskService.commonAddRiskDeal();
        return returnMsg;
    }

    @Override
    public ReturnMsg saveFrom3rdChinaLifeByProductNo(String prdCode) throws PinyinException {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("prdCode", prdCode);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("ESB-TRANNO", this.code);
        header.put("Content-Type", "application/json");
        String respStr = this.wings.doPost(this.prdConf.getChina_life_product_server(), JsonUtil.toJson(reqMap), header);
        Ulog.info((String)("\u4ea7\u54c1\u4e2d\u5fc3\u8fd4\u56de\u6570\u636e" + respStr));
        DetailBo detailBo = (DetailBo)JsonUtil.json2Class((String)respStr, DetailBo.class);
        this.saveFrom3rdChinaLife(detailBo);
        return null;
    }

    private boolean validAge(Map<String, Object> request) {
        String unitB;
        boolean flag = true;
        String min = StrUtil.trimStr((Object)request.get(MIN_AGE));
        String max = StrUtil.trimStr((Object)request.get(MAX_AGE));
        String unitA = (String)min.subSequence(min.length() - 1, min.length());
        if ("A".equals(unitA)) {
            min = "10" + min;
        }
        if ("A".equals(unitB = (String)max.subSequence(max.length() - 1, max.length()))) {
            max = "10" + max;
        }
        Integer numberA = Integer.valueOf((String)min.subSequence(0, min.length() - 1));
        Integer numberB = Integer.valueOf((String)max.subSequence(0, max.length() - 1));
        if (numberA - numberB > 0) {
            flag = false;
        }
        return flag;
    }

    private void getAge(Map<String, Object> request) {
        String productList = JsonUtil.toJson((Object)request.get("dataList"));
        List productMap = JsonUtil.json2List((String)productList);
        ArrayList<Integer> minList = new ArrayList<Integer>();
        ArrayList<Integer> maxList = new ArrayList<Integer>();
        for (Map product : productMap) {
            String min = StrUtil.trimStr(product.get(MIN_AGE));
            String max = StrUtil.trimStr(product.get(MAX_AGE));
            this.getRandAge(minList, min);
            this.getRandAge(maxList, max);
        }
        this.getAgeResult(minList, maxList, request);
    }

    private void getRandAge(List<Integer> list, String age) {
        String unit = (String)age.subSequence(age.length() - 1, age.length());
        if ("A".equals(unit)) {
            age = "10" + age;
        }
        Integer number = Integer.valueOf((String)age.subSequence(0, age.length() - 1));
        list.add(number);
    }

    private void getAgeResult(List<Integer> minList, List<Integer> maxList, Map<String, Object> request) {
        int min = Collections.max(minList);
        int max = Collections.min(maxList);
        String minResult = "";
        String maxResult = "";
        minResult = (min + "").length() > 2 ? (String)(min + "").subSequence(2, (min + "").length()) + "A" : min + "D";
        maxResult = (max + "").length() > 2 ? (String)(max + "").subSequence(2, (max + "").length()) + "A" : max + "D";
        request.put(MIN_AGE, minResult);
        request.put(MAX_AGE, maxResult);
    }

    private void deleteRiskRelationInfo(List<Dsn_Structure> newInsertDsn, List<Dsn_Structure> bizAttribute, List<DsnStructureNew> noNeed) {
        Map noMap = noNeed.stream().collect(Collectors.toMap(Dsn_Structure::getNodeNo, Function.identity()));
        Dsn_Structure structure = new Dsn_Structure();
        newInsertDsn.forEach(dsn -> {
            if (StrUtil.isNull(noMap.get(dsn.getNodeNo()))) {
                if ("n_sub_risks_detail".equalsIgnoreCase(dsn.getNodeType())) {
                    Sip_Risks risks = new Sip_Risks();
                    risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)dsn.getNodeNo());
                    this.dao.delete((AbsModel)risks);
                }
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn.getNodeNo());
                structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn.getUpNode());
                this.dao.delete((AbsModel)structure);
            }
        });
        Ulog.info((String)JsonUtil.toJson(bizAttribute));
    }

    private void queryDsnAll(String riskUuid, List<Dsn_Structure> newInsertDsn, List<Sip_Risks> hasSaveRiskList, String riskDetailUuid, List<Sip_Risks> newDeleteRisk, List<DsnStructureNew> noNeed, String productUuid) {
        Map<String, List<Sip_Risks>> oldRiskMap = hasSaveRiskList.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        List<Map<String, Object>> mainRiskTree = this.getQuerySqlable(riskUuid, "M");
        List<Map<String, Object>> accyRisksUuid = this.queryAccyRiskList(riskUuid);
        ArrayList accyRisksList = new ArrayList();
        accyRisksUuid.forEach(e -> accyRisksList.addAll(this.getQuerySqlable(StrUtil.trimStr(e.get("node_no")), "A")));
        this.dealMainRisk(newInsertDsn, riskDetailUuid, oldRiskMap, mainRiskTree, newDeleteRisk, noNeed, productUuid);
        if (!accyRisksUuid.isEmpty()) {
            List<Sip_Risks> newRiskCode = this.queryHasSaveRisk(accyRisksUuid);
            this.dealAccyRisk(newInsertDsn, oldRiskMap, newRiskCode, newDeleteRisk, noNeed, productUuid);
        }
    }

    private void dealAccyRisk(List<Dsn_Structure> newInsertDsn, Map<String, List<Sip_Risks>> oldRiskMap, List<Sip_Risks> newRiskCode, List<Sip_Risks> newDeleteRisk, List<DsnStructureNew> noNeed, String productUuid) {
        ArrayList noNeedDelAccyRisksList = new ArrayList();
        newRiskCode.forEach(e -> {
            if (!StrUtil.isNull(oldRiskMap.get(e.getPolicyCode()))) {
                Dsn_Structure dsnStructure = new Dsn_Structure();
                dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getRiskUuid());
                Dsn_Structure structure = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
                dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)structure.getUpNode());
                Dsn_Structure dsnStructure1 = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
                newDeleteRisk.add((Sip_Risks)((Object)e));
                List<Map<String, Object>> disList = this.getQuerySqlable(dsnStructure1.getNodeNo(), "A");
                noNeedDelAccyRisksList.addAll(this.getQuerySqlable(dsnStructure1.getNodeNo(), "A"));
                this.incrementSynchronousAccyRisk((Sip_Risks)((Object)((Object)((List)oldRiskMap.get(e.getPolicyCode())).get(0))), (Sip_Risks)((Object)e), "A", disList, noNeed, productUuid);
            }
        });
        newInsertDsn.addAll(JsonUtil.listMap2ListClass(noNeedDelAccyRisksList, Dsn_Structure.class));
    }

    private void incrementSynchronousAccyRisk(Sip_Risks oldRisk, Sip_Risks newRisk, String riskType, List<Map<String, Object>> disList, List<DsnStructureNew> noNeed, String productUuid) {
        Dsn_Structure oldRiskNode = this.riskDao.getRiskNodeNoByRiskUUID(oldRisk.getRiskUuid());
        List<Map<String, Object>> list = this.getQuerySqlable(oldRiskNode.getNodeNo(), riskType);
        TreeNode oldTree = this.getTree(oldRisk, list);
        TreeNode newTree = this.getTree(newRisk, disList);
        this.dealDeff(oldTree, newTree, noNeed, productUuid);
    }

    private TreeNode getTree(Sip_Risks newRisk, List<Map<String, Object>> disList) {
        Dsn_Structure newRiskNode = this.riskDao.getRiskNodeNoByRiskUUID(newRisk.getRiskUuid());
        TreeNode newTreeNode = new TreeNode();
        BeanUtils.copyProperties((Object)((Object)newRiskNode), (Object)((Object)newTreeNode));
        return this.listToTree(disList, newTreeNode);
    }

    private void dealDeff(TreeNode oldTree, TreeNode newTree, List<DsnStructureNew> noNeed, String productUuid) {
        List<TreeNode> children = oldTree.getChildren();
        Map oldTreeMap = children.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
        TreeNode oldSubRisks = (TreeNode)((Object)oldTreeMap.get("n_sub_risks"));
        List<TreeNode> newChild = newTree.getChildren();
        Map treeNodeMap = newChild.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
        TreeNode newSubRisks = (TreeNode)((Object)treeNodeMap.get("n_sub_risks"));
        ArrayList<DsnStructureNew> insert = new ArrayList<DsnStructureNew>();
        treeNodeMap.forEach((k, v) -> {
            if (!"n_sub_risks".equalsIgnoreCase((String)k)) {
                TreeNode newTreeNode = v;
                TreeNode oldTreeNode = (TreeNode)((Object)((Object)oldTreeMap.get(k)));
                this.dealAttr(oldTreeNode, newTreeNode, insert, noNeed, oldTreeNode.getRiskName(), productUuid);
            }
        });
        this.dealSuRisk(oldSubRisks, newSubRisks, insert, noNeed, productUuid);
        Dsn_Structure structure = new Dsn_Structure();
        if (!insert.isEmpty()) {
            insert.forEach(dsn -> {
                Dsn_Structure newStr = new Dsn_Structure();
                BeanUtils.copyProperties((Object)dsn, (Object)((Object)newStr));
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn.getNodeNo());
                structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn.getUpNode());
                this.dao.delete((AbsModel)structure);
                this.dao.save((AbsModel)newStr);
            });
        }
    }

    private void dealAttr(TreeNode oldRiskDetail, TreeNode newRiskDetail, List<DsnStructureNew> insert, List<DsnStructureNew> noNeed, String riskCode, String productUuid) {
        if (null == oldRiskDetail || null == newRiskDetail) {
            return;
        }
        QuerySqlable querySqlable = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from sip_risks where risk_uuid = ?";
        querySqlable.add((Object)oldRiskDetail.getNodeNo());
        querySqlable.setSql(sql);
        List<TreeNode> oldChild = oldRiskDetail.getChildren();
        List<TreeNode> newChildren = newRiskDetail.getChildren();
        if (null == oldChild && null == newChildren) {
            return;
        }
        if (null == oldChild) {
            DsnStructureNew structure = new DsnStructureNew();
            BeanUtils.copyProperties((Object)((Object)newRiskDetail), (Object)((Object)structure));
            structure.setSerno(UniqueSeq.shortUUID());
            structure.setUpNode(oldRiskDetail.getNodeNo());
            insert.add(structure);
            List<TreeNode> children = newRiskDetail.getChildren();
            this.deleteAtrr(noNeed, children);
        } else if (null == newChildren) {
            Dsn_Structure structure = new Dsn_Structure();
            oldChild.forEach(old -> structure.where().addIn((ModelField)Dsn_Structure.Field.node_no, old.getNodeNo()));
            this.dao.delete((AbsModel)structure);
        } else {
            this.updateNeedAttr(oldRiskDetail, insert, noNeed, oldChild, newChildren);
        }
    }

    private void updateNeedAttr(TreeNode oldRiskDetail, List<DsnStructureNew> insert, List<DsnStructureNew> noNeed, List<TreeNode> oldChild, List<TreeNode> newChildren) {
        oldChild.forEach(e -> {
            if (!StrUtil.isNull((Object)nodeNameMap.get(e.getNodeName()))) {
                e.setNodeName(nodeNameMap.get(e.getNodeName()));
            }
        });
        Map oldMap = oldChild.stream().collect(Collectors.toMap(Dsn_Structure::getNodeName, Function.identity()));
        HashMap<String, TreeNode> md5OldMap = new HashMap<String, TreeNode>();
        oldMap.forEach((k, v) -> md5OldMap.put(Md5.md5((String)k.trim()), (TreeNode)((Object)v)));
        Map newMap = newChildren.stream().collect(Collectors.toMap(Dsn_Structure::getNodeName, Function.identity()));
        HashMap<String, TreeNode> md5NewMap = new HashMap<String, TreeNode>();
        newMap.forEach((k, v) -> md5NewMap.put(Md5.md5((String)k.trim()), (TreeNode)((Object)v)));
        md5OldMap.forEach((k, v) -> {
            if (StrUtil.isNull(md5NewMap.get(k))) {
                Dsn_Structure structure = new Dsn_Structure();
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)v.getNodeNo());
                this.dao.delete((AbsModel)structure);
            } else {
                TreeNode treeNode = (TreeNode)((Object)((Object)md5NewMap.get(k)));
                Dsn_Structure structure = new Dsn_Structure();
                structure.setRelateFk(treeNode.getRelateFk());
                structure.setRelateTab(treeNode.getRelateTab());
                structure.setRelateField(treeNode.getRelateField());
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)v.getNodeNo());
                this.dao.update((AbsModel)structure);
                this.dealBizAtr((TreeNode)((Object)v), treeNode);
            }
        });
        md5NewMap.forEach((key, e) -> {
            if (StrUtil.isNull(md5OldMap.get(key))) {
                DsnStructureNew structure = new DsnStructureNew();
                BeanUtils.copyProperties((Object)e, (Object)((Object)structure));
                structure.setUpNode(oldRiskDetail.getNodeNo());
                structure.setSerno(UniqueSeq.shortUUID());
                insert.add(structure);
                List<TreeNode> children = e.getChildren();
                this.deleteAtrr(noNeed, children);
            }
        });
    }

    private void dealBizAtr(TreeNode oldTreeNode, TreeNode newtreeNode) {
        Dsn_Biz_Attribute oldBiz = this.getDsnBizAttribute(oldTreeNode);
        Dsn_Biz_Attribute newBiz = this.getDsnBizAttribute(newtreeNode);
        this.dealBizAttrOption(oldBiz, newBiz);
    }

    private void dealBizAttrOption(Dsn_Biz_Attribute oldBiz, Dsn_Biz_Attribute newBiz) {
        List<Dsn_Biz_Attribute_Option> newBizOption = this.getDsnBizAttributeOption(newBiz);
        newBizOption.forEach(e -> e.setBizUuid(oldBiz.getBizUuid()));
        Dsn_Biz_Attribute_Option option = new Dsn_Biz_Attribute_Option();
        option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)oldBiz.getBizUuid());
        this.dao.delete((AbsModel)option);
        this.dao.save(newBizOption);
    }

    private List<Dsn_Biz_Attribute_Option> getDsnBizAttributeOption(Dsn_Biz_Attribute oldBiz) {
        Dsn_Biz_Attribute_Option option = new Dsn_Biz_Attribute_Option();
        option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)oldBiz.getBizUuid());
        return this.dao.findAll((AbsModel)option);
    }

    private Dsn_Biz_Attribute getDsnBizAttribute(TreeNode oldTreeNode) {
        Dsn_Biz_Attribute attribute = new Dsn_Biz_Attribute();
        attribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)oldTreeNode.getNodeNo());
        return (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)attribute);
    }

    private void deleteAtrr(List<DsnStructureNew> noNeed, List<TreeNode> children) {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>();
        TreeUtil.treeToList(children, treeList);
        if (!treeList.isEmpty()) {
            treeList.forEach(tree -> {
                DsnStructureNew structure = new DsnStructureNew();
                BeanUtils.copyProperties((Object)tree, (Object)((Object)structure));
                noNeed.add(structure);
            });
        }
    }

    private void dealSuRisk(TreeNode oldSubRisks, TreeNode newSubRisks, List<DsnStructureNew> insert, List<DsnStructureNew> noNeed, String productUuid) {
        List<TreeNode> oldChildren = oldSubRisks.getChildren();
        this.getNeedAttr(oldSubRisks, newSubRisks, insert, noNeed, oldChildren);
        this.treeAndKey(oldChildren);
        List<TreeNode> newChildren = newSubRisks.getChildren();
        this.treeAndKey(newChildren);
        if (null != oldChildren && null != newChildren && !oldChildren.isEmpty() && !newChildren.isEmpty()) {
            Map oldMap = oldChildren.stream().collect(Collectors.toMap(TreeNode::getKey, Function.identity()));
            Map newMap = newChildren.stream().collect(Collectors.toMap(TreeNode::getKey, Function.identity()));
            newChildren.forEach(e -> this.newRiskNeedInsert(oldSubRisks, insert, noNeed, oldMap, (TreeNode)((Object)e)));
            oldChildren.forEach(e -> {
                if (StrUtil.isNull(newMap.get(e.getKey()))) {
                    Dsn_Structure dsn = new Dsn_Structure();
                    dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getNodeNo());
                    this.dao.delete((AbsModel)dsn);
                } else {
                    Dsn_Structure dsn = new Dsn_Structure();
                    dsn.setNodeName(((TreeNode)((Object)((Object)newMap.get(e.getKey())))).getNodeName());
                    dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getNodeNo());
                    this.dao.update((AbsModel)dsn);
                    Sip_Risks risks = new Sip_Risks();
                    risks.setRiskName(((TreeNode)((Object)((Object)newMap.get(e.getKey())))).getRiskName());
                    String riskUuid = e.getRiskUuid();
                    risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUuid);
                    this.dao.update((AbsModel)risks);
                    List<TreeNode> oldSubChildren = e.getChildren();
                    List<TreeNode> newSubChildren = ((TreeNode)((Object)((Object)newMap.get(e.getKey())))).getChildren();
                    Map oldSubMap = oldSubChildren.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
                    Map newSubMap = newSubChildren.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
                    newSubMap.forEach((k, v) -> {
                        if (!"n_sub_risks".equalsIgnoreCase((String)k)) {
                            TreeNode newNode = v;
                            TreeNode oldNode = (TreeNode)((Object)((Object)((Object)oldSubMap.get(k))));
                            this.dealAttr(oldNode, newNode, insert, noNeed, oldNode.getKey(), productUuid);
                        }
                    });
                }
            });
        }
    }

    private void getNeedAttr(TreeNode oldSubRisks, TreeNode newSubRisks, List<DsnStructureNew> insert, List<DsnStructureNew> noNeed, List<TreeNode> oldChildren) {
        if (null == oldChildren && null != newSubRisks.getChildren()) {
            List<TreeNode> newChild = newSubRisks.getChildren();
            newChild.forEach(e -> {
                e.setUpNode(oldSubRisks.getNodeNo());
                e.setSerno(UniqueSeq.shortUUID());
                DsnStructureNew structure = new DsnStructureNew();
                BeanUtils.copyProperties((Object)e, (Object)((Object)structure));
                insert.add(structure);
                ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
                List<TreeNode> children = e.getChildren();
                TreeUtil.treeToList(children, nodeList);
                nodeList.forEach(dsn -> {
                    DsnStructureNew stru = new DsnStructureNew();
                    BeanUtils.copyProperties((Object)dsn, (Object)((Object)stru));
                    noNeed.add(stru);
                });
            });
        }
    }

    private void newRiskNeedInsert(TreeNode oldSubRisks, List<DsnStructureNew> insert, List<DsnStructureNew> noNeed, Map<String, TreeNode> oldMap, TreeNode e) {
        if (StrUtil.isNull((Object)((Object)oldMap.get(e.getKey())))) {
            List<TreeNode> children = e.getChildren();
            e.setSerno(UniqueSeq.shortUUID());
            e.setUpNode(oldSubRisks.getNodeNo());
            DsnStructureNew structure = new DsnStructureNew();
            BeanUtils.copyProperties((Object)((Object)e), (Object)((Object)structure));
            if (!StrUtil.isNull((Object)structure.getSerno())) {
                insert.add(structure);
            }
            ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
            TreeUtil.treeToList(children, nodeList);
            nodeList.forEach(k -> {
                DsnStructureNew dsnStructure = new DsnStructureNew();
                BeanUtils.copyProperties((Object)k, (Object)((Object)dsnStructure));
                noNeed.add(dsnStructure);
            });
        }
    }

    private void treeAndKey(List<TreeNode> oldChildren) {
        if (null != oldChildren) {
            oldChildren.forEach(e -> {
                List<TreeNode> children = e.getChildren();
                List treeNodes = children.stream().filter(f -> "n_sub_risks_detail".equalsIgnoreCase(f.getNodeType())).collect(Collectors.toList());
                TreeNode treeNode = (TreeNode)((Object)((Object)treeNodes.get(0)));
                Sip_Risks risks = new Sip_Risks();
                risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)treeNode.getNodeNo());
                Sip_Risks one = (Sip_Risks)this.dao.findOne((AbsModel)risks);
                e.setKey(one.getPolicyCode());
                e.setRiskName(one.getRiskName());
                e.setRiskUuid(one.getRiskUuid());
            });
        }
    }

    private void dealMainRisk(List<Dsn_Structure> newInsertDsn, String riskDetailUuid, Map<String, List<Sip_Risks>> oldRiskMap, List<Map<String, Object>> mainRiskTree, List<Sip_Risks> newDeleteRisk, List<DsnStructureNew> noNeed, String productUuid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskDetailUuid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_risk_detail");
        Dsn_Structure dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        Sip_Risks risks = new Sip_Risks();
        risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)dsnStructure.getNodeNo());
        Sip_Risks sipRisks = (Sip_Risks)this.dao.findOne((AbsModel)risks);
        if ("common-add".equalsIgnoreCase(sipRisks.getRiskNo())) {
            sipRisks.setPolicyCode(sipRisks.getRiskNo());
        }
        if (!StrUtil.isNull(oldRiskMap.get(sipRisks.getPolicyCode()))) {
            newInsertDsn.addAll(JsonUtil.listMap2ListClass(mainRiskTree, Dsn_Structure.class));
            newDeleteRisk.add(sipRisks);
            this.incrementSynchronousAccyRisk(oldRiskMap.get(sipRisks.getPolicyCode()).get(0), sipRisks, "M", mainRiskTree, noNeed, productUuid);
        }
    }

    public List<Map<String, Object>> getQuerySqlable(String riskUuid, String riskType) {
        ArrayList<Dsn_Structure> dsnList = new ArrayList<Dsn_Structure>();
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskUuid);
        Dsn_Structure one = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        dsnList.add(one);
        this.getTree(dsnList, riskUuid, riskType);
        return JsonUtil.json2List((String)JsonUtil.toJson(dsnList));
    }

    public TreeNode listToTree(List<Map<String, Object>> riskTreeList, TreeNode parentNo) {
        List dsnStructureList = JsonUtil.listMap2ListClass(riskTreeList, TreeNode.class);
        TreeUtil tree = new TreeUtil(dsnStructureList);
        List<TreeNode> treeNodes = tree.buildTree(parentNo);
        return treeNodes.get(0);
    }

    private void getTree(List<Dsn_Structure> dsnList, String upNode, String riskType) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
        if ("M".equalsIgnoreCase(riskType)) {
            structure.where().addNotEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
        }
        List parentList = this.dao.findAll((AbsModel)structure);
        dsnList.addAll(parentList);
        parentList.forEach(dsn -> this.getTree(dsnList, dsn.getNodeNo(), riskType));
    }

    private List<Sip_Risks> queryHasSaveRisk(List<Map<String, Object>> accyRisksUuid) {
        Dsn_Structure structure = new Dsn_Structure();
        accyRisksUuid.forEach(dsn -> structure.where().addIn((ModelField)Dsn_Structure.Field.up_node, StrUtil.trimStr(dsn.get("node_no"))));
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
        List dsnStructureList = this.dao.findAll((AbsModel)structure);
        Sip_Risks risks = new Sip_Risks();
        dsnStructureList.forEach(e -> risks.where().addIn((ModelField)Sip_Risks.Field.risk_uuid, e.getNodeNo()));
        return this.dao.findAll((AbsModel)risks);
    }

    private List<Map<String, Object>> queryAccyRiskList(String riskUuid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskUuid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        Dsn_Structure accyRsks = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)accyRsks.getNodeNo());
        return JsonUtil.json2List((String)JsonUtil.toJson((Object)this.dao.findAll((AbsModel)structure)));
    }

    static {
        ruleAttr.add("min_amount");
        ruleAttr.add("min_premium");
        ruleAttr.add("payment_duration");
        ruleAttr.add("payment_mode");
        ruleAttr.add("period_duration");
        exceptAttrNo.add("age");
        exceptAttrNo.add("premium");
        exceptAttrNo.add("faceAmnt");
        riskCodeMap.put("D4R", "NLsUpu9q");
        riskCodeMap.put("982", "dDlEfS7m");
        nodeNameMap.put("\u7f34\u8d39\u65b9\u5f0f", "\u4ea4\u8d39\u65b9\u5f0f");
    }
}

