/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.service.impl;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Products;
import com.newtouch.chinalife.service.IProductDealProductService;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductDealProductServiceImpl
extends BaseService
implements IProductDealProductService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public void dealProductRiskRealtion(String productCode) {
        Sip_Products products = new Sip_Products();
        products.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productCode);
        Sip_Products newProduct = (Sip_Products)this.dao.findOne((AbsModel)products);
        List<Dsn_Structure> structures = this.queryRiskByProductUuid(newProduct.getProductUuid());
        if (!structures.isEmpty()) {
            ArrayList risksList = new ArrayList();
            structures.forEach(dsn -> {
                Sip_Product_Risks risks = new Sip_Product_Risks();
                risks.setRiskUuid(dsn.getNodeNo());
                risks.setProductUuid(newProduct.getProductUuid());
                risks.setSerno(UniqueSeq.shortUUID());
                risksList.add(risks);
            });
            Sip_Product_Risks risks = new Sip_Product_Risks();
            risks.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)newProduct.getProductUuid());
            this.dao.delete((AbsModel)risks);
            this.dao.save(risksList);
        }
    }

    private List<Dsn_Structure> queryRiskByProductUuid(String productUuid) {
        String sql = "select * from dsn_structure where up_node in (\n    select node_no from  dsn_structure where up_node in (\n            select node_no from dsn_structure where up_node = ? and node_type = ?)\n            ) and node_type = ?";
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        querySql.setSql(sql);
        querySql.add((Object)productUuid);
        querySql.add((Object)"n_risk");
        querySql.add((Object)"n_risk_detail");
        List mainRiskList = this.dbHandle().queryList(querySql);
        return JsonUtil.listMap2ListClass((List)mainRiskList, Dsn_Structure.class);
    }
}

