/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.service.impl;

import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risks;
import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.newtouch.chinalife.dao.IRiskAttrDao;
import com.newtouch.chinalife.entity.bo.CoverageInfoBo;
import com.newtouch.chinalife.entity.bo.DetailBo;
import com.newtouch.chinalife.entity.bo.IprMoneyInfoBo;
import com.newtouch.chinalife.entity.bo.PolFactorsBo;
import com.newtouch.chinalife.entity.bo.PolFactorsListBo;
import com.newtouch.chinalife.entity.bo.PolicyCatBo;
import com.newtouch.chinalife.entity.bo.PrdFactorsBo;
import com.newtouch.chinalife.entity.bo.SubPolicyBo;
import com.newtouch.chinalife.entity.bo.UserdLabel;
import com.newtouch.chinalife.entity.vo.AttributeDetailVo;
import com.newtouch.chinalife.entity.vo.MdfAttrDetailVo;
import com.newtouch.chinalife.service.IConvertService;
import com.newtouch.config.ProductConfig;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConvertServiceImpl
implements IConvertService {
    @Autowired
    private AbsModelRepository dao;
    private static String paymentDuration = "payment_duration";
    private static String periodDuration = "period_duration";
    @Autowired
    private ProductConfig prdConf;
    @Autowired
    private IRiskAttrDao riskDao;
    protected static final Map<String, String> attrMap = new HashMap<String, String>();
    protected static final Map<String, String> uiTypeMap = new HashMap<String, String>();
    private static final List<String> exceptAttrNo = new ArrayList<String>();
    private String periodDurationTag = "I";
    private String paymentDurationTag = "M";
    private static final String TYPE_NO = "N";

    @Override
    public Map<String, Object> transReqMap(DetailBo chinaLifeBo) throws PinyinException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<HashMap<String, Object>> productMapList = new LinkedList<HashMap<String, Object>>();
        result.put("product_detail", productMapList);
        HashMap<String, Object> productMap = new HashMap<String, Object>();
        productMapList.add(productMap);
        String productType = this.dealProductDetail(productMap, chinaLifeBo.getPrdFactorsBo());
        List<Map<String, Object>> riskList = this.getRiskList(chinaLifeBo.getPrdFactorsBo().getPolFactorsListBo(), productType, productMap);
        productMap.put("risk_detail", riskList);
        ArrayList newRiskList = new ArrayList();
        riskList.forEach(e -> {
            newRiskList.add(e);
            List additionalRisk = (List)e.get("additional_risk");
            newRiskList.addAll(additionalRisk);
        });
        result.put("riskList", riskList);
        return result;
    }

    @Override
    public List<Map<String, Object>> getRiskList(List<PolFactorsListBo> polListBo, String productType, Map<String, Object> productMap) {
        LinkedList<Map<String, Object>> riskList = new LinkedList<Map<String, Object>>();
        HashMap<String, Object> mainMap = new HashMap<String, Object>();
        HashMap<String, Object> addRiskMap = new HashMap<String, Object>();
        HashMap<String, Object> addParentRiskMap = new HashMap<String, Object>();
        HashMap mainNo = new HashMap();
        polListBo.stream().forEach(polBo -> {
            HashMap<String, Object> riskMap = new HashMap<String, Object>();
            this.riskDetailDeal((Map<String, Object>)riskMap, (PolFactorsListBo)polBo);
            Map<String, Object> parentRiskAttrList = this.getRiskAttrList((PolFactorsListBo)polBo);
            String riskNo = StrUtil.trimStr(riskMap.get("risk_no"));
            List<Map<String, Object>> subRiskList = this.subRiskDeal(polBo.getIprMoneyInfoBos(), polBo.getPolicyCatBos(), polBo.getFaceAmntCode(), polBo.getSubPolicyBos(), parentRiskAttrList);
            riskMap.put("pol_sub_risk", subRiskList);
            if ("M".equals(riskMap.get("is_main_risk"))) {
                riskMap.put("additional_risk", new LinkedList());
                mainMap.put(riskNo, riskMap);
                mainNo.put(polBo.getPolCode(), riskNo);
            } else {
                if (this.prdConf.getCommon_prd_type().equals(productType)) {
                    riskMap.put("belong_product_no", productMap.get("product_no"));
                    riskMap.put("belong_product_name", productMap.get("product_name"));
                }
                addRiskMap.put(riskNo, riskMap);
                addParentRiskMap.put(riskNo, this.prdConf.getCommon_prd_type().equals(productType) ? this.prdConf.getCommon_add_parent_risk_no() : mainNo.get(polBo.getRefPolCode()));
            }
        });
        if (this.prdConf.getCommon_prd_type().equals(productType)) {
            mainMap.put(this.prdConf.getCommon_add_parent_risk_no(), this.getCommonMainRisk());
        }
        this.dealMainAndAuxiliaryRisks(mainMap, addRiskMap, addParentRiskMap);
        mainMap.forEach((k, mainRisk) -> riskList.add((Map)mainRisk));
        return riskList;
    }

    private void dealMainAndAuxiliaryRisks(Map<String, Object> mainMap, Map<String, Object> addRiskMap, Map<String, Object> addParentRiskMap) {
        if (!addParentRiskMap.isEmpty()) {
            addParentRiskMap.forEach((addRiskNo, mainRiskNo) -> {
                if (!StrUtil.isNull((Object)mainRiskNo)) {
                    Object mainRisk = mainMap.get(StrUtil.trimStr((Object)mainRiskNo));
                    if (mainRisk == null) {
                        throw new BusinessException("\u9644\u52a0\u9669\u914d\u7f6e\u7684\u4e3b\u9669\u4e0d\u5b58\u5728\u3002");
                    }
                    Map mainRiskMap = (Map)mainRisk;
                    List addRiskList = (List)mainRiskMap.get("additional_risk");
                    addRiskList.add(addRiskMap.get(addRiskNo));
                }
            });
        }
    }

    private boolean isShortInsurance(List<PolicyCatBo> policyCatBos) {
        boolean flag = false;
        for (PolicyCatBo cat : policyCatBos) {
            if (!cat.getCatCode().equals("202")) continue;
            flag = true;
        }
        return flag;
    }

    private boolean isUniversalInsurance(List<PolicyCatBo> policyCatBos) {
        boolean flag = false;
        for (PolicyCatBo cat : policyCatBos) {
            if (!cat.getCatCode().equals("904")) continue;
            flag = true;
        }
        return flag;
    }

    private Map<String, Object> getCommonMainRisk() {
        HashMap<String, Object> riskMap = new HashMap<String, Object>();
        Sip_Risks risk = this.riskDao.queryRiskByRiskNo(this.prdConf.getCommon_add_parent_risk_no());
        if (StrUtil.isNull((Object)risk.getRiskUuid())) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u901a\u7528\u9644\u52a0\u9669\u6a21\u677f\u7684risk_no\u3002");
        }
        Map riskTempMap = JsonUtil.json2Map((String)JsonUtil.toJson((Object)((Object)risk)));
        riskMap.putAll(riskTempMap);
        riskMap.put("additional_risk", new LinkedList());
        return riskMap;
    }

    private List<Map<String, Object>> subRiskDeal(List<IprMoneyInfoBo> payItrel, List<PolicyCatBo> policyCatBos, String isAmount, List<SubPolicyBo> subPolicyBos, Map<String, Object> parentRiskAttrList) {
        LinkedList<Map<String, Object>> subRiskList = new LinkedList<Map<String, Object>>();
        subPolicyBos.stream().forEach(subBo -> {
            HashMap<String, Object> riskMap = new HashMap<String, Object>();
            this.riskDetailDeal((Map<String, Object>)riskMap, (SubPolicyBo)subBo);
            List<Map<String, Object>> attrList = this.getRiskAttrList(payItrel, policyCatBos, isAmount, (SubPolicyBo)subBo, parentRiskAttrList);
            riskMap.put("attr_detail", attrList);
            subRiskList.add(riskMap);
        });
        return subRiskList;
    }

    private List<Map<String, Object>> getRiskAttrList(List<IprMoneyInfoBo> payItrel, List<PolicyCatBo> policyCatBos, String isAmount, SubPolicyBo subBo, Map<String, Object> parentRiskAttrList) {
        LinkedList<Map<String, Object>> attrList = new LinkedList<Map<String, Object>>();
        boolean isShort = this.isShortInsurance(policyCatBos);
        boolean isUniversal = this.isUniversalInsurance(policyCatBos);
        Map<String, Object> initPayMent = this.initPayMent(paymentDuration, parentRiskAttrList, payItrel);
        Map<String, Object> initPeriod = this.initPayMent(periodDuration, parentRiskAttrList, payItrel);
        attrList.add(initPayMent);
        attrList.add(initPeriod);
        if (!isUniversal) {
            Map<String, Object> initCalcMode = this.initCalcMode("calcMode ", isShort);
            attrList.add(initCalcMode);
        } else {
            Map<String, Object> initPremium = this.initCalcMode("premium", isShort);
            attrList.add(initPremium);
            Map<String, Object> initPay = this.initPayMent("payment_mode", parentRiskAttrList, payItrel);
            attrList.add(initPay);
        }
        subBo.getPolFactorsBos().stream().forEach(attrBo -> {
            String attrNo = attrBo.getMetaDataId();
            if ("moneyinDur".equals(attrNo) || "insureDur".equals(attrNo)) {
                return;
            }
            if (!exceptAttrNo.contains(attrNo)) {
                Map<String, Object> attrVoMap = this.attrDeal(isUniversal, isAmount, (PolFactorsBo)attrBo, parentRiskAttrList);
                attrList.add(attrVoMap);
            }
        });
        return attrList;
    }

    private Map<String, Object> initCalcMode(String type, boolean isShort) {
        AttributeDetailVo attrVo = new AttributeDetailVo();
        if ("calcMode ".equals(type)) {
            attrVo.setAttrNo("calc_mode");
            attrVo.setAttrName("\u6d4b\u7b97\u6a21\u5f0f");
            attrVo.setUiType("select");
            LinkedList<MdfAttrDetailVo> optionVos = new LinkedList<MdfAttrDetailVo>();
            AtomicInteger index = new AtomicInteger();
            MdfAttrDetailVo madVo = new MdfAttrDetailVo();
            madVo.setOptionName("\u4fdd\u989d\u7b97\u4fdd\u8d39");
            madVo.setOptionValue("faceAmnt");
            madVo.setOptionOrder(String.valueOf(index.incrementAndGet()));
            MdfAttrDetailVo madVo1 = new MdfAttrDetailVo();
            madVo1.setOptionName("\u4fdd\u8d39\u7b97\u4fdd\u989d");
            madVo1.setOptionValue("premium");
            madVo1.setOptionOrder(String.valueOf(index.incrementAndGet()));
            if (isShort) {
                optionVos.add(madVo);
            } else {
                optionVos.add(madVo);
                optionVos.add(madVo1);
            }
            attrVo.setOptions(optionVos);
        } else if ("premium".equals(type)) {
            attrVo.setAttrNo("initial_premium");
            attrVo.setAttrName("\u4fdd\u8d39");
            attrVo.setUiType("readonly");
            LinkedList<MdfAttrDetailVo> optionVos = new LinkedList<MdfAttrDetailVo>();
            attrVo.setOptions(optionVos);
        }
        return JsonUtil.json2Map((String)JsonUtil.toJson((Object)attrVo));
    }

    private Map<String, Object> initPayMent(String type, Map<String, Object> parentRiskAttrList, List<IprMoneyInfoBo> payItrel) {
        AttributeDetailVo attrVo = new AttributeDetailVo();
        LinkedList<MdfAttrDetailVo> optionVos = new LinkedList<MdfAttrDetailVo>();
        if (paymentDuration.equals(type)) {
            List optionVoTemp = (List)parentRiskAttrList.get(paymentDuration);
            attrVo.setAttrNo(paymentDuration);
            attrVo.setAttrName("\u4ea4\u8d39\u671f\u95f4");
            attrVo.setUiType("select");
            attrVo.setOptions(optionVoTemp);
        } else if (periodDuration.equals(type)) {
            List optionVoTemp = (List)parentRiskAttrList.get(periodDuration);
            attrVo.setAttrNo(periodDuration);
            attrVo.setAttrName("\u4fdd\u9669\u671f\u95f4");
            attrVo.setUiType("select");
            attrVo.setOptions(optionVoTemp);
        } else if ("payment_mode".equals(type)) {
            AtomicInteger index = new AtomicInteger();
            payItrel.forEach(optionBo -> {
                MdfAttrDetailVo madVo = new MdfAttrDetailVo();
                madVo.setOptionName(optionBo.getPayItrvlCodeDesc());
                madVo.setOptionValue(optionBo.getPayItrvlCode());
                madVo.setOptionOrder(String.valueOf(index.incrementAndGet()));
                optionVos.add(madVo);
            });
            attrVo.setAttrNo("payment_mode");
            attrVo.setAttrName("\u4ea4\u8d39\u65b9\u5f0f");
            attrVo.setUiType("select");
            attrVo.setOptions(optionVos);
        }
        return JsonUtil.json2Map((String)JsonUtil.toJson((Object)attrVo));
    }

    private Map<String, Object> attrDeal(boolean isUnversal, String isAmount, PolFactorsBo attrBo, Map<String, Object> parentRiskAttrList) {
        AttributeDetailVo attrVo = new AttributeDetailVo();
        String attrNo = attrBo.getMetaDataId();
        if (!isUnversal) {
            attrNo = StrUtil.isNull((Object)attrMap.get(attrNo)) ? attrNo : attrMap.get(attrNo);
            attrVo.setAttrNo(attrNo);
            attrVo.setAttrName(attrBo.getMetaDataDesc());
            String uiType = StrUtil.isNull((Object)uiTypeMap.get(attrNo)) ? this.getUiType(attrBo.getMetaDataDispType()) : uiTypeMap.get(attrNo);
            attrVo.setUiType(uiType);
            LinkedList optionVoTemp = (LinkedList)parentRiskAttrList.get(attrNo);
            if (StrUtil.isNull((Object)optionVoTemp) || optionVoTemp.isEmpty()) {
                LinkedList optionVos = new LinkedList();
                AtomicInteger index = new AtomicInteger();
                attrBo.getMetaDataValue().stream().forEach(optionBo -> {
                    MdfAttrDetailVo madVo = new MdfAttrDetailVo();
                    madVo.setOptionName(optionBo.getKey());
                    madVo.setOptionValue(optionBo.getValue());
                    madVo.setOptionOrder(String.valueOf(index.incrementAndGet()));
                    optionVos.add(madVo);
                });
                optionVoTemp = optionVos;
            }
            attrVo.setOptions(optionVoTemp);
        } else if ("faceAmnt".equals(attrNo) && "0".equals(isAmount)) {
            attrNo = StrUtil.isNull((Object)attrMap.get(attrNo)) ? attrNo : attrMap.get(attrNo);
            attrVo.setAttrNo(attrNo);
            attrVo.setAttrName(attrBo.getMetaDataDesc());
            attrVo.setUiType("readonly");
            LinkedList optionVoTemp = (LinkedList)parentRiskAttrList.get(attrNo);
            if (StrUtil.isNull((Object)optionVoTemp) || optionVoTemp.isEmpty()) {
                LinkedList optionVos = new LinkedList();
                AtomicInteger index = new AtomicInteger();
                attrBo.getMetaDataValue().stream().forEach(optionBo -> {
                    MdfAttrDetailVo madVo = new MdfAttrDetailVo();
                    madVo.setOptionName(optionBo.getKey());
                    madVo.setOptionValue(optionBo.getValue());
                    madVo.setOptionOrder(String.valueOf(index.incrementAndGet()));
                    optionVos.add(madVo);
                });
                optionVoTemp = optionVos;
            }
            attrVo.setOptions(optionVoTemp);
        }
        return JsonUtil.json2Map((String)JsonUtil.toJson((Object)attrVo));
    }

    private String getUiType(String metaDataDispType) {
        String uiType = "";
        switch (metaDataDispType) {
            case "combobox": {
                uiType = "select";
                break;
            }
            case "input": {
                uiType = "text";
                break;
            }
            default: {
                uiType = "text";
            }
        }
        return uiType;
    }

    private Map<String, Object> getRiskAttrList(PolFactorsListBo polBo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (polBo.getPolicyDurBos() == null || polBo.getPolicyDurBos().isEmpty()) {
            return resultMap;
        }
        LinkedList periodDurationOptions = new LinkedList();
        LinkedList paymentDurationOptions = new LinkedList();
        polBo.getPolicyDurBos().stream().forEach(attr -> {
            MdfAttrDetailVo madVo = new MdfAttrDetailVo();
            if ("W".equals(attr.getDurUnit()) || "C".equals(attr.getDurUnit()) || "B".equals(attr.getDurUnit()) || "#".equals(attr.getDurUnit())) {
                madVo.setOptionName(attr.getDurUnitDesc());
                madVo.setOptionValue(attr.getDurAmnt());
                madVo.setOptionOrder(attr.getDurAmnt());
            } else {
                madVo.setOptionName(attr.getDurAmnt() + attr.getDurUnitDesc());
                madVo.setOptionValue(attr.getDurAmnt());
                madVo.setOptionOrder(attr.getDurAmnt());
            }
            if (this.periodDurationTag.equals(attr.getDurCode())) {
                periodDurationOptions.add(madVo);
            }
            if (this.paymentDurationTag.equals(attr.getDurCode())) {
                paymentDurationOptions.add(madVo);
            }
        });
        resultMap.put(periodDuration, periodDurationOptions);
        resultMap.put(paymentDuration, paymentDurationOptions);
        return resultMap;
    }

    private void riskDetailDeal(Map<String, Object> riskMap, SubPolicyBo subBo) {
        Sip_Risks risk = new Sip_Risks();
        String policyId = StrUtil.trimStr((Object)subBo.getSubPolId());
        risk.setPolicyId(policyId);
        String policyCode = StrUtil.trimStr((Object)subBo.getSubPolCode());
        risk.setPolicyCode(policyCode);
        String riskName = StrUtil.trimStr((Object)subBo.getSubPolName());
        risk.setRiskName(riskName);
        risk.setRiskNo(this.getRiskNo(policyId));
        risk.setIsBenefit(StrUtil.trimStr((Object)subBo.getExistFlag()));
        risk.setIsAnn(StrUtil.trimStr((Object)subBo.getIsAnnFlag()));
        risk.setIsDividend(StrUtil.trimStr((Object)subBo.getIsBonusFlag()));
        risk.setIsWaiver(StrUtil.trimStr((Object)subBo.getIsDerateFlag()));
        risk.setWaiverRisk(subBo.getDerateRange());
        risk.setIsMainRisk("S");
        List<CoverageInfoBo> coverageInfoBos = subBo.getCoverageInfoBos();
        if (null != coverageInfoBos && !coverageInfoBos.isEmpty()) {
            StringBuilder dutyType = new StringBuilder();
            for (CoverageInfoBo duty : coverageInfoBos) {
                dutyType.append(duty.getCoverageCode() + ",");
            }
            risk.setDutyType(dutyType.toString().substring(0, dutyType.toString().length() - 1));
        }
        this.defaultSet(risk);
        Map riskTempMap = JsonUtil.json2Map((String)JsonUtil.toJson((Object)((Object)risk)));
        riskMap.putAll(riskTempMap);
    }

    private void defaultSet(Sip_Risks risk) {
        Date now = new Date();
        if (risk.getStartDate() == null) {
            risk.setStartDate(now);
        }
        if (risk.getEndDate() == null) {
            risk.setEndDate(now);
        }
        if (risk.getEndDate() == null) {
            risk.setEndDate(now);
        }
        if (StrUtil.isNull((Object)risk.getIsBenefit())) {
            risk.setIsBenefit(TYPE_NO);
        }
        if (StrUtil.isNull((Object)risk.getIsDividend())) {
            risk.setIsDividend(TYPE_NO);
        }
        risk.setCrtDate(now);
        risk.setMdfDate(now);
    }

    private void riskDetailDeal(Map<String, Object> riskMap, PolFactorsListBo polBo) {
        Sip_Risks risk = new Sip_Risks();
        String isRequired = polBo.getSubPolicyBos().get(0).getSaleServeOption();
        String policyId = StrUtil.trimStr((Object)polBo.getPolCode());
        risk.setPolicyCode(policyId);
        String riskName = StrUtil.trimStr((Object)polBo.getPolNameChn());
        risk.setRiskName(riskName);
        risk.setIsAmount(polBo.getFaceAmntCode());
        risk.setRiskNo(this.getRiskNo(policyId));
        risk.setIsBenefit(StrUtil.trimStr((Object)polBo.getExistFlag()));
        risk.setIsAnn(StrUtil.trimStr((Object)polBo.getIsAnnFlag()));
        risk.setIsDividend(StrUtil.trimStr((Object)polBo.getIsBonusFlag()));
        risk.setIsWaiver(StrUtil.trimStr((Object)polBo.getIsDerateFlag()));
        risk.setIsMainRisk(this.getRiskType(polBo.getMrCode()));
        risk.setRiskClassify(this.getRiskClass(polBo.getPolicyCatBos()));
        risk.setUnionCode(polBo.getUnionCode());
        risk.setTransferCode(polBo.getTransferCode());
        this.defaultSet(risk);
        Map riskTempMap = JsonUtil.json2Map((String)JsonUtil.toJson((Object)((Object)risk)));
        riskTempMap.put("is_required", isRequired);
        riskMap.putAll(riskTempMap);
    }

    private String getRiskNo(String policyId) {
        String riskNo = UniqueSeq.shortUUID();
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.policy_code, (Object)policyId);
        risk = (Sip_Risks)this.dao.findOne((AbsModel)risk);
        riskNo = StrUtil.isNull((Object)risk.getRiskNo()) ? riskNo : risk.getRiskNo();
        return riskNo;
    }

    private String getRiskClass(List<PolicyCatBo> policyCatBos) {
        if (null == policyCatBos || policyCatBos.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        policyCatBos.stream().forEach(policyCatBo -> sb.append(policyCatBo.getCatCode()).append(","));
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    private String getRiskType(String mrCode) {
        String type = "";
        switch (mrCode) {
            case "M": {
                type = "M";
                break;
            }
            case "R": {
                type = "A";
                break;
            }
        }
        return type;
    }

    private String dealProductDetail(Map<String, Object> productMap, PrdFactorsBo prdFactorsBo) throws PinyinException {
        String productType = prdFactorsBo.getPrdType();
        Sip_Products products = new Sip_Products();
        if (this.prdConf.getCommon_prd_type().equals(productType)) {
            String templateRiskUUID = this.riskDao.getRiskUUIDByRiskNo(this.prdConf.getCommon_add_parent_risk_no());
            if (StrUtil.isNull((Object)templateRiskUUID)) {
                throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u901a\u7528\u9644\u52a0\u9669\u6a21\u677f\u7684risk_no\u3002");
            }
            String prduuid = this.riskDao.getPrduuidByRiskUUID(templateRiskUUID);
            products.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)prduuid);
            products = (Sip_Products)this.dao.findOne((AbsModel)products);
            Map productTempMap = JsonUtil.json2Map((String)JsonUtil.toJson((Object)((Object)products)));
            productMap.putAll(productTempMap);
            return productType;
        }
        products.setOpenState("WAIT");
        List<UserdLabel> userdLabel = prdFactorsBo.getUserdLabel();
        StringBuilder productTip = new StringBuilder();
        for (UserdLabel tip : userdLabel) {
            productTip.append(tip.getMarkEngName()).append(",");
        }
        products.setProductTip(productTip.toString().substring(0, productTip.toString().length() - 1));
        products.setProductName(StrUtil.trimStr((Object)prdFactorsBo.getPrdName()));
        products.setProductNo(StrUtil.trimStr((Object)prdFactorsBo.getPrdCode()));
        products.setMinAge(prdFactorsBo.getAgeValueFrom() + prdFactorsBo.getValueFromUnit());
        products.setMaxAge(prdFactorsBo.getAgeValueTo() + prdFactorsBo.getValueToUnit());
        products.setEndDate(this.getDate(prdFactorsBo.getPrdEndDate()));
        products.setStartDate(this.getDate(prdFactorsBo.getPrdStartDate()));
        products.setSex(prdFactorsBo.getSex());
        products.setState(StrUtil.trimStr((Object)prdFactorsBo.getPrdStatus()));
        products.setProductType(StrUtil.trimStr((Object)prdFactorsBo.getPrdType()));
        products.setProductSlogan(prdFactorsBo.getPrdDes());
        products.setSpecialAgreement(prdFactorsBo.getPolliciTation());
        String pinyinString = PinyinHelper.convertToPinyinString((String)StrUtil.trimStr((Object)prdFactorsBo.getPrdName()), (String)"", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
        products.setProductNamePinyin(pinyinString);
        this.defaultSet(products);
        Map productTempMap = JsonUtil.json2Map((String)JsonUtil.toJson((Object)((Object)products)));
        productMap.putAll(productTempMap);
        return productType;
    }

    private void defaultSet(Sip_Products products) {
        Date now = new Date();
        if (products.getShelfDate() == null) {
            products.setShelfDate(now);
        }
        if (products.getStartDate() == null) {
            products.setStartDate(now);
        }
        if (products.getEndDate() == null) {
            products.setEndDate(now);
        }
        products.setCrtDate(now);
        products.setMdfDate(now);
    }

    private Date getDate(String dateStr) {
        Date sysDate;
        try {
            sysDate = DateUtil.str2Timestamp((String)dateStr.substring(0, 19));
        }
        catch (Exception e) {
            sysDate = new Date();
        }
        return sysDate;
    }

    static {
        attrMap.put("faceAmnt", "insured_amount");
        uiTypeMap.put("insured_amount", "text");
        attrMap.put("faceAmntList", "insured_amount");
        uiTypeMap.put("insured_amount", "text");
        attrMap.put("premium", "initial_premium");
        uiTypeMap.put("initial_premium", "text");
        attrMap.put("insureDur", periodDuration);
        uiTypeMap.put(periodDuration, "select");
        attrMap.put("payItrvlCode", "payment_mode");
        uiTypeMap.put("payment_mode", "select");
        attrMap.put("moneyinDur", paymentDuration);
        uiTypeMap.put(paymentDuration, "select");
        attrMap.put("occClassNo", "occupation");
        uiTypeMap.put("occupation", "radio");
        attrMap.put("renewFlag", "is_auto_renewal");
        attrMap.put("annDrawAge", "annuity_start_age");
        uiTypeMap.put("annuity_start_age", "select");
        uiTypeMap.put("applAgeRange", "radio");
        exceptAttrNo.add("sex");
        exceptAttrNo.add("age");
    }
}

