/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.dao.impl;

import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Organ_Product_Info;
import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.model.Sip_Organ_Risk_Info;
import cn.com.chinalife.model.Sip_Products;
import com.newtouch.chinalife.dao.IProductDao;
import com.newtouch.chinalife.util.JsonUtils;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductDaoImpl
implements IProductDao {
    @Autowired
    private AbsModelRepository dao;

    public void dealPrdInfo(Map<String, Object> productResult, List<Map<String, Object>> organPrdList) {
        for (Map<String, Object> prd : organPrdList) {
            String key = StrUtil.trimStr((Object)prd.get("attr_no"));
            String value = StrUtil.trimStr((Object)prd.get("attr_value"));
            if ("product_tip".equals(key)) {
                String value1 = StrUtil.trimStr((Object)productResult.get("product_tip"));
                value = JsonUtils.getUnion(value1, value, ",");
            }
            productResult.put(key, value);
        }
    }

    @Override
    public List<Map<String, Object>> queryProductDetail(Map<String, Object> param) {
        String queryAttr;
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        Dsn_Structure dsnStructure = new Dsn_Structure();
        String organPrdUuid = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        String productUuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        String nodeType = "prd_detail";
        List attrList = null;
        List optionList = null;
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
        dsnStructure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUuid);
        List nodeSeqList = this.dao.findAll((AbsModel)dsnStructure, false);
        for (Dsn_Structure node : nodeSeqList) {
            queryAttr = "SELECT * FROM dsn_structure str join dsn_biz_attribute attr  on str.node_no = attr.biz_uuid WHERE str.node_seq like ?";
            querySql.add((Object)("%" + node.getNodeNo() + "%"));
            querySql.setSql(queryAttr);
            attrList = this.dao.findAll(querySql);
            querySql.clearParam();
        }
        if (null != attrList && !attrList.isEmpty()) {
            for (Map attr : attrList) {
                queryAttr = "select * from dsn_biz_attribute_option where biz_uuid = ?  order by option_order";
                querySql.add(attr.get("biz_uuid"));
                querySql.setSql(queryAttr);
                optionList = this.dao.findAll(querySql);
                querySql.clearParam();
                attr.put("attrOption", optionList);
            }
            this.getFieldValueOrgan(attrList, productUuid, organPrdUuid);
        }
        return attrList;
    }

    @Override
    public Map<String, Object> getFieldValueApp(List<Map<String, Object>> attrList) {
        HashMap<String, Object> attrValueNew = new HashMap<String, Object>();
        for (Map<String, Object> attrValue : attrList) {
            String key = (String)attrValue.get("attr_no");
            Object value = attrValue.get("field_value");
            attrValueNew.put(key, value);
            if (!"product_no".equals(key)) continue;
            attrValueNew.put("product_code", value);
        }
        return attrValueNew;
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, String productUuid, String organPrdUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryProduct = "select * from sip_products where product_uuid = ?";
        querySql.add((Object)productUuid);
        querySql.setSql(queryProduct);
        List productInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        Map product = productInfo.isEmpty() ? null : (Map)productInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            String storedTab = StrUtil.trimStr((Object)attrValue.get("stored_tab"));
            String storedField = StrUtil.trimStr((Object)attrValue.get("stored_field"));
            String attrUuid = StrUtil.trimStr((Object)attrValue.get("attr_uuid"));
            if ("sip_products".equalsIgnoreCase(storedTab) && null != product) {
                attrValue.put("field_value", product.get(storedField));
            }
            if (StrUtil.isNull((Object)organPrdUuid)) continue;
            String queryOrganProduct = "select * from sip_organ_product_info where organ_prd_uuid = ? and attr_uuid = ?";
            querySql.add((Object)organPrdUuid);
            querySql.add((Object)attrUuid);
            querySql.setSql(queryOrganProduct);
            List organProductInfo = this.dao.findAll(querySql);
            querySql.clearParam();
            Map organ = organProductInfo.isEmpty() ? null : (Map)organProductInfo.get(0);
            if (null == organ) continue;
            attrValue.put("field_value", organ.get("attr_value"));
        }
    }

    @Override
    public List<Dsn_Structure> queryRiskInfo(Map<String, Object> param) {
        Ulog.info((String)("\u6839\u636eproduct_uuid\u67e5\u8be2\u4e3b\u9669\u4fe1\u606f\u7684\u5165\u53c2\uff1a" + JsonUtil.toJson(param)));
        String productUuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUuid);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"main_risks");
        List riskInfo = this.dao.findAll((AbsModel)dsnStructure);
        Ulog.info((String)("\u6839\u636eproduct_uuid\u67e5\u8be2\u4e3b\u9669\u4fe1\u606f\u7684\u8fd4\u53c2\uff1a" + JsonUtil.toJson((Object)riskInfo)));
        return riskInfo;
    }

    @Override
    public void saveProductInfo(List<Map<String, Object>> request, Map<String, Object> product, String organPrdUuid) {
        Sip_Organ_Product_Info daoProduct = new Sip_Organ_Product_Info();
        for (Map<String, Object> oldProduct : request) {
            String newValue;
            String key = StrUtil.trimStr((Object)oldProduct.get("attr_no"));
            String value = StrUtil.trimStr((Object)oldProduct.get("field_value"));
            if (value.equals(newValue = StrUtil.trimStr((Object)product.get(key))) || StrUtil.isNull((Object)newValue)) continue;
            Sip_Organ_Product_Info sipOrganProduct = new Sip_Organ_Product_Info();
            sipOrganProduct.setAllowMdf(oldProduct.get("allow_mdf").toString());
            sipOrganProduct.setAttrNo(oldProduct.get("attr_no").toString());
            sipOrganProduct.setAttrUuid(oldProduct.get("attr_uuid").toString());
            sipOrganProduct.setAttrValue(newValue);
            sipOrganProduct.setOrganPrdUuid(organPrdUuid);
            daoProduct.where().addEq((ModelField)Sip_Organ_Product_Info.Field.organ_prd_uuid, (Object)organPrdUuid);
            daoProduct.where().addEq((ModelField)Sip_Organ_Product_Info.Field.attr_uuid, (Object)oldProduct.get("attr_uuid").toString());
            this.dao.delete((AbsModel)daoProduct);
            this.dao.save((AbsModel)sipOrganProduct);
        }
    }

    @Override
    public void saveRiskInfo(Map<String, Object> riskInfo, Map<String, Object> request, String organPrd, String value) {
        Sip_Organ_Risk_Info daoRisk = new Sip_Organ_Risk_Info();
        Sip_Organ_Risk_Info sipOrganRisk = new Sip_Organ_Risk_Info();
        sipOrganRisk.setAllowMdf(StrUtil.trimStr((Object)riskInfo.get("allow_mdf")));
        sipOrganRisk.setAttrNo(StrUtil.trimStr((Object)riskInfo.get("attr_no")));
        sipOrganRisk.setAttrUuid(StrUtil.trimStr((Object)riskInfo.get("attr_uuid")));
        sipOrganRisk.setRiskUuid(StrUtil.trimStr((Object)request.get("risk_uuid")));
        sipOrganRisk.setOrganPrdUuid(organPrd);
        sipOrganRisk.setAttrValue(value);
        daoRisk.where().addEq((ModelField)Sip_Organ_Risk_Info.Field.organ_prd_uuid, (Object)organPrd);
        daoRisk.where().addEq((ModelField)Sip_Organ_Risk_Info.Field.attr_uuid, (Object)riskInfo.get("attr_uuid").toString());
        this.dao.delete((AbsModel)daoRisk);
        this.dao.save((AbsModel)sipOrganRisk);
    }

    @Override
    public String getProductUUIDByProductNo(String productNo) {
        Sip_Products sipProducts4Query = new Sip_Products();
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.data_flag, (Object)"1");
        Sip_Products sipProducts = (Sip_Products)this.dao.findOne((AbsModel)sipProducts4Query);
        return sipProducts.getProductUuid();
    }

    @Override
    public String getProductDetailNodeByProductUUid(String productUUid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUUid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd_detail");
        List structureList = this.dao.findAll((AbsModel)structure);
        return structureList.isEmpty() ? "" : ((Dsn_Structure)((Object)structureList.get(0))).getNodeNo();
    }

    @Override
    public Dsn_Structure getMainParentNodeByProductUUid(String productUUid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUUid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_risk");
        List structureList = this.dao.findAll((AbsModel)structure);
        return structureList.isEmpty() ? null : (Dsn_Structure)((Object)structureList.get(0));
    }

    @Override
    public Sip_Products queryProductByProductNo(String productNo) {
        Sip_Products products = new Sip_Products();
        products.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        List sipProducts = this.dao.findAll((AbsModel)products);
        return sipProducts == null || sipProducts.isEmpty() ? null : (Sip_Products)((Object)sipProducts.get(0));
    }

    @Override
    public Sip_Organ_Products queryOrganProduct(Map<String, Object> request) {
        Sip_Organ_Products sipOrgan = new Sip_Organ_Products();
        Sip_Organ_Products result = null;
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.product_uuid, request.get("product_uuid"));
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.organ_id, request.get("organ_id"));
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.channel_no, request.get("channel_no"));
        List product = this.dao.findAll((AbsModel)sipOrgan, false);
        if (null != product && !product.isEmpty()) {
            result = (Sip_Organ_Products)((Object)product.get(0));
        }
        return result;
    }

    @Override
    public String getUpNode(String nodeNo) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        Dsn_Structure dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        return dsnStructure.getUpNode();
    }
}

