/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chinalife.dao.impl;

import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.model.Sip_Products;
import com.newtouch.chinalife.dao.IBranchDao;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.string.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BranchDaoImpl
implements IBranchDao {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public Map<String, Object> productOragnQueryByOrgan(Map<String, Object> param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder organId = new StringBuilder();
        StringBuilder channel = new StringBuilder();
        String organPrdUuid = (String)param.get("organ_prd_uuid");
        String query = "SELECT *  from sip_organ_products  where organ_prd_uuid = ?";
        querySql.add((Object)organPrdUuid);
        querySql.setSql(query);
        List findAll = this.dao.findAll(querySql);
        querySql.clearParam();
        for (Map map2 : findAll) {
            String organid = (String)map2.get("organ_id");
            String channelType = (String)map2.get("channel_no");
            if (StrUtil.isNull((Object)organId.toString()) || !organId.toString().contains(organid)) {
                organId.append(organid).append(",");
            }
            if (StrUtil.isNull((Object)channel.toString()) || !channel.toString().contains(channelType)) {
                channel.append(channelType).append(",");
            }
            map.put("organ_prd_uuid", map2.get("organ_prd_uuid"));
            map.put("product_uuid", map2.get("product_uuid"));
            map.put("prp_start_date", map2.get("prp_start_date"));
            map.put("prp_end_date", map2.get("prp_end_date"));
            map.put("pol_start_date", map2.get("prp_start_date"));
            map.put("pol_end_date", map2.get("prp_end_date"));
            map.put("data_flag", map2.get("data_flag"));
        }
        map.put("organ_id", organId.toString().substring(0, organId.toString().length() - 1));
        map.put("channel_no", channel.toString().substring(0, channel.toString().length() - 1));
        return map;
    }

    @Override
    public void saveProductOrgan(List<Sip_Organ_Products> oldData, List<Sip_Organ_Products> request) {
        Sip_Organ_Products sipOrgan = new Sip_Organ_Products();
        if (null == oldData || oldData.isEmpty()) {
            this.dao.save(request);
        } else {
            sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.organ_prd_uuid, (Object)oldData.get(0).getOrganPrdUuid());
            this.dao.delete((AbsModel)sipOrgan);
            this.dao.save(request);
        }
    }

    @Override
    public boolean queryProductRedisBranch(Map<String, Object> param) {
        boolean flag = true;
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String query = "select organ_prd_uuid from sip_organ_products t where t.product_uuid =? and t.organ_id=? and channel_no=?";
        querySql.add(param.get("product_uuid"));
        querySql.add(param.get("organ_id"));
        querySql.add(param.get("channel_no"));
        querySql.setSql(query);
        List findAll = this.dao.findAll(querySql);
        if (null == findAll || findAll.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    @Override
    public void updateProduct(Map<String, Object> param) {
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        String productUuid = StrUtil.trimStr((Object)"product_uuid");
        Sip_Products sipProduct = new Sip_Products();
        sipProduct.setOrganId(organId);
        sipProduct.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUuid);
        this.dao.update((AbsModel)sipProduct);
    }
}

