/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.ajax;

import com.newtouch.log.Ulog;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.pojo.Message;
import com.newtouch.spring.SpringContext;
import com.newtouch.util.json.JsonUtilOld;
import com.newtouch.util.string.StrUtil;
import com.newtouch.web.BaseController;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CallAjaxController
extends BaseController {
    @RequestMapping(value={"/callAjax.do"})
    public String doCallAjax(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map dataMap = this.getRequestMap(request);
        String classname = StrUtil.trimStr(dataMap.get("classname"));
        String method = StrUtil.trimStr(dataMap.get("method"));
        Object obj = SpringContext.getBean(classname);
        Class[] argTypes = new Class[]{Map.class};
        Method method1 = obj.getClass().getMethod(method, argTypes);
        Object[] argValues = new Object[]{dataMap};
        ReturnMsg returnMsg = (ReturnMsg)method1.invoke(obj, argValues);
        HashMap<String, String> alert = new HashMap<String, String>();
        int i = 0;
        for (Message msg : returnMsg.getMsgList()) {
            alert.put("ajaxtype", "alert");
            alert.put(msg.getMsgCode() + i, msg.getMsgRemark());
            ++i;
        }
        if (!alert.isEmpty()) {
            returnMsg.getDataList().add(alert);
        }
        String json = this.toJson(returnMsg.getDataList());
        Ulog.info((String)("CallAjax\u8fd4\u56deJson=" + json));
        response.setContentType("application/json;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print(json);
        out.flush();
        out.close();
        return CallAjaxController.return2Json((ReturnMsg)returnMsg);
    }

    private String toJson(List<Map<String, Object>> returnMsg) throws Exception {
        HashMap<String, Object> alert = new HashMap<String, Object>();
        HashMap<String, Object> focus = new HashMap<String, Object>();
        HashMap<String, Object> style = new HashMap<String, Object>();
        HashMap<String, Object> msg = new HashMap<String, Object>();
        HashMap<String, Object> readonly = new HashMap<String, Object>();
        HashMap<String, Object> disabled = new HashMap<String, Object>();
        HashMap<String, Object> edit = new HashMap<String, Object>();
        HashMap<String, Object> select = new HashMap<String, Object>();
        HashMap<String, Object> input = new HashMap<String, Object>();
        HashMap<String, Object> grid = new HashMap<String, Object>();
        for (Map<String, Object> map : returnMsg) {
            this.toJson("alert", map, alert);
            this.toJson("focus", map, focus);
            this.toJson("style", map, style);
            this.toJson("msg", map, msg);
            this.toJson("readonly", map, readonly);
            this.toJson("disabled", map, disabled);
            this.toJson("edit", map, edit);
            this.toJson("input", map, input);
            this.gridToJson(map, grid);
            this.selectToJson(map, select);
        }
        HashMap<String, HashMap<String, Object>> jsonPage = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, HashMap<String, HashMap<String, Object>>> returnJson = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
        if (!alert.isEmpty()) {
            jsonPage.put("alert", alert);
        }
        if (!focus.isEmpty()) {
            jsonPage.put("focus", focus);
        }
        if (!style.isEmpty()) {
            jsonPage.put("style", style);
        }
        if (!msg.isEmpty()) {
            jsonPage.put("msg", msg);
        }
        if (!readonly.isEmpty()) {
            jsonPage.put("readonly", readonly);
        }
        if (!disabled.isEmpty()) {
            jsonPage.put("disabled", disabled);
        }
        if (!edit.isEmpty()) {
            jsonPage.put("edit", edit);
        }
        if (!select.isEmpty()) {
            jsonPage.put("select", select);
        }
        if (!input.isEmpty()) {
            jsonPage.put("input", input);
        }
        if (!grid.isEmpty()) {
            jsonPage.put("grid", grid);
        }
        if (!jsonPage.isEmpty()) {
            returnJson.put("data", jsonPage);
        }
        return JsonUtilOld.formatJSONObject(returnJson);
    }

    private void toJson(String type, Map<String, Object> map, Map<String, Object> json) {
        if (map.get("ajaxtype") == null || !type.equals(map.get("ajaxtype"))) {
            return;
        }
        for (String key : map.keySet()) {
            if ("ajaxtype".equals(key)) continue;
            Ulog.debug((String)(key + " | " + map.get(key)));
            json.put(key, map.get(key) != null ? StrUtil.trimStr((Object)map.get(key)) : map.get(key));
        }
    }

    private void selectToJson(Map<String, Object> map, Map<String, Object> json) {
        if (map.get("ajaxtype") == null || !"select".equals(map.get("ajaxtype"))) {
            return;
        }
        for (String key : map.keySet()) {
            if ("ajaxtype".equals(key)) continue;
            if ("ajaxscope".equals(key)) {
                json.put("ajaxscope", map.get(key));
                continue;
            }
            json.put(key, map.get(key));
        }
    }

    private void gridToJson(Map<String, Object> map, Map<String, Object> json) throws Exception {
        if (map.get("ajaxtype") == null || !"grid".equals(map.get("ajaxtype"))) {
            return;
        }
        for (String key : map.keySet()) {
            if ("ajaxtype".equals(key)) continue;
            List valueMap = (List)map.get(key);
            json.put(key, JsonUtilOld.formatJSONArray(valueMap));
        }
    }
}

