/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.util;

import cn.com.chinalife.model.Dsn_Attribute;
import cn.com.chinalife.model.Dsn_Attribute_Option;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Rules_Const;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Product_Risks;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.util.ModelMd5Callback;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.string.StrUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
@CacheConfig(cacheNames={"productQueryUtils"})
public class ProductQueryUtilsSipService {
    @Autowired
    AbsModelRepository dao;
    private ModelMd5Callback<AbsModel> md5Callback = new ModelMd5Callback();

    public Dsn_Structure queryStructure(String nodeNo) {
        Dsn_Structure danStructure = new Dsn_Structure();
        danStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        danStructure.where().addCallback(this.md5Callback);
        danStructure = (Dsn_Structure)this.dao.findOne((AbsModel)danStructure);
        String serno = danStructure.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return danStructure;
    }

    public Dsn_Structure queryStructure(String upNode, String nodeType) {
        Dsn_Structure danStructure = new Dsn_Structure();
        danStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
        danStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
        danStructure.where().addCallback(this.md5Callback);
        danStructure = (Dsn_Structure)this.dao.findOne((AbsModel)danStructure);
        String serno = danStructure.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return danStructure;
    }

    public Dsn_Structure querySubStructure(String upNode, String nodeType) {
        Dsn_Structure structure = this.queryStructure(upNode, nodeType);
        if (StrUtil.isNull((Object)((Object)structure))) {
            return structure;
        }
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)structure.getNodeNo());
        List structureList = this.dao.findAll((AbsModel)structure);
        structureList.forEach(dsn -> structure.where().addIn((ModelField)Dsn_Structure.Field.up_node, dsn.getNodeNo()));
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_sub_risks_detail");
        List childList = this.dao.findAll((AbsModel)structure);
        if (childList.isEmpty()) {
            return null;
        }
        return (Dsn_Structure)((Object)childList.get(0));
    }

    public List<Dsn_Structure> queryStructures(String upNode) {
        Dsn_Structure danStructure = new Dsn_Structure();
        danStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
        danStructure.where().addCallback(this.md5Callback);
        danStructure.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)danStructure);
    }

    public Sip_Products queryProduct(String prdUuid) {
        Sip_Products sipProduct = new Sip_Products();
        sipProduct.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)prdUuid);
        sipProduct.where().addCallback(this.md5Callback);
        sipProduct = (Sip_Products)this.dao.findOne((AbsModel)sipProduct);
        String serno = sipProduct.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return sipProduct;
    }

    public Dsn_Biz_Attribute queryBizAttribute(String nodeNo) {
        Dsn_Biz_Attribute dsnBizAttribute = new Dsn_Biz_Attribute();
        dsnBizAttribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)nodeNo);
        dsnBizAttribute.where().addCallback(this.md5Callback);
        dsnBizAttribute = (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)dsnBizAttribute);
        String serno = dsnBizAttribute.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return dsnBizAttribute;
    }

    public List<Dsn_Biz_Attribute_Option> queryBizAttributeOption(String bizUuid) {
        Dsn_Biz_Attribute_Option dsnBizAttributeOption = new Dsn_Biz_Attribute_Option();
        dsnBizAttributeOption.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)bizUuid);
        dsnBizAttributeOption.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnBizAttributeOption);
    }

    public Dsn_Attribute queryAttribute(String attrUuid) {
        Dsn_Attribute danAttribute = new Dsn_Attribute();
        danAttribute.where().addEq((ModelField)Dsn_Attribute.Field.attr_uuid, (Object)attrUuid);
        danAttribute.where().addCallback(this.md5Callback);
        danAttribute = (Dsn_Attribute)this.dao.findOne((AbsModel)danAttribute);
        String serno = danAttribute.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return danAttribute;
    }

    public List<Dsn_Attribute_Option> queryAttributeOption(String attrUuid) {
        Dsn_Attribute_Option danAttributeOption = new Dsn_Attribute_Option();
        danAttributeOption.where().addEq((ModelField)Dsn_Attribute_Option.Field.attr_uuid, (Object)attrUuid);
        danAttributeOption.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)danAttributeOption);
    }

    public Dsn_Rules queryRule(String nodeNo) {
        Dsn_Rules danRules = new Dsn_Rules();
        danRules.where().addEq((ModelField)Dsn_Rules.Field.rule_no, (Object)nodeNo);
        danRules.where().addCallback(this.md5Callback);
        danRules = (Dsn_Rules)this.dao.findOne((AbsModel)danRules);
        String serno = danRules.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return danRules;
    }

    public List<Dsn_Rules_Const> queryRuleConst(String ruleNo) {
        Dsn_Rules_Const danRulesConst = new Dsn_Rules_Const();
        danRulesConst.where().addEq((ModelField)Dsn_Rules_Const.Field.rule_no, (Object)ruleNo);
        danRulesConst.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)danRulesConst);
    }

    public Sip_Risk_Relation queryRiskRelation(String mainRisk, String riskUuid) {
        Sip_Risk_Relation sipRiskRelation = new Sip_Risk_Relation();
        sipRiskRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)mainRisk);
        sipRiskRelation.where().addEq((ModelField)Sip_Risk_Relation.Field.risk_uuid, (Object)riskUuid);
        sipRiskRelation.where().addCallback(this.md5Callback);
        sipRiskRelation = (Sip_Risk_Relation)this.dao.findOne((AbsModel)sipRiskRelation);
        String serno = sipRiskRelation.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return sipRiskRelation;
    }

    public Sip_Product_Risks queryProductRelation(String prdUuid, String riskUuid) {
        Sip_Product_Risks sipProductRisks = new Sip_Product_Risks();
        sipProductRisks.where().addEq((ModelField)Sip_Product_Risks.Field.product_uuid, (Object)prdUuid);
        sipProductRisks.where().addEq((ModelField)Sip_Product_Risks.Field.risk_uuid, (Object)riskUuid);
        sipProductRisks.where().addCallback(this.md5Callback);
        sipProductRisks = (Sip_Product_Risks)this.dao.findOne((AbsModel)sipProductRisks);
        String serno = sipProductRisks.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return sipProductRisks;
    }

    public Sip_Risks queryRisk(String riskUuid) {
        Sip_Risks sipRisk = new Sip_Risks();
        sipRisk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUuid);
        sipRisk.where().addCallback(this.md5Callback);
        sipRisk = (Sip_Risks)this.dao.findOne((AbsModel)sipRisk);
        String serno = sipRisk.getSerno();
        if (StrUtil.isNull((Object)serno)) {
            return null;
        }
        return sipRisk;
    }

    public List<Dsn_Rules> queryRules(String nodeNo) {
        Dsn_Rules dsnRules = new Dsn_Rules();
        dsnRules.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)nodeNo);
        dsnRules.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnRules);
    }
}

