/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.service.impl;

import cn.com.chinalife.dao.IProductDaoSipService;
import cn.com.chinalife.dao.IRulesDao;
import cn.com.chinalife.model.Dsn_Rules;
import cn.com.chinalife.model.Dsn_Rules_Const;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Menu;
import cn.com.chinalife.model.Sip_Organ_Rules;
import cn.com.chinalife.service.IRiskServiceSipService;
import cn.com.chinalife.service.IRulesServiceSipService;
import cn.com.chinalife.util.ProductDetailDealJsonUtilSipService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.date.DateUtil;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RulesServiceSipServiceImpl
implements IRulesServiceSipService {
    @Autowired
    private IRulesDao rulesDao;
    @Autowired
    private IRiskServiceSipService riskService;
    @Autowired
    private IProductDaoSipService product;
    @Autowired
    private AbsModelRepository dao;
    @Value(value="${module_product_engine_url}")
    private String engineUrl;

    @Override
    public ReturnMsg queryRulesDropDownInfo(String groupType) {
        Return msg = new Return();
        try {
            List<String> rootConfigUuidList = this.getRootByGroupType(groupType);
            List<Menu> allMenu = this.getMenuTree();
            ArrayList<Menu> rootMenu = new ArrayList<Menu>();
            for (Menu nav : allMenu) {
                if (!rootConfigUuidList.contains(nav.getConfigUuid())) continue;
                rootMenu.add(nav);
            }
            Collections.sort(rootMenu, this.orderByDisplayOrder());
            for (Menu nav : rootMenu) {
                if ("0".equals(nav.getUpConfig())) {
                    List<Map<String, Object>> paramList = this.getParam(nav.getConfigUuid());
                    nav.setParamList(paramList);
                }
                List<Menu> childList = this.getChild(nav.getConfigUuid(), allMenu);
                nav.setChildren(childList);
            }
            msg.setSuccessMsg(new Message("2016000", "\u6210\u529f"));
            msg.getDataTable().put("rulesConfig", rootMenu);
            return msg.msg();
        }
        catch (Exception e) {
            msg.setFailMsg(new Message("2016020", "\u89c4\u5219\u4e0b\u62c9\u9009\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38"));
            return msg.msg();
        }
    }

    public Comparator<Menu> orderByDisplayOrder() {
        return (o1, o2) -> {
            if (o1.getDisplayOrder() != o2.getDisplayOrder()) {
                return Integer.valueOf(StrUtil.trimStr((Object)o1.getDisplayOrder())) - Integer.valueOf(StrUtil.trimStr((Object)o2.getDisplayOrder()));
            }
            return 0;
        };
    }

    public List<Menu> getChild(String configUuid, List<Menu> allMenu) {
        ArrayList<Menu> childList = new ArrayList<Menu>();
        for (Menu nav : allMenu) {
            if (!nav.getUpConfig().equals(configUuid)) continue;
            List<Map<String, Object>> paramList = this.getParam(nav.getConfigUuid());
            nav.setParamList(paramList);
            childList.add(nav);
        }
        for (Menu nav : childList) {
            if (StrUtil.isNull((Object)nav.getConfigUuid())) continue;
            nav.setChildren(this.getChild(nav.getConfigUuid(), allMenu));
        }
        Collections.sort(childList, this.orderByDisplayOrder());
        if (childList.isEmpty()) {
            return new ArrayList<Menu>();
        }
        return childList;
    }

    public List<Menu> getMenuTree() {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder sql = new StringBuilder();
        sql.append("select config.config_uuid   configUuid, ");
        sql.append("       config.config_no     value, ");
        sql.append("       config.config_name   label, ");
        sql.append("       config.show_level    showLevel, ");
        sql.append("       config.up_config     upConfig, ");
        sql.append("       config.display_order displayOrder, ");
        sql.append("       config.value_type    valueType, ");
        sql.append("       config.option_init   optionInit, ");
        sql.append("       config.service_entry  serverParam, ");
        sql.append("       config.is_show_choose  isShowChoose, ");
        sql.append("       config.actual_level  actualLevel ");
        sql.append("  from dsn_rules_config config");
        query.setSql(sql.toString());
        List listMap = this.dao.findAll(query);
        String json = JsonUtil.toJson((Object)listMap);
        return JSONObject.parseArray((String)json, Menu.class);
    }

    public List<Map<String, Object>> getParam(String configUuid) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder sql = new StringBuilder();
        sql.append(" select p.config_uuid,p.param_no,p.param_name,p.display_order,p.param_type ");
        sql.append("   from dsn_rules_config_param p");
        sql.append("  where p.config_uuid = ? ");
        sql.append("  ORDER BY P.DISPLAY_ORDER ");
        query.add((Object)configUuid);
        query.setSql(sql.toString());
        return this.dao.findAll(query);
    }

    public List<String> getRootByGroupType(String groupType) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select config_uuid ");
        sql.append("   from dsn_rules_config_group ");
        sql.append("  where group_type = ? ");
        return this.dao.getJdbcTemplate().queryForList(sql.toString(), String.class, new Object[]{groupType});
    }

    @Override
    public ReturnMsg queryAllRulesInfoByNodeNo(Map<String, Object> requestMap) {
        Return result = new Return();
        String nodeNo = StrUtil.trimStr((Object)requestMap.get("node_no"));
        String flag = StrUtil.trimStr((Object)requestMap.get("flag"));
        if (StrUtil.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        List<Dsn_Rules> ruleInfoList = this.rulesDao.queryRuleInfoList(nodeNo, flag);
        result.setDataList(ruleInfoList, Dsn_Rules.class);
        return result.msg();
    }

    @Override
    public ReturnMsg saveRulesInfo(Map<String, Object> requestMap) {
        Return result = new Return();
        String nodeNo = StrUtil.trimStr((Object)requestMap.get("node_no"));
        String flag = StrUtil.trimStr((Object)requestMap.get("flag"));
        if (StrUtil.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        try {
            this.headCompanySave(requestMap);
        }
        catch (BusinessException e) {
            if (e.getMessage().startsWith("2016032")) {
                result.setFailMsg(new Message("2016032", "\u5f53\u524d\u7528\u6237\u65e0\u4fdd\u5b58\u6b64\u4f7f\u7528\u573a\u666f\u89c4\u5219\u6743\u9650"));
            }
            if (e.getMessage().startsWith("2016033")) {
                result.setFailMsg(new Message("2016033", "\u4f7f\u7528\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u3002"));
            }
            return result.msg();
        }
        List<Dsn_Rules> ruleInfoList = this.rulesDao.queryRuleInfoList(nodeNo, flag);
        result.setDataList(ruleInfoList, Dsn_Rules.class);
        return result.msg();
    }

    @Override
    public ReturnMsg queryOrganRulesInfoByNodeNo(Map<String, Object> requestMap) {
        Return result = new Return();
        String nodeNo = StrUtil.trimStr((Object)requestMap.get("node_no"));
        if (StrUtil.isNull((Object)nodeNo)) {
            result.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result.msg();
        }
        List<Sip_Organ_Rules> organRuleInfo = this.rulesDao.queryOrganRuleInfo(requestMap);
        result.setDataList(organRuleInfo, Sip_Organ_Rules.class);
        return result.msg();
    }

    @Override
    public Map<String, Object> queryRiskRule(String ruleNo, String orgProduct, Map<String, Object> parm, String attrNo) {
        HashMap<String, Object> riskRule = new HashMap<String, Object>();
        String source = StrUtil.trimStr((Object)parm.get("source"));
        String useSence = StrUtil.trimStr((Object)parm.get("use_scene"));
        String initRule = "init_rule";
        String initKey = "initRule";
        Map<String, Object> initRuleInfo = this.queryRule(ruleNo, initRule, orgProduct, source, useSence);
        riskRule.put(initKey, initRuleInfo);
        String insureRule = "insure_rule";
        String insureKey = "insureRule";
        Map<String, Object> insureRuleInfo = this.queryRule(ruleNo, insureRule, orgProduct, source, useSence);
        riskRule.put(insureKey, insureRuleInfo);
        String insuranceRule = "insurance_rule";
        String insuranceKey = "insuranceRule";
        Map<String, Object> insuranceRuleInfo = this.queryRule(ruleNo, insuranceRule, orgProduct, source, useSence);
        riskRule.put(insuranceKey, insuranceRuleInfo);
        String underwriteRule = "underwrite_rule";
        String underwriteKey = "underwriteRule";
        Map<String, Object> underwriteRuleInfo = this.queryRule(ruleNo, underwriteRule, orgProduct, source, useSence);
        riskRule.put(underwriteKey, underwriteRuleInfo);
        String linkageRule = "linkage_rule";
        String linkageKey = "linkageRule";
        Map<String, Object> linkageRuleInfo = this.queryRule(ruleNo, linkageRule, orgProduct, source, useSence);
        riskRule.put(linkageKey, linkageRuleInfo);
        String liabilityRule = "liability_rule";
        String liabilityKey = "liabilityRule";
        Map<String, Object> liabilityRuleInfo = this.queryRule(ruleNo, liabilityRule, orgProduct, source, useSence);
        riskRule.put(liabilityKey, liabilityRuleInfo);
        return riskRule;
    }

    @Override
    public String switchRule(Map<String, Object> parmer, String ruleInfo) {
        String productNo = StrUtil.trimStr((Object)parmer.get("product_code"));
        String riskUuid = StrUtil.trimStr((Object)parmer.get("mainRiskUuid"));
        String subUuid = StrUtil.trimStr((Object)parmer.get("subRiskUuid"));
        String rulePrd = ruleInfo.replace("P110000010962", productNo);
        String ruleMain = rulePrd.replace("v7H5aucw", riskUuid);
        if (!StrUtil.isNull((Object)subUuid)) {
            return ruleMain.replace("OrhlpfRq", subUuid);
        }
        return ruleMain;
    }

    private Map<String, Object> queryRule(String ruleNo, String nodeType, String orgProduct, String source, String useSence) {
        Ulog.info((String)("\u6839\u636e\u89c4\u5219\u8282\u70b9\u67e5\u8be2\u4e0b\u7ea7\u5177\u4f53\u89c4\u5219\u4fe1\u606f\uff1aorgProduct:" + orgProduct + "source:" + source));
        HashMap<String, Object> result = new HashMap<String, Object>();
        Dsn_Structure dsnStruct = new Dsn_Structure();
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)ruleNo);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
        Dsn_Structure rule = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStruct);
        dsnStruct.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)rule.getNodeNo());
        List allRule = this.dao.findAll((AbsModel)dsnStruct);
        ArrayList<Dsn_Rules> queryRuleInfoList = new ArrayList<Dsn_Rules>();
        ArrayList<Sip_Organ_Rules> queryOrganRuleInfo = new ArrayList<Sip_Organ_Rules>();
        for (Dsn_Structure dsnRule : allRule) {
            List findAll;
            Dsn_Rules sipRules = new Dsn_Rules();
            sipRules.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)dsnRule.getNodeNo());
            sipRules.where().addEq((ModelField)Dsn_Rules.Field.status, (Object)"1");
            if ("propose".equals(useSence)) {
                sipRules.where().addIn((ModelField)Dsn_Rules.Field.use_scene, new String[]{"all", "propose"});
            } else {
                sipRules.where().addIn((ModelField)Dsn_Rules.Field.use_scene, new String[]{"all", "insure"});
            }
            if (null == (findAll = this.dao.findAll((AbsModel)sipRules)) || findAll.isEmpty()) continue;
            for (Dsn_Rules one : findAll) {
                one.getRuleInfo();
                JSONObject jsonObj = JSON.parseObject((String)one.getRuleInfo());
                HashMap map = new HashMap();
                ProductDetailDealJsonUtilSipService.getRuleInfoNewJson(jsonObj, map);
                one.setRuleInfo(JsonUtil.toJson(map));
                queryRuleInfoList.add(one);
            }
        }
        Sip_Organ_Rules organRules = new Sip_Organ_Rules();
        organRules.where().addEq((ModelField)Sip_Organ_Rules.Field.node_no, (Object)rule.getNodeNo());
        organRules.where().addEq((ModelField)Sip_Organ_Rules.Field.organ_prd_uuid, (Object)orgProduct);
        List findOrganRule = this.dao.findAll((AbsModel)organRules);
        if (null != findOrganRule && !findOrganRule.isEmpty()) {
            for (Sip_Organ_Rules one : findOrganRule) {
                queryOrganRuleInfo.add(one);
            }
        }
        result.put("headRuleInfo", queryRuleInfoList);
        result.put("organRuleInfo", queryOrganRuleInfo);
        return result;
    }

    @Override
    public ReturnMsg queryProductRulesInfo(Map<String, Object> requestMap) throws Exception {
        Return result = new Return();
        String nodeNo = StrUtil.trimStr((Object)requestMap.get("product_uuid"));
        String organPrdUuid = StrUtil.trimStr((Object)requestMap.get("organ_prd_uuid"));
        Map<String, Object> queryRiskRule = this.queryRiskRule(nodeNo, organPrdUuid, requestMap, "");
        List<Dsn_Structure> queryRiskInfo = this.product.queryRiskInfo(requestMap);
        ArrayList<Map> listRisk = new ArrayList<Map>();
        for (Dsn_Structure risk : queryRiskInfo) {
            String riskUuid = risk.getNodeNo();
            requestMap.put("risk_uuid", riskUuid);
            ReturnMsg queryRiskDetail = this.riskService.queryRiskDetail(requestMap);
            Map riskDetail = queryRiskDetail.getDataTable();
            listRisk.add(riskDetail);
        }
        result.getDataTable().put("productRules", queryRiskRule);
        result.getDataTable().put("riskRules", listRisk);
        return result.msg();
    }

    @Override
    public ReturnMsg saveOrganRulesInfoByNodeNo(Map<String, Object> requestMap) {
        Return result = new Return();
        String organPrdUuid = StrUtil.trimStr((Object)requestMap.get("organ_prd_uuid"));
        if (StrUtil.isNull((Object)organPrdUuid)) {
            result.setFailMsg(new Message("2016021", "\u5206\u516c\u53f8\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            return result.msg();
        }
        try {
            this.organCompanySave(requestMap);
        }
        catch (Exception e) {
            result.setFailMsg(e.getMessage());
            return result.msg();
        }
        return result.msg();
    }

    private void headCompanySave(Map<String, Object> requestMap) {
        String object = JsonUtil.toJson((Object)requestMap.get("rules"));
        String nodeNo = StrUtil.trimStr((Object)requestMap.get("node_no"));
        String userNo = StrUtil.trimStr((Object)requestMap.get("user_no"));
        List organRules = JsonUtil.json2List((String)object);
        Dsn_Rules sipOrganRule = new Dsn_Rules();
        if (null != organRules && !organRules.isEmpty()) {
            if (!this.isSaveRule(userNo, nodeNo)) {
                throw new BusinessException(new Message("2016032", "\u5f53\u524d\u7528\u6237\u65e0\u4fdd\u5b58\u6b64\u4f7f\u7528\u573a\u666f\u89c4\u5219\u6743\u9650"));
            }
            sipOrganRule.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)nodeNo);
            this.dao.delete((AbsModel)sipOrganRule);
            for (Map organRule : organRules) {
                sipOrganRule.setNodeNo(nodeNo);
                String ruleNo = StrUtil.trimStr(organRule.get("rule_no"));
                sipOrganRule.setRuleNo(ruleNo);
                String constMap = JsonUtil.toJson(organRule.get("constMap"));
                Map json2Map = JsonUtil.json2Map((String)constMap);
                Dsn_Rules_Const ruleConst = new Dsn_Rules_Const();
                if (null != json2Map && !json2Map.isEmpty()) {
                    ruleConst.where().addEq((ModelField)Dsn_Rules_Const.Field.rule_no, (Object)ruleNo);
                    this.dao.delete((AbsModel)ruleConst);
                    for (Map.Entry entry : json2Map.entrySet()) {
                        if ("####".equals(entry.getKey())) {
                            throw new BusinessException(new Message("\u5e38\u91cf\u89c4\u5219\u4fdd\u5b58\u5165\u53c2\u9519\u8bef"));
                        }
                        ruleConst.setConstNo((String)entry.getKey());
                        ruleConst.setConstMapping(StrUtil.trimStr(entry.getValue()));
                        ruleConst.setRuleNo(ruleNo);
                        this.dao.save((AbsModel)ruleConst);
                    }
                }
                sipOrganRule.setRuleName(StrUtil.trimStr(organRule.get("rule_name")));
                long endDate1 = Long.parseLong(JsonUtil.toJson(organRule.get("end_date")));
                String endDate = new SimpleDateFormat("yyyy-MM-dd").format(endDate1);
                sipOrganRule.setEndDate(DateUtil.string2Date((Object)endDate));
                long startDate = Long.parseLong(JsonUtil.toJson(organRule.get("start_date")));
                String startDate1 = new SimpleDateFormat("yyyy-MM-dd").format(startDate);
                sipOrganRule.setStartDate(DateUtil.string2Date((Object)startDate1));
                sipOrganRule.setStatus(StrUtil.trimStr(organRule.get("status")));
                String useScene = StrUtil.trimStr(organRule.get("use_scene"));
                if (StrUtil.isNull((Object)useScene)) {
                    throw new BusinessException(new Message("2016033", "\u4f7f\u7528\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u3002"));
                }
                sipOrganRule.setUseScene(useScene);
                if ("admin".equals(userNo) && "propose".equals(useScene)) {
                    throw new BusinessException(new Message("2016032", "\u5f53\u524d\u7528\u6237\u65e0\u4fdd\u5b58\u6b64\u4f7f\u7528\u573a\u666f\u89c4\u5219\u6743\u9650"));
                }
                if ("propose".equals(userNo) && !"propose".equals(useScene)) {
                    throw new BusinessException(new Message("2016032", "\u5f53\u524d\u7528\u6237\u65e0\u4fdd\u5b58\u6b64\u4f7f\u7528\u573a\u666f\u89c4\u5219\u6743\u9650"));
                }
                sipOrganRule.setMemo(StrUtil.trimStr(organRule.get("memo")));
                String scheduleOrder1 = StrUtil.trimStr(organRule.get("schedule_order"));
                sipOrganRule.setScheduleOrder(Integer.parseInt(scheduleOrder1));
                String ruleInfo = JsonUtil.toJson(organRule.get("rule_info"));
                sipOrganRule.setRuleInfo(ruleInfo);
                sipOrganRule.checkValue();
                this.dao.save((AbsModel)sipOrganRule);
            }
        }
    }

    private boolean isSaveRule(String userNo, String nodeNo) {
        boolean flag = true;
        Dsn_Rules sipOrganRule = new Dsn_Rules();
        sipOrganRule.where().addEq((ModelField)Dsn_Rules.Field.node_no, (Object)nodeNo);
        if ("propose".equals(userNo)) {
            sipOrganRule.where().addIn((ModelField)Dsn_Rules.Field.use_scene, new String[]{"all", "insure"});
        }
        if ("admin".equals(userNo)) {
            sipOrganRule.where().addIn((ModelField)Dsn_Rules.Field.use_scene, "propose");
        }
        if (!CollectionUtils.isEmpty((Collection)this.dao.findAll((AbsModel)sipOrganRule))) {
            flag = false;
        }
        return flag;
    }

    private void organCompanySave(Map<String, Object> requestMap) {
        String object = JsonUtil.toJson((Object)requestMap.get("rules"));
        List ruleList = JsonUtil.json2List((String)object);
        String organPrdUuid = StrUtil.trimStr((Object)requestMap.get("organ_prd_uuid"));
        for (Map rule : ruleList) {
            String nodeNo = StrUtil.trimStr(rule.get("node_no"));
            if (StrUtil.isNull((Object)nodeNo)) {
                throw new BusinessException(new Message("2016022", "\u8be5\u89c4\u5219\u8282\u70b9\u7f16\u7801\u4e0d\u5b58\u5728"));
            }
            Sip_Organ_Rules sipOrganRule = new Sip_Organ_Rules();
            sipOrganRule.setOrganPrdUuid(organPrdUuid);
            sipOrganRule.setNodeNo(nodeNo);
            sipOrganRule.setRuleNo(StrUtil.trimStr(rule.get("rule_no")));
            String constMap = JsonUtil.toJson((Object)requestMap.get("constMap"));
            Map json2Map = JsonUtil.json2Map((String)constMap);
            Dsn_Rules_Const ruleConst = new Dsn_Rules_Const();
            if (null != json2Map && !json2Map.isEmpty()) {
                ruleConst.where().addEq((ModelField)Dsn_Rules_Const.Field.rule_no, (Object)StrUtil.trimStr(rule.get("rule_no")));
                ruleConst.where().addEq((ModelField)Dsn_Rules_Const.Field.const_mapping, (Object)StrUtil.trimStr(json2Map.get("const_mapping")));
                this.dao.delete((AbsModel)ruleConst);
                ruleConst.setConstNo(StrUtil.trimStr(json2Map.get("const_no")));
                ruleConst.setConstMapping(StrUtil.trimStr(json2Map.get("const_mapping")));
                ruleConst.setRuleNo(StrUtil.trimStr(rule.get("rule_no")));
                this.dao.save((AbsModel)ruleConst);
            }
            sipOrganRule.setRuleName(StrUtil.trimStr(rule.get("rule_name")));
            long endDate1 = Long.parseLong(JsonUtil.toJson(rule.get("end_date")));
            String endDate = new SimpleDateFormat("yyyy-MM-dd").format(endDate1);
            sipOrganRule.setEndDate(DateUtil.string2Date((Object)endDate));
            long startDate1 = Long.parseLong(JsonUtil.toJson(rule.get("start_date")));
            String startDate = new SimpleDateFormat("yyyy-MM-dd").format(startDate1);
            sipOrganRule.setStartDate(DateUtil.string2Date((Object)startDate));
            sipOrganRule.setStatus(StrUtil.trimStr(rule.get("status")));
            sipOrganRule.setMemo(StrUtil.trimStr(rule.get("memo")));
            String ruleInfo = JsonUtil.toJson(rule.get("rule_info"));
            sipOrganRule.setRuleInfo(ruleInfo);
            sipOrganRule.checkValue();
            sipOrganRule.where().addEq((ModelField)Sip_Organ_Rules.Field.node_no, (Object)nodeNo);
            sipOrganRule.where().addEq((ModelField)Sip_Organ_Rules.Field.rule_name, (Object)StrUtil.trimStr(rule.get("rule_name")));
            sipOrganRule.where().addEq((ModelField)Sip_Organ_Rules.Field.organ_prd_uuid, (Object)organPrdUuid);
            this.dao.delete((AbsModel)sipOrganRule);
            this.dao.save((AbsModel)sipOrganRule);
        }
    }
}

