/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.service.impl;

import cn.com.chinalife.dao.IBranchDaoSipService;
import cn.com.chinalife.dao.IProductDaoSipService;
import cn.com.chinalife.dao.IRiskDao;
import cn.com.chinalife.dao.PcProductDao;
import cn.com.chinalife.entity.RiskRelationVo;
import cn.com.chinalife.entity.TreeNode;
import cn.com.chinalife.entity.bo.DetailBo;
import cn.com.chinalife.model.Dsn_Biz_Attribute;
import cn.com.chinalife.model.Dsn_Biz_Attribute_Option;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Risk_Relation;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.service.IBranchServiceSipService;
import cn.com.chinalife.service.IConvertServiceSipService;
import cn.com.chinalife.service.IProductDealProductServiceSipService;
import cn.com.chinalife.service.IProductServiceSipService;
import cn.com.chinalife.service.IRiskServiceSipService;
import cn.com.chinalife.service.IRulesServiceSipService;
import cn.com.chinalife.util.BaseCheckUtil;
import cn.com.chinalife.util.StructureConstantSipService;
import cn.com.chinalife.util.TreeUtilSipService;
import cn.com.chinalife.wings.rmi.httptools.base.WingsHttpUtil;
import cn.com.chinalife.wings.util.DateUtil;
import com.github.stuxuhai.jpinyin.PinyinException;
import com.newtouch.cache.CacheManager;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.ReturnMsg;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.test.http.HttpClient;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.md5.Md5;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import com.newtouch.web.BaseController;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductServiceSipServiceImpl
extends BaseService
implements IProductServiceSipService {
    @Autowired
    private IProductDaoSipService productDao;
    @Autowired
    private PcProductDao pcProductDao;
    @Autowired
    @Lazy
    private IRiskDao riskDao;
    @Autowired
    private IRulesServiceSipService rule;
    @Autowired
    private IRiskServiceSipService riskService;
    @Autowired
    private IBranchServiceSipService branch;
    @Autowired
    private IBranchDaoSipService branchDao;
    @Autowired
    private WingsHttpUtil wings;
    @Autowired
    private IConvertServiceSipService convertService;
    @Autowired
    private IProductDealProductServiceSipService productDealProductService;
    @Autowired
    private IProductServiceSipService productService;
    private String productNameNode = "product_name";
    private String code = "000000";
    private static final List<String> exceptAttrNo = new ArrayList<String>();
    private static final List<String> ruleAttr = new ArrayList<String>();
    @Value(value="${template.product_no}")
    private String baseProductNo;
    @Value(value="${template.main_risk_no}")
    private String baseRiskNo;
    @Value(value="${module_product_engine_url}")
    private String engineUrl;
    @Value(value="${china_life_product_server}")
    private String chinaLifePrdServerUrl;
    @Value(value="${china_life_risk_server}")
    private String chinaLifeRiskServerUrl;
    private String info02 = "\u8bf7\u6c42\u8def\u5f84\uff1a";
    private String info03 = "\u54cd\u5e94\u6570\u636e\uff1a[";
    private static Map<String, String> riskCodeMap = new HashMap<String, String>();
    private static Map<String, String> nodeNameMap = new HashMap<String, String>();
    private static final String MIN_AGE = "min_age";
    private static final String MAX_AGE = "max_age";
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg queryPcProductList(Map<String, Object> requestMap) {
        Return msg = new Return();
        List<Map<String, Object>> proposeProductList = this.pcProductDao.queryProductList(requestMap);
        BaseCheckUtil.checkStringParamIsNull(JsonUtil.toJson(proposeProductList), "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
        msg.setDataList(proposeProductList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductList(Map<String, Object> param) {
        Return msg = new Return();
        List<Map<String, Object>> queryPolPolicyParty = this.productDao.queryProductList(param);
        msg.setDataList(queryPolPolicyParty);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProposeProductList(Map<String, Object> param) {
        Return msg = new Return();
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        BaseCheckUtil.checkStringParamIsNull(organId, "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\uff0c\u5165\u53c2\u673a\u6784\u7f16\u7801organ_id\u4e3a\u7a7a\uff01");
        String channelNo = StrUtil.trimStr((Object)param.get("channel_no"));
        BaseCheckUtil.checkStringParamIsNull(channelNo, "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\uff0c\u5165\u53c2\u6e20\u9053\u7f16\u7801channel_no\u4e3a\u7a7a\uff01");
        List proposeProductList = this.productService.queryProductListCache(organId, channelNo).getDataList();
        BaseCheckUtil.checkStringParamIsNull(JsonUtil.toJson((Object)proposeProductList), "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
        List<Sip_Risks> sipRisks = this.riskDao.queryRiskByRiskClassify();
        List collect = sipRisks.stream().map(Sip_Risks::getPolicyCode).collect(Collectors.toList());
        Iterator iterator = proposeProductList.iterator();
        while (iterator.hasNext()) {
            Map productMap = (Map)iterator.next();
            String[] riskCodeArr = StrUtil.trimStr(productMap.get("riskCode")).split(",");
            if (riskCodeArr.length == 1 && collect.contains(riskCodeArr[0])) {
                iterator.remove();
            }
            if (!"E".equals(StrUtil.trimStr(productMap.get("state")))) continue;
            iterator.remove();
        }
        msg.setDataList(proposeProductList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductListCache(String organId, String channelNo) {
        Return msg = new Return();
        List headProductList = new ArrayList();
        ArrayList<Map> result = new ArrayList<Map>();
        HashMap headMap = new HashMap();
        HashMap<String, Map> organMap = new HashMap<String, Map>();
        String headOffice = "prdList:000000";
        String headOfficeResult = (String)CacheManager.get((String)headOffice);
        if (!StrUtil.isNull((Object)headOfficeResult)) {
            headProductList = JsonUtil.json2List((String)StrUtil.trimStr((Object)headOfficeResult));
        }
        for (Map map1 : headProductList) {
            headMap.put(StrUtil.trimStr(map1.get("product_no")), map1);
        }
        String branchOffice = "prdList:" + organId + channelNo;
        String branchResult = (String)CacheManager.get((String)branchOffice);
        if (StrUtil.isNull((Object)branchResult)) {
            branchOffice = "prdList:" + organId.subSequence(0, 4) + "00" + channelNo;
            branchResult = (String)CacheManager.get((String)branchOffice);
        }
        boolean contains = StructureConstantSipService.getOrganSpecialList().contains(organId.subSequence(0, 4));
        if (StrUtil.isNull((Object)branchResult) && !contains) {
            branchOffice = "prdList:" + organId.subSequence(0, 2) + "0000" + channelNo;
            branchResult = (String)CacheManager.get((String)branchOffice);
        }
        if (!StrUtil.isNull((Object)branchResult)) {
            List organProductList = JsonUtil.json2List((String)StrUtil.trimStr((Object)branchResult));
            for (Map map2 : organProductList) {
                organMap.put(StrUtil.trimStr(map2.get("product_no")), map2);
            }
            headMap.putAll(organMap);
        }
        for (String key : headMap.keySet()) {
            result.add((Map)headMap.get(key));
        }
        msg.setDataList(result);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductDetail(Map<String, Object> param) {
        Return msg = new Return();
        String source = StrUtil.trimStr((Object)param.get("source"));
        ArrayList<Map<String, Object>> queryProductResult = new ArrayList<Map<String, Object>>();
        if ("app".equals(source)) {
            Map<String, Object> queryPrdDetail = this.productDao.queryPrdDetail(param);
            queryProductResult.add(queryPrdDetail);
            msg.setDataList(queryProductResult);
        } else {
            List<Map<String, Object>> queryProductDetail = this.productDao.queryProductDetail(param);
            msg.setDataList(queryProductDetail);
        }
        List<Dsn_Structure> queryRiskInfo = this.productDao.queryRiskInfo(param);
        msg.getDataTable().put("riskInfo", queryRiskInfo);
        return msg.msg();
    }

    @Override
    public ReturnMsg saveProductInfo(Map<String, Object> request) {
        Return msg = new Return();
        Map organProduct = JsonUtil.json2Map((String)JsonUtil.toJson((Object)request.get("organProduct")));
        HashMap<String, Object> parmer = new HashMap<String, Object>();
        String flag = StrUtil.trimStr(organProduct.get("flag"));
        String organProUuid = this.saveOrganPro(request, flag);
        organProduct.put("organ_prd_uuid", organProUuid);
        if (StrUtil.isNull((Object)organProUuid)) {
            msg.setFailMsg(new Message("2016024", "\u8be5\u4ea7\u54c1\u5df2\u5728\u76f8\u540c\u673a\u6784\u3001\u76f8\u540c\u6e20\u9053\u4e0b\u914d\u7f6e\u5165\u5e93\uff0c\u8bf7\u76f4\u63a5\u70b9\u51fb\u4fee\u6539\u6309\u94ae\u8fdb\u884c\u4fee\u6539"));
            return msg.msg();
        }
        try {
            parmer.put("organ_prd_uuid", organProUuid);
            if (!"1".equals(flag)) {
                this.saveOrganProduct(request, organProUuid, parmer);
                this.saveOrganRisk(request, organProUuid, parmer);
            }
        }
        catch (BusinessException e) {
            if (e.getMessage().startsWith("2016029")) {
                msg.setFailMsg(new Message("2016029", "\u4e0d\u80fd\u5927\u4e8e\u6216\u4e92\u65a5\u603b\u516c\u53f8\u914d\u7f6e\u7684\u88ab\u4fdd\u9669\u4eba\u6027\u522b\uff0c\u8bf7\u4fee\u6539"));
            } else if (e.getMessage().startsWith("2016030")) {
                msg.setFailMsg(new Message("2016030", "\u4e0d\u80fd\u5c0f\u4e8e\u603b\u516c\u53f8\u914d\u7f6e\u7684\u6700\u5c0f\u6295\u4fdd\u5e74\u9f84\u6216\u5927\u4e8e\u6700\u5927\u6295\u4fdd\u5e74\u9f84\uff0c\u8bf7\u4fee\u6539"));
            }
            return msg.msg();
        }
        catch (Exception e) {
            msg.setFailMsg(new Message("2016026", "\u5206\u516c\u53f8\u4ea7\u54c1\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58\u5931\u8d25"));
            return msg.msg();
        }
        msg.setSuccessMsg(new Message("2016000", "\u6210\u529f"));
        msg.setDataTable(organProduct);
        return msg.msg();
    }

    private String saveOrganPro(Map<String, Object> request, String flag) {
        String[] organList;
        Map<String, Object> oldOrgan = null;
        List<Sip_Organ_Products> switchOldData = null;
        List<Sip_Organ_Products> switchRequestData = null;
        Map organProduct = JsonUtil.json2Map((String)JsonUtil.toJson((Object)request.get("organProduct")));
        String organPrdUuid = StrUtil.trimStr(organProduct.get("organ_prd_uuid"));
        String organ = StrUtil.trimStr(organProduct.get("organ_id"));
        for (String organDt : organList = organ.split(",")) {
            if (!StrUtil.isNull((Object)organPrdUuid)) {
                if (this.branchDao.queryProductRedisBranch(organProduct, "0", organDt)) {
                    return null;
                }
                oldOrgan = this.branch.queryProductOrganByOrgan(organProduct);
                switchOldData = this.switchData(oldOrgan);
                switchRequestData = this.switchData(organProduct);
                this.branchDao.saveProductOrgan(switchOldData, switchRequestData);
                continue;
            }
            if (this.branchDao.queryProductRedisBranch(organProduct, "1", organDt)) {
                return organPrdUuid;
            }
            organPrdUuid = UniqueSeq.shortUUID();
            organProduct.put("organ_prd_uuid", organPrdUuid);
            switchRequestData = this.switchData(organProduct);
            this.branchDao.saveProductOrgan(switchOldData, switchRequestData);
        }
        if ("1".equals(flag)) {
            this.branchDao.updateProduct(organProduct);
        }
        return organPrdUuid;
    }

    private void saveOrganProduct(Map<String, Object> request, String organUuid, Map<String, Object> parmer) {
        HashMap<String, Object> product = new HashMap<String, Object>();
        Map productInfo = JsonUtil.json2Map((String)JsonUtil.toJson((Object)request.get("productInfo")));
        product.put("product_uuid", productInfo.get("product_uuid"));
        parmer.put("product_code", productInfo.get("product_no"));
        product.put("organ_prd_uuid", organUuid);
        this.validSaveInfo(productInfo);
        ReturnMsg queryProductDetail = this.queryProductDetail(product);
        List productList = queryProductDetail.getDataList();
        this.productDao.saveProductInfo(productList, productInfo, organUuid);
    }

    private void validSaveInfo(Map<String, Object> productInfo) {
        Sip_Products prd = new Sip_Products();
        prd.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)StrUtil.trimStr((Object)productInfo.get("product_no")));
        Sip_Products comPrd = (Sip_Products)this.dao.findOne((AbsModel)prd);
        String sex = comPrd.getSex();
        String minAge = comPrd.getMinAge();
        String maxAge = comPrd.getMaxAge();
        if (!"B".equals(sex) && !sex.equals(StrUtil.trimStr((Object)productInfo.get("sex")))) {
            throw new BusinessException(new Message("2016029", "\u4e0d\u80fd\u5927\u4e8e\u6216\u4e92\u65a5\u603b\u516c\u53f8\u914d\u7f6e\u7684\u88ab\u4fdd\u9669\u4eba\u6027\u522b\uff0c\u8bf7\u4fee\u6539"));
        }
        if (!this.validAge(MIN_AGE, minAge, StrUtil.trimStr((Object)productInfo.get(MIN_AGE)))) {
            throw new BusinessException(new Message("2016030", "\u4e0d\u80fd\u5c0f\u4e8e\u603b\u516c\u53f8\u914d\u7f6e\u7684\u6700\u5c0f\u6295\u4fdd\u5e74\u9f84\u6216\u5927\u4e8e\u6700\u5927\u6295\u4fdd\u5e74\u9f84\uff0c\u8bf7\u4fee\u6539"));
        }
        if (!this.validAge(MAX_AGE, maxAge, StrUtil.trimStr((Object)productInfo.get(MAX_AGE)))) {
            throw new BusinessException(new Message("2016030", "\u4e0d\u80fd\u5c0f\u4e8e\u603b\u516c\u53f8\u914d\u7f6e\u7684\u6700\u5c0f\u6295\u4fdd\u5e74\u9f84\u6216\u5927\u4e8e\u6700\u5927\u6295\u4fdd\u5e74\u9f84\uff0c\u8bf7\u4fee\u6539"));
        }
    }

    private boolean validAge(String key, String value, String newValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (key.equals(MIN_AGE)) {
            map.put(MIN_AGE, value);
            map.put(MAX_AGE, newValue);
            if (!BaseCheckUtil.validAge(map)) {
                return false;
            }
            if (value.endsWith("A") && newValue.endsWith("D")) {
                return false;
            }
        }
        if (key.equals(MAX_AGE)) {
            map.put(MIN_AGE, newValue);
            map.put(MAX_AGE, value);
            if (!BaseCheckUtil.validAge(map)) {
                return false;
            }
        }
        return true;
    }

    private void saveOrganRisk(Map<String, Object> request, String organUuid, Map<String, Object> parmer) {
        List riskInfo = JsonUtil.json2List((String)JsonUtil.toJson((Object)request.get("risk")));
        List subRiskInfo = JsonUtil.json2List((String)JsonUtil.toJson((Object)request.get("sub_risk")));
        this.saveOrganRiskInfo(riskInfo, organUuid, "n_risk_detail", parmer);
        this.saveOrganRiskInfo(subRiskInfo, organUuid, "n_sub_risks_detail", parmer);
    }

    public void saveOrganRiskInfo(List<Map<String, Object>> newRisk, String organUuid, String type, Map<String, Object> parmer) {
        HashMap<String, Object> risk = new HashMap<String, Object>();
        for (Map<String, Object> subRisk : newRisk) {
            String upNode = this.productDao.getUpNode(StrUtil.trimStr((Object)subRisk.get("risk_uuid")));
            risk.put("organ_prd_uuid", subRisk.get("organ_prd_uuid"));
            risk.put("risk_uuid", upNode);
            if (type.equals("n_risk_detail")) {
                parmer.put("mainRiskUuid", StrUtil.trimStr((Object)subRisk.get("risk_uuid")));
            } else if (type.equals("n_sub_risks_detail")) {
                parmer.put("mainRiskUuid", subRisk.get("main_risk"));
                parmer.put("subRiskUuid", subRisk.get("risk_uuid"));
            }
            List<Map<String, Object>> queryRiskDetail = this.riskDao.queryRiskDetail(risk, upNode, type);
            this.compareValue(subRisk, queryRiskDetail, organUuid, parmer);
        }
    }

    private void compareValue(Map<String, Object> request, List<Map<String, Object>> risk, String organPrd, Map<String, Object> parmer) {
        for (Map<String, Object> riskInfo : risk) {
            String key = StrUtil.trimStr((Object)riskInfo.get("attr_no"));
            String oldValue = StrUtil.trimStr((Object)riskInfo.get("field_value"));
            String value = request.get(key).toString();
            if (value.equals(oldValue)) continue;
            this.productDao.saveRiskInfo(riskInfo, request, organPrd, value);
            if (!ruleAttr.contains(key)) continue;
            Map<String, Object> ruleResule = this.riskService.saveOrganRule(request, key, parmer);
            this.rule.saveOrganRulesInfoByNodeNo(ruleResule);
        }
    }

    @Override
    public ReturnMsg saveProductFrom3rd(Map<String, Object> requestMap) {
        Return result = new Return();
        Object proDetail = requestMap.get("product_detail");
        List riskList = (List)requestMap.get("riskList");
        if (StrUtil.isNull((Object)proDetail)) {
            result.setFailMsg(new Message("2016007", "\u4ea7\u54c1\u8be6\u60c5\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
            return result.msg();
        }
        if (!(proDetail instanceof List)) {
            result.setFailMsg(new Message("2016008", "\u4ea7\u54c1\u8be6\u60c5\u8282\u70b9\u53ea\u80fd\u662fList\u683c\u5f0f\u3002"));
            return result.msg();
        }
        List productList = (List)proDetail;
        Ulog.info((String)("\u4ea7\u54c1\u8be6\u60c5\uff1a" + JsonUtil.toJson((Object)productList)));
        try {
            String productUuid = this.productDeal(productList);
            this.riskNewDeal(productUuid, (Map)productList.get(0), riskList);
        }
        catch (BusinessException e) {
            result.setFailMsg(e.getMessage());
        }
        return result.msg();
    }

    private String productDeal(List<Map<String, Object>> productList) {
        StringBuilder productNewuUuid = new StringBuilder();
        String templateProductUUID = this.productDao.getProductUUIDByProductNo(this.baseProductNo);
        if (StrUtil.isNull((Object)templateProductUUID)) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u6a21\u677f\u7684product_no\u3002");
        }
        String templateRiskUUID = this.riskDao.getRiskUUIDByRiskNo(this.baseRiskNo);
        if (StrUtil.isNull((Object)templateRiskUUID)) {
            throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u9700\u8981\u914d\u7f6e\u6a21\u677f\u7684risk_no\u3002");
        }
        productList.stream().forEach(productMap -> {
            String productUUid = this.copyProductTemp((Map<String, Object>)productMap, templateProductUUID);
            productNewuUuid.append(productUUid);
        });
        return productNewuUuid.toString();
    }

    private void riskNewDeal(String productUUid, Map<String, Object> productMap, List<Map<String, Object>> riskList) {
        List<Sip_Risks> riskStructure = this.riskDao.queryRiskStructure(riskList);
        riskStructure.forEach(risk -> {
            if ("common-add".equalsIgnoreCase(risk.getRiskNo())) {
                risk.setPolicyCode(risk.getRiskNo());
            }
        });
        Map<String, List<Sip_Risks>> mainRiksMap = riskStructure.stream().filter(e -> "M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        ArrayList<Sip_Risks> needDeleteRisk = new ArrayList<Sip_Risks>();
        Dsn_Structure mainParentNode = this.productDao.getMainParentNodeByProductUUid(productUUid);
        mainParentNode.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)mainParentNode.getNodeNo());
        List<String> riskUuidList = this.riskService.riskDeal(productUUid, this.baseRiskNo, "M", productMap, mainParentNode, productUUid);
        ArrayList<Dsn_Structure> newInsertDsn = new ArrayList<Dsn_Structure>();
        ArrayList<Dsn_Structure> noNeed = new ArrayList<Dsn_Structure>();
        if (riskStructure.isEmpty()) {
            return;
        }
        riskUuidList.forEach(riskUuid -> {
            Dsn_Structure mainDsn = new Dsn_Structure();
            mainDsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, riskUuid);
            Dsn_Structure dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)mainDsn);
            mainDsn.where().addIn((ModelField)Dsn_Structure.Field.node_no, dsnStructure.getUpNode());
            mainDsn.where().addNotEq((ModelField)Dsn_Structure.Field.node_type, (Object)"root");
            Dsn_Structure mainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)mainDsn);
            this.queryDsnAll(dsnStructure.getUpNode(), newInsertDsn, riskStructure, mainRisk.getNodeNo(), needDeleteRisk, noNeed);
        });
        this.changeRiskCode(riskStructure, needDeleteRisk);
        riskUuidList.forEach(riskUuid -> {
            Sip_Risks risks = new Sip_Risks();
            risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, riskUuid);
            Sip_Risks newRisks = (Sip_Risks)this.dao.findOne((AbsModel)risks);
            this.dealAccyRiks(newRisks, mainRiksMap);
            this.dealRiskRelation(newRisks, mainRiksMap);
        });
        List<Dsn_Structure> bizAttribute = newInsertDsn.stream().filter(e -> !StrUtil.isNull((Object)e.getRelateTab())).collect(Collectors.toList());
        if (!needDeleteRisk.isEmpty()) {
            Sip_Risks sipRisks = new Sip_Risks();
            needDeleteRisk.forEach(risk -> sipRisks.where().addIn((ModelField)Sip_Risks.Field.risk_uuid, risk.getRiskUuid()));
            this.dao.delete((AbsModel)sipRisks);
        }
        this.deleteRiskRelationInfo(newInsertDsn, bizAttribute, noNeed);
        Sip_Products products = new Sip_Products();
        products.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUUid);
        Sip_Products sipProducts = (Sip_Products)this.dao.findOne((AbsModel)products);
        if (!StrUtil.isNull((Object)sipProducts.getProductNo())) {
            this.productDealProductService.dealProductRiskRealtion(sipProducts.getProductNo());
        }
    }

    private void dealAccyRiks(Sip_Risks newRisks, Map<String, List<Sip_Risks>> mainRiksMap) {
        Sip_Risks oldRisk = new Sip_Risks();
        if ("common-add".equalsIgnoreCase(newRisks.getRiskNo()) && !StrUtil.isNull(mainRiksMap.get("common-add"))) {
            oldRisk = mainRiksMap.get(newRisks.getRiskNo()).get(0);
        }
        if (!mainRiksMap.isEmpty() && !StrUtil.isNull(mainRiksMap.get(newRisks.getPolicyCode()))) {
            oldRisk = mainRiksMap.get(newRisks.getPolicyCode()).get(0);
        }
        this.dealAccyRisk(newRisks, oldRisk);
    }

    private void dealAccyRisk(Sip_Risks newRisks, Sip_Risks oldRisk) {
        Dsn_Structure structure = this.getAccyRiskByMainRisk(newRisks);
        Dsn_Structure oldStructure = this.getAccyRiskByMainRisk(oldRisk);
        if ("common-add".equalsIgnoreCase(newRisks.getRiskNo())) {
            List<Sip_Risks> newRisksList = this.queryRisk(structure);
            List<Sip_Risks> oldRisks = this.queryRisk(oldStructure);
            Map oldRiskMap = oldRisks.stream().collect(Collectors.toMap(Sip_Risks::getPolicyCode, Function.identity()));
            Dsn_Structure dsnStructure = new Dsn_Structure();
            ArrayList dsnStructures = new ArrayList();
            newRisksList.forEach(e -> {
                if (StrUtil.isNull(oldRiskMap.get(e.getPolicyCode()))) {
                    dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getRiskUuid());
                    dsnStructures.add(this.dao.findOne((AbsModel)dsnStructure));
                }
            });
            if (!dsnStructures.isEmpty()) {
                dsnStructures.forEach(dsn -> dsnStructure.where().addIn((ModelField)Dsn_Structure.Field.node_no, dsn.getUpNode()));
                List structuresList = this.dao.findAll((AbsModel)dsnStructure);
                structuresList.forEach(dsn -> {
                    dsn.setUpNode(oldStructure.getNodeNo());
                    dsn.setSerno(UniqueSeq.shortUUID());
                    dsnStructure.where().addIn((ModelField)Dsn_Structure.Field.node_no, dsn.getNodeNo());
                    this.dao.delete((AbsModel)dsnStructure);
                    this.dao.save((AbsModel)dsn);
                });
            }
        } else {
            oldStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldStructure.getNodeNo());
            this.dao.delete((AbsModel)oldStructure);
            structure.setUpNode(oldStructure.getUpNode());
            structure.setSerno(UniqueSeq.shortUUID());
            this.dao.save((AbsModel)structure);
        }
    }

    private List<Sip_Risks> queryRisk(Dsn_Structure structure) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)structure.getNodeNo());
        List dsnStructures = this.dao.findAll((AbsModel)dsnStructure);
        dsnStructures.forEach(dsn -> dsnStructure.where().addIn((ModelField)Dsn_Structure.Field.up_node, dsn.getNodeNo()));
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
        List accyDeatil = this.dao.findAll((AbsModel)dsnStructure);
        Sip_Risks risks = new Sip_Risks();
        accyDeatil.forEach(e -> risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)e.getNodeNo()));
        return this.dao.findAll((AbsModel)risks);
    }

    private Dsn_Structure getAccyRiskByMainRisk(Sip_Risks risk) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)risk.getRiskUuid());
        Dsn_Structure one = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)one.getUpNode());
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
    }

    private void dealRiskRelation(Sip_Risks newRisks, Map<String, List<Sip_Risks>> mainRiksMap) {
        if (!mainRiksMap.isEmpty() && !StrUtil.isNull(mainRiksMap.get(newRisks.getPolicyCode()))) {
            Sip_Risks oldRisk = mainRiksMap.get(newRisks.getPolicyCode()).get(0);
            Dsn_Structure oldStructure = this.getAccyRiskByMainRisk(oldRisk);
            List<RiskRelationVo> newAccyRiskList = this.getAccyRiskList(newRisks);
            List<Sip_Risks> riskUuidList = this.getRiskUuidList(oldStructure);
            Map<String, List<Sip_Risks>> oldMap = riskUuidList.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
            ArrayList relationRes = new ArrayList();
            newAccyRiskList.forEach(risk -> {
                Sip_Risk_Relation relation = new Sip_Risk_Relation();
                if (oldMap.isEmpty()) {
                    BeanUtils.copyProperties((Object)risk, (Object)((Object)relation));
                    relation.setMainRisk(oldRisk.getRiskUuid());
                    relation.setSerno(UniqueSeq.shortUUID());
                    relationRes.add(relation);
                } else {
                    List oldRelationList = (List)oldMap.get(risk.getRiskCode());
                    if (!StrUtil.isNull((Object)oldRelationList) && !oldRelationList.isEmpty()) {
                        oldRelationList.forEach(oldRelation -> {
                            BeanUtils.copyProperties((Object)risk, (Object)((Object)relation));
                            relation.setMainRisk(oldRisk.getRiskUuid());
                            relation.setRiskUuid(oldRelation.getRiskUuid());
                            relation.setSerno(UniqueSeq.shortUUID());
                            relationRes.add(relation);
                        });
                    }
                }
            });
            Sip_Risk_Relation relation = new Sip_Risk_Relation();
            relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)oldRisk.getRiskUuid());
            this.dao.delete((AbsModel)relation);
            relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)newRisks.getRiskUuid());
            this.dao.delete((AbsModel)relation);
            this.dao.save(relationRes);
        }
    }

    private List<RiskRelationVo> getAccyRiskList(Sip_Risks risk) {
        ArrayList<RiskRelationVo> relationVo = new ArrayList<RiskRelationVo>();
        Sip_Risk_Relation relation = new Sip_Risk_Relation();
        relation.where().addEq((ModelField)Sip_Risk_Relation.Field.main_risk, (Object)risk.getRiskUuid());
        List all = this.dao.findAll((AbsModel)relation);
        all.forEach(arr -> {
            RiskRelationVo riskRelation = new RiskRelationVo();
            Sip_Risks sipRisks = new Sip_Risks();
            sipRisks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)arr.getRiskUuid());
            Sip_Risks risks = (Sip_Risks)this.dao.findOne((AbsModel)sipRisks);
            if (!StrUtil.isNull((Object)risks.getSerno())) {
                BeanUtils.copyProperties((Object)arr, (Object)((Object)riskRelation));
                riskRelation.setRiskCode(risks.getPolicyCode());
                relationVo.add(riskRelation);
            }
        });
        return relationVo;
    }

    private void changeRiskCode(List<Sip_Risks> oldRisk, List<Sip_Risks> newRiskList) {
        List<Sip_Risks> oldMain = oldRisk.stream().filter(e -> "M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        List<Sip_Risks> newMain = newRiskList.stream().filter(e -> "M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        List<Sip_Risks> oldOthMain = oldRisk.stream().filter(e -> !"M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        List<Sip_Risks> newOthMain = newRiskList.stream().filter(e -> !"M".equalsIgnoreCase(e.getIsMainRisk())).collect(Collectors.toList());
        this.dealRisk(oldMain, newMain);
        this.dealRisk(oldOthMain, newOthMain);
    }

    private List<Sip_Risks> getRiskUuidList(Dsn_Structure oldStructure) {
        ArrayList<Sip_Risks> riskUuidList = new ArrayList<Sip_Risks>();
        oldStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)oldStructure.getNodeNo());
        List dsnStructureList = this.dao.findAll((AbsModel)oldStructure);
        dsnStructureList.forEach(acc -> {
            oldStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)acc.getNodeNo());
            oldStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
            Dsn_Structure daoOne = (Dsn_Structure)this.dao.findOne((AbsModel)oldStructure);
            if (!StrUtil.isNull((Object)daoOne.getSerno())) {
                Sip_Risks risks = new Sip_Risks();
                risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)daoOne.getNodeNo());
                Sip_Risks sipRisks = (Sip_Risks)this.dao.findOne((AbsModel)risks);
                riskUuidList.add(sipRisks);
            }
        });
        return riskUuidList;
    }

    private void dealRisk(List<Sip_Risks> oldRisk, List<Sip_Risks> newRiskList) {
        Dsn_Structure structure = new Dsn_Structure();
        Map newRiskMap = newRiskList.stream().collect(Collectors.toMap(Sip_Risks::getPolicyCode, Function.identity()));
        Map<String, List<Sip_Risks>> oldRiskList = oldRisk.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        oldRiskList.forEach((k, v) -> {
            Sip_Risks risk = (Sip_Risks)((Object)((Object)v.get(0)));
            Sip_Risks newRisk = (Sip_Risks)((Object)((Object)newRiskMap.get(risk.getPolicyCode())));
            if (!StrUtil.isNull((Object)((Object)newRisk))) {
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)risk.getRiskUuid());
                structure.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                Dsn_Structure oldRiskDsn = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldRiskDsn.getUpNode());
                structure.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                Dsn_Structure oldMainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)newRisk.getRiskUuid());
                Dsn_Structure newRiskDsn = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)newRiskDsn.getUpNode());
                structure.where().addNotEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
                Dsn_Structure newMainRisk = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
                oldMainRisk.setUpNode(newMainRisk.getUpNode());
                oldMainRisk.setNodeSeq(newMainRisk.getNodeSeq());
                oldMainRisk.setSerno(newMainRisk.getSerno());
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)newMainRisk.getNodeNo());
                this.dao.delete((AbsModel)structure);
                oldMainRisk.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)oldMainRisk.getNodeNo());
                oldMainRisk.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)oldMainRisk.getUpNode());
                this.dao.delete((AbsModel)oldMainRisk);
                this.dao.save((AbsModel)oldMainRisk);
            }
        });
    }

    private String copyProductTemp(Map<String, Object> productMap, String productUUID) {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("parent_node_no", productUUID);
        reqMap.put(this.productNameNode, "productName");
        String productUUid = this.productIsExist(productMap);
        if (StrUtil.isNull((Object)productUUid)) {
            productUUid = this.sendService(reqMap);
        }
        reqMap.clear();
        String detailNode = this.productDao.getProductDetailNodeByProductUUid(productUUid);
        Ulog.info((String)("\u4ea7\u54c1\u8be6\u60c5\uff1a" + JsonUtil.toJson(productMap)));
        productMap.forEach((k, v) -> reqMap.put((String)k, StrUtil.trimStr((Object)v)));
        reqMap.put("current_node_no", detailNode);
        reqMap.put("product_uuid", productUUid);
        this.modifyProductDetail(reqMap);
        return productUUid;
    }

    private String productIsExist(Map<String, Object> productMap) {
        String productNo = StrUtil.trimStr((Object)productMap.get("product_no"));
        if (StrUtil.isNull((Object)productNo)) {
            throw new BusinessException(new Message("2016011", "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Sip_Products product = this.productDao.queryProductByProductNo(productNo);
        return product == null ? "" : product.getProductUuid();
    }

    private void modifyProductDetail(Map<String, String> productDetailMap) {
        String url = this.engineUrl + "/saveProductDetails.controller";
        HttpClient http = HttpClient.getInstance();
        String reqStr = http.sendHttpPost(url, productDetailMap);
        Ulog.info((String)(this.info02 + url));
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(new Message("2016012", "\u4ea7\u54c1\u914d\u7f6e\u670d\u52a1\u3010n3s-insure-sip\u3011\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002"));
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException("\u4fdd\u5b58\u4ea7\u54c1\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\u3002" + json2Map.get("dtildMsg").toString());
        }
    }

    private String sendService(Map<String, String> reqMap) {
        String url = this.engineUrl + "/doProductConfigAddition.controller";
        HttpClient http = HttpClient.getInstance();
        String reqStr = http.sendHttpPost(url, reqMap);
        Ulog.info((String)(this.info02 + url));
        Ulog.info((String)(this.info03 + reqStr + "]"));
        if (StrUtil.isNull((Object)reqStr)) {
            throw new BusinessException(new Message("2016012", "\u4ea7\u54c1\u914d\u7f6e\u670d\u52a1\u3010n3s-insure-sip\u3011\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002"));
        }
        Map json2Map = JsonUtil.json2Map((String)reqStr);
        String flag = StrUtil.trimStr(json2Map.get("flag"));
        if (!"success".equals(flag)) {
            throw new BusinessException(new Message("2016013", "\u590d\u5236\u4ea7\u54c1\u5931\u8d25\u3002"));
        }
        Map result = (Map)json2Map.get("defmap");
        return StrUtil.trimStr(result.get("node_no"));
    }

    private List<Sip_Organ_Products> switchData(Map<String, Object> organData) {
        ArrayList<Sip_Organ_Products> resultList = new ArrayList<Sip_Organ_Products>();
        String channel = StrUtil.trimStr((Object)organData.get("channel_no"));
        String organ = StrUtil.trimStr((Object)organData.get("organ_id"));
        String[] organList = organ.split(",");
        String[] channelList = channel.split(",");
        for (String org : organList) {
            for (String channelNo : channelList) {
                Sip_Organ_Products switchResult = new Sip_Organ_Products();
                switchResult.setOrganId(org);
                switchResult.setOrganPrdUuid(StrUtil.trimStr((Object)organData.get("organ_prd_uuid")));
                switchResult.setPolStartDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("pol_start_date"))));
                switchResult.setPolEndDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("pol_end_date"))));
                switchResult.setPrpStartDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("prp_start_date"))));
                switchResult.setPrpEndDate(DateUtil.parseStrToDate((String)StrUtil.trimStr((Object)organData.get("prp_end_date"))));
                switchResult.setProductUuid(StrUtil.trimStr((Object)organData.get("product_uuid")));
                switchResult.setChannelNo(channelNo);
                resultList.add(switchResult);
            }
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> saveProductListToRedis(Map<String, Object> requestMap) {
        return this.productDao.queryProductList(requestMap);
    }

    @Override
    public ReturnMsg saveFrom3rdChinaLife(DetailBo detailBo) throws PinyinException {
        Map<String, Object> selfMap = this.convertService.transReqMap(detailBo);
        Ulog.info((String)("\u8f6c\u6362\u540e\u62a5\u6587\uff1a" + JsonUtil.toJson(selfMap)));
        ReturnMsg returnMsg = this.saveProductFrom3rd(selfMap);
        this.riskService.commonAddRiskDeal();
        return returnMsg;
    }

    @Override
    public ReturnMsg saveFrom3rdChinaLifeByProductNo(String prdCode) throws PinyinException {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("prdCode", prdCode);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("ESB-TRANNO", this.code);
        header.put("Content-Type", "application/json");
        String respStr = this.wings.doPost(this.chinaLifePrdServerUrl, JsonUtil.toJson(reqMap), header);
        Ulog.info((String)("\u4ea7\u54c1\u4e2d\u5fc3\u8fd4\u56de\u6570\u636e" + respStr));
        DetailBo detailBo = (DetailBo)JsonUtil.json2Class((String)respStr, DetailBo.class);
        this.saveFrom3rdChinaLife(detailBo);
        return null;
    }

    @Override
    public ReturnMsg queryAppRiskDetail(Map<String, Object> requestMap) throws Exception {
        Return result = new Return();
        String productUuid = StrUtil.trimStr((Object)requestMap.get("product_uuid"));
        if (StrUtil.isNull((Object)productUuid)) {
            Sip_Products products = this.productDao.queryProductByProductNo(StrUtil.trimStr((Object)requestMap.get("product_code")));
            productUuid = products.getProductUuid();
            requestMap.put("product_uuid", productUuid);
        }
        Sip_Organ_Products queryOrganProduct = this.productDao.queryOrganProduct(requestMap);
        String orgPrdUuid = "";
        if (null != queryOrganProduct) {
            orgPrdUuid = queryOrganProduct.getOrganPrdUuid();
        }
        requestMap.put("organ_prd_uuid", orgPrdUuid);
        ReturnMsg queryProductDetail = this.queryProductDetail(requestMap);
        List productDataList = queryProductDetail.getDataList();
        Map riskInfo = queryProductDetail.getDataTable();
        List riskList = JsonUtil.json2List((String)JsonUtil.toJson(riskInfo.get("riskInfo")), Dsn_Structure.class);
        ArrayList<Map> listRisk = new ArrayList<Map>();
        Map product = (Map)productDataList.get(0);
        for (Dsn_Structure riskVo : riskList) {
            requestMap.put("risk_uuid", riskVo.getNodeNo());
            ReturnMsg queryRiskDetail = this.riskService.queryRiskDetail(requestMap, product);
            Map riskDetail = queryRiskDetail.getDataTable();
            riskDetail.put("product_code", product.get("product_no"));
            riskDetail.put(this.productNameNode, product.get(this.productNameNode));
            listRisk.add(riskDetail);
            product.put("pol_policy_risk", listRisk);
        }
        result.setDataList(productDataList);
        return result.msg();
    }

    @Override
    public ReturnMsg saveCompositeProduct(Map<String, Object> request) {
        Return msg = new Return();
        Sip_Products saveCompositeProduct = new Sip_Products();
        try {
            this.getAge(request);
            if (!BaseCheckUtil.validAge(request)) {
                msg.setFailMsg(new Message("2016023", "\u7ec4\u5408\u4ea7\u54c1\u5e74\u9f84\u8303\u56f4\u4e0d\u80fd\u7ec4\u5408\u51fa\u5355\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u65b0\u9009\u62e9"));
                return msg.msg();
            }
            saveCompositeProduct = this.productDao.saveCompositeProduct(request);
            this.productDao.saveCompositeRelation(request, saveCompositeProduct);
        }
        catch (Exception e) {
            msg.setFailMsg(e.getMessage());
            return msg.msg();
        }
        msg.getDataTable().put("productUuid", saveCompositeProduct.getProductUuid());
        msg.getDataTable().put("productNo", saveCompositeProduct.getProductNo());
        msg.setSuccessMsg(new Message("2016000", "\u6210\u529f"));
        return msg.msg();
    }

    private void getAge(Map<String, Object> request) {
        String productList = JsonUtil.toJson((Object)request.get("dataList"));
        List productMap = JsonUtil.json2List((String)productList);
        ArrayList<Integer> minList = new ArrayList<Integer>();
        ArrayList<Integer> maxList = new ArrayList<Integer>();
        for (Map product : productMap) {
            String min = StrUtil.trimStr(product.get(MIN_AGE));
            String max = StrUtil.trimStr(product.get(MAX_AGE));
            this.getRandAge(minList, min);
            this.getRandAge(maxList, max);
        }
        this.getAgeResult(minList, maxList, request);
    }

    private void getRandAge(List<Integer> list, String age) {
        String unit = (String)age.subSequence(age.length() - 1, age.length());
        if ("A".equals(unit)) {
            age = "10" + age;
        }
        Integer number = Integer.valueOf((String)age.subSequence(0, age.length() - 1));
        list.add(number);
    }

    private void getAgeResult(List<Integer> minList, List<Integer> maxList, Map<String, Object> request) {
        int min = Collections.max(minList);
        int max = Collections.min(maxList);
        String minResult = "";
        String maxResult = "";
        minResult = (min + "").length() > 2 ? (String)(min + "").subSequence(2, (min + "").length()) + "A" : min + "D";
        maxResult = (max + "").length() > 2 ? (String)(max + "").subSequence(2, (max + "").length()) + "A" : max + "D";
        request.put(MIN_AGE, minResult);
        request.put(MAX_AGE, maxResult);
    }

    @Override
    public ReturnMsg queryProductListToRedis(Map<String, Object> param) throws Exception {
        Return msg = new Return();
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtil.trimStr((Object)param.get("channel_no"));
        if (!this.code.equals(organId)) {
            List<Map<String, Object>> organPrd = this.riskDao.queryOrganPrd(StrUtil.trimStr((Object)param.get("organ_prd_uuid")));
            Map<String, Object> organ = organPrd.get(0);
            param.put("organ_id", organ.get("organ_id"));
            param.put("channel_no", organ.get("channel_no"));
            List<Map<String, Object>> organList = this.productDao.queryOrganProductList(param);
            if (null != organList && !organList.isEmpty()) {
                CacheManager.put((String)("prdList:" + organ.get("organ_id") + organ.get("channel_no")), (Object)JsonUtil.toJson(organList));
                Ulog.info((String)("\u4ea7\u54c1\u5217\u8868\u7684keyprdList:" + organId + channelNo));
                for (Map<String, Object> map : organList) {
                    HashMap<String, Object> req = new HashMap<String, Object>();
                    req.put("organ_id", param.get("organ_id"));
                    req.put("channel_no", param.get("channel_no"));
                    req.put("product_uuid", map.get("product_uuid"));
                    req.put("product_code", map.get("product_no"));
                    req.put("source", "app");
                    if (!StrUtil.trimStr((Object)map.get("product_no")).equals(StrUtil.trimStr((Object)param.get("product_no")))) continue;
                    ReturnMsg queryAppRiskDetail = this.queryAppRiskDetail(req);
                    CacheManager.put((String)("prdDetail:" + map.get("product_no") + organ.get("organ_id") + organ.get("channel_no")), (Object)BaseController.return2Json((ReturnMsg)queryAppRiskDetail));
                }
            }
        } else {
            param.put("state", "ALL");
            List<Map<String, Object>> dataList = this.productDao.queryProductList(param);
            if (null != dataList && !dataList.isEmpty()) {
                CacheManager.put((String)("prdList:" + organId), (Object)JsonUtil.toJson(dataList));
                Ulog.info((String)("\u4ea7\u54c1\u5217\u8868\u7684keyprdList:" + organId));
            }
        }
        msg.setSuccessMsg(new Message("2016000", "\u6210\u529f"));
        return msg.msg();
    }

    private void deleteRiskRelationInfo(List<Dsn_Structure> newInsertDsn, List<Dsn_Structure> bizAttribute, List<Dsn_Structure> noNeed) {
        Map noMap = noNeed.stream().collect(Collectors.toMap(Dsn_Structure::getNodeNo, Function.identity()));
        Dsn_Structure structure = new Dsn_Structure();
        newInsertDsn.forEach(dsn -> {
            if (StrUtil.isNull(noMap.get(dsn.getNodeNo()))) {
                if ("n_sub_risks_detail".equalsIgnoreCase(dsn.getNodeType())) {
                    Sip_Risks risks = new Sip_Risks();
                    risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)dsn.getNodeNo());
                    this.dao.delete((AbsModel)risks);
                }
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn.getNodeNo());
                structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn.getUpNode());
                this.dao.delete((AbsModel)structure);
            }
        });
        Ulog.info((String)JsonUtil.toJson(bizAttribute));
    }

    private void queryDsnAll(String riskUuid, List<Dsn_Structure> newInsertDsn, List<Sip_Risks> hasSaveRiskList, String riskDetailUuid, List<Sip_Risks> newDeleteRisk, List<Dsn_Structure> noNeed) {
        Map<String, List<Sip_Risks>> oldRiskMap = hasSaveRiskList.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        List<Map<String, Object>> mainRiskTree = this.getQuerySqlable(riskUuid, "M");
        List<Map<String, Object>> accyRisksUuid = this.queryAccyRiskList(riskUuid);
        ArrayList accyRisksList = new ArrayList();
        accyRisksUuid.forEach(e -> accyRisksList.addAll(this.getQuerySqlable(StrUtil.trimStr(e.get("node_no")), "A")));
        this.dealMainRisk(newInsertDsn, riskDetailUuid, oldRiskMap, mainRiskTree, newDeleteRisk, noNeed);
        if (!accyRisksUuid.isEmpty()) {
            List<Sip_Risks> newRiskCode = this.queryHasSaveRisk(accyRisksUuid);
            this.dealAccyRisk(newInsertDsn, oldRiskMap, newRiskCode, newDeleteRisk, noNeed);
        }
    }

    private void dealAccyRisk(List<Dsn_Structure> newInsertDsn, Map<String, List<Sip_Risks>> oldRiskMap, List<Sip_Risks> newRiskCode, List<Sip_Risks> newDeleteRisk, List<Dsn_Structure> noNeed) {
        ArrayList noNeedDelAccyRisksList = new ArrayList();
        newRiskCode.forEach(e -> {
            if (!StrUtil.isNull(oldRiskMap.get(e.getPolicyCode()))) {
                Dsn_Structure dsnStructure = new Dsn_Structure();
                dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getRiskUuid());
                Dsn_Structure structure = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
                dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)structure.getUpNode());
                Dsn_Structure dsnStructure1 = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
                newDeleteRisk.add((Sip_Risks)((Object)e));
                List<Map<String, Object>> disList = this.getQuerySqlable(dsnStructure1.getNodeNo(), "A");
                noNeedDelAccyRisksList.addAll(this.getQuerySqlable(dsnStructure1.getNodeNo(), "A"));
                this.incrementSynchronousAccyRisk((Sip_Risks)((Object)((Object)((List)oldRiskMap.get(e.getPolicyCode())).get(0))), (Sip_Risks)((Object)e), "A", disList, noNeed);
            }
        });
        newInsertDsn.addAll(JsonUtil.listMap2ListClass(noNeedDelAccyRisksList, Dsn_Structure.class));
    }

    private void incrementSynchronousAccyRisk(Sip_Risks oldRisk, Sip_Risks newRisk, String riskType, List<Map<String, Object>> disList, List<Dsn_Structure> noNeed) {
        Dsn_Structure oldRiskNode = this.riskDao.getRiskNodeNoByRiskUUID(oldRisk.getRiskUuid());
        List<Map<String, Object>> list = this.getQuerySqlable(oldRiskNode.getNodeNo(), riskType);
        TreeNode oldTree = this.getTree(oldRisk, list);
        TreeNode newTree = this.getTree(newRisk, disList);
        this.dealDeff(oldTree, newTree, noNeed);
    }

    private TreeNode getTree(Sip_Risks newRisk, List<Map<String, Object>> disList) {
        Dsn_Structure newRiskNode = this.riskDao.getRiskNodeNoByRiskUUID(newRisk.getRiskUuid());
        TreeNode newTreeNode = new TreeNode();
        BeanUtils.copyProperties((Object)((Object)newRiskNode), (Object)((Object)newTreeNode));
        return this.listToTree(disList, newTreeNode);
    }

    private void dealDeff(TreeNode oldTree, TreeNode newTree, List<Dsn_Structure> noNeed) {
        List<TreeNode> children = oldTree.getChildren();
        Map oldTreeMap = children.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
        TreeNode oldSubRisks = (TreeNode)((Object)oldTreeMap.get("n_sub_risks"));
        List<TreeNode> newChild = newTree.getChildren();
        Map treeNodeMap = newChild.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
        TreeNode newSubRisks = (TreeNode)((Object)treeNodeMap.get("n_sub_risks"));
        ArrayList<Dsn_Structure> insert = new ArrayList<Dsn_Structure>();
        treeNodeMap.forEach((k, v) -> {
            if (!"n_sub_risks".equalsIgnoreCase((String)k)) {
                TreeNode newTreeNode = v;
                TreeNode oldTreeNode = (TreeNode)((Object)((Object)oldTreeMap.get(k)));
                this.dealAttr(oldTreeNode, newTreeNode, insert, noNeed);
            }
        });
        this.dealSuRisk(oldSubRisks, newSubRisks, insert, noNeed);
        Dsn_Structure structure = new Dsn_Structure();
        if (!insert.isEmpty()) {
            insert.forEach(dsn -> {
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn.getNodeNo());
                structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn.getUpNode());
                this.dao.delete((AbsModel)structure);
                this.dao.save((AbsModel)dsn);
            });
        }
    }

    private void dealAttr(TreeNode oldRiskDetail, TreeNode newRiskDetail, List<Dsn_Structure> insert, List<Dsn_Structure> noNeed) {
        if (null == oldRiskDetail || null == newRiskDetail) {
            return;
        }
        QuerySqlable querySqlable = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from sip_risks where risk_uuid = ?";
        querySqlable.add((Object)oldRiskDetail.getNodeNo());
        querySqlable.setSql(sql);
        List<TreeNode> oldChild = oldRiskDetail.getChildren();
        List<TreeNode> newChildren = newRiskDetail.getChildren();
        if (null == oldChild && null == newChildren) {
            return;
        }
        if (null == oldChild) {
            Dsn_Structure structure = new Dsn_Structure();
            BeanUtils.copyProperties((Object)((Object)newRiskDetail), (Object)((Object)structure));
            structure.setSerno(UniqueSeq.shortUUID());
            structure.setUpNode(oldRiskDetail.getNodeNo());
            insert.add(structure);
            List<TreeNode> children = newRiskDetail.getChildren();
            this.deleteAtrr(noNeed, children);
        } else if (null == newChildren) {
            Dsn_Structure structure = new Dsn_Structure();
            oldChild.forEach(old -> structure.where().addIn((ModelField)Dsn_Structure.Field.node_no, old.getNodeNo()));
            this.dao.delete((AbsModel)structure);
        } else {
            this.updateNeedAttr(oldRiskDetail, insert, noNeed, oldChild, newChildren);
        }
    }

    private void updateNeedAttr(TreeNode oldRiskDetail, List<Dsn_Structure> insert, List<Dsn_Structure> noNeed, List<TreeNode> oldChild, List<TreeNode> newChildren) {
        oldChild.forEach(e -> {
            if (!StrUtil.isNull((Object)nodeNameMap.get(e.getNodeName()))) {
                e.setNodeName(nodeNameMap.get(e.getNodeName()));
            }
        });
        Map oldMap = oldChild.stream().collect(Collectors.toMap(Dsn_Structure::getNodeName, Function.identity()));
        HashMap<String, TreeNode> md5OldMap = new HashMap<String, TreeNode>();
        oldMap.forEach((k, v) -> md5OldMap.put(Md5.md5((String)k.trim()), (TreeNode)((Object)v)));
        Map newMap = newChildren.stream().collect(Collectors.toMap(Dsn_Structure::getNodeName, Function.identity()));
        HashMap<String, TreeNode> md5NewMap = new HashMap<String, TreeNode>();
        newMap.forEach((k, v) -> md5NewMap.put(Md5.md5((String)k.trim()), (TreeNode)((Object)v)));
        md5OldMap.forEach((k, v) -> {
            if (StrUtil.isNull(md5NewMap.get(k))) {
                Dsn_Structure structure = new Dsn_Structure();
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)v.getNodeNo());
                this.dao.delete((AbsModel)structure);
            } else {
                TreeNode treeNode = (TreeNode)((Object)((Object)md5NewMap.get(k)));
                Dsn_Structure structure = new Dsn_Structure();
                structure.setRelateFk(treeNode.getRelateFk());
                structure.setRelateTab(treeNode.getRelateTab());
                structure.setRelateField(treeNode.getRelateField());
                structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)v.getNodeNo());
                this.dao.update((AbsModel)structure);
                this.dealBizAtr((TreeNode)((Object)v), treeNode);
            }
        });
        md5NewMap.forEach((key, e) -> {
            if (StrUtil.isNull(md5OldMap.get(key))) {
                Dsn_Structure structure = new Dsn_Structure();
                BeanUtils.copyProperties((Object)e, (Object)((Object)structure));
                structure.setUpNode(oldRiskDetail.getNodeNo());
                structure.setSerno(UniqueSeq.shortUUID());
                insert.add(structure);
                List<TreeNode> children = e.getChildren();
                this.deleteAtrr(noNeed, children);
            }
        });
    }

    private void dealBizAtr(TreeNode oldTreeNode, TreeNode newtreeNode) {
        Dsn_Biz_Attribute oldBiz = this.getDsnBizAttribute(oldTreeNode);
        Dsn_Biz_Attribute newBiz = this.getDsnBizAttribute(newtreeNode);
        this.dealBizAttrOption(oldBiz, newBiz);
    }

    private void dealBizAttrOption(Dsn_Biz_Attribute oldBiz, Dsn_Biz_Attribute newBiz) {
        List<Dsn_Biz_Attribute_Option> newBizOption = this.getDsnBizAttributeOption(newBiz);
        newBizOption.forEach(e -> e.setBizUuid(oldBiz.getBizUuid()));
        Dsn_Biz_Attribute_Option option = new Dsn_Biz_Attribute_Option();
        option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)oldBiz.getBizUuid());
        this.dao.delete((AbsModel)option);
        this.dao.save(newBizOption);
    }

    private List<Dsn_Biz_Attribute_Option> getDsnBizAttributeOption(Dsn_Biz_Attribute oldBiz) {
        Dsn_Biz_Attribute_Option option = new Dsn_Biz_Attribute_Option();
        option.where().addEq((ModelField)Dsn_Biz_Attribute_Option.Field.biz_uuid, (Object)oldBiz.getBizUuid());
        return this.dao.findAll((AbsModel)option);
    }

    private Dsn_Biz_Attribute getDsnBizAttribute(TreeNode oldTreeNode) {
        Dsn_Biz_Attribute attribute = new Dsn_Biz_Attribute();
        attribute.where().addEq((ModelField)Dsn_Biz_Attribute.Field.biz_uuid, (Object)oldTreeNode.getNodeNo());
        return (Dsn_Biz_Attribute)this.dao.findOne((AbsModel)attribute);
    }

    private void deleteAtrr(List<Dsn_Structure> noNeed, List<TreeNode> children) {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>();
        TreeUtilSipService.treeToList(children, treeList);
        if (!treeList.isEmpty()) {
            treeList.forEach(tree -> {
                Dsn_Structure structure = new Dsn_Structure();
                BeanUtils.copyProperties((Object)tree, (Object)((Object)structure));
                noNeed.add(structure);
            });
        }
    }

    private void dealSuRisk(TreeNode oldSubRisks, TreeNode newSubRisks, List<Dsn_Structure> insert, List<Dsn_Structure> noNeed) {
        List<TreeNode> oldChildren = oldSubRisks.getChildren();
        this.getNeedAttr(oldSubRisks, newSubRisks, insert, noNeed, oldChildren);
        this.treeAndKey(oldChildren);
        List<TreeNode> newChildren = newSubRisks.getChildren();
        this.treeAndKey(newChildren);
        if (null != oldChildren && null != newChildren && !oldChildren.isEmpty() && !newChildren.isEmpty()) {
            Map oldMap = oldChildren.stream().collect(Collectors.toMap(TreeNode::getKey, Function.identity()));
            Map newMap = newChildren.stream().collect(Collectors.toMap(TreeNode::getKey, Function.identity()));
            newChildren.forEach(e -> this.newRiskNeedInsert(oldSubRisks, insert, noNeed, oldMap, (TreeNode)((Object)e)));
            oldChildren.forEach(e -> {
                if (StrUtil.isNull(newMap.get(e.getKey()))) {
                    Dsn_Structure dsn = new Dsn_Structure();
                    dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getNodeNo());
                    this.dao.delete((AbsModel)dsn);
                } else {
                    Dsn_Structure dsn = new Dsn_Structure();
                    dsn.setNodeName(((TreeNode)((Object)((Object)newMap.get(e.getKey())))).getNodeName());
                    dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)e.getNodeNo());
                    this.dao.update((AbsModel)dsn);
                    Sip_Risks risks = new Sip_Risks();
                    risks.setRiskName(((TreeNode)((Object)((Object)newMap.get(e.getKey())))).getRiskName());
                    String riskUuid = e.getRiskUuid();
                    risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUuid);
                    this.dao.update((AbsModel)risks);
                    List<TreeNode> oldSubChildren = e.getChildren();
                    List<TreeNode> newSubChildren = ((TreeNode)((Object)((Object)newMap.get(e.getKey())))).getChildren();
                    Map oldSubMap = oldSubChildren.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
                    Map newSubMap = newSubChildren.stream().collect(Collectors.toMap(Dsn_Structure::getNodeType, Function.identity()));
                    newSubMap.forEach((k, v) -> {
                        if (!"n_sub_risks".equalsIgnoreCase((String)k)) {
                            TreeNode newNode = v;
                            TreeNode oldNode = (TreeNode)((Object)((Object)((Object)oldSubMap.get(k))));
                            this.dealAttr(oldNode, newNode, insert, noNeed);
                        }
                    });
                }
            });
        }
    }

    private void getNeedAttr(TreeNode oldSubRisks, TreeNode newSubRisks, List<Dsn_Structure> insert, List<Dsn_Structure> noNeed, List<TreeNode> oldChildren) {
        if (null == oldChildren && null != newSubRisks.getChildren()) {
            List<TreeNode> newChild = newSubRisks.getChildren();
            newChild.forEach(e -> {
                e.setUpNode(oldSubRisks.getNodeNo());
                e.setSerno(UniqueSeq.shortUUID());
                Dsn_Structure structure = new Dsn_Structure();
                BeanUtils.copyProperties((Object)e, (Object)((Object)structure));
                insert.add(structure);
                ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
                List<TreeNode> children = e.getChildren();
                TreeUtilSipService.treeToList(children, nodeList);
                nodeList.forEach(dsn -> {
                    Dsn_Structure stru = new Dsn_Structure();
                    BeanUtils.copyProperties((Object)dsn, (Object)((Object)stru));
                    noNeed.add(stru);
                });
            });
        }
    }

    private void newRiskNeedInsert(TreeNode oldSubRisks, List<Dsn_Structure> insert, List<Dsn_Structure> noNeed, Map<String, TreeNode> oldMap, TreeNode e) {
        if (StrUtil.isNull((Object)((Object)oldMap.get(e.getKey())))) {
            List<TreeNode> children = e.getChildren();
            e.setSerno(UniqueSeq.shortUUID());
            e.setUpNode(oldSubRisks.getNodeNo());
            Dsn_Structure structure = new Dsn_Structure();
            BeanUtils.copyProperties((Object)((Object)e), (Object)((Object)structure));
            if (!StrUtil.isNull((Object)structure.getSerno())) {
                insert.add(structure);
            }
            ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
            TreeUtilSipService.treeToList(children, nodeList);
            nodeList.forEach(k -> {
                Dsn_Structure dsnStructure = new Dsn_Structure();
                BeanUtils.copyProperties((Object)k, (Object)((Object)dsnStructure));
                noNeed.add(dsnStructure);
            });
        }
    }

    private void treeAndKey(List<TreeNode> oldChildren) {
        if (null != oldChildren) {
            oldChildren.forEach(e -> {
                List<TreeNode> children = e.getChildren();
                List treeNodes = children.stream().filter(f -> "n_sub_risks_detail".equalsIgnoreCase(f.getNodeType())).collect(Collectors.toList());
                TreeNode treeNode = (TreeNode)((Object)((Object)treeNodes.get(0)));
                Sip_Risks risks = new Sip_Risks();
                risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)treeNode.getNodeNo());
                Sip_Risks one = (Sip_Risks)this.dao.findOne((AbsModel)risks);
                e.setKey(one.getPolicyCode());
                e.setRiskName(one.getRiskName());
                e.setRiskUuid(one.getRiskUuid());
            });
        }
    }

    private void dealMainRisk(List<Dsn_Structure> newInsertDsn, String riskDetailUuid, Map<String, List<Sip_Risks>> oldRiskMap, List<Map<String, Object>> mainRiskTree, List<Sip_Risks> newDeleteRisk, List<Dsn_Structure> noNeed) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskDetailUuid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_risk_detail");
        Dsn_Structure dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        Sip_Risks risks = new Sip_Risks();
        risks.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)dsnStructure.getNodeNo());
        Sip_Risks sipRisks = (Sip_Risks)this.dao.findOne((AbsModel)risks);
        if ("common-add".equalsIgnoreCase(sipRisks.getRiskNo())) {
            sipRisks.setPolicyCode(sipRisks.getRiskNo());
        }
        if (!StrUtil.isNull(oldRiskMap.get(sipRisks.getPolicyCode()))) {
            newInsertDsn.addAll(JsonUtil.listMap2ListClass(mainRiskTree, Dsn_Structure.class));
            newDeleteRisk.add(sipRisks);
            this.incrementSynchronousAccyRisk(oldRiskMap.get(sipRisks.getPolicyCode()).get(0), sipRisks, "M", mainRiskTree, noNeed);
        }
    }

    public List<Map<String, Object>> getQuerySqlable(String riskUuid, String riskType) {
        ArrayList<Dsn_Structure> dsnList = new ArrayList<Dsn_Structure>();
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskUuid);
        Dsn_Structure one = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        dsnList.add(one);
        this.getTree(dsnList, riskUuid, riskType);
        return JsonUtil.json2List((String)JsonUtil.toJson(dsnList));
    }

    public TreeNode listToTree(List<Map<String, Object>> riskTreeList, TreeNode parentNo) {
        List dsnStructureList = JsonUtil.listMap2ListClass(riskTreeList, TreeNode.class);
        TreeUtilSipService tree = new TreeUtilSipService(dsnStructureList);
        List<TreeNode> treeNodes = tree.buildTree(parentNo);
        return treeNodes.get(0);
    }

    private void getTree(List<Dsn_Structure> dsnList, String upNode, String riskType) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
        if ("M".equalsIgnoreCase(riskType)) {
            structure.where().addNotEq((ModelField)Dsn_Structure.Field.node_type, (Object)"accy_risks");
        }
        List parentList = this.dao.findAll((AbsModel)structure);
        dsnList.addAll(parentList);
        parentList.forEach(dsn -> this.getTree(dsnList, dsn.getNodeNo(), riskType));
    }

    private List<Sip_Risks> queryHasSaveRisk(List<Map<String, Object>> accyRisksUuid) {
        Dsn_Structure structure = new Dsn_Structure();
        accyRisksUuid.forEach(dsn -> structure.where().addIn((ModelField)Dsn_Structure.Field.up_node, StrUtil.trimStr(dsn.get("node_no"))));
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
        List dsnStructureList = this.dao.findAll((AbsModel)structure);
        Sip_Risks risks = new Sip_Risks();
        dsnStructureList.forEach(e -> risks.where().addIn((ModelField)Sip_Risks.Field.risk_uuid, e.getNodeNo()));
        return this.dao.findAll((AbsModel)risks);
    }

    private List<Map<String, Object>> queryAccyRiskList(String riskUuid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskUuid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        Dsn_Structure accyRsks = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)accyRsks.getNodeNo());
        return JsonUtil.json2List((String)JsonUtil.toJson((Object)this.dao.findAll((AbsModel)structure)));
    }

    @Override
    public List<Map<String, Object>> queryProduct(String request, String flag) {
        QuerySqlable query = DBHandleCreator.getInstance().getQuerySql();
        List resultDao = null;
        if ("M".equals(flag)) {
            String sql = "select product_no from sip_products where product_uuid in(\nselect product_uuid from sip_product_risks  where risk_uuid=?\n)";
            query.add((Object)this.queryRiskUuid(request, flag));
            query.setSql(sql);
            resultDao = this.dao.findAll(query);
            query.clearParam();
        } else if ("A".equals(flag)) {
            String sql = "select product_no from sip_products e right join (\nselect * from sip_product_risks where risk_uuid in(\nselect main_risk from sip_risk_relation  where risk_uuid=?\n)) s\non  e.product_uuid = s.product_uuid";
            query.add((Object)this.queryRiskUuid(request, flag));
            query.setSql(sql);
            resultDao = this.dao.findAll(query);
            query.clearParam();
        }
        return resultDao;
    }

    private String queryRiskUuid(String request, String flag) {
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.policy_code, (Object)request);
        risk.where().addEq((ModelField)Sip_Risks.Field.is_main_risk, (Object)flag);
        Sip_Risks risk1 = (Sip_Risks)this.dao.findOne((AbsModel)risk);
        return risk1.getRiskUuid();
    }

    @Override
    public String queryPrdDetailFromRedis(Map<String, Object> requestMap) throws Exception {
        String flag = StrUtil.trimStr((Object)requestMap.get("source_flag"));
        String productNo = StrUtil.trimStr((Object)requestMap.get("product_code"));
        String useScene = StrUtil.trimStr((Object)requestMap.get("use_scene"));
        Sip_Products products = this.productDao.queryProductByProductNo(productNo);
        String productUuid = products.getProductUuid();
        requestMap.put("product_uuid", productUuid);
        requestMap.put("use_scene", useScene);
        String organId = StrUtil.trimStr((Object)requestMap.get("organ_id"));
        String channelNo = StrUtil.trimStr((Object)requestMap.get("channel_no"));
        Object branchResult = null;
        if ("0".equals(flag)) {
            ReturnMsg queryAppRiskDetail = this.queryAppRiskDetail(requestMap);
            return BaseController.return2Json((ReturnMsg)queryAppRiskDetail, (boolean)true);
        }
        if ("1".equals(flag)) {
            String branchOffice = "";
            branchOffice = "propose".equals(useScene) ? "prpPrdDetail:" + productNo + organId + channelNo : "prdDetail:" + productNo + organId + channelNo;
            branchResult = CacheManager.get((String)branchOffice);
            if (StrUtil.isNull((Object)branchResult) && null != this.productDao.queryOrganProduct(requestMap)) {
                return BaseController.return2Json((ReturnMsg)this.queryDetail(requestMap, useScene), (boolean)true);
            }
            if (StrUtil.isNull((Object)branchResult)) {
                String organId1 = organId.subSequence(0, 4) + "00";
                branchOffice = "propose".equals(useScene) ? "prpPrdDetail:" + productNo + organId1 + channelNo : "prdDetail:" + productNo + organId1 + channelNo;
                branchResult = CacheManager.get((String)branchOffice);
                requestMap.put("organ_id", organId1);
            }
            if (StrUtil.isNull((Object)branchResult) && null != this.productDao.queryOrganProduct(requestMap)) {
                return BaseController.return2Json((ReturnMsg)this.queryDetail(requestMap, useScene), (boolean)true);
            }
            boolean contains = StructureConstantSipService.getOrganSpecialList().contains(organId.subSequence(0, 4));
            if (StrUtil.isNull((Object)branchResult) && !contains) {
                String organId2 = organId.subSequence(0, 2) + "0000";
                branchOffice = "propose".equals(useScene) ? "prpPrdDetail:" + productNo + organId2 + channelNo : "prdDetail:" + productNo + organId2 + channelNo;
                branchResult = CacheManager.get((String)branchOffice);
                requestMap.put("organ_id", organId2);
            }
            if (StrUtil.isNull((Object)branchResult) && null != this.productDao.queryOrganProduct(requestMap) && !contains) {
                return BaseController.return2Json((ReturnMsg)this.queryDetail(requestMap, useScene), (boolean)true);
            }
            if (StrUtil.isNull((Object)branchResult)) {
                branchOffice = "propose".equals(useScene) ? "prpPrdDetail:" + productNo + "000000" + channelNo : "prdDetail:" + productNo + "000000" + channelNo;
                branchResult = CacheManager.get((String)branchOffice);
                requestMap.put("organ_id", "000000");
            }
            if (StrUtil.isNull((Object)branchResult)) {
                return BaseController.return2Json((ReturnMsg)this.queryDetail(requestMap, useScene), (boolean)true);
            }
            return branchResult.toString();
        }
        throw new BusinessException(new Message("2016025", "\u4ea7\u54c1\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a"));
    }

    public ReturnMsg queryDetail(Map<String, Object> requestMap, String useScene) throws Exception {
        String productNo = StrUtil.trimStr((Object)requestMap.get("product_code"));
        String channelNo = StrUtil.trimStr((Object)requestMap.get("channel_no"));
        String organId = StrUtil.trimStr((Object)requestMap.get("organ_id"));
        String key = productNo + organId + channelNo;
        ReturnMsg queryAppRiskDetail = this.queryAppRiskDetail(requestMap);
        if ("propose".equals(useScene)) {
            CacheManager.put((String)("prpPrdDetail:" + key), (Object)BaseController.return2Json((ReturnMsg)queryAppRiskDetail));
        } else {
            CacheManager.put((String)("prdDetail:" + key), (Object)BaseController.return2Json((ReturnMsg)queryAppRiskDetail));
        }
        return queryAppRiskDetail;
    }

    @Override
    public ReturnMsg queryProductAndRiskInfo(Map<String, Object> map) {
        List productNoList = (List)map.get("product_no");
        Return msg = new Return();
        ArrayList productList = new ArrayList();
        productNoList.forEach(p -> p.forEach((k, v) -> {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            Map productInfoMap = JsonUtil.json2Map((String)JsonUtil.toJson((Object)((Object)this.productDao.queryProductInfo(StrUtil.trimStr((Object)v)))));
            if (!StrUtil.isNull(productInfoMap.get("serno"))) {
                this.queryRiskInfo(productList, v, list, productInfoMap);
            }
        }));
        msg.setDataList(productList);
        return msg.msg();
    }

    private void queryRiskInfo(List<Map<String, Object>> productList, Object v, List<Map<String, Object>> list, Map<String, Object> productInfoMap) {
        List<Map<String, Object>> riskList = this.productDao.queryRiskUuid(StrUtil.trimStr((Object)v));
        riskList.forEach(e -> {
            list.add((Map<String, Object>)e);
            List<Map<String, Object>> attachRiskList = this.productDao.queryAttachRiskUuid(StrUtil.trimStr(e.get("risk_uuid")));
            if (!attachRiskList.isEmpty()) {
                attachRiskList.forEach(m -> list.add((Map<String, Object>)m));
            }
        });
        ArrayList riskInfoList = new ArrayList();
        list.forEach(o -> riskInfoList.add(this.productDao.queryRiskInfo(StrUtil.trimStr(o.get("risk_uuid")))));
        productInfoMap.put("riskList", riskInfoList);
        productList.add(productInfoMap);
    }

    @Override
    public ReturnMsg deleteOrganProduct(Map<String, Object> param) {
        Return msg = new Return();
        try {
            this.productDao.deleteOrganPrd(param);
        }
        catch (Exception e) {
            msg.setSuccessMsg(new Message("2016028", "\u5206\u516c\u53f8\u4ea7\u54c1\u7b56\u7565\u5220\u9664\u5931\u8d25"));
        }
        msg.setSuccessMsg(new Message("2016027", "\u5206\u516c\u53f8\u4ea7\u54c1\u7b56\u7565\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteCompositeProduct(Map<String, Object> param) {
        Return msg = new Return();
        try {
            this.productDao.deleteCompositeProduct(param);
        }
        catch (Exception e) {
            msg.setSuccessMsg(new Message("2016031", "\u5206\u516c\u53f8\u7ec4\u5408\u4ea7\u54c1\u5220\u9664\u6210\u529f"));
        }
        msg.setSuccessMsg(new Message("2016031", "\u5206\u516c\u53f8\u7ec4\u5408\u4ea7\u54c1\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    static {
        ruleAttr.add("min_amount");
        ruleAttr.add("min_premium");
        ruleAttr.add("payment_duration");
        ruleAttr.add("payment_mode");
        ruleAttr.add("period_duration");
        exceptAttrNo.add("age");
        exceptAttrNo.add("premium");
        exceptAttrNo.add("faceAmnt");
        riskCodeMap.put("D4R", "NLsUpu9q");
        riskCodeMap.put("982", "dDlEfS7m");
        nodeNameMap.put("\u7f34\u8d39\u65b9\u5f0f", "\u4ea4\u8d39\u65b9\u5f0f");
    }
}

