/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.dao.impl;

import cn.com.chinalife.dao.IStructureService;
import cn.com.chinalife.model.Dsn_Structure;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.string.StrUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class StructureServiceImplSipService
implements IStructureService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public List<Dsn_Structure> getSubAttr(Dsn_Structure dsn) {
        Dsn_Structure detailAttr = new Dsn_Structure();
        detailAttr.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)dsn.getNodeNo());
        detailAttr.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)detailAttr, false);
    }

    @Override
    public List<Dsn_Structure> getSubAttr(String nodeNo) {
        Dsn_Structure detailAttr = new Dsn_Structure();
        detailAttr.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        detailAttr.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)detailAttr, false);
    }

    @Override
    public Dsn_Structure getOneDsnBySerno(String serno) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
    }

    @Override
    public Dsn_Structure getOneDsnByNodeNo(String nodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        List queryList = this.dao.findAll((AbsModel)dsn);
        return (Dsn_Structure)((Object)queryList.get(0));
    }

    @Override
    public String getRiskuuidByNode(Dsn_Structure riskNode) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskNode.getNodeNo());
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail", "n_exempt_detail", "n_a_exempt_detai"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            throw new BusinessException(new Message("2016003", riskNode.getNodeName() + "\u9669\u79cd\u6570\u636e\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return ((Dsn_Structure)((Object)queryList.get(0))).getNodeNo();
    }

    @Override
    public String getRiskuuidByNodeNo(String upRiskNodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upRiskNodeNo);
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail", "n_exempt_detail", "n_a_exempt_detai"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return ((Dsn_Structure)((Object)queryList.get(0))).getNodeNo();
    }

    @Override
    public List<Dsn_Structure> getSubNode(String upNodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNodeNo);
        dsn.setOrderBy(new Sort.Order[]{Dsn_Structure.Field.display_order.asc()});
        return this.dao.findAll((AbsModel)dsn);
    }

    @Override
    public void delNodeBySerno(String serno) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
        this.dao.delete((AbsModel)dsn);
    }

    @Override
    public int getSubNodeCount(String seq) {
        int count = 0;
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_seq, (Object)seq);
        Dsn_Structure structure = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
        if (StrUtil.isNull((Object)structure.getSerno())) {
            return count;
        }
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)structure.getNodeNo());
        List structureList = this.dao.findAll((AbsModel)structure);
        return structureList.size();
    }

    @Override
    public Dsn_Structure getSubNodeByNodeType(String upNodeNo, String nodeType) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNodeNo);
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
    }
}

