/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.dao.impl;

import cn.com.chinalife.dao.IRiskDao;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.service.IRulesServiceSipService;
import cn.com.chinalife.util.DataBaseUtil;
import cn.com.chinalife.util.ModelUtilSipService;
import cn.com.chinalife.util.PinYin4J;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.string.StrUtil;
import com.newtouch.web.BaseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RiskDaoImpl
extends BaseService
implements IRiskDao {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IRulesServiceSipService rule;
    private static Map<String, String> riskCodeMap = new HashMap<String, String>();

    @Override
    public List<Map<String, Object>> queryRiskDetail(Map<String, Object> param, String nodeNo, String type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organRiskUuid = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        Dsn_Structure riskVo = this.getDsnStructureInfo(nodeNo, type);
        List attrList = null;
        List<Map<String, Object>> optionList = null;
        String nodeType = "attr_detail";
        String queryAttr = "SELECT * FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type =? ";
        querySql.add((Object)riskVo.getNodeNo());
        querySql.add((Object)nodeType);
        querySql.setSql(queryAttr);
        attrList = this.dao.findAll(querySql);
        querySql.clearParam();
        for (Map attr : attrList) {
            optionList = this.queryAttrOption(querySql, attr);
            attr.put("attrOption", optionList);
        }
        this.getFieldValueOrgan(attrList, riskVo, organRiskUuid);
        return attrList;
    }

    @Override
    public Map<String, Object> queryRiskDetailInfo(Map<String, Object> param, String nodeNo, String type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organRiskUuid = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        Dsn_Structure riskVo = this.getDsnStructureInfo(nodeNo, type);
        String queryRisk = "select * from sip_risks where risk_uuid = ?";
        querySql.add((Object)riskVo.getNodeNo());
        querySql.setSql(queryRisk);
        List riskInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        Map risk = riskInfo.isEmpty() ? null : (Map)riskInfo.get(0);
        String riskCode = "";
        for (Map.Entry next : risk.entrySet()) {
            if (!StrUtil.isNull((Object)organRiskUuid)) {
                Map organRisk;
                String queryProduct = "select * from sip_organ_risk_info where organ_prd_uuid = ? and risk_uuid = ? and attr_no = ?";
                querySql.add((Object)organRiskUuid);
                querySql.add((Object)riskVo.getNodeNo());
                querySql.add(next.getKey());
                querySql.setSql(queryProduct);
                List riskOrganInfo = this.dao.findAll(querySql);
                querySql.clearParam();
                Map map = organRisk = riskOrganInfo.isEmpty() ? null : (Map)riskOrganInfo.get(0);
                if (null != organRisk) {
                    risk.put(next.getKey(), organRisk.get("attr_value"));
                }
            }
            if (!"policy_code".equals(next.getKey())) continue;
            riskCode = StrUtil.trimStr(next.getValue());
        }
        risk.put("risk_code", riskCode);
        return risk;
    }

    @Override
    public List<Map<String, Object>> queryRiskLiability(String nodeNo, String type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)type);
        Dsn_Structure dsnResult = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.clear();
        String libiaity = "select * from dsn_structure where up_node=?";
        querySql.add((Object)dsnResult.getNodeNo());
        querySql.setSql(libiaity);
        List result = this.dao.findAll(querySql);
        querySql.clearParam();
        List index = null;
        for (Map li : result) {
            List ruleList;
            String ruleSql;
            String nodeType = StrUtil.trimStr(li.get("node_type"));
            String indexSql = "select a.node_no,b.field_1 name,b.field_2 code,b.field_3 sort from dsn_structure a left join\ndsn_dynamic_data b\non a.node_no = b.relate_fk\nwhere up_node=?";
            querySql.add((Object)StrUtil.trimStr(li.get("node_no")));
            querySql.setSql(indexSql);
            index = this.dao.findAll(querySql);
            querySql.clearParam();
            if (!"n_liability_table".equals(nodeType)) {
                for (Map rule : index) {
                    ruleSql = "select a.node_name,a.node_no,b.rule_name,b.rule_info from dsn_structure a  left join dsn_rules b\non a.node_no=b.node_no\nwhere a.up_node=?";
                    querySql.add((Object)StrUtil.trimStr(rule.get("node_no")));
                    querySql.setSql(ruleSql);
                    ruleList = this.dao.findAll(querySql);
                    querySql.clearParam();
                    rule.put("ruleList", ruleList);
                }
            } else {
                for (Map rule : index) {
                    ruleSql = "SELECT a.node_name,\n  a.node_no,\n  b.field_1 name,\n  b.field_2 code,\n  b.field_3 sort\nFROM dsn_structure a\nLEFT JOIN dsn_dynamic_data b\nON a.node_no   =b.relate_fk\nWHERE a.up_node=?";
                    querySql.add((Object)StrUtil.trimStr(rule.get("node_no")));
                    querySql.setSql(ruleSql);
                    ruleList = this.dao.findAll(querySql);
                    querySql.clearParam();
                    rule.put("ruleList", ruleList);
                }
            }
            li.put("indexList", index);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryRiskRate(String nodeNo, String type) throws Exception {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)type);
        Dsn_Structure dsnResult = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.clear();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_name, (Object)"\u9669\u79cd\u4fe1\u606f");
        Dsn_Structure riskResule = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.clear();
        String rate = "select a.node_no,b.field_1 name,b.field_2 code from dsn_structure a left join\ndsn_dynamic_data b\non a.node_no = b.relate_fk\nwhere up_node=?";
        querySql.add((Object)dsnResult.getNodeNo());
        querySql.setSql(rate);
        List result = this.dao.findAll(querySql);
        for (Map map : result) {
            String tableName = "dsn_rate_" + riskResule.getNodeNo().toLowerCase() + "_" + StrUtil.trimStr(map.get("code")).toLowerCase();
            List<Map<String, Object>> rateDetail = null;
            if (DataBaseUtil.queryTableInDB(tableName)) {
                rateDetail = this.getRateDetail(tableName);
            }
            map.put("rateDetail", rateDetail);
            String node = StrUtil.trimStr(map.get("node_no"));
            List<Map<String, Object>> input = this.getParmer(node, "input");
            this.switchParmer(input);
            map.put("input", input);
            List<Map<String, Object>> output = this.getParmer(node, "output");
            this.switchParmer(output);
            map.put("output", output);
        }
        return result;
    }

    private void switchParmer(List<Map<String, Object>> input) {
        for (Map<String, Object> map : input) {
            map.put("column", PinYin4J.converterToFirstSpell(StrUtil.trimStr((Object)map.get("name"))).toLowerCase());
        }
    }

    private List<Map<String, Object>> getRateDetail(String tableName) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from " + tableName;
        querySql.setSql(sql);
        return this.dao.findAll(querySql);
    }

    private List<Map<String, Object>> getParmer(String nodeNo, String type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)type);
        Dsn_Structure structure = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
        dsn.clear();
        String rates = "select b.attr_name name,b.attr_no code from   dsn_structure a\nleft join dsn_biz_attribute  b\non a.relate_fk=b.biz_uuid\nwhere a.up_node=?";
        querySql.add((Object)structure.getNodeNo());
        querySql.setSql(rates);
        return this.dao.findAll(querySql);
    }

    private List<Map<String, Object>> queryAttrOption(QuerySqlable querySql, Map<String, Object> attr) {
        String attrOption = "select * from dsn_biz_attribute_option where biz_uuid = ? order by option_order";
        querySql.add(attr.get("biz_uuid"));
        querySql.setSql(attrOption);
        List optionList = this.dao.findAll(querySql);
        querySql.clearParam();
        return optionList;
    }

    @Override
    public Map<String, Object> getFieldValueApp(List<Map<String, Object>> attrList) {
        HashMap<String, Object> attrValueNew = new HashMap<String, Object>();
        for (Map<String, Object> attrValue : attrList) {
            String key = StrUtil.trimStr((Object)attrValue.get("attr_no"));
            Object value = attrValue.get("field_value");
            attrValueNew.put(key, value);
            if (!"risk_no".equals(key)) continue;
            attrValueNew.put("risk_code", value);
        }
        return attrValueNew;
    }

    @Override
    public String getRiskUUIDByRiskNo(String riskNo) {
        Sip_Risks risk4Query = new Sip_Risks();
        risk4Query.where().addEq((ModelField)Sip_Risks.Field.risk_no, (Object)riskNo);
        risk4Query.where().addEq((ModelField)Sip_Risks.Field.data_flag, (Object)"1");
        risk4Query = (Sip_Risks)this.dao.findOne((AbsModel)risk4Query);
        return risk4Query.getRiskUuid();
    }

    @Override
    public Dsn_Structure getRiskNodeNoByRiskUUID(String riskUUID) {
        Dsn_Structure dsn = this.getDsnStructure(riskUUID);
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)dsn.getUpNode());
        dsn = (Dsn_Structure)this.dao.findOne((AbsModel)dsn);
        return dsn;
    }

    @Override
    public String getPrduuidByRiskUUID(String mainRiskUUID) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)mainRiskUUID);
        List mainRiskAll = this.dao.findAll((AbsModel)dsn);
        if (mainRiskAll.isEmpty()) {
            return "";
        }
        String prsUuid = ((Dsn_Structure)((Object)mainRiskAll.get(0))).getNodeSeq();
        return prsUuid.substring(0, prsUuid.indexOf(46));
    }

    @Override
    public Sip_Risks queryRiskByRiskNo(String riskNo) {
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.risk_no, (Object)riskNo);
        List risks = this.dao.findAll((AbsModel)risk);
        return risks == null || risks.isEmpty() ? null : (Sip_Risks)((Object)risks.get(0));
    }

    @Override
    public Dsn_Structure queryRiskRootNode(String upNodeSeq, String riskUuid) {
        Dsn_Structure riskDetail = this.getDsnStructure(riskUuid);
        riskDetail.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskDetail.getUpNode());
        riskDetail.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)"root");
        List structures = this.dao.findAll((AbsModel)riskDetail);
        if (structures.isEmpty()) {
            riskDetail.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskDetail.getUpNode());
            structures = this.dao.findAll((AbsModel)riskDetail);
        }
        for (Dsn_Structure structure : structures) {
            if (StrUtil.isNull((Object)((Object)structure))) continue;
            return structure;
        }
        return null;
    }

    @Override
    public String getRiskDetailNodeBySerno(String newRiskSerno) {
        Dsn_Structure rootRiskNode = new Dsn_Structure();
        rootRiskNode.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)newRiskSerno);
        rootRiskNode = (Dsn_Structure)this.dao.findOne((AbsModel)rootRiskNode);
        return this.getRiskUuidByNodeNo(rootRiskNode.getNodeNo());
    }

    @Override
    public String getRiskUuidByNode(Dsn_Structure riskNode) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskNode.getNodeNo());
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail", "n_sub_risks_detail", "n_exempt_detail", "n_a_exempt_detai"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            throw new BusinessException(new Message("2016003", riskNode.getNodeName() + "\u9669\u79cd\u6570\u636e\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return ((Dsn_Structure)((Object)queryList.get(0))).getNodeNo();
    }

    @Override
    public String getRiskUuidByNodeNo(String upRiskNodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upRiskNodeNo);
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_detail", "n_accy_detail", "n_sub_risks_detail", "n_exempt_detail", "n_a_exempt_detai"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return ((Dsn_Structure)((Object)queryList.get(0))).getNodeNo();
    }

    @Override
    public Dsn_Structure queryRiskAttrByRiskRootNode(String riskNodeNo) {
        Dsn_Structure dsn = new Dsn_Structure();
        dsn.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskNodeNo);
        dsn.where().addIn((ModelField)Dsn_Structure.Field.node_type, new String[]{"n_risk_attr", "n_a_exempt_attr", "n_accy_attr", "n_risk_attr"});
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return (Dsn_Structure)((Object)queryList.get(0));
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, Dsn_Structure riskVo, String organPrdUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryRisk = "select * from sip_risks where risk_uuid = ?";
        querySql.add((Object)riskVo.getNodeNo());
        querySql.setSql(queryRisk);
        List riskInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        Map risk = riskInfo.isEmpty() ? null : (Map)riskInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            this.detalFieldData(riskVo, organPrdUuid, querySql, risk, attrValue);
        }
    }

    private void detalFieldData(Dsn_Structure riskVo, String organPrdUuid, QuerySqlable querySql, Map<String, Object> risk, Map<String, Object> attrValue) {
        String storedTab = StrUtil.trimStr((Object)attrValue.get("stored_tab"));
        String storedField = StrUtil.trimStr((Object)attrValue.get("stored_field"));
        String attrUuid = StrUtil.trimStr((Object)attrValue.get("attr_uuid"));
        String attrNo = StrUtil.trimStr((Object)attrValue.get("attr_no"));
        if ("sip_risks".equalsIgnoreCase(storedTab) && null != risk) {
            if ("risk_no".equals(attrNo)) {
                String policyId = StrUtil.trimStr((Object)risk.get("policy_code"));
                attrValue.put("field_value", policyId);
            } else {
                attrValue.put("field_value", risk.get(storedField));
            }
        }
        if (!StrUtil.isNull((Object)organPrdUuid)) {
            Map organRisk;
            String queryProduct = "select * from sip_organ_risk_info where organ_prd_uuid = ? and risk_uuid = ? and attr_uuid = ?";
            querySql.add((Object)organPrdUuid);
            querySql.add((Object)riskVo.getNodeNo());
            querySql.add((Object)attrUuid);
            querySql.setSql(queryProduct);
            List riskOrganInfo = this.dao.findAll(querySql);
            querySql.clearParam();
            Map map = organRisk = riskOrganInfo.isEmpty() ? null : (Map)riskOrganInfo.get(0);
            if (null != organRisk) {
                attrValue.put("field_value", organRisk.get("attr_value"));
            }
        }
    }

    @Override
    public List<Map<String, Object>> queryRiskAttr(Map<String, Object> param, String nodeNo) {
        String organRiskUuid = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        List<Map<String, Object>> optionList = null;
        Dsn_Structure dsnStructure = new Dsn_Structure();
        Dsn_Structure riskAttr = this.getDsnStructureByUpNodeAndNodeType(nodeNo, "n_risk_attr");
        String attr = "attr";
        String queryProduct = "SELECT * FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ?";
        querySql.add((Object)riskAttr.getNodeNo());
        querySql.add((Object)attr);
        querySql.setSql(queryProduct);
        List riskAttrInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        for (Map attrVo : riskAttrInfo) {
            optionList = this.queryAttrOption(querySql, attrVo);
            attrVo.put("attrOption", optionList);
            dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)StrUtil.trimStr(attrVo.get("node_no")));
            Dsn_Structure ruleNo = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
            Map<String, Object> ruleInfo = this.rule.queryRiskRule(ruleNo.getNodeNo(), organRiskUuid, param, StrUtil.trimStr(attrVo.get("attr_no")));
            attrVo.put("ruleOption", ruleInfo);
        }
        return riskAttrInfo;
    }

    @Override
    public List<Map<String, Object>> queryRiskAttrOption(String subUuid, String key) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)subUuid);
        Dsn_Structure riskAttr = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        String riskNode = riskAttr.getUpNode();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)riskNode);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_risk_attr");
        Dsn_Structure attrNode = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        String queryProduct = "SELECT * FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ? and attr.attr_no=?";
        querySql.add((Object)attrNode.getNodeNo());
        querySql.add((Object)"attr");
        querySql.add((Object)key);
        querySql.setSql(queryProduct);
        List riskAttrInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        List<Map<String, Object>> result = null;
        result = this.getMaps(querySql, riskAttrInfo, result);
        return result;
    }

    @Override
    public String getRiskUuid(String productUuid, String riskNo) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select b.risk_uuid from sip_product_risks a left join sip_risks b on a.risk_uuid=b.risk_uuid where a.product_uuid=? and  b.policy_id=?";
        querySql.add((Object)productUuid);
        querySql.add((Object)riskNo);
        querySql.setSql(sql);
        List findAll = this.dao.findAll(querySql);
        Map map = (Map)findAll.get(0);
        return StrUtil.trimStr(map.get("risk_uuid"));
    }

    @Override
    public List<Map<String, Object>> getOrganPrdUuid(String productUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "SELECT *  from sip_organ_products where product_uuid = ?";
        querySql.add((Object)productUuid);
        querySql.setSql(sql);
        return this.dao.findAll(querySql);
    }

    @Override
    public List<Map<String, Object>> getOrganPrdUuidByChannel(String productUuid, String channelNo, String organId) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "SELECT *  from sip_organ_products where product_uuid = ? and channel_no=? and organ_id=? ";
        querySql.add((Object)productUuid);
        querySql.add((Object)channelNo);
        querySql.add((Object)organId);
        querySql.setSql(sql);
        return this.dao.findAll(querySql);
    }

    @Override
    public List<Map<String, Object>> queryOrganPrd(String orgPrdUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "SELECT *  from sip_organ_products where organ_prd_uuid = ?";
        querySql.add((Object)orgPrdUuid);
        querySql.setSql(sql);
        return this.dao.findAll(querySql);
    }

    private List<Map<String, Object>> getMaps(QuerySqlable querySql, List<Map<String, Object>> riskAttrInfo, List<Map<String, Object>> result) {
        if (null != riskAttrInfo && !riskAttrInfo.isEmpty()) {
            Map<String, Object> attrVo = riskAttrInfo.get(0);
            result = this.queryAttrOption(querySql, attrVo);
            for (Map<String, Object> map : result) {
                ModelUtilSipService.removeUnused(map);
            }
        }
        return result;
    }

    private Dsn_Structure getDsnStructure(String riskUuid) {
        Dsn_Structure riskDetail = new Dsn_Structure();
        riskDetail.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)riskUuid);
        riskDetail = (Dsn_Structure)this.dao.findOne((AbsModel)riskDetail);
        return riskDetail;
    }

    @Override
    public Dsn_Structure getDsnStructureInfo(String nodeNo, String type) {
        if ("n_risk_detail".equals(type) || "n_accy_exempt".equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, "n_risk_detail");
        }
        if ("main_exempt".equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, "n_exempt_detail");
        }
        if ("n_accy_risks".equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, "n_accy_detail");
        }
        if ("n_sub_risks_detail".equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, "n_sub_risks_detail");
        }
        return this.getDsnStructureByUpNode(nodeNo);
    }

    public Dsn_Structure getDsnStructureByUpNodeAndNodeType(String nodeNo, String type) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)type);
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
    }

    public List<Dsn_Structure> getDsnStructureList(String nodeNo, String type) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)type);
        return this.dao.findAll((AbsModel)dsnStructure);
    }

    public Dsn_Structure getDsnStructureByUpNode(String nodeNo) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nodeNo);
        return (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
    }

    @Override
    public List<Sip_Risks> queryRiskStructure(List<Map<String, Object>> riskList) {
        Sip_Risks sipRisks = new Sip_Risks();
        ArrayList<Map<String, Object>> risks = new ArrayList<Map<String, Object>>();
        sipRisks.where().addNotEq((ModelField)Sip_Risks.Field.is_main_risk, (Object)"S");
        risks.addAll(riskList);
        riskList.forEach(e -> risks.addAll((List)e.get("additional_risk")));
        ArrayList<Sip_Risks> returnList = new ArrayList<Sip_Risks>();
        risks.forEach(risk -> {
            String riskUuid = "";
            if ("common-add".equalsIgnoreCase(StrUtil.trimStr(risk.get("risk_no")))) {
                String riskNo = StrUtil.trimStr(risk.get("risk_no"));
                riskUuid = riskCodeMap.get(riskNo);
            } else {
                riskUuid = riskCodeMap.get(StrUtil.trimStr(risk.get("policy_code")));
            }
            Sip_Risks sip = new Sip_Risks();
            sip.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUuid);
            Sip_Risks one = (Sip_Risks)this.dao.findOne((AbsModel)sip);
            if (!StrUtil.isNull((Object)one.getSerno())) {
                returnList.add(one);
            } else if ("common-add".equalsIgnoreCase(StrUtil.trimStr(risk.get("risk_no")))) {
                sipRisks.where().addIn((ModelField)Sip_Risks.Field.policy_code, StrUtil.trimStr(risk.get("risk_no")));
            } else {
                sipRisks.where().addIn((ModelField)Sip_Risks.Field.policy_code, StrUtil.trimStr(risk.get("policy_code")));
            }
        });
        List risksList = this.dao.findAll((AbsModel)sipRisks);
        ArrayList risksListNew = new ArrayList();
        risksList.forEach(e -> {
            Dsn_Structure riskNodeNoByRiskUUID = this.getRiskNodeNoByRiskUUID(e.getRiskUuid());
            if (!"root".equalsIgnoreCase(riskNodeNoByRiskUUID.getNodeType())) {
                risksListNew.add(e);
            }
        });
        Map<String, List<Sip_Risks>> collect = risksListNew.stream().collect(Collectors.groupingBy(Sip_Risks::getPolicyCode));
        if (!collect.isEmpty()) {
            collect.forEach((k, v) -> returnList.add((Sip_Risks)((Object)v.get(0))));
        }
        return returnList;
    }

    @Override
    public List<Dsn_Structure> queryNewRiskUuid(String upNode) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)upNode);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_risks");
        Dsn_Structure nAccyRisks = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        structure.where().addEq((ModelField)Dsn_Structure.Field.up_node, (Object)nAccyRisks.getNodeNo());
        List accyRisks = this.dao.findAll((AbsModel)structure);
        accyRisks.forEach(risk -> {
            structure.where().addIn((ModelField)Dsn_Structure.Field.up_node, risk.getNodeNo());
            structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_accy_detail");
        });
        if (!accyRisks.isEmpty()) {
            return this.dao.findAll((AbsModel)structure);
        }
        return new ArrayList<Dsn_Structure>();
    }

    @Override
    public String ruleNodeNo(String productUuid, String type) {
        Dsn_Structure riskDsn = this.getDsnStructure(productUuid);
        Dsn_Structure ruleDsn = this.getDsnStructureByUpNodeAndNodeType(riskDsn.getUpNode(), "n_rule");
        Dsn_Structure insureRuleDsn = this.getDsnStructureByUpNodeAndNodeType(ruleDsn.getNodeNo(), type);
        return insureRuleDsn.getNodeNo();
    }

    @Override
    public String queryPolicyCodeBySerno(String serno) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.serno, (Object)serno);
        Dsn_Structure addRiskNode = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        Dsn_Structure addRiskDetail = this.getDsnStructureByUpNodeAndNodeType(addRiskNode.getNodeNo(), "n_accy_detail");
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)addRiskDetail.getNodeNo());
        Sip_Risks riskResult = (Sip_Risks)this.dao.findOne((AbsModel)risk);
        return riskResult.getPolicyCode();
    }

    @Override
    public String queryPolicyCodeByAdd(String nodeNo) {
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        Dsn_Structure upNode = (Dsn_Structure)this.dao.findOne((AbsModel)dsnStructure);
        Dsn_Structure addRiskDetail = this.getDsnStructureByUpNodeAndNodeType(upNode.getUpNode(), "n_risk_detail");
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)addRiskDetail.getNodeNo());
        Sip_Risks riskResult = (Sip_Risks)this.dao.findOne((AbsModel)risk);
        return riskResult.getPolicyCode();
    }

    @Override
    public boolean validRiskCommon(String addNodeNo, String mainNodeNo) {
        boolean flag = true;
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select * from sip_common_risk_relation where main_risk_no =? and add_risk_no=?";
        querySql.add((Object)mainNodeNo);
        querySql.add((Object)addNodeNo);
        querySql.setSql(sql);
        List result = this.dao.findAll(querySql);
        if (null == result || result.isEmpty()) {
            flag = false;
        }
        return flag;
    }

    @Override
    public List<Sip_Risks> queryRiskByRiskClassify() {
        Sip_Risks sipRisks = new Sip_Risks();
        sipRisks.where().addLike((ModelField)Sip_Risks.Field.risk_classify, (Object)"904");
        return this.dao.findAll((AbsModel)sipRisks);
    }

    @Override
    public List<Sip_Risks> queryRiskByRiskClassify2() {
        Sip_Risks sipRisks = new Sip_Risks();
        sipRisks.where().addLike((ModelField)Sip_Risks.Field.risk_classify, (Object)"903");
        return this.dao.findAll((AbsModel)sipRisks);
    }

    static {
        riskCodeMap.put("D4R", "NLsUpu9q");
        riskCodeMap.put("982", "r7mmDkAl");
        riskCodeMap.put("983", "E96lIUMb");
        riskCodeMap.put("984", "OsxUBFZm");
        riskCodeMap.put("682", "y3nduygq");
        riskCodeMap.put("common-add", "7hPRKPZF");
    }
}

