/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.dao.impl;

import cn.com.chinalife.config.ProductListConfig;
import cn.com.chinalife.dao.IProductDaoSipService;
import cn.com.chinalife.model.Dsn_Structure;
import cn.com.chinalife.model.Sip_Organ_Product_Info;
import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.model.Sip_Organ_Risk_Info;
import cn.com.chinalife.model.Sip_Organ_Risk_Relation;
import cn.com.chinalife.model.Sip_Organ_Rules;
import cn.com.chinalife.model.Sip_Products;
import cn.com.chinalife.model.Sip_Products_Relation;
import cn.com.chinalife.model.Sip_Risks;
import cn.com.chinalife.util.JsonUtilsSipService;
import cn.com.chinalife.util.StructureConstantSipService;
import com.newtouch.cache.CacheManager;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.context.pojo.PageCount;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.msg.Return;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import com.newtouch.util.uuid.UniqueSeq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ProductDaoSipServiceImpl
implements IProductDaoSipService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private ProductListConfig productListConfig;

    @Override
    public List<Map<String, Object>> queryProductList(Map<String, Object> param) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        StringBuilder sql = new StringBuilder();
        sql.append("select * from sip_products where data_flag =?");
        querySql.add((Object)"1");
        if (!StrUtil.isNull((Object)param.get("product_no"))) {
            sql.append("and product_no like ?");
            querySql.add((Object)("%" + param.get("product_no").toString() + "%"));
        }
        if (!StrUtil.isNull((Object)param.get("product_name"))) {
            sql.append("and product_name like ?");
            querySql.add((Object)("%" + param.get("product_name").toString() + "%"));
        }
        if (!StrUtil.isNull((Object)param.get("product_type"))) {
            sql.append("and product_type = ?");
            querySql.add((Object)param.get("product_type").toString());
        }
        if (!StrUtil.isNull((Object)param.get("product_sale_channel"))) {
            sql.append("and product_sale_channel like ?");
            querySql.add((Object)("%" + param.get("product_sale_channel").toString() + "%"));
        }
        this.getGroupProductSql(param, querySql, organId, sql);
        PageCount pageCount = ThreadLocalContext.get().getPageCount();
        if (!StrUtil.isNull((Object)StrUtil.trimStr((Object)param.get("nowPage"))) && !StrUtil.isNull((Object)StrUtil.trimStr((Object)param.get("rows4Page")))) {
            pageCount.setNowPage(Integer.valueOf(StrUtil.trimStr((Object)param.get("nowPage"))));
            pageCount.setRows4Page(Integer.valueOf(StrUtil.trimStr((Object)param.get("rows4Page"))));
            querySql.setPaginate(true);
        }
        querySql.setSql(sql.toString());
        List findAll = this.dao.findAll(querySql, false);
        querySql.clearParam();
        List readsList = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String proposeList = this.productListConfig.getOnline();
        String prd = "('";
        List<String> productList = Arrays.asList(proposeList.split(","));
        for (String product_no : productList) {
            prd = prd + product_no + "','";
        }
        prd = prd.substring(0, prd.length() - 2) + ")";
        String sqlPro = "select * from sip_products where product_no in " + prd;
        querySql.setSql(sqlPro);
        List propose = this.dao.findAll(querySql);
        querySql.clearParam();
        findAll.addAll(propose);
        try {
            readsList = JsonUtil.json2List((String)JsonUtil.toJson((Object)findAll));
            for (Map productResult : readsList) {
                this.dealResultList(param, querySql, resultList, productResult);
            }
        }
        catch (Exception e) {
            throw new BusinessException(new Message("1016001", "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\u5f02\u5e38"));
        }
        return resultList;
    }

    @Override
    public String queryRiskClassByRiskCode(String riskCode) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder sql = new StringBuilder();
        sql.append("select risk_classify from sip_risks where policy_code = ? and is_main_risk = ?");
        querySql.add((Object)riskCode);
        querySql.add((Object)"M");
        querySql.setSql(sql.toString());
        return (String)((Map)this.dao.findAll(querySql, false).get(0)).get("risk_classify");
    }

    private void dealResultList(Map<String, Object> param, QuerySqlable querySql, List<Map<String, Object>> resultList, Map<String, Object> productResult) {
        String queryAttr;
        String type = StrUtil.trimStr((Object)productResult.get("product_catefory"));
        String productUuid = StrUtil.trimStr((Object)productResult.get("product_uuid"));
        param.put("product_uuid", productUuid);
        Sip_Organ_Products organProduct = this.queryOrganProduct(param);
        if ("Z".equals(type)) {
            queryAttr = "select sp.product_no from sip_products sp left join sip_products_relation spr on spr.product_uuid = sp.product_uuid where spr.composite_product_uuid = ?";
            querySql.add((Object)productUuid);
            querySql.setSql(queryAttr);
            querySql.setPaginate(false);
            List prdList = this.dao.findAll(querySql, false);
            querySql.clearParam();
            productResult.put("compose", prdList);
            this.productRisks(productResult, type);
        } else {
            this.productRisks(productResult, type);
        }
        if (null != organProduct) {
            queryAttr = "select attr_no,attr_value from sip_organ_product_info  where organ_prd_uuid =?";
            querySql.add((Object)organProduct.getOrganPrdUuid());
            querySql.setSql(queryAttr);
            querySql.setPaginate(false);
            List organPrdList = this.dao.findAll(querySql, false);
            querySql.clearParam();
            if (null != organPrdList && !organPrdList.isEmpty()) {
                this.dealPrdInfo(productResult, organPrdList);
            }
            productResult.put("pol_start_date", organProduct.getPolStartDate());
            productResult.put("pol_end_date", organProduct.getPolEndDate());
            productResult.put("prp_start_date", organProduct.getPrpStartDate());
            productResult.put("prp_end_date", organProduct.getPrpEndDate());
        }
        resultList.add(productResult);
    }

    private void productRisks(Map<String, Object> productResult, String type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder riskResule = new StringBuilder();
        StringBuilder riskDividend = new StringBuilder();
        StringBuffer isUniversal = new StringBuffer("N");
        StringBuffer isDividend = new StringBuffer("N");
        String productUuid = StrUtil.trimStr((Object)productResult.get("product_uuid"));
        if ("Z".equals(type)) {
            String queryAttr = "select * from sip_products sp left join sip_products_relation spr on spr.product_uuid = sp.product_uuid where spr.composite_product_uuid =?";
            querySql.add((Object)productUuid);
            querySql.setSql(queryAttr);
            querySql.setPaginate(false);
            List comsProductList = this.dao.findAll(querySql, false);
            querySql.clearParam();
            if (null != comsProductList && !comsProductList.isEmpty()) {
                for (Map prdUuid : comsProductList) {
                    String comsPrductUuid = StrUtil.trimStr(prdUuid.get("product_uuid"));
                    this.dealRiskCode(comsPrductUuid, riskResule, isUniversal, isDividend);
                }
            }
        } else {
            this.dealRiskCode(productUuid, riskResule, isUniversal, isDividend);
        }
        if (!StrUtil.isNull((Object)riskResule)) {
            productResult.put("riskCode", riskResule.toString().substring(0, riskResule.toString().length() - 1));
            productResult.put("isUniversal", isUniversal);
            productResult.put("isDividend", isDividend);
        }
    }

    private void dealRiskCode(String productUuid, StringBuilder riskResule, StringBuffer isUniversal, StringBuffer isDividend) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryAttr = "select * from sip_product_risks  where product_uuid=?";
        querySql.add((Object)productUuid);
        querySql.setSql(queryAttr);
        querySql.setPaginate(false);
        List riskList = this.dao.findAll(querySql);
        querySql.clearParam();
        StringBuilder riskCodes = new StringBuilder();
        for (Map risk : riskList) {
            String queryrisk = "select policy_code,risk_classify  from sip_risks where risk_uuid=?";
            querySql.add(risk.get("risk_uuid"));
            querySql.setSql(queryrisk);
            querySql.setPaginate(false);
            List riskCode = this.dao.findAll(querySql);
            if (null != riskCode && !riskCode.isEmpty()) {
                String code = StrUtil.trimStr(((Map)riskCode.get(0)).get("policy_code"));
                riskResule.append(code).append(",");
                if (StrUtil.trimStr(((Map)riskCode.get(0)).get("risk_classify")).contains("904")) {
                    riskCodes.append(code);
                    riskResule.delete(riskResule.length() - code.length() - 1, riskResule.length());
                    isUniversal.replace(0, 1, "Y");
                }
                if (StrUtil.trimStr(((Map)riskCode.get(0)).get("risk_classify")).contains("903")) {
                    isDividend.replace(0, 1, "Y");
                }
            }
            querySql.clearParam();
        }
        if (!StrUtil.isNull((Object)riskCodes)) {
            riskResule.append((CharSequence)riskCodes).append(",");
        }
    }

    public void dealPrdInfo(Map<String, Object> productResult, List<Map<String, Object>> organPrdList) {
        for (Map<String, Object> prd : organPrdList) {
            String key = StrUtil.trimStr((Object)prd.get("attr_no"));
            String value = StrUtil.trimStr((Object)prd.get("attr_value"));
            if ("product_tip".equals(key)) {
                String value1 = StrUtil.trimStr((Object)productResult.get("product_tip"));
                value = JsonUtilsSipService.getUnion(value1, value, ",");
            }
            productResult.put(key, value);
        }
    }

    private void getGroupProductSql(Map<String, Object> param, QuerySqlable querySql, String organId, StringBuilder sql) {
        if ("1".equals(param.get("flag"))) {
            if (StrUtil.isNull((Object)param.get("state"))) {
                sql.append("and (open_state = ? or  open_state = ?) and product_catefory is null ");
                querySql.add((Object)"ALL");
                querySql.add((Object)"PART");
            } else {
                sql.append("and open_state = ? and product_catefory is null ");
                querySql.add((Object)param.get("state").toString());
            }
        } else if (!StrUtil.isNull((Object)param.get("product_name"))) {
            sql.append("and open_state = ? or (open_state=? and( product_catefory!=? or product_catefory  is  null )and product_name like ?) ");
            this.dealQuerySql(querySql, "product_name", organId, param, sql);
        } else if (!StrUtil.isNull((Object)param.get("product_no"))) {
            sql.append("and open_state = ? or (open_state=? and ( product_catefory!=? or product_catefory  is  null )and product_no like ?) ");
            this.dealQuerySql(querySql, "product_no", organId, param, sql);
        } else if (!StrUtil.isNull((Object)param.get("product_type"))) {
            sql.append("and open_state = ? or (open_state=? and ( product_catefory!=? or product_catefory  is  null ) and product_type = ?) ");
            this.dealQuerySql(querySql, "product_type", organId, param, sql);
        } else if ("ALL".equals(param.get("state"))) {
            sql.append("and open_state = ?");
            querySql.add((Object)param.get("state").toString());
        } else if ("PART".equals(param.get("state"))) {
            sql.append("and open_state= ? and (product_catefory!=?\u3000or product_catefory is null )\nor (product_catefory =? and organ_id =? and channel_no=?) \norder by mdf_date desc");
            querySql.add((Object)param.get("state").toString());
            querySql.add((Object)"Z");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
        } else {
            sql.append("and open_state = ? or (open_state=? and (product_catefory!=? or product_catefory  is  null) ) ");
            this.dealQuerySql(querySql, "", organId, param, sql);
        }
    }

    private void dealQuerySql(QuerySqlable querySql, String type, String organId, Map<String, Object> param, StringBuilder sql) {
        if (!StrUtil.isNull((Object)param.get("state"))) {
            querySql.add((Object)param.get("state").toString());
        } else {
            querySql.add((Object)"ALL");
        }
        querySql.add((Object)"PART");
        querySql.add((Object)"Z");
        if (type.equals("product_name")) {
            querySql.add((Object)("%" + param.get("product_name").toString() + "%"));
            sql.append("or (product_catefory =? and organ_id =? and channel_no=? and product_name like ?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
            querySql.add((Object)("%" + param.get("product_name").toString() + "%"));
        } else if (type.equals("product_no")) {
            querySql.add((Object)("%" + param.get("product_no").toString() + "%"));
            sql.append("or (product_catefory =? and organ_id =? and channel_no=? and product_no like ?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
            querySql.add((Object)("%" + param.get("product_no").toString() + "%"));
        } else if (type.equals("product_type")) {
            querySql.add((Object)param.get("product_type").toString());
            sql.append("or (product_catefory =? and organ_id =? and channel_no=? and product_type= ?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
            querySql.add((Object)param.get("product_type").toString());
        } else {
            sql.append("or (product_catefory =? and organ_id =? and channel_no=?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
        }
    }

    @Override
    public List<Map<String, Object>> queryOrganProductList(Map<String, Object> param) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtil.trimStr((Object)param.get("channel_no"));
        String sql = "select a.* from sip_products a  right  join \n(select * from sip_organ_products   where organ_id = ?  and channel_no=?) b\non a.product_uuid = b.product_uuid\nwhere (a.product_catefory is null  or a.product_catefory !=?)  and (a.open_state=?  or a.open_state =?)";
        querySql.add((Object)organId);
        querySql.add((Object)channelNo);
        querySql.add((Object)"Z");
        querySql.add((Object)"ALL");
        querySql.add((Object)"PART");
        querySql.setSql(sql);
        List findAllPrd = this.dao.findAll(querySql);
        querySql.clearParam();
        String queryAttr = "select * from sip_products  where product_catefory=?  and organ_id=? and channel_no=? ";
        querySql.add((Object)"Z");
        String organIdProvi = "";
        organIdProvi = StructureConstantSipService.getOrganSpecialList().contains(organId.subSequence(0, 4)) ? organId.subSequence(0, 4) + "00" : organId.subSequence(0, 2) + "0000";
        querySql.add((Object)organIdProvi);
        querySql.add((Object)channelNo);
        querySql.setSql(queryAttr);
        List findAll = this.dao.findAll(querySql, false);
        querySql.clearParam();
        for (Map map : findAll) {
            findAllPrd.add(map);
        }
        List readsList = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            readsList = JsonUtil.json2List((String)JsonUtil.toJson((Object)findAllPrd));
            for (Map productResult : readsList) {
                this.dealResultList(param, querySql, resultList, productResult);
            }
        }
        catch (Exception e) {
            throw new BusinessException(new Message("1016001", "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\u5f02\u5e38"));
        }
        return resultList;
    }

    @Override
    public List<Map<String, Object>> queryProductDetail(Map<String, Object> param) {
        String queryAttr;
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        Dsn_Structure dsnStructure = new Dsn_Structure();
        String organPrdUuid = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        String productUuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        String nodeType = "prd_detail";
        List attrList = null;
        List optionList = null;
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)nodeType);
        dsnStructure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUuid);
        List nodeSeqList = this.dao.findAll((AbsModel)dsnStructure, false);
        for (Dsn_Structure node : nodeSeqList) {
            queryAttr = "SELECT * FROM dsn_structure str join dsn_biz_attribute attr  on str.node_no = attr.biz_uuid WHERE str.up_node = ?";
            querySql.add((Object)node.getNodeNo());
            querySql.setSql(queryAttr);
            attrList = this.dao.findAll(querySql);
            querySql.clearParam();
        }
        if (null != attrList && !attrList.isEmpty()) {
            for (Map attr : attrList) {
                queryAttr = "select * from dsn_biz_attribute_option where biz_uuid = ?  order by option_order";
                querySql.add(attr.get("biz_uuid"));
                querySql.setSql(queryAttr);
                optionList = this.dao.findAll(querySql);
                querySql.clearParam();
                attr.put("attrOption", optionList);
            }
            this.getFieldValueOrgan(attrList, productUuid, organPrdUuid);
        }
        return attrList;
    }

    @Override
    public Map<String, Object> queryPrdDetail(Map<String, Object> param) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organPrdUuid = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        String productUuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        Object attrList = null;
        String queryProduct = "select * from sip_products where product_uuid = ?";
        querySql.add((Object)productUuid);
        querySql.setSql(queryProduct);
        List productInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        Map product = productInfo.isEmpty() ? null : (Map)productInfo.get(0);
        for (String key : product.keySet()) {
            if (StrUtil.isNull((Object)organPrdUuid)) continue;
            String queryOrganProduct = "select * from sip_organ_product_info where organ_prd_uuid = ? and attr_no = ?";
            querySql.add((Object)organPrdUuid);
            querySql.add((Object)key);
            querySql.setSql(queryOrganProduct);
            List organProductInfo = this.dao.findAll(querySql);
            querySql.clearParam();
            Map organ = organProductInfo.isEmpty() ? null : (Map)organProductInfo.get(0);
            if (null == organ) continue;
            product.put(key, organ.get("attr_value"));
        }
        return product;
    }

    @Override
    public Map<String, Object> getFieldValueApp(List<Map<String, Object>> attrList) {
        HashMap<String, Object> attrValueNew = new HashMap<String, Object>();
        for (Map<String, Object> attrValue : attrList) {
            String key = (String)attrValue.get("attr_no");
            Object value = attrValue.get("field_value");
            attrValueNew.put(key, value);
            if (!"product_no".equals(key)) continue;
            attrValueNew.put("product_code", value);
        }
        return attrValueNew;
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, String productUuid, String organPrdUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryProduct = "select * from sip_products where product_uuid = ?";
        querySql.add((Object)productUuid);
        querySql.setSql(queryProduct);
        List productInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        Map product = productInfo.isEmpty() ? null : (Map)productInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            String storedTab = StrUtil.trimStr((Object)attrValue.get("stored_tab"));
            String storedField = StrUtil.trimStr((Object)attrValue.get("stored_field"));
            String attrUuid = StrUtil.trimStr((Object)attrValue.get("attr_uuid"));
            if ("sip_products".equalsIgnoreCase(storedTab) && null != product) {
                attrValue.put("field_value", product.get(storedField));
            }
            if (StrUtil.isNull((Object)organPrdUuid)) continue;
            String queryOrganProduct = "select * from sip_organ_product_info where organ_prd_uuid = ? and attr_uuid = ?";
            querySql.add((Object)organPrdUuid);
            querySql.add((Object)attrUuid);
            querySql.setSql(queryOrganProduct);
            List organProductInfo = this.dao.findAll(querySql);
            querySql.clearParam();
            Map organ = organProductInfo.isEmpty() ? null : (Map)organProductInfo.get(0);
            if (null == organ) continue;
            attrValue.put("field_value", organ.get("attr_value"));
        }
    }

    @Override
    public List<Dsn_Structure> queryRiskInfo(Map<String, Object> param) {
        Ulog.info((String)("\u6839\u636eproduct_uuid\u67e5\u8be2\u4e3b\u9669\u4fe1\u606f\u7684\u5165\u53c2\uff1a" + JsonUtil.toJson(param)));
        String productUuid = StrUtil.trimStr((Object)param.get("product_uuid"));
        Dsn_Structure dsnStructure = new Dsn_Structure();
        dsnStructure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUuid);
        dsnStructure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"main_risks");
        List riskInfo = this.dao.findAll((AbsModel)dsnStructure);
        Ulog.info((String)("\u6839\u636eproduct_uuid\u67e5\u8be2\u4e3b\u9669\u4fe1\u606f\u7684\u8fd4\u53c2\uff1a" + JsonUtil.toJson((Object)riskInfo)));
        return riskInfo;
    }

    @Override
    public void saveProductInfo(List<Map<String, Object>> request, Map<String, Object> product, String organPrdUuid) {
        Return rn = new Return();
        Sip_Organ_Product_Info daoProduct = new Sip_Organ_Product_Info();
        for (Map<String, Object> oldProduct : request) {
            String newValue;
            String key = StrUtil.trimStr((Object)oldProduct.get("attr_no"));
            String value = StrUtil.trimStr((Object)oldProduct.get("field_value"));
            if (value.equals(newValue = StrUtil.trimStr((Object)product.get(key)))) continue;
            Sip_Organ_Product_Info sipOrganProduct = new Sip_Organ_Product_Info();
            sipOrganProduct.setAllowMdf(oldProduct.get("allow_mdf").toString());
            sipOrganProduct.setAttrNo(oldProduct.get("attr_no").toString());
            sipOrganProduct.setAttrUuid(oldProduct.get("attr_uuid").toString());
            sipOrganProduct.setAttrValue(newValue);
            sipOrganProduct.setOrganPrdUuid(organPrdUuid);
            daoProduct.where().addEq((ModelField)Sip_Organ_Product_Info.Field.organ_prd_uuid, (Object)organPrdUuid);
            daoProduct.where().addEq((ModelField)Sip_Organ_Product_Info.Field.attr_uuid, (Object)oldProduct.get("attr_uuid").toString());
            this.dao.delete((AbsModel)daoProduct);
            if (StrUtil.isNull((Object)newValue)) continue;
            this.dao.save((AbsModel)sipOrganProduct);
        }
    }

    @Override
    public void saveRiskInfo(Map<String, Object> riskInfo, Map<String, Object> request, String organPrd, String value) {
        Sip_Organ_Risk_Info daoRisk = new Sip_Organ_Risk_Info();
        Sip_Organ_Risk_Info sipOrganRisk = new Sip_Organ_Risk_Info();
        sipOrganRisk.setAllowMdf(StrUtil.trimStr((Object)riskInfo.get("allow_mdf")));
        sipOrganRisk.setAttrNo(StrUtil.trimStr((Object)riskInfo.get("attr_no")));
        sipOrganRisk.setAttrUuid(StrUtil.trimStr((Object)riskInfo.get("attr_uuid")));
        sipOrganRisk.setRiskUuid(StrUtil.trimStr((Object)request.get("risk_uuid")));
        sipOrganRisk.setOrganPrdUuid(organPrd);
        sipOrganRisk.setAttrValue(value);
        daoRisk.where().addEq((ModelField)Sip_Organ_Risk_Info.Field.organ_prd_uuid, (Object)organPrd);
        daoRisk.where().addEq((ModelField)Sip_Organ_Risk_Info.Field.attr_uuid, (Object)riskInfo.get("attr_uuid").toString());
        this.dao.delete((AbsModel)daoRisk);
        this.dao.save((AbsModel)sipOrganRisk);
    }

    @Override
    public String getProductUUIDByProductNo(String productNo) {
        Sip_Products sipProducts4Query = new Sip_Products();
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        sipProducts4Query.where().addEq((ModelField)Sip_Products.Field.data_flag, (Object)"1");
        Sip_Products sipProducts = (Sip_Products)this.dao.findOne((AbsModel)sipProducts4Query);
        return sipProducts.getProductUuid();
    }

    @Override
    public String getProductDetailNodeByProductUUid(String productUUid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUUid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"prd_detail");
        List structureList = this.dao.findAll((AbsModel)structure);
        return structureList.isEmpty() ? "" : ((Dsn_Structure)((Object)structureList.get(0))).getNodeNo();
    }

    @Override
    public Dsn_Structure getMainParentNodeByProductUUid(String productUUid) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addLikeR((ModelField)Dsn_Structure.Field.node_seq, (Object)productUUid);
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_type, (Object)"n_risk");
        List structureList = this.dao.findAll((AbsModel)structure);
        return structureList.isEmpty() ? null : (Dsn_Structure)((Object)structureList.get(0));
    }

    @Override
    public Sip_Products queryProductByProductNo(String productNo) {
        Sip_Products products = new Sip_Products();
        products.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        List sipProducts = this.dao.findAll((AbsModel)products);
        return sipProducts == null || sipProducts.isEmpty() ? null : (Sip_Products)((Object)sipProducts.get(0));
    }

    @Override
    public Sip_Organ_Products queryOrganProduct(Map<String, Object> request) {
        Sip_Organ_Products sipOrgan = new Sip_Organ_Products();
        Sip_Organ_Products result = null;
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.product_uuid, request.get("product_uuid"));
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.organ_id, request.get("organ_id"));
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.channel_no, request.get("channel_no"));
        List product = this.dao.findAll((AbsModel)sipOrgan, false);
        if (null != product && !product.isEmpty()) {
            result = (Sip_Organ_Products)((Object)product.get(0));
        }
        return result;
    }

    @Override
    public Sip_Products saveCompositeProduct(Map<String, Object> request) {
        String organId = StrUtil.trimStr((Object)request.get("organ_id"));
        String channelNo = StrUtil.trimStr((Object)request.get("channel_type"));
        String productName = StrUtil.trimStr((Object)request.get("product_name"));
        String maxAge = StrUtil.trimStr((Object)request.get("max_age"));
        String minAge = StrUtil.trimStr((Object)request.get("min_age"));
        String productUuid = UniqueSeq.shortUUID();
        String productNo = UniqueSeq.shortUUID();
        Sip_Products sipProducts = new Sip_Products();
        sipProducts.setOrganId(organId);
        sipProducts.setChannelNo(channelNo);
        sipProducts.setProductName(productName);
        sipProducts.setProductUuid(productUuid);
        sipProducts.setProductNo(productNo);
        sipProducts.setProductCatefory("Z");
        sipProducts.setMaxAge(maxAge);
        sipProducts.setMinAge(minAge);
        sipProducts.setOpenState("PART");
        sipProducts.setState("1");
        this.dao.save((AbsModel)sipProducts);
        return sipProducts;
    }

    @Override
    public void saveCompositeRelation(Map<String, Object> request, Sip_Products sipProducts) {
        ArrayList<Sip_Products_Relation> list = new ArrayList<Sip_Products_Relation>();
        String compositeProductUuid = sipProducts.getProductUuid();
        String productNo = sipProducts.getProductNo();
        String productList = JsonUtil.toJson((Object)request.get("dataList"));
        List productMap = JsonUtil.json2List((String)productList);
        for (Map product : productMap) {
            Sip_Products_Relation productRelation = new Sip_Products_Relation();
            productRelation.setCompositeProductUuid(compositeProductUuid);
            productRelation.setProductNo(productNo);
            productRelation.setProductUuid(StrUtil.trimStr(product.get("product_uuid")));
            list.add(productRelation);
        }
        this.dao.save(list);
    }

    @Override
    public List<Map<String, Object>> queryProductListToRedis(Map<String, Object> param) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.data_flag, (Object)1);
        if ("000000".equals(organId)) {
            product.where().addEq((ModelField)Sip_Products.Field.open_state, (Object)"ALL");
        } else {
            product.where().addEq((ModelField)Sip_Products.Field.open_state, (Object)"PART");
        }
        product.setOrderBy(new Sort.Order[]{Sip_Products.Field.mdf_date.desc()});
        List findAll = this.dao.findAll((AbsModel)product, false);
        List readsList = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            readsList = JsonUtil.json2List((String)JsonUtil.toJson((Object)findAll));
            for (Map productResult : readsList) {
                String type = StrUtil.trimStr(productResult.get("product_catefory"));
                String organ = StrUtil.trimStr(productResult.get("organ_id"));
                String productUuid = StrUtil.trimStr(productResult.get("product_uuid"));
                if ("Z".equals(type)) {
                    if (!organId.equals(organ)) continue;
                    String queryAttr = "select sp.product_no from sip_products sp left join sip_products_relation spr on spr.product_uuid = sp.product_uuid where spr.composite_product_uuid = ?";
                    querySql.add((Object)productUuid);
                    querySql.setSql(queryAttr);
                    List prdList = this.dao.findAll(querySql);
                    querySql.clearParam();
                    productResult.put("compose", prdList);
                    resultList.add(productResult);
                    continue;
                }
                resultList.add(productResult);
            }
        }
        catch (Exception e) {
            throw new BusinessException(new Message("1016001", "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\u5f02\u5e38"));
        }
        return resultList;
    }

    @Override
    public String getUpNode(String nodeNo) {
        Dsn_Structure structure = new Dsn_Structure();
        structure.where().addEq((ModelField)Dsn_Structure.Field.node_no, (Object)nodeNo);
        Dsn_Structure dsnStructure = (Dsn_Structure)this.dao.findOne((AbsModel)structure);
        return dsnStructure.getUpNode();
    }

    @Override
    public Map<String, Object> queryProductAndRiskInfo(String productNo) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryOrgan = "";
        querySql.add((Object)productNo);
        querySql.setSql(queryOrgan);
        this.dao.findAll(querySql);
        return null;
    }

    @Override
    public List<Map<String, Object>> queryRiskUuid(String productNo) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select risk_uuid from sip_products p right join sip_product_risks pr on p.product_uuid = pr.product_uuid  where p.product_no = ?";
        querySql.add((Object)productNo);
        querySql.setSql(sql);
        return this.dao.findAll(querySql);
    }

    @Override
    public Sip_Products queryProductInfo(String productNo) {
        Sip_Products product = new Sip_Products();
        product.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)productNo);
        return (Sip_Products)this.dao.findOne((AbsModel)product);
    }

    @Override
    public List<Map<String, Object>> queryAttachRiskUuid(String riskUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String sql = "select distinct srr.risk_uuid from sip_product_risks r right join sip_risk_relation srr on r.risk_uuid = srr.main_risk where r.risk_uuid = ? ";
        querySql.add((Object)riskUuid);
        querySql.setSql(sql);
        return this.dao.findAll(querySql);
    }

    @Override
    public Sip_Risks queryRiskInfo(String riskUuid) {
        Sip_Risks risk = new Sip_Risks();
        risk.where().addEq((ModelField)Sip_Risks.Field.risk_uuid, (Object)riskUuid);
        return (Sip_Risks)this.dao.findOne((AbsModel)risk);
    }

    @Override
    public void deleteOrganPrd(Map<String, Object> param) {
        String organPrd = StrUtil.trimStr((Object)param.get("organ_prd_uuid"));
        String prdNo = StrUtil.trimStr((Object)param.get("product_no"));
        HashMap<String, Object> req = new HashMap<String, Object>();
        Sip_Organ_Products sipOrganPrd = new Sip_Organ_Products();
        sipOrganPrd.where().addEq((ModelField)Sip_Organ_Products.Field.organ_prd_uuid, (Object)organPrd);
        Sip_Organ_Products organPrd1 = (Sip_Organ_Products)this.dao.findOne((AbsModel)sipOrganPrd);
        req.put("organ_id", organPrd1.getOrganId());
        req.put("channel_no", organPrd1.getChannelNo());
        sipOrganPrd.clear();
        sipOrganPrd.where().addEq((ModelField)Sip_Organ_Products.Field.organ_prd_uuid, (Object)organPrd);
        this.dao.delete((AbsModel)sipOrganPrd);
        Sip_Organ_Product_Info sipPrdInfo = new Sip_Organ_Product_Info();
        sipPrdInfo.where().addEq((ModelField)Sip_Organ_Product_Info.Field.organ_prd_uuid, (Object)organPrd);
        this.dao.delete((AbsModel)sipPrdInfo);
        Sip_Organ_Risk_Info sipRiskPrd = new Sip_Organ_Risk_Info();
        sipRiskPrd.where().addEq((ModelField)Sip_Organ_Risk_Info.Field.organ_prd_uuid, (Object)organPrd);
        this.dao.delete((AbsModel)sipRiskPrd);
        Sip_Organ_Risk_Relation sipRelationPrd = new Sip_Organ_Risk_Relation();
        sipRelationPrd.where().addEq((ModelField)Sip_Organ_Risk_Relation.Field.organ_prd_uuid, (Object)organPrd);
        this.dao.delete((AbsModel)sipRelationPrd);
        Sip_Organ_Rules rules = new Sip_Organ_Rules();
        rules.where().addEq((ModelField)Sip_Organ_Rules.Field.organ_prd_uuid, (Object)organPrd);
        this.dao.delete((AbsModel)rules);
        String key = "prdDetail:" + prdNo + organPrd1.getOrganId() + organPrd1.getChannelNo();
        CacheManager.remove((String)key);
        List<Map<String, Object>> organList = this.queryOrganProductList(req);
        CacheManager.put((String)("prdList:" + organPrd1.getOrganId() + organPrd1.getChannelNo()), (Object)JsonUtil.toJson(organList));
    }

    @Override
    public void deleteCompositeProduct(Map<String, Object> param) {
        String prdNo = StrUtil.trimStr((Object)param.get("product_no"));
        String channelNo = StrUtil.trimStr((Object)param.get("channel_no"));
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        Sip_Products sipPrdInfo = new Sip_Products();
        sipPrdInfo.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)prdNo);
        Sip_Products prd2 = (Sip_Products)this.dao.findOne((AbsModel)sipPrdInfo);
        sipPrdInfo.clear();
        sipPrdInfo.where().addEq((ModelField)Sip_Products.Field.product_no, (Object)prdNo);
        this.dao.delete((AbsModel)sipPrdInfo);
        Sip_Organ_Products sipOrganPrd = new Sip_Organ_Products();
        sipOrganPrd.where().addEq((ModelField)Sip_Organ_Products.Field.product_uuid, (Object)prd2.getProductUuid());
        this.dao.delete((AbsModel)sipOrganPrd);
        List<Map<String, Object>> organList = this.queryOrganProductList(param);
        CacheManager.put((String)("prdList:" + organId + channelNo), (Object)JsonUtil.toJson(organList));
    }
}

