/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.dao.impl;

import cn.com.chinalife.dao.PcProductDao;
import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.util.JsonUtilsSipService;
import com.newtouch.context.ThreadLocalContext;
import com.newtouch.context.pojo.PageCount;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.msg.exception.BusinessException;
import com.newtouch.msg.pojo.Message;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PcProductDaoImpl
implements PcProductDao {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public List<Map<String, Object>> queryProductList(Map<String, Object> param) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        StringBuilder sql = new StringBuilder();
        StringBuilder risk_sql = new StringBuilder();
        risk_sql.append("SELECT sr.risk_uuid FROM sip_risks sr WHERE (instr(sr.RISK_CLASSIFY,?) > 0 OR instr(sr.RISK_CLASSIFY,?) >0) and sr.is_main_risk= ? ");
        querySql.add((Object)"904");
        querySql.add((Object)"903");
        querySql.add((Object)"M");
        if (!StrUtil.isNull((Object)param.get("risk_code"))) {
            risk_sql.append("and policy_code like ?");
            querySql.add((Object)("%" + param.get("risk_code").toString() + "%"));
        }
        sql.append("select * from  sip_products sp WHERE sp.product_uuid IN  (SELECT spr.product_uuid  FROM sip_product_risks spr  WHERE spr.risk_uuid IN (" + risk_sql + "))and sp.data_flag =? and sp.state = ?");
        querySql.add((Object)"1");
        querySql.add((Object)"S");
        if (!StrUtil.isNull((Object)param.get("shelf_year"))) {
            sql.append("and to_char(shelf_date,'yyyy') = ?");
            querySql.add((Object)param.get("shelf_year").toString());
        }
        if (!StrUtil.isNull((Object)param.get("shelf_date_start")) && !StrUtil.isNull((Object)param.get("shelf_date_end"))) {
            sql.append("and to_char(shelf_date,'yyyy-MM-dd') > ? and to_char(shelf_date,'yyyy-MM-dd') < ?");
            querySql.add((Object)param.get("shelf_date_start").toString());
            querySql.add((Object)param.get("shelf_date_end").toString());
        }
        if (!StrUtil.isNull((Object)param.get("product_no"))) {
            sql.append("and product_no like ?");
            querySql.add((Object)("%" + param.get("product_no").toString() + "%"));
        }
        if (!StrUtil.isNull((Object)param.get("product_name"))) {
            sql.append("and product_name like ?");
            querySql.add((Object)("%" + param.get("product_name").toString() + "%"));
        }
        if (!StrUtil.isNull((Object)param.get("product_type"))) {
            sql.append("and product_type = ?");
            querySql.add((Object)param.get("product_type").toString());
        }
        if (!StrUtil.isNull((Object)param.get("product_sale_channel"))) {
            sql.append("and product_sale_channel like ?");
            querySql.add((Object)("%" + param.get("product_sale_channel").toString() + "%"));
        }
        this.getGroupProductSql(param, querySql, organId, sql);
        PageCount pageCount = ThreadLocalContext.get().getPageCount();
        if (!StrUtil.isNull((Object)StrUtil.trimStr((Object)param.get("nowPage"))) && !StrUtil.isNull((Object)StrUtil.trimStr((Object)param.get("rows4Page")))) {
            pageCount.setNowPage(Integer.valueOf(StrUtil.trimStr((Object)param.get("nowPage"))));
            pageCount.setRows4Page(Integer.valueOf(StrUtil.trimStr((Object)param.get("rows4Page"))));
            querySql.setPaginate(true);
        }
        querySql.setSql(sql.toString());
        List findAll = this.dao.findAll(querySql, false);
        querySql.clearParam();
        List readsList = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            readsList = JsonUtil.json2List((String)JsonUtil.toJson((Object)findAll));
            for (Map productResult : readsList) {
                this.dealResultList(param, querySql, resultList, productResult);
            }
        }
        catch (Exception e) {
            throw new BusinessException(new Message("1016001", "\u4ea7\u54c1\u5217\u8868\u67e5\u8be2\u5f02\u5e38"));
        }
        return resultList;
    }

    private void dealResultList(Map<String, Object> param, QuerySqlable querySql, List<Map<String, Object>> resultList, Map<String, Object> productResult) {
        String queryAttr;
        String type = StrUtil.trimStr((Object)productResult.get("product_catefory"));
        String productUuid = StrUtil.trimStr((Object)productResult.get("product_uuid"));
        param.put("product_uuid", productUuid);
        Sip_Organ_Products organProduct = this.queryOrganProduct(param);
        if ("Z".equals(type)) {
            queryAttr = "select sp.product_no from sip_products sp left join sip_products_relation spr on spr.product_uuid = sp.product_uuid where spr.composite_product_uuid = ?";
            querySql.add((Object)productUuid);
            querySql.setSql(queryAttr);
            querySql.setPaginate(false);
            List prdList = this.dao.findAll(querySql, false);
            querySql.clearParam();
            productResult.put("compose", prdList);
            this.productRisks(productResult, type);
        } else {
            this.productRisks(productResult, type);
        }
        if (null != organProduct) {
            queryAttr = "select attr_no,attr_value from sip_organ_product_info  where organ_prd_uuid =?";
            querySql.add((Object)organProduct.getOrganPrdUuid());
            querySql.setSql(queryAttr);
            querySql.setPaginate(false);
            List organPrdList = this.dao.findAll(querySql, false);
            querySql.clearParam();
            if (null != organPrdList && !organPrdList.isEmpty()) {
                this.dealPrdInfo(productResult, organPrdList);
            }
            productResult.put("pol_start_date", organProduct.getPolStartDate());
            productResult.put("pol_end_date", organProduct.getPolEndDate());
            productResult.put("prp_start_date", organProduct.getPrpStartDate());
            productResult.put("prp_end_date", organProduct.getPrpEndDate());
        }
        resultList.add(productResult);
    }

    public Sip_Organ_Products queryOrganProduct(Map<String, Object> request) {
        Sip_Organ_Products sipOrgan = new Sip_Organ_Products();
        Sip_Organ_Products result = null;
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.product_uuid, request.get("product_uuid"));
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.organ_id, request.get("organ_id"));
        sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.channel_no, request.get("channel_no"));
        List product = this.dao.findAll((AbsModel)sipOrgan, false);
        if (null != product && !product.isEmpty()) {
            result = (Sip_Organ_Products)((Object)product.get(0));
        }
        return result;
    }

    private void productRisks(Map<String, Object> productResult, String type) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder riskResule = new StringBuilder();
        StringBuffer isUniversal = new StringBuffer("N");
        String productUuid = StrUtil.trimStr((Object)productResult.get("product_uuid"));
        if ("Z".equals(type)) {
            String queryAttr = "select * from sip_products sp left join sip_products_relation spr on spr.product_uuid = sp.product_uuid where spr.composite_product_uuid =?";
            querySql.add((Object)productUuid);
            querySql.setSql(queryAttr);
            querySql.setPaginate(false);
            List comsProductList = this.dao.findAll(querySql, false);
            querySql.clearParam();
            if (null != comsProductList && !comsProductList.isEmpty()) {
                for (Map prdUuid : comsProductList) {
                    String comsPrductUuid = StrUtil.trimStr(prdUuid.get("product_uuid"));
                    this.dealRiskCode(comsPrductUuid, riskResule, isUniversal);
                }
            }
        } else {
            this.dealRiskCode(productUuid, riskResule, isUniversal);
        }
        if (!StrUtil.isNull((Object)riskResule)) {
            productResult.put("riskCode", riskResule.toString().substring(0, riskResule.toString().length() - 1));
            productResult.put("isUniversal", isUniversal);
        }
    }

    private void dealRiskCode(String productUuid, StringBuilder riskResule, StringBuffer isUniversal) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryAttr = "select * from sip_product_risks  where product_uuid=?";
        querySql.add((Object)productUuid);
        querySql.setSql(queryAttr);
        querySql.setPaginate(false);
        List riskList = this.dao.findAll(querySql);
        querySql.clearParam();
        for (Map risk : riskList) {
            String queryrisk = "select policy_code,risk_classify  from sip_risks where risk_uuid=?";
            querySql.add(risk.get("risk_uuid"));
            querySql.setSql(queryrisk);
            querySql.setPaginate(false);
            List riskCode = this.dao.findAll(querySql);
            if (null != riskCode && !riskCode.isEmpty()) {
                String code = StrUtil.trimStr(((Map)riskCode.get(0)).get("policy_code"));
                riskResule.append(code).append(",");
                if (StrUtil.trimStr(((Map)riskCode.get(0)).get("risk_classify")).contains("904")) {
                    isUniversal.replace(0, 1, "Y");
                }
            }
            querySql.clearParam();
        }
    }

    public void dealPrdInfo(Map<String, Object> productResult, List<Map<String, Object>> organPrdList) {
        for (Map<String, Object> prd : organPrdList) {
            String key = StrUtil.trimStr((Object)prd.get("attr_no"));
            String value = StrUtil.trimStr((Object)prd.get("attr_value"));
            if ("product_tip".equals(key)) {
                String value1 = StrUtil.trimStr((Object)productResult.get("product_tip"));
                value = JsonUtilsSipService.getUnion(value1, value, ",");
            }
            productResult.put(key, value);
        }
    }

    private void getGroupProductSql(Map<String, Object> param, QuerySqlable querySql, String organId, StringBuilder sql) {
        if ("1".equals(param.get("flag"))) {
            if (StrUtil.isNull((Object)param.get("state"))) {
                sql.append("and (open_state = ? or  open_state = ?) and product_catefory is null ");
                querySql.add((Object)"ALL");
                querySql.add((Object)"PART");
            } else {
                sql.append("and open_state = ? and product_catefory is null ");
                querySql.add((Object)param.get("state").toString());
            }
        } else if (!StrUtil.isNull((Object)param.get("product_name"))) {
            sql.append("and open_state = ? or (open_state=? and( product_catefory!=? or product_catefory  is  null )and product_name like ?) ");
            this.dealQuerySql(querySql, "product_name", organId, param, sql);
        } else if (!StrUtil.isNull((Object)param.get("product_no"))) {
            sql.append("and open_state = ? or (open_state=? and ( product_catefory!=? or product_catefory  is  null )and product_no like ?) ");
            this.dealQuerySql(querySql, "product_no", organId, param, sql);
        } else if (!StrUtil.isNull((Object)param.get("product_type"))) {
            sql.append("and open_state = ? or (open_state=? and ( product_catefory!=? or product_catefory  is  null ) and product_type = ?) ");
            this.dealQuerySql(querySql, "product_type", organId, param, sql);
        } else if ("ALL".equals(param.get("state"))) {
            sql.append("and open_state = ?");
            querySql.add((Object)param.get("state").toString());
        } else if ("PART".equals(param.get("state"))) {
            sql.append("and open_state= ? and (product_catefory!=?\u3000or product_catefory is null )\nor (product_catefory =? and organ_id =? and channel_no=?) \norder by mdf_date desc");
            querySql.add((Object)param.get("state").toString());
            querySql.add((Object)"Z");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
        } else {
            sql.append("and open_state = ? or (open_state=? and (product_catefory!=? or product_catefory  is  null) ) ");
            this.dealQuerySql(querySql, "", organId, param, sql);
        }
    }

    private void dealQuerySql(QuerySqlable querySql, String type, String organId, Map<String, Object> param, StringBuilder sql) {
        if (!StrUtil.isNull((Object)param.get("state"))) {
            querySql.add((Object)param.get("state").toString());
        } else {
            querySql.add((Object)"ALL");
        }
        querySql.add((Object)"PART");
        querySql.add((Object)"Z");
        if (type.equals("product_name")) {
            querySql.add((Object)("%" + param.get("product_name").toString() + "%"));
            sql.append("or (product_catefory =? and organ_id =? and channel_no=? and product_name like ?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
            querySql.add((Object)("%" + param.get("product_name").toString() + "%"));
        } else if (type.equals("product_no")) {
            querySql.add((Object)("%" + param.get("product_no").toString() + "%"));
            sql.append("or (product_catefory =? and organ_id =? and channel_no=? and product_no like ?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
            querySql.add((Object)("%" + param.get("product_no").toString() + "%"));
        } else if (type.equals("product_type")) {
            querySql.add((Object)param.get("product_type").toString());
            sql.append("or (product_catefory =? and organ_id =? and channel_no=? and product_type= ?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
            querySql.add((Object)param.get("product_type").toString());
        } else {
            sql.append("or (product_catefory =? and organ_id =? and channel_no=?) order  by mdf_date desc");
            querySql.add((Object)"Z");
            querySql.add((Object)organId);
            querySql.add(param.get("channel_type"));
        }
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, String productUuid, String organPrdUuid) {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String queryProduct = "select * from sip_products where product_uuid = ?";
        querySql.add((Object)productUuid);
        querySql.setSql(queryProduct);
        List productInfo = this.dao.findAll(querySql);
        querySql.clearParam();
        Map product = productInfo.isEmpty() ? null : (Map)productInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            String storedTab = StrUtil.trimStr((Object)attrValue.get("stored_tab"));
            String storedField = StrUtil.trimStr((Object)attrValue.get("stored_field"));
            String attrUuid = StrUtil.trimStr((Object)attrValue.get("attr_uuid"));
            if ("sip_products".equalsIgnoreCase(storedTab) && null != product) {
                attrValue.put("field_value", product.get(storedField));
            }
            if (StrUtil.isNull((Object)organPrdUuid)) continue;
            String queryOrganProduct = "select * from sip_organ_product_info where organ_prd_uuid = ? and attr_uuid = ?";
            querySql.add((Object)organPrdUuid);
            querySql.add((Object)attrUuid);
            querySql.setSql(queryOrganProduct);
            List organProductInfo = this.dao.findAll(querySql);
            querySql.clearParam();
            Map organ = organProductInfo.isEmpty() ? null : (Map)organProductInfo.get(0);
            if (null == organ) continue;
            attrValue.put("field_value", organ.get("attr_value"));
        }
    }
}

