/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinalife.dao.impl;

import cn.com.chinalife.dao.IBranchDaoSipService;
import cn.com.chinalife.model.Sip_Organ_Products;
import cn.com.chinalife.model.Sip_Products;
import com.newtouch.dao.DBHandleCreator;
import com.newtouch.dao.QuerySqlable;
import com.newtouch.log.Ulog;
import com.newtouch.repository.AbsModel;
import com.newtouch.repository.AbsModelRepository;
import com.newtouch.repository.ModelField;
import com.newtouch.util.json.JsonUtil;
import com.newtouch.util.string.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BranchDaoSipServiceImpl
implements IBranchDaoSipService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public List<Map<String, Object>> productOragnQuery(Map<String, Object> param) {
        String queryOrgan;
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String organCode = StrUtil.trimStr((Object)param.get("organ_id"));
        String substring = organCode.substring(0, 2);
        List returnList = null;
        if (organCode.equals("000000")) {
            queryOrgan = "SELECT organ_prd_uuid  from sip_organ_products  where product_uuid = ? group by organ_prd_uuid";
            querySql.add(param.get("product_uuid"));
            querySql.setSql(queryOrgan);
        } else {
            queryOrgan = "SELECT organ_prd_uuid  from sip_organ_products  where product_uuid = ? and organ_id like ? and channel_no = ? group by organ_prd_uuid";
            querySql.add(param.get("product_uuid"));
            querySql.add((Object)(substring + "%"));
            querySql.add(param.get("channel_type"));
            querySql.setSql(queryOrgan);
        }
        List productOrganList = this.dao.findAll(querySql);
        querySql.clearParam();
        for (Map map : productOrganList) {
            StringBuilder organId = new StringBuilder();
            StringBuilder channel = new StringBuilder();
            String organPrdUuid = (String)map.get("organ_prd_uuid");
            String query = "SELECT *  from sip_organ_products  where organ_prd_uuid = ?";
            querySql.add((Object)organPrdUuid);
            querySql.setSql(query);
            List findAll = this.dao.findAll(querySql);
            querySql.clearParam();
            for (Map map2 : findAll) {
                String organid = StrUtil.trimStr(map2.get("organ_id"));
                String channelType = StrUtil.trimStr(map2.get("channel_no"));
                String queryChannel = "select enum_name from sys_enum  where up_enum =? and enum_code=?";
                querySql.add((Object)"branch_id");
                querySql.add((Object)channelType);
                querySql.setSql(queryChannel);
                List channelList = this.dao.findAll(querySql);
                querySql.clearParam();
                String channelName = StrUtil.trimStr(((Map)channelList.get(0)).get("enum_name"));
                String organ = "SELECT company_name FROM SIP_COMPANY_ORGAN where organ_id=?";
                querySql.add((Object)organid);
                querySql.setSql(organ);
                List organList = this.dao.findAll(querySql);
                querySql.clearParam();
                String organName = StrUtil.trimStr(((Map)organList.get(0)).get("company_name"));
                if (StrUtil.isNull((Object)organId.toString()) || !organId.toString().contains(organName)) {
                    organId.append(organName).append(",");
                }
                if (StrUtil.isNull((Object)channel.toString()) || !channel.toString().contains(channelName)) {
                    channel.append(channelName).append(",");
                }
                map.put("organ_prd_uuid", map2.get("organ_prd_uuid"));
                map.put("product_uuid", map2.get("product_uuid"));
                map.put("prp_start_date", map2.get("prp_start_date"));
                map.put("prp_end_date", map2.get("prp_end_date"));
                map.put("pol_start_date", map2.get("pol_start_date"));
                map.put("pol_end_date", map2.get("pol_end_date"));
                map.put("data_flag", map2.get("data_flag"));
            }
            map.put("organ_id", organId.toString().substring(0, organId.toString().length() - 1));
            map.put("channel_no", channel.toString().substring(0, channel.toString().length() - 1));
        }
        try {
            returnList = JsonUtil.json2List((String)JsonUtil.toJson((Object)productOrganList));
        }
        catch (Exception e) {
            Ulog.error((String)("\u67e5\u8be2\u4ea7\u54c1\u673a\u6784\u6570\u636e\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a" + e.toString()));
        }
        return returnList;
    }

    @Override
    public Map<String, Object> productOragnQueryByOrgan(Map<String, Object> param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        StringBuilder organId = new StringBuilder();
        StringBuilder channel = new StringBuilder();
        String organPrdUuid = (String)param.get("organ_prd_uuid");
        String query = "SELECT *  from sip_organ_products  where organ_prd_uuid = ?";
        querySql.add((Object)organPrdUuid);
        querySql.setSql(query);
        List findAll = this.dao.findAll(querySql);
        querySql.clearParam();
        for (Map map2 : findAll) {
            String organid = (String)map2.get("organ_id");
            String channelType = (String)map2.get("channel_no");
            if (StrUtil.isNull((Object)organId.toString()) || !organId.toString().contains(organid)) {
                organId.append(organid).append(",");
            }
            if (StrUtil.isNull((Object)channel.toString()) || !channel.toString().contains(channelType)) {
                channel.append(channelType).append(",");
            }
            map.put("organ_prd_uuid", map2.get("organ_prd_uuid"));
            map.put("product_uuid", map2.get("product_uuid"));
            map.put("prp_start_date", map2.get("prp_start_date"));
            map.put("prp_end_date", map2.get("prp_end_date"));
            map.put("pol_start_date", map2.get("prp_start_date"));
            map.put("pol_end_date", map2.get("prp_end_date"));
            map.put("data_flag", map2.get("data_flag"));
        }
        map.put("organ_id", organId.toString().substring(0, organId.toString().length() - 1));
        map.put("channel_no", channel.toString().substring(0, channel.toString().length() - 1));
        return map;
    }

    @Override
    public void saveProductOrgan(List<Sip_Organ_Products> oldData, List<Sip_Organ_Products> request) {
        Sip_Organ_Products sipOrgan = new Sip_Organ_Products();
        if (null == oldData || oldData.isEmpty()) {
            this.dao.save(request);
        } else {
            sipOrgan.where().addEq((ModelField)Sip_Organ_Products.Field.organ_prd_uuid, (Object)oldData.get(0).getOrganPrdUuid());
            this.dao.delete((AbsModel)sipOrgan);
            this.dao.save(request);
        }
    }

    @Override
    public boolean queryProductRedisBranch(Map<String, Object> param, String flag1, String organId) {
        boolean flag = true;
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String query = "select organ_prd_uuid from sip_organ_products t where t.product_uuid =? and t.organ_id=? and channel_no=?";
        querySql.add(param.get("product_uuid"));
        querySql.add((Object)organId);
        querySql.add(param.get("channel_no"));
        querySql.setSql(query);
        List findAll = this.dao.findAll(querySql);
        if ("1".equals(flag1)) {
            if (null == findAll || findAll.isEmpty()) {
                flag = false;
            }
        } else if ("0".equals(flag1) && (findAll.isEmpty() || param.get("organ_prd_uuid").equals(((Map)findAll.get(0)).get("organ_prd_uuid")))) {
            flag = false;
        }
        return flag;
    }

    @Override
    public List<Map<String, Object>> querOrganData() {
        QuerySqlable querySql = DBHandleCreator.getInstance().getQuerySql();
        String query = "select c.parent_id,c.organ_id,c.company_name,c.class_id from sip_company_organ  c";
        querySql.setSql(query);
        return this.dao.findAll(querySql);
    }

    @Override
    public void updateProduct(Map<String, Object> param) {
        String organId = StrUtil.trimStr((Object)param.get("organ_id"));
        String productUuid = StrUtil.trimStr((Object)"product_uuid");
        Sip_Products sipProduct = new Sip_Products();
        sipProduct.setOrganId(organId);
        sipProduct.where().addEq((ModelField)Sip_Products.Field.product_uuid, (Object)productUuid);
        this.dao.update((AbsModel)sipProduct);
    }
}

