package cn.axj.crypt.secret;

import cn.axj.crypt.annotation.Decryption;
import cn.axj.crypt.annotation.Encryption;
import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.handler.ThreadLocalHandler;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Description:  临时方案不是很完善不太建议使用
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved.
 *
 * @version 1.0  2023/02/2023/2/28 20:44 by 张振涛（fly_sky_java@163.com）创建
 */
@Component
@Slf4j
public class EncryptionComponent {
    @Resource
    private CryptProperties cryptProperties;

    private final List<BaseAlgorithmHttpInputMessage> list = new ArrayList<>();

    public EncryptionComponent(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        this.addAll(list);
    }

    private void addAll(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        String temp;
        for (int i = 0; i < list.size(); i++) {
            temp = list.get(i).getBinding();
            for (int j = i + 1; j < list.size(); j++) {
                String binding = list.get(j).getBinding();
                if (temp.equals(binding)) {
                    throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
                }
            }
        }
        this.list.addAll(list);
        log.info("加密类完成初始化加载........");
    }

    public String encryptionObject(String o) {
        log.info("进入到需要加密的响应类.....");
        if (o == null) {
            return null;
        }
        boolean isFlag = false;
        if (cryptProperties.isGlobalEnable() && cryptProperties.isEncryptionRequired()) {
            isFlag = true;
        }
        if (!cryptProperties.isResponseEncryption()) {
            isFlag = false;
        }
        if (isFlag){
            //绑定算法
            String bind = StringUtils.isBlank(cryptProperties.getEncryptBind()) ? cryptProperties.getBind() : cryptProperties.getEncryptBind();
            //解密字符串
            String decryptionStringName = cryptProperties.getDecryptionStringName();

            try {
                //全局加解密时：开启全局加解密时，并且全局加密为false时，并且未开启注解，
                //非全局加解密时：当入参不解密或者没有写加密注解时，直接返回原信息。
                log.info("条件1：" + (cryptProperties.isGlobalEnable() && Objects.equals(cryptProperties.isEncryptionRequired(), false)));
                log.info("条件2：" + (!cryptProperties.isGlobalEnable() && (!Objects.equals(ThreadLocalHandler.get(), "request_crypt"))));
                if ((cryptProperties.isGlobalEnable() && Objects.equals(cryptProperties.isEncryptionRequired(), false)) ||
                        (!cryptProperties.isGlobalEnable() && (!Objects.equals(ThreadLocalHandler.get(), "request_crypt")))) {
                    log.info("不满足需要加密的情况");
                    return o;
                }
                for (BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage : list) {
                    if (bind.equals(baseAlgorithmHttpInputMessage.getBinding())) {
                        if (StringUtils.isNotBlank(decryptionStringName)) {
                            //如果是json字符的话，获取需要加密的属性值，然后返回部分加密的字符串
                            if (o instanceof String) {
                                Map resultMap = JSON.parseObject(o.toString(), Map.class);
                                if (Objects.nonNull(resultMap) && Objects.nonNull(resultMap.get(decryptionStringName))) {
                                    Object obj = resultMap.get(decryptionStringName);
                                    String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(obj));
                                    resultMap.put(decryptionStringName, encrypt);
                                    return JSON.toJSONString(resultMap);
                                }
                            }
                            Field dataFiled = o.getClass().getDeclaredField(decryptionStringName);
                            dataFiled.setAccessible(true);
                            Object dataObject = dataFiled.get(o);
                            String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(dataObject));
                            log.info("加密后的字符串信息........" + encrypt);
                            dataFiled.set(o, encrypt);
                            return o;
                        } else {
                            String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(o));
                            log.info("加密后的字符串信息........" + encrypt);
                            return encrypt;
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return o;
    }

}
