/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.secret.implement;

import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import cn.axj.crypt.secret.config.AesKeyConfig;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AesAlgorithmHttpInputMessage
extends BaseAlgorithmHttpInputMessage {
    @Resource
    private AesKeyConfig aesKeyConfig;
    private static String aesKey;
    private static String ivVal;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";

    @Override
    public String getBinding() {
        return KEY_ALGORITHM;
    }

    @Override
    public String decrypt(String content) throws Exception {
        return this.decrypt(content, aesKey, ivVal);
    }

    @Override
    public String encrypt(String content) throws Exception {
        return this.encrypt(content, aesKey, ivVal);
    }

    @Autowired
    public void setAesKey() {
        aesKey = this.aesKeyConfig.getKey();
    }

    @Autowired
    public void setIvVal() {
        ivVal = this.aesKeyConfig.getIv();
    }

    private byte[] generateKey(String aesKey) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return aesKey.getBytes();
    }

    private AlgorithmParameters generateIV(String ivVal) throws Exception {
        byte[] iv = ivVal.getBytes();
        AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    private Key convertToKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }

    private String encrypt(String plainText, String aesKey, String ivVal) throws Exception {
        byte[] data = plainText.getBytes();
        AlgorithmParameters iv = this.generateIV(ivVal);
        byte[] keyBytes = this.generateKey(aesKey);
        Key key = this.convertToKey(keyBytes);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, key, iv);
        byte[] encryptData = cipher.doFinal(data);
        return this.bytesToHexString(encryptData);
    }

    private String decrypt(String encryptedStr, String aesKey, String ivVal) throws Exception {
        byte[] encryptedData = this.hexStringToByte(encryptedStr);
        byte[] keyBytes = this.generateKey(aesKey);
        Key key = this.convertToKey(keyBytes);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        AlgorithmParameters iv = this.generateIV(ivVal);
        cipher.init(2, key, iv);
        byte[] decryptData = cipher.doFinal(encryptedData);
        return new String(decryptData);
    }

    private byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(this.toByte(achar[pos]) << 4 | this.toByte(achar[pos + 1]));
        }
        return result;
    }

    private byte toByte(char c) {
        return (byte)"0123456789abcdef".indexOf(c);
    }

    private String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (byte b : bArray) {
            String sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toLowerCase());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        AesAlgorithmHttpInputMessage aesAlgorithmHttpInputMessage = new AesAlgorithmHttpInputMessage();
        String plainTextString = "\u4f60\u597d\u5417\uff1f\u6211\u662fbob";
        System.out.println("\u660e\u6587 : " + plainTextString);
        String aesKey = "S9u978Q31NGPGc5H";
        String ivVal = "X83yESM9iShLxfwS";
        try {
            String encryptedData = aesAlgorithmHttpInputMessage.encrypt(plainTextString, aesKey, ivVal);
            System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e : ");
            System.out.println(encryptedData);
            System.out.println();
            String s = "6bcecc6ff7389a71ba35b5f435576340f2dd2fba2914927f6e3fdb517c0a02e89083b576be8a2dc133f76dbf13489efdbd3c417271ec918e3ba55d91f5c36db6030b196b2f466864103d4ebf3a16639de349b89ab9c5d70dea3b2918f5ea40f50c05fa985c2a08224b7a587fcd9ced3140099772123a98658c3f65c1f3b516d0dd1f6d1a959ab2f8bdb1118184b664312e26f5e0904bf8daad17c4e7ea67b3e45619f640cbe7b7efdc7a231163461d9bd5435c33c3c27ce24450b6029fec4b323b8aa80708c9281508a88657c17dfabaa40846cfbe228f97972e200f6d227a77434bcb5b6d5e1d3598227a4543e2057e412acc33e7fa57e33e1a4802b1bc41aca9cb70ab4113c0bd46c0fcf01f3e9df88d03155d7f033e85ce3dbbf5ea28206c80cfb52ceef4167e57c471f7fa954cad8b50152f6a274dff4703f066f6e2fc34d2ae5a6b4ac0204bae030fff67b28abbec6b16bbb59f9f4a129c3548f38813afcf4ba9cdebd6191682e7b512472e97511821b5439f232a39093f88baaf9324a22c62fff050f78dad2800e20d3413a03efc3d2ddc5229094eaea741594c8bac5cd0b9d27dc3ab99719a3b4de7c62e298fb0c58b0fe946a1ae975597b141a8ccd501ddaeb21484c84890f83cdad1ba7d84";
            String data = aesAlgorithmHttpInputMessage.decrypt(s, aesKey, ivVal);
            System.out.println("\u89e3\u5bc6\u5f97\u5230\u7684\u6570\u636e : " + data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

