/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.secret;

import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.handler.ThreadLocalHandler;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EncryptionComponent {
    private static final Logger log = LoggerFactory.getLogger(EncryptionComponent.class);
    @Resource
    private CryptProperties cryptProperties;
    private final List<BaseAlgorithmHttpInputMessage> list = new ArrayList<BaseAlgorithmHttpInputMessage>();

    public EncryptionComponent(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        this.addAll(list);
    }

    private void addAll(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        for (int i = 0; i < list.size(); ++i) {
            String temp = list.get(i).getBinding();
            for (int j = i + 1; j < list.size(); ++j) {
                String binding = list.get(j).getBinding();
                if (!temp.equals(binding)) continue;
                throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
            }
        }
        this.list.addAll(list);
        log.info("\u52a0\u5bc6\u7c7b\u5b8c\u6210\u521d\u59cb\u5316\u52a0\u8f7d........");
    }

    public String encryptionObject(String o) {
        log.info("\u8fdb\u5165\u5230\u9700\u8981\u52a0\u5bc6\u7684\u54cd\u5e94\u7c7b.....");
        if (o == null) {
            return null;
        }
        boolean isFlag = false;
        if (this.cryptProperties.isGlobalEnable() && this.cryptProperties.isEncryptionRequired()) {
            isFlag = true;
        }
        if (!this.cryptProperties.isResponseEncryption()) {
            isFlag = false;
        }
        if (isFlag) {
            String bind = StringUtils.isBlank((CharSequence)this.cryptProperties.getEncryptBind()) ? this.cryptProperties.getBind() : this.cryptProperties.getEncryptBind();
            String decryptionStringName = this.cryptProperties.getDecryptionStringName();
            try {
                log.info("\u6761\u4ef61\uff1a" + (this.cryptProperties.isGlobalEnable() && Objects.equals(this.cryptProperties.isEncryptionRequired(), false)));
                log.info("\u6761\u4ef62\uff1a" + (!this.cryptProperties.isGlobalEnable() && !Objects.equals(ThreadLocalHandler.get(), "request_crypt")));
                if (this.cryptProperties.isGlobalEnable() && Objects.equals(this.cryptProperties.isEncryptionRequired(), false) || !this.cryptProperties.isGlobalEnable() && !Objects.equals(ThreadLocalHandler.get(), "request_crypt")) {
                    log.info("\u4e0d\u6ee1\u8db3\u9700\u8981\u52a0\u5bc6\u7684\u60c5\u51b5");
                    return o;
                }
                for (BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage : this.list) {
                    if (!bind.equals(baseAlgorithmHttpInputMessage.getBinding())) continue;
                    if (StringUtils.isNotBlank((CharSequence)decryptionStringName)) {
                        Map resultMap;
                        if (o instanceof String && Objects.nonNull(resultMap = (Map)JSON.parseObject((String)o.toString(), Map.class)) && Objects.nonNull(resultMap.get(decryptionStringName))) {
                            Object obj = resultMap.get(decryptionStringName);
                            String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(obj));
                            resultMap.put(decryptionStringName, encrypt);
                            return JSON.toJSONString((Object)resultMap);
                        }
                        Field dataFiled = o.getClass().getDeclaredField(decryptionStringName);
                        dataFiled.setAccessible(true);
                        Object dataObject = dataFiled.get(o);
                        String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString((Object)dataObject));
                        log.info("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4fe1\u606f........" + encrypt);
                        dataFiled.set(o, encrypt);
                        return o;
                    }
                    String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString((Object)o));
                    log.info("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4fe1\u606f........" + encrypt);
                    return encrypt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return o;
    }
}

