package cn.axj.crypt.handler;

import cn.axj.crypt.annotation.Decryption;
import com.alibaba.fastjson.JSON;
import cn.axj.crypt.annotation.Encryption;
import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;


/**
 * @author aoxiaojun
 * @date 2020/12/15 16:40
 **/
@Order(Ordered.HIGHEST_PRECEDENCE)
@ControllerAdvice
@Slf4j
public class ResponseEncryptionAdvice implements ResponseBodyAdvice {

    @Resource
    private CryptProperties cryptProperties;

    private final List<BaseAlgorithmHttpInputMessage> list = new ArrayList<>();

    public ResponseEncryptionAdvice(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        this.addAll(list);
    }

    private void addAll(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        String temp;
        for (int i = 0; i < list.size(); i++) {
            temp = list.get(i).getBinding();
            for (int j = i + 1; j < list.size(); j++) {
                String binding = list.get(j).getBinding();
                if (temp.equals(binding)) {
                    throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
                }
            }
        }
        this.list.addAll(list);
        log.info("加密类完成初始化加载........");
    }

    @Override
    public boolean supports(MethodParameter methodParameter, Class aClass) {
        log.info("进入到需要加密的响应类.....");
        if (cryptProperties.isGlobalEnable()&&cryptProperties.isEncryptionRequired()){
            return true;
        }
        if (!cryptProperties.isResponseEncryption()) {
            return false;
        }
        Encryption encryption;
        encryption = methodParameter.getMethodAnnotation(Encryption.class);
        if (encryption == null) {
            encryption = methodParameter.getContainingClass().getAnnotation(Encryption.class);
        }
        if (encryption != null) {
            log.info("需要进行加密操作，但是需要注意入参是否包含加密字段........");
        } else {
            log.info("不需要进行加密操作........");
        }
        return encryption != null;
    }

    @Override
    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (o == null) {
            return null;
        }
        //绑定算法
        String bind = StringUtils.isBlank(cryptProperties.getEncryptBind())?cryptProperties.getBind():cryptProperties.getEncryptBind();
        //解密字符串
        String decryptionStringName=cryptProperties.getDecryptionStringName();
        Class<?> targetClass = methodParameter.getContainingClass();
        Decryption decryption = methodParameter.getMethodAnnotation(Decryption.class);
        Encryption encryption = methodParameter.getMethodAnnotation(Encryption.class);
        if (encryption == null) {
            encryption = targetClass.getAnnotation(Encryption.class);
        }
        if (Objects.nonNull(encryption)){
            bind = encryption.bind();
            decryptionStringName = encryption.decryptionStringName();
        }
        try {
            //全局加解密时：开启全局加解密时，并且全局加密为false时，并且未开启注解，
            //非全局加解密时：当入参不解密或者没有写加密注解时，直接返回原信息。
            log.info("条件1："+(Objects.isNull(encryption)&&cryptProperties.isGlobalEnable()&&Objects.equals(cryptProperties.isEncryptionRequired(),false)));
            log.info("条件2："+(!cryptProperties.isGlobalEnable()&&(!Objects.equals(ThreadLocalHandler.get(), "request_crypt")||Objects.isNull(decryption))));
            if ((Objects.isNull(encryption)&&cryptProperties.isGlobalEnable()&&Objects.equals(cryptProperties.isEncryptionRequired(),false))||
                    (!cryptProperties.isGlobalEnable()&&(!Objects.equals(ThreadLocalHandler.get(), "request_crypt")||Objects.isNull(decryption)))) {
                log.info("不满足需要加密的情况");
                return o;
            }
            for (BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage : list) {
                if (bind.equals(baseAlgorithmHttpInputMessage.getBinding())) {
                    if (StringUtils.isNotBlank(decryptionStringName)) {
                        //如果是json字符的话，获取需要加密的属性值，然后返回部分加密的字符串
                        if (o instanceof String){
                           Map resultMap = JSON.parseObject(o.toString(), Map.class);
                           if (Objects.nonNull(resultMap)&&Objects.nonNull(resultMap.get(decryptionStringName))){
                               Object obj = resultMap.get(decryptionStringName);
                               String encrypt =  baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(obj));
                               resultMap.put(decryptionStringName,encrypt);
                               return JSON.toJSONString(resultMap);
                           }
                        }
                        Field dataFiled = o.getClass().getDeclaredField(decryptionStringName);
                        dataFiled.setAccessible(true);
                        Object dataObject = dataFiled.get(o);
                        String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(dataObject));
                        log.info("加密后的字符串信息........" + encrypt);
                        dataFiled.set(o, encrypt);
                        return o;
                    } else {
                        String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(o));
                        log.info("加密后的字符串信息........" + encrypt);
                        return encrypt;
                    }
                }
            }
            //找不到绑定的加密对象
            String methodName = Objects.requireNonNull(methodParameter.getMethod()).getName();
            String targetClassName = targetClass.getSimpleName();

            throw new BindingException("Unable to find a binding object of encryption,targetClass is " + targetClassName + ",method is " + methodName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }
}
