//package cn.axj.crypt.filter;
//
//import cn.axj.crypt.config.CryptProperties;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.stereotype.Component;
//import org.springframework.web.util.ContentCachingResponseWrapper;
//
//import javax.annotation.Resource;
//import javax.servlet.Filter;
//import javax.servlet.FilterChain;
//import javax.servlet.FilterConfig;
//import javax.servlet.ServletException;
//import javax.servlet.ServletRequest;
//import javax.servlet.ServletResponse;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//import java.io.IOException;
//import java.nio.charset.StandardCharsets;
//import java.util.Objects;
//
//@Component
//public class MyResponseFilter implements Filter {
//
//    @Resource
//    private CryptProperties cryptProperties;
//
//    @Override
//    public void init(FilterConfig filterConfig) throws ServletException {
//        // 初始化过滤器
//    }
//
//    @Override
//    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
//            throws IOException, ServletException {
//        HttpServletRequest httpRequest = (HttpServletRequest) request;
//        HttpServletResponse httpResponse = (HttpServletResponse) response;
//
//        // 使用 ContentCachingResponseWrapper 缓存响应体
//        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(httpResponse);
//
//        // 继续处理请求
//        chain.doFilter(request, responseWrapper);
//
//        // 获取缓存的响应体内容
//        byte[] content = responseWrapper.getContentAsByteArray();
//        String contentString = new String(content, StandardCharsets.UTF_8);
//
//        // 在这里对响应体内容进行处理
//        // 全局开启加密，并且加密是必须得，加密或修改响应内容
//
//        if (cryptProperties.isGlobalEnable()
//                &&cryptProperties.isEncryptionRequired()
//                && StringUtils.isNotBlank(cryptProperties.getResponseFilterEncryptJsonField())){
//            contentString="{\""+cryptProperties.getResponseFilterEncryptJsonField()+"\":\""+contentString+"\"}";
//        }
//        // contentString = encrypt(contentString);
//
//        // 将处理后的响应体内容写回响应
//        responseWrapper.setContentType(httpResponse.getContentType());
//        responseWrapper.setCharacterEncoding(httpResponse.getCharacterEncoding());
//        responseWrapper.getWriter().write(contentString);
//
//        // 将缓存的响应体内容复制到原始响应中
//        responseWrapper.copyBodyToResponse();
//    }
//
//    @Override
//    public void destroy() {
//        // 销毁过滤器
//    }
//}