/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.filter;

import cn.axj.crypt.config.CryptProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class MyResponseFilter
implements Filter {
    @Resource
    private CryptProperties cryptProperties;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(httpResponse);
        chain.doFilter(request, (ServletResponse)responseWrapper);
        byte[] content = responseWrapper.getContentAsByteArray();
        String contentString = new String(content, StandardCharsets.UTF_8);
        if (this.cryptProperties.isGlobalEnable() && this.cryptProperties.isEncryptionRequired() && StringUtils.isNotBlank((CharSequence)this.cryptProperties.getResponseFilterEncryptJsonField())) {
            contentString = "{\"" + this.cryptProperties.getResponseFilterEncryptJsonField() + "\":\"" + contentString + "\"}";
        }
        responseWrapper.setContentType(httpResponse.getContentType());
        responseWrapper.setCharacterEncoding(httpResponse.getCharacterEncoding());
        responseWrapper.getWriter().write(contentString);
        responseWrapper.copyBodyToResponse();
    }

    public void destroy() {
    }
}

