package cn.axj.crypt.secret.implement;

import cn.axj.crypt.constant.AlgorithmConstant;
import cn.axj.crypt.secret.config.AesKeyConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Security;

/**
 * @author aoxiaojun
 * @date 2020/12/11 17:08
 **/
@Component
public class AesAlgorithmHttpInputMessage extends BaseAlgorithmHttpInputMessage {


    @Resource
    private AesKeyConfig aesKeyConfig;

    @Override
    public String getBinding() {
        return AlgorithmConstant.AES;
    }



    @Override
    public String decrypt(String content) throws Exception {
        return decrypt(content,aesKey,ivVal);
    }


    @Override
    public String encrypt(String content) throws Exception{
        return encrypt(content, aesKey, ivVal);
    }


    private static String aesKey;
    private static String ivVal;


    @Autowired
    public void setAesKey() {
        AesAlgorithmHttpInputMessage.aesKey = aesKeyConfig.getKey();
    }
    @Autowired
    public void setIvVal() {
        AesAlgorithmHttpInputMessage.ivVal = aesKeyConfig.getIv();
    }

    /**
     * 算法名
     */
    private static final String KEY_ALGORITHM = "AES";

    /**
     * 加解密算法/模式/填充方式
     * ECB模式只用密钥即可对数据进行加密解密，CBC模式需要添加一个参数iv
     */
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";


    /**
     * 生成密匙
     * @param aesKey aeskey
     * @return byte
     */
    private byte[] generateKey(String aesKey) {
        Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
        return aesKey.getBytes();
    }



    private AlgorithmParameters generateIV(String ivVal) throws Exception{
        byte[] iv = ivVal.getBytes();
        AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
        params.init(new IvParameterSpec(iv));
        return params;

    }


    /**
     * 转化成JAVA的密钥格式
     * @param keyBytes keyBytes
     * @return Key
     */
    private Key convertToKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes,KEY_ALGORITHM);
    }



    //加密
    private String encrypt(String plainText, String aesKey, String ivVal) throws Exception {
        byte[] data=plainText.getBytes();
        AlgorithmParameters iv = generateIV(ivVal);
        byte[] keyBytes = generateKey(aesKey);
        //转化为密钥
        Key key = convertToKey(keyBytes);
        Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        //设置为加密模式
        cipher.init(Cipher.ENCRYPT_MODE, key,iv);
        byte[] encryptData= cipher.doFinal(data);
        return bytesToHexString(encryptData);
    }


    //解密
    private String decrypt(String encryptedStr, String aesKey, String ivVal) throws Exception{
        byte[] encryptedData = hexStringToByte(encryptedStr);
        byte[] keyBytes = generateKey(aesKey);
        Key key = convertToKey(keyBytes);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        AlgorithmParameters iv = generateIV(ivVal);
        //设置为解密模式
        cipher.init(Cipher.DECRYPT_MODE, key,iv);
        byte[] decryptData = cipher.doFinal(encryptedData);
        return new String(decryptData);
    }



    /**
     * 十六进制字符串转换成数组
     * @param hex
     * @return
     */
    private byte[] hexStringToByte(String hex) {
        int len = (hex.length() / 2);
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; i++) {
            int pos = i * 2;
            result[i] = (byte) (toByte(achar[pos]) << 4 | toByte(achar[pos + 1]));
        }
        return result;
    }



    private byte toByte(char c) {
        return (byte) "0123456789abcdef".indexOf(c);

    }



    /**
     * 把字节数组转换成16进制字符串
     * @param bArray
     * @return
     */
    private String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        String sTemp;
        for (byte b : bArray) {
            sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toLowerCase());
        }
        return sb.toString();

    }


    public static void main(String[] args) {
        AesAlgorithmHttpInputMessage aesAlgorithmHttpInputMessage = new AesAlgorithmHttpInputMessage();
        //明文
        String plainTextString = "你好吗？我是bob";
        System.out.println("明文 : "+plainTextString);
        String aesKey="S9u978Q31NGPGc5H";
        String ivVal="X83yESM9iShLxfwS";
        try {
            //进行加密
            String encryptedData = aesAlgorithmHttpInputMessage.encrypt(plainTextString, aesKey,ivVal);
            //输出加密后的数据
            System.out.println("加密后的数据 : ");
            System.out.println(encryptedData);
            System.out.println();
            String s = "6bcecc6ff7389a71ba35b5f435576340f2dd2fba2914927f6e3fdb517c0a02e89083b576be8a2dc133f76dbf13489efdbd3c417271ec918e3ba55d91f5c36db6030b196b2f466864103d4ebf3a16639de349b89ab9c5d70dea3b2918f5ea40f50c05fa985c2a08224b7a587fcd9ced3140099772123a98658c3f65c1f3b516d0dd1f6d1a959ab2f8bdb1118184b664312e26f5e0904bf8daad17c4e7ea67b3e45619f640cbe7b7efdc7a231163461d9bd5435c33c3c27ce24450b6029fec4b323b8aa80708c9281508a88657c17dfabaa40846cfbe228f97972e200f6d227a77434bcb5b6d5e1d3598227a4543e2057e412acc33e7fa57e33e1a4802b1bc41aca9cb70ab4113c0bd46c0fcf01f3e9df88d03155d7f033e85ce3dbbf5ea28206c80cfb52ceef4167e57c471f7fa954cad8b50152f6a274dff4703f066f6e2fc34d2ae5a6b4ac0204bae030fff67b28abbec6b16bbb59f9f4a129c3548f38813afcf4ba9cdebd6191682e7b512472e97511821b5439f232a39093f88baaf9324a22c62fff050f78dad2800e20d3413a03efc3d2ddc5229094eaea741594c8bac5cd0b9d27dc3ab99719a3b4de7c62e298fb0c58b0fe946a1ae975597b141a8ccd501ddaeb21484c84890f83cdad1ba7d84";
            String data = aesAlgorithmHttpInputMessage.decrypt(s, aesKey,ivVal);
            System.out.println("解密得到的数据 : " + data);
//            JSONObject jsonObject = JSON.parseObject(data);
//            System.out.println(jsonObject);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
