package cn.axj.crypt.config;

import cn.axj.crypt.constant.AlgorithmConstant;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author aoxiaojun
 * @date 2020/12/15 15:15
 **/
@Component
@ConfigurationProperties("crypt")
public class CryptProperties {

    /**
     * 配置参数是否需要解密，默认需要,可通过配置secret.parameter.decryption  全局加密时改配置不生效
     */
    private boolean parameterDecryption = true;

    /**
     * 配置响应是否需要加密，默认不需要 ，可通过配置secret.response.encryption  全局加密时改配置不生效
     */
    private boolean responseEncryption = true;

    /**
     * 默认字符集
     */
    private String charset = "UTF-8";

    /**
     * 是否启用全局加解密
     */
    private boolean globalEnable=true;

    /**
     *  加密字段 适用于全局加密
     */
    private String encryptionStringName="params";

    /**
     *  解密字段 适用于全局加密 返回对象中必须包含该字段，也就是对返回对象中的某一个字段加密，如果没有该字段则整个对象加密
     */
    private String decryptionStringName="";

    /**
     * 加密方式 适用于全局加密
     */
    private String bind =AlgorithmConstant.AES_ECB;

    /**
     * 加密是否必须 适用于全局加密
     */
    private boolean encryptionRequired=true;

    /**
     * 解密是否必须 适用于全局加密
     */
    private boolean decryptionRequired=true;

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isParameterDecryption() {
        return parameterDecryption;
    }

    public void setParameterDecryption(boolean parameterDecryption) {
        this.parameterDecryption = parameterDecryption;
    }

    public boolean isResponseEncryption() {
        return responseEncryption;
    }

    public void setResponseEncryption(boolean responseEncryption) {
        this.responseEncryption = responseEncryption;
    }

    public boolean isGlobalEnable() {
        return globalEnable;
    }

    public void setGlobalEnable(boolean globalEnable) {
        this.globalEnable = globalEnable;
    }

    public String getEncryptionStringName() {
        return encryptionStringName;
    }

    public void setEncryptionStringName(String encryptionStringName) {
        this.encryptionStringName = encryptionStringName;
    }

    public String getDecryptionStringName() {
        return decryptionStringName;
    }

    public void setDecryptionStringName(String decryptionStringName) {
        this.decryptionStringName = decryptionStringName;
    }

    public String getBind() {
        return bind;
    }

    public void setBind(String bind) {
        this.bind = bind;
    }

    public boolean isEncryptionRequired() {
        return encryptionRequired;
    }

    public void setEncryptionRequired(boolean encryptionRequired) {
        this.encryptionRequired = encryptionRequired;
    }

    public boolean isDecryptionRequired() {
        return decryptionRequired;
    }

    public void setDecryptionRequired(boolean decryptionRequired) {
        this.decryptionRequired = decryptionRequired;
    }
}
