package cn.axj.crypt.handler;

import org.springframework.stereotype.Component;

/**
 * Description:
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved.
 *
 * @version 1.0  2022/01/2022/1/29 9:16 PM by 张振涛（zhangzt@cloud-young.com）创建
 */
@Component
public class ThreadLocalHandler {
    public static ThreadLocal<String> tokenContext = new ThreadLocal<>();

    /**
     * 把token放入threadLocal中
     **/
    public static void set(String token) {
        tokenContext.set(token);
    }

    /**
     * 从threadLocal中获取对应线程存储的值
     **/
    public static String get() {
        return tokenContext.get();
    }
}
