/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.handler;

import cn.axj.crypt.annotation.Decryption;
import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.exception.DecryptErrorException;
import cn.axj.crypt.exception.EncryptionStringNameIsNullException;
import cn.axj.crypt.exception.ParameterBodyIsNullException;
import cn.axj.crypt.handler.ThreadLocalHandler;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice(annotations={Controller.class})
public class ParameterDecryptionAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(ParameterDecryptionAdvice.class);
    @Resource
    private CryptProperties cryptProperties;
    private final List<BaseAlgorithmHttpInputMessage> decryptionList = new ArrayList<BaseAlgorithmHttpInputMessage>(8);

    public ParameterDecryptionAdvice(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        this.init(list);
    }

    private void init(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        for (int i = 0; i < list.size(); ++i) {
            String temp = list.get(i).getBinding();
            for (int j = i + 1; j < list.size(); ++j) {
                String binding = list.get(j).getBinding();
                if (!temp.equals(binding)) continue;
                throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
            }
        }
        this.decryptionList.addAll(list);
        log.info("\u89e3\u5bc6\u7c7b\u5b8c\u6210\u521d\u59cb\u5316\u52a0\u8f7d........");
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean flag;
        if (this.cryptProperties.isGlobalEnable() && this.cryptProperties.isDecryptionRequired()) {
            return true;
        }
        if (!this.cryptProperties.isParameterDecryption()) {
            return false;
        }
        Decryption decryption = (Decryption)methodParameter.getMethodAnnotation(Decryption.class);
        RequestBody requestBody = (RequestBody)methodParameter.getParameterAnnotation(RequestBody.class);
        log.info("\u662f\u5426\u62e5\u6709\u89e3\u5bc6\u6ce8\u89e3:" + decryption + "\u3002\u662f\u5426\u62e5\u6709requestBody\uff1a" + requestBody);
        boolean bl = flag = Objects.nonNull(decryption) && Objects.nonNull(requestBody);
        if (flag) {
            log.info("\u9700\u8981\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c........");
        } else {
            log.info("\u4e0d\u9700\u8981\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c........");
        }
        return flag;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws RuntimeException, IOException {
        InputStream body;
        String bind = this.cryptProperties.getBind();
        String encryptionStringName = this.cryptProperties.getEncryptionStringName();
        boolean required = this.cryptProperties.isDecryptionRequired();
        String simpleName = parameter.getContainingClass().getSimpleName();
        String methodName = Objects.requireNonNull(parameter.getMethod()).getName();
        if (!this.cryptProperties.isGlobalEnable()) {
            Decryption decryption = (Decryption)parameter.getMethodAnnotation(Decryption.class);
            Class targetClass = parameter.getContainingClass();
            if (decryption == null) {
                decryption = targetClass.getAnnotation(Decryption.class);
            }
            assert (decryption != null);
            bind = decryption.bind();
            encryptionStringName = decryption.encryptionStringName();
            required = decryption.required();
            if (StringUtils.isEmpty((Object)encryptionStringName)) {
                throw new EncryptionStringNameIsNullException("The annotation Decryption\u2018s encryptionStringName is empty,please check the method annotation,target method is " + simpleName + "." + methodName);
            }
        }
        if ((body = inputMessage.getBody()) == null) {
            throw new ParameterBodyIsNullException("request body is null");
        }
        for (BaseAlgorithmHttpInputMessage baseDecryption : this.decryptionList) {
            String decrypt;
            if (!baseDecryption.getBinding().equals(bind)) continue;
            String encryptData = IOUtils.toString((InputStream)body, (String)this.cryptProperties.getCharset());
            JSONObject jsonObject = JSONObject.parseObject((String)encryptData);
            String encryptString = jsonObject.getString(encryptionStringName);
            if (required && StringUtils.isEmpty((Object)encryptString)) {
                throw new ParameterBodyIsNullException("request body is null");
            }
            if (!required && StringUtils.isEmpty((Object)encryptString)) {
                return inputMessage;
            }
            ThreadLocalHandler.set("request_crypt");
            try {
                decrypt = baseDecryption.decrypt(encryptString);
                log.info("\u89e3\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4fe1\u606f........" + decrypt);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DecryptErrorException("decrypt error for String " + encryptString + " ,current algorithm is " + bind);
            }
            InputStream inputStream = IOUtils.toInputStream((String)decrypt, (String)this.cryptProperties.getCharset());
            try {
                BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage = (BaseAlgorithmHttpInputMessage)baseDecryption.getClass().newInstance();
                baseAlgorithmHttpInputMessage.setHeaders(inputMessage.getHeaders());
                baseAlgorithmHttpInputMessage.setBody(inputStream);
                return baseAlgorithmHttpInputMessage;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new BindingException("Unable to find a binding object of decryption,targetClass is " + simpleName + ",method is " + methodName);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

