/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.handler;

import cn.axj.crypt.annotation.Encryption;
import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.constant.AlgorithmConstant;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice(annotations={Controller.class})
public class ResponseEncryptionAdvice
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(ResponseEncryptionAdvice.class);
    @Resource
    private CryptProperties cryptProperties;
    private final HttpServletRequest request;
    private final List<BaseAlgorithmHttpInputMessage> list = new ArrayList<BaseAlgorithmHttpInputMessage>();

    public ResponseEncryptionAdvice(List<BaseAlgorithmHttpInputMessage> list, HttpServletRequest request) throws BindingException {
        this.addAll(list);
        this.request = request;
    }

    private void addAll(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        for (int i = 0; i < list.size(); ++i) {
            String temp = list.get(i).getBinding();
            for (int j = i + 1; j < list.size(); ++j) {
                String binding = list.get(j).getBinding();
                if (!temp.equals(binding)) continue;
                throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
            }
        }
        this.list.addAll(list);
        log.info("\u52a0\u5bc6\u7c7b\u5b8c\u6210\u521d\u59cb\u5316\u52a0\u8f7d........");
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        if (!this.cryptProperties.isResponseEncryption()) {
            return false;
        }
        Encryption encryption = (Encryption)methodParameter.getMethodAnnotation(Encryption.class);
        if (encryption == null) {
            encryption = methodParameter.getContainingClass().getAnnotation(Encryption.class);
        }
        if (encryption != null) {
            log.info("\u9700\u8981\u8fdb\u884c\u52a0\u5bc6\u64cd\u4f5c\uff0c\u4f46\u662f\u9700\u8981\u6ce8\u610f\u5165\u53c2\u662f\u5426\u5305\u542b\u52a0\u5bc6\u5b57\u6bb5........");
        } else {
            log.info("\u4e0d\u9700\u8981\u8fdb\u884c\u52a0\u5bc6\u64cd\u4f5c........");
        }
        return encryption != null;
    }

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (o == null) {
            return null;
        }
        Encryption encryption = (Encryption)methodParameter.getMethodAnnotation(Encryption.class);
        Class targetClass = methodParameter.getContainingClass();
        if (encryption == null) {
            encryption = targetClass.getAnnotation(Encryption.class);
        }
        try {
            String sessionId = this.request.getSession().getId();
            if (!Objects.equals(AlgorithmConstant.cacheRequest.get(sessionId), true)) {
                return o;
            }
            String bind = encryption.bind();
            String fieldName = encryption.fieldName();
            for (BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage : this.list) {
                if (!bind.equals(baseAlgorithmHttpInputMessage.getBinding())) continue;
                if (StringUtils.isNotBlank((CharSequence)fieldName)) {
                    Field dataFiled = o.getClass().getDeclaredField(fieldName);
                    dataFiled.setAccessible(true);
                    Object dataObject = dataFiled.get(o);
                    String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString((Object)dataObject));
                    log.info("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4fe1\u606f........" + encrypt);
                    dataFiled.set(o, encrypt);
                    return o;
                }
                String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString((Object)o));
                log.info("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32\u4fe1\u606f........" + encrypt);
                return encrypt;
            }
            String methodName = Objects.requireNonNull(methodParameter.getMethod()).getName();
            String targetClassName = targetClass.getSimpleName();
            throw new BindingException("Unable to find a binding object of encryption,targetClass is " + targetClassName + ",method is " + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return o;
        }
    }
}

