/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.secret.implement;

import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Component;

@Component
public class Base64AlgorithmHttpInputMessage
extends BaseAlgorithmHttpInputMessage {
    @Resource
    private CryptProperties cryptProperties;

    @Override
    public String getBinding() {
        return "BASE64";
    }

    @Override
    public String decrypt(String content) throws Exception {
        return new String(this.decode(content), this.cryptProperties.getCharset());
    }

    @Override
    public String encrypt(String content) throws Exception {
        return this.encode(content.getBytes(this.cryptProperties.getCharset()));
    }

    private byte[] decode(String base64) {
        return Base64.decodeBase64((String)base64);
    }

    private String encode(byte[] bytes) {
        try {
            return new String(Base64.encodeBase64((byte[])bytes), this.cryptProperties.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

