package cn.axj.crypt.handler;

import cn.axj.crypt.constant.AlgorithmConstant;
import cn.axj.crypt.exception.ParameterBodyIsNullException;
import com.alibaba.fastjson.JSON;
import cn.axj.crypt.annotation.Encryption;
import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author aoxiaojun
 * @date 2020/12/15 16:40
 **/
@ControllerAdvice(annotations = Controller.class)
@Slf4j
public class ResponseEncryptionAdvice implements ResponseBodyAdvice {

    @Resource
    private CryptProperties cryptProperties;

    private final List<BaseAlgorithmHttpInputMessage> list = new ArrayList<>();

    public ResponseEncryptionAdvice(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        this.addAll(list);
    }

    private void addAll(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        String temp;
        for(int i=0;i<list.size();i++){
            temp = list.get(i).getBinding();
            for (int j = i+1;j<list.size();j++){
                String binding = list.get(j).getBinding();
                if(temp.equals(binding)){
                    throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
                }
            }
        }
        this.list.addAll(list);
        log.info("加密类完成初始化加载........");
    }

    @Override
    public boolean supports(MethodParameter methodParameter, Class aClass) {
        if(!cryptProperties.isResponseEncryption()){
            return false;
        }
        Encryption encryption;
        encryption = methodParameter.getMethodAnnotation(Encryption.class);
        if(encryption == null){
            encryption = methodParameter.getContainingClass().getAnnotation(Encryption.class);
        }
        if (encryption != null){
            log.info("需要进行加密操作，但是需要注意入参是否包含加密字段........");
        }else {
            log.info("不需要进行加密操作........");
        }
        return encryption != null;
    }

    @Override
    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if(o == null){
            return null;
        }
        Encryption encryption;
        encryption = methodParameter.getMethodAnnotation(Encryption.class);
        Class<?> targetClass = methodParameter.getContainingClass();
        if(encryption == null){
            encryption = targetClass.getAnnotation(Encryption.class);
        }
        try {
            //根据请求中的参数判断是否要进行解密操作
           String sessionId =  ((HttpServletRequest)serverHttpRequest).getSession().getId();
           if (!Objects.equals(AlgorithmConstant.cacheRequest.get(sessionId),true)){
               return o;
           }
//            AlgorithmConstant.cacheRequest.put( request.getSession().getId(),true);
//            InputStream body =  serverHttpRequest.getBody();
//            boolean required = encryption.required();
//            String encryptData = IOUtils.toString(body, cryptProperties.getCharset());
//            JSONObject jsonObject = JSONObject.parseObject(encryptData);
//            String encryptString = jsonObject.getString(encryption.encryptionStringName());
//            //当必须时，并且请求参数中包含了解密字段后才返回加密信息
//            if(!(required&& StringUtils.isNotBlank(encryptString))){
//              return o;
//            }
            String bind = encryption.bind();
            String fieldName = encryption.fieldName();
            for (BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage : list) {
                if(bind.equals(baseAlgorithmHttpInputMessage.getBinding())){
                    if(StringUtils.isNotBlank(fieldName)) {
                        Field dataFiled = o.getClass().getDeclaredField(fieldName);
                        dataFiled.setAccessible(true);
                        Object dataObject = dataFiled.get(o);
                        String encrypt = baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(dataObject));
                        dataFiled.set(o, encrypt);
                        return o;
                    }else{
                        return baseAlgorithmHttpInputMessage.encrypt(JSON.toJSONString(o));
                    }
                }
            }
            //找不到绑定的加密对象
            String methodName = Objects.requireNonNull(methodParameter.getMethod()).getName();
            String targetClassName = targetClass.getSimpleName();

            throw new BindingException("Unable to find a binding object of encryption,targetClass is "+targetClassName+",method is "+methodName);
        } catch (Exception e){
            e.printStackTrace();
        }
        return o;
    }
}
