package cn.axj.crypt.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author aoxiaojun
 * @date 2020/12/15 15:15
 **/
@Component
@ConfigurationProperties("crypt")
public class CryptProperties {

    /**
     * 配置参数是否需要解密，默认需要,可通过配置secret.parameter.decryption
     */
    private boolean parameterDecryption = true;

    /**
     * 配置响应是否需要加密，默认不需要 ，可通过配置secret.response.encryption
     */
    private boolean responseEncryption = false;

    private String charset = "UTF-8";

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isParameterDecryption() {
        return parameterDecryption;
    }

    public void setParameterDecryption(boolean parameterDecryption) {
        this.parameterDecryption = parameterDecryption;
    }

    public boolean isResponseEncryption() {
        return responseEncryption;
    }

    public void setResponseEncryption(boolean responseEncryption) {
        this.responseEncryption = responseEncryption;
    }
}
