/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.secret.implement;

import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import cn.axj.crypt.secret.config.RsaKeyConfig;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RsaAlgorithmHttpInputMessage
extends BaseAlgorithmHttpInputMessage {
    @Resource
    private RsaKeyConfig rsaKeyConfig;
    private static final String KEY_ALGORTHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static String publicKeyStr;
    private static String privateKeyStr;

    @Override
    public String getBinding() {
        return KEY_ALGORTHM;
    }

    @Override
    public String decrypt(String content) throws Exception {
        return this.decode(content);
    }

    @Override
    public String encrypt(String content) throws Exception {
        return this.encrypt(content, this.getPublicKey());
    }

    @Autowired
    public void setPublicKeyStr() {
        publicKeyStr = this.rsaKeyConfig.getPublicKey();
    }

    @Autowired
    public void setPrivateKeyStr() {
        privateKeyStr = this.rsaKeyConfig.getPrivateKey();
    }

    private String encrypt(String content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("rsa");
        cipher.init(1, publicKey);
        Base64 base64 = new Base64();
        byte[] data = content.getBytes();
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return base64.encodeToString(encryptedData);
    }

    private String decrypt(String content, PrivateKey privateKey) throws Exception {
        byte[] byteArray = Base64.decodeBase64((String)content);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        int inputLen = byteArray.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(byteArray, offSet, 128) : cipher.doFinal(byteArray, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData);
    }

    private PrivateKey getPrivateKey() throws Exception {
        byte[] keyBytes = this.decryptBase64(privateKeyStr);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORTHM);
        return keyFactory.generatePrivate(pkcs8EncodedKeySpec);
    }

    private PublicKey getPublicKey() throws Exception {
        byte[] keyBytes = this.decryptBase64(publicKeyStr);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORTHM);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private byte[] decryptBase64(String keys) {
        Base64 base64 = new Base64();
        return base64.decode(keys);
    }

    public String encode(String content) throws Exception {
        return this.encrypt(content, this.getPublicKey());
    }

    public String decode(String content) throws Exception {
        return this.decrypt(content, this.getPrivateKey());
    }
}

