/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.secret.implement;

import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import cn.axj.crypt.secret.config.AesEcbConfig;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;

@Component
public class AesEcbAlgorithmHttpInputMessage
extends BaseAlgorithmHttpInputMessage {
    @Resource
    private AesEcbConfig aesKeyConfig;
    private static String aesKey;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    @Autowired
    public void setAesKey() {
        aesKey = this.aesKeyConfig.getKey();
    }

    @Override
    public String getBinding() {
        return "AES_ECB";
    }

    @Override
    public String decrypt(String content) throws Exception {
        return AesEcbAlgorithmHttpInputMessage.aesDecrypt(content, KEY_ALGORITHM);
    }

    @Override
    public String encrypt(String content) throws Exception {
        return AesEcbAlgorithmHttpInputMessage.aesEncrypt(content, KEY_ALGORITHM);
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return AesEcbAlgorithmHttpInputMessage.base64Encode(AesEcbAlgorithmHttpInputMessage.aesEncryptToBytes(content, encryptKey));
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM);
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), KEY_ALGORITHM));
        return cipher.doFinal(content.getBytes("utf-8"));
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return encryptStr.isEmpty() ? null : AesEcbAlgorithmHttpInputMessage.aesDecryptByBytes(AesEcbAlgorithmHttpInputMessage.base64Decode(encryptStr), decryptKey);
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM);
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), KEY_ALGORITHM));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return base64Code.isEmpty() ? null : new BASE64Decoder().decodeBuffer(base64Code);
    }
}

