/*
 * Decompiled with CFR 0.152.
 */
package cn.axj.crypt.handler;

import cn.axj.crypt.annotation.Decryption;
import cn.axj.crypt.config.CryptProperties;
import cn.axj.crypt.exception.BindingException;
import cn.axj.crypt.exception.DecryptErrorException;
import cn.axj.crypt.exception.EncryptionStringNameIsNullException;
import cn.axj.crypt.exception.ParameterBodyIsNullException;
import cn.axj.crypt.secret.BaseAlgorithmHttpInputMessage;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class ParameterDecryptionAdvice
implements RequestBodyAdvice {
    @Resource
    private CryptProperties cryptProperties;
    private List<BaseAlgorithmHttpInputMessage> decryptionList = new ArrayList<BaseAlgorithmHttpInputMessage>(8);

    public ParameterDecryptionAdvice(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        this.init(list);
    }

    private void init(List<BaseAlgorithmHttpInputMessage> list) throws BindingException {
        for (int i = 0; i < list.size(); ++i) {
            String temp = list.get(i).getBinding();
            for (int j = i + 1; j < list.size(); ++j) {
                String binding = list.get(j).getBinding();
                if (!temp.equals(binding)) continue;
                throw new BindingException("The algorithm implements binding value is repeat!please check it exists two value of " + binding);
            }
        }
        this.decryptionList.addAll(list);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        if (!this.cryptProperties.isParameterDecryption()) {
            return false;
        }
        Decryption decryption = (Decryption)methodParameter.getParameterAnnotation(Decryption.class);
        RequestBody requestBody = (RequestBody)methodParameter.getParameterAnnotation(RequestBody.class);
        return Objects.nonNull(decryption) && Objects.nonNull(requestBody);
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws RuntimeException, IOException {
        Decryption decryption = (Decryption)parameter.getParameterAnnotation(Decryption.class);
        assert (decryption != null);
        String simpleName = parameter.getContainingClass().getSimpleName();
        String methodName = Objects.requireNonNull(parameter.getMethod()).getName();
        String bind = decryption.bind();
        String encryptionStringName = decryption.encryptionStringName();
        if (StringUtils.isEmpty((Object)encryptionStringName)) {
            throw new EncryptionStringNameIsNullException("The annotation Decryption\u2018s encryptionStringName is empty,please check the method annotation,target method is " + simpleName + "." + methodName);
        }
        InputStream body = inputMessage.getBody();
        if (body == null) {
            throw new ParameterBodyIsNullException("request body is null");
        }
        for (BaseAlgorithmHttpInputMessage baseDecryption : this.decryptionList) {
            String decrypt;
            if (!baseDecryption.getBinding().equals(bind)) continue;
            String encryptData = IOUtils.toString((InputStream)body, (String)this.cryptProperties.getCharset());
            JSONObject jsonObject = JSONObject.parseObject((String)encryptData);
            String encryptString = jsonObject.getString(encryptionStringName);
            if (StringUtils.isEmpty((Object)encryptString)) {
                throw new ParameterBodyIsNullException("request body is null");
            }
            try {
                decrypt = baseDecryption.decrypt(encryptString);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DecryptErrorException("decrypt error for String " + encryptString + " ,current algorithm is " + bind);
            }
            InputStream inputStream = IOUtils.toInputStream((String)decrypt, (String)this.cryptProperties.getCharset());
            try {
                BaseAlgorithmHttpInputMessage baseAlgorithmHttpInputMessage = (BaseAlgorithmHttpInputMessage)baseDecryption.getClass().newInstance();
                baseAlgorithmHttpInputMessage.setHeaders(inputMessage.getHeaders());
                baseAlgorithmHttpInputMessage.setBody(inputStream);
                return baseAlgorithmHttpInputMessage;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new BindingException("Unable to find a binding object of decryption,targetClass is " + simpleName + ",method is " + methodName);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

